<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialRequiredMonthlyCrossCompanySearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_monthly_cross_company: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmaterial_required_monthly_cross_companysearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmaterial_required_monthly_cross_companysearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["month", [], fields.month.isInvalid],
            ["buyer", [], fields.buyer.isInvalid],
            ["processed_by", [ew.Validators.integer], fields.processed_by.isInvalid],
            ["design_id", [], fields.design_id.isInvalid],
            ["size_cm", [], fields.size_cm.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["req_material_rid", [], fields.req_material_rid.isInvalid],
            ["req_material_packing", [], fields.req_material_packing.isInvalid],
            ["req_material_qty", [ew.Validators.float], fields.req_material_qty.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["no", [ew.Validators.integer], fields.no.isInvalid],
            ["datetime", [], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "month": <?= $Page->month->toClientList($Page) ?>,
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
            "processed_by": <?= $Page->processed_by->toClientList($Page) ?>,
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "req_material_rid": <?= $Page->req_material_rid->toClientList($Page) ?>,
            "req_material_packing": <?= $Page->req_material_packing->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmaterial_required_monthly_cross_companysearch" id="fmaterial_required_monthly_cross_companysearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_required_monthly_cross_company">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->month->Visible) { // month ?>
    <div id="r_month" class="row"<?= $Page->month->rowAttributes() ?>>
        <label for="x_month" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_monthly_cross_company_month"><?= $Page->month->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_month" id="z_month" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->month->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_monthly_cross_company_month" class="ew-search-field ew-search-field-single">
    <select
        id="x_month"
        name="x_month"
        class="form-select ew-select<?= $Page->month->isInvalidClass() ?>"
        <?php if (!$Page->month->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_monthly_cross_companysearch_x_month"
        <?php } ?>
        data-table="material_required_monthly_cross_company"
        data-field="x_month"
        data-value-separator="<?= $Page->month->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->month->getPlaceHolder()) ?>"
        <?= $Page->month->editAttributes() ?>>
        <?= $Page->month->selectOptionListHtml("x_month") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->month->getErrorMessage(false) ?></div>
<?= $Page->month->Lookup->getParamTag($Page, "p_x_month") ?>
<?php if (!$Page->month->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_monthly_cross_companysearch", function() {
    var options = { name: "x_month", selectId: "fmaterial_required_monthly_cross_companysearch_x_month" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_monthly_cross_companysearch.lists.month?.lookupOptions.length) {
        options.data = { id: "x_month", form: "fmaterial_required_monthly_cross_companysearch" };
    } else {
        options.ajax = { id: "x_month", form: "fmaterial_required_monthly_cross_companysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_monthly_cross_company.fields.month.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
    <div id="r_buyer" class="row"<?= $Page->buyer->rowAttributes() ?>>
        <label for="x_buyer" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_monthly_cross_company_buyer"><?= $Page->buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer" id="z_buyer" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_monthly_cross_company_buyer" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer"
        name="x_buyer"
        class="form-select ew-select<?= $Page->buyer->isInvalidClass() ?>"
        <?php if (!$Page->buyer->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_monthly_cross_companysearch_x_buyer"
        <?php } ?>
        data-table="material_required_monthly_cross_company"
        data-field="x_buyer"
        data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>"
        <?= $Page->buyer->editAttributes() ?>>
        <?= $Page->buyer->selectOptionListHtml("x_buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer->getErrorMessage(false) ?></div>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
<?php if (!$Page->buyer->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_monthly_cross_companysearch", function() {
    var options = { name: "x_buyer", selectId: "fmaterial_required_monthly_cross_companysearch_x_buyer" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_monthly_cross_companysearch.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x_buyer", form: "fmaterial_required_monthly_cross_companysearch" };
    } else {
        options.ajax = { id: "x_buyer", form: "fmaterial_required_monthly_cross_companysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_monthly_cross_company.fields.buyer.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->processed_by->Visible) { // processed_by ?>
    <div id="r_processed_by" class="row"<?= $Page->processed_by->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_monthly_cross_company_processed_by"><?= $Page->processed_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_processed_by" id="z_processed_by" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->processed_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_monthly_cross_company_processed_by" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->processed_by->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_processed_by" class="ew-auto-suggest">
    <input type="<?= $Page->processed_by->getInputTextType() ?>" class="form-control" name="sv_x_processed_by" id="sv_x_processed_by" value="<?= RemoveHtml($Page->processed_by->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->processed_by->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->processed_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->processed_by->formatPattern()) ?>"<?= $Page->processed_by->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="material_required_monthly_cross_company" data-field="x_processed_by" data-input="sv_x_processed_by" data-value-separator="<?= $Page->processed_by->displayValueSeparatorAttribute() ?>" name="x_processed_by" id="x_processed_by" value="<?= HtmlEncode($Page->processed_by->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->processed_by->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fmaterial_required_monthly_cross_companysearch", function() {
    fmaterial_required_monthly_cross_companysearch.createAutoSuggest(Object.assign({"id":"x_processed_by","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->processed_by->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.material_required_monthly_cross_company.fields.processed_by.autoSuggestOptions));
});
</script>
<?= $Page->processed_by->Lookup->getParamTag($Page, "p_x_processed_by") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id" class="row"<?= $Page->design_id->rowAttributes() ?>>
        <label for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_monthly_cross_company_design_id"><?= $Page->design_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design_id" id="z_design_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_monthly_cross_company_design_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-select ew-select<?= $Page->design_id->isInvalidClass() ?>"
        <?php if (!$Page->design_id->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_monthly_cross_companysearch_x_design_id"
        <?php } ?>
        data-table="material_required_monthly_cross_company"
        data-field="x_design_id"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage(false) ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<?php if (!$Page->design_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_monthly_cross_companysearch", function() {
    var options = { name: "x_design_id", selectId: "fmaterial_required_monthly_cross_companysearch_x_design_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_monthly_cross_companysearch.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fmaterial_required_monthly_cross_companysearch" };
    } else {
        options.ajax = { id: "x_design_id", form: "fmaterial_required_monthly_cross_companysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_monthly_cross_company.fields.design_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm" class="row"<?= $Page->size_cm->rowAttributes() ?>>
        <label for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_monthly_cross_company_size_cm"><?= $Page->size_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_monthly_cross_company_size_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_cm->getInputTextType() ?>" name="x_size_cm" id="x_size_cm" data-table="material_required_monthly_cross_company" data-field="x_size_cm" value="<?= $Page->size_cm->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_cm->formatPattern()) ?>"<?= $Page->size_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_monthly_cross_company_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_monthly_cross_company_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="material_required_monthly_cross_company" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
    <div id="r_req_material_rid" class="row"<?= $Page->req_material_rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_monthly_cross_company_req_material_rid"><?= $Page->req_material_rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_monthly_cross_company_req_material_rid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->req_material_rid->getInputTextType() ?>" name="x_req_material_rid" id="x_req_material_rid" data-table="material_required_monthly_cross_company" data-field="x_req_material_rid" value="<?= $Page->req_material_rid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_rid->formatPattern()) ?>"<?= $Page->req_material_rid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->req_material_rid->getErrorMessage(false) ?></div>
<?= $Page->req_material_rid->Lookup->getParamTag($Page, "p_x_req_material_rid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
    <div id="r_req_material_packing" class="row"<?= $Page->req_material_packing->rowAttributes() ?>>
        <label for="x_req_material_packing" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_monthly_cross_company_req_material_packing"><?= $Page->req_material_packing->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_packing" id="z_req_material_packing" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_packing->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_monthly_cross_company_req_material_packing" class="ew-search-field ew-search-field-single">
    <select
        id="x_req_material_packing"
        name="x_req_material_packing"
        class="form-select ew-select<?= $Page->req_material_packing->isInvalidClass() ?>"
        <?php if (!$Page->req_material_packing->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_monthly_cross_companysearch_x_req_material_packing"
        <?php } ?>
        data-table="material_required_monthly_cross_company"
        data-field="x_req_material_packing"
        data-value-separator="<?= $Page->req_material_packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_packing->getPlaceHolder()) ?>"
        <?= $Page->req_material_packing->editAttributes() ?>>
        <?= $Page->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_packing->getErrorMessage(false) ?></div>
<?= $Page->req_material_packing->Lookup->getParamTag($Page, "p_x_req_material_packing") ?>
<?php if (!$Page->req_material_packing->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_monthly_cross_companysearch", function() {
    var options = { name: "x_req_material_packing", selectId: "fmaterial_required_monthly_cross_companysearch_x_req_material_packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_monthly_cross_companysearch.lists.req_material_packing?.lookupOptions.length) {
        options.data = { id: "x_req_material_packing", form: "fmaterial_required_monthly_cross_companysearch" };
    } else {
        options.ajax = { id: "x_req_material_packing", form: "fmaterial_required_monthly_cross_companysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_monthly_cross_company.fields.req_material_packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
    <div id="r_req_material_qty" class="row"<?= $Page->req_material_qty->rowAttributes() ?>>
        <label for="x_req_material_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_monthly_cross_company_req_material_qty"><?= $Page->req_material_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_qty" id="z_req_material_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_monthly_cross_company_req_material_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->req_material_qty->getInputTextType() ?>" name="x_req_material_qty" id="x_req_material_qty" data-table="material_required_monthly_cross_company" data-field="x_req_material_qty" value="<?= $Page->req_material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_qty->formatPattern()) ?>"<?= $Page->req_material_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->req_material_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_monthly_cross_company__barcode"><?= $Page->_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_monthly_cross_company__barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="material_required_monthly_cross_company" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->no->Visible) { // no ?>
    <div id="r_no" class="row"<?= $Page->no->rowAttributes() ?>>
        <label for="x_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_monthly_cross_company_no"><?= $Page->no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_no" id="z_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_monthly_cross_company_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->no->getInputTextType() ?>" name="x_no" id="x_no" data-table="material_required_monthly_cross_company" data-field="x_no" value="<?= $Page->no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no->formatPattern()) ?>"<?= $Page->no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_monthly_cross_company_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_monthly_cross_company_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="material_required_monthly_cross_company" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmaterial_required_monthly_cross_companysearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmaterial_required_monthly_cross_companysearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmaterial_required_monthly_cross_companysearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required_monthly_cross_company");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
