<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialRequiredMonthlyCrossCompanyList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_monthly_cross_company: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fmaterial_required_monthly_cross_companysrch" id="fmaterial_required_monthly_cross_companysrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fmaterial_required_monthly_cross_companysrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_monthly_cross_company: currentTable } });
var currentForm;
var fmaterial_required_monthly_cross_companysrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmaterial_required_monthly_cross_companysrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["month", [], fields.month.isInvalid],
            ["buyer", [], fields.buyer.isInvalid],
            ["processed_by", [ew.Validators.integer], fields.processed_by.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "month": <?= $Page->month->toClientList($Page) ?>,
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
            "processed_by": <?= $Page->processed_by->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->month->Visible) { // month ?>
<?php
if (!$Page->month->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_month" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->month->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_month" class="ew-search-caption ew-label"><?= $Page->month->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_month" id="z_month" value="LIKE">
</div>
        </div>
        <div id="el_material_required_monthly_cross_company_month" class="ew-search-field">
    <select
        id="x_month"
        name="x_month"
        class="form-select ew-select<?= $Page->month->isInvalidClass() ?>"
        <?php if (!$Page->month->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_monthly_cross_companysrch_x_month"
        <?php } ?>
        data-table="material_required_monthly_cross_company"
        data-field="x_month"
        data-value-separator="<?= $Page->month->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->month->getPlaceHolder()) ?>"
        <?= $Page->month->editAttributes() ?>>
        <?= $Page->month->selectOptionListHtml("x_month") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->month->getErrorMessage(false) ?></div>
<?= $Page->month->Lookup->getParamTag($Page, "p_x_month") ?>
<?php if (!$Page->month->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_monthly_cross_companysrch", function() {
    var options = { name: "x_month", selectId: "fmaterial_required_monthly_cross_companysrch_x_month" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_monthly_cross_companysrch.lists.month?.lookupOptions.length) {
        options.data = { id: "x_month", form: "fmaterial_required_monthly_cross_companysrch" };
    } else {
        options.ajax = { id: "x_month", form: "fmaterial_required_monthly_cross_companysrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_monthly_cross_company.fields.month.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
<?php
if (!$Page->buyer->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_buyer" class="ew-search-caption ew-label"><?= $Page->buyer->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer" id="z_buyer" value="=">
</div>
        </div>
        <div id="el_material_required_monthly_cross_company_buyer" class="ew-search-field">
    <select
        id="x_buyer"
        name="x_buyer"
        class="form-select ew-select<?= $Page->buyer->isInvalidClass() ?>"
        <?php if (!$Page->buyer->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_monthly_cross_companysrch_x_buyer"
        <?php } ?>
        data-table="material_required_monthly_cross_company"
        data-field="x_buyer"
        data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>"
        <?= $Page->buyer->editAttributes() ?>>
        <?= $Page->buyer->selectOptionListHtml("x_buyer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer->getErrorMessage(false) ?></div>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
<?php if (!$Page->buyer->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_monthly_cross_companysrch", function() {
    var options = { name: "x_buyer", selectId: "fmaterial_required_monthly_cross_companysrch_x_buyer" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_monthly_cross_companysrch.lists.buyer?.lookupOptions.length) {
        options.data = { id: "x_buyer", form: "fmaterial_required_monthly_cross_companysrch" };
    } else {
        options.ajax = { id: "x_buyer", form: "fmaterial_required_monthly_cross_companysrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_monthly_cross_company.fields.buyer.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->processed_by->Visible) { // processed_by ?>
<?php
if (!$Page->processed_by->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_processed_by" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->processed_by->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->processed_by->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_processed_by" id="z_processed_by" value="=">
</div>
        </div>
        <div id="el_material_required_monthly_cross_company_processed_by" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->processed_by->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_processed_by" class="ew-auto-suggest">
    <input type="<?= $Page->processed_by->getInputTextType() ?>" class="form-control" name="sv_x_processed_by" id="sv_x_processed_by" value="<?= RemoveHtml($Page->processed_by->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->processed_by->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->processed_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->processed_by->formatPattern()) ?>"<?= $Page->processed_by->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="material_required_monthly_cross_company" data-field="x_processed_by" data-input="sv_x_processed_by" data-value-separator="<?= $Page->processed_by->displayValueSeparatorAttribute() ?>" name="x_processed_by" id="x_processed_by" value="<?= HtmlEncode($Page->processed_by->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->processed_by->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fmaterial_required_monthly_cross_companysrch", function() {
    fmaterial_required_monthly_cross_companysrch.createAutoSuggest(Object.assign({"id":"x_processed_by","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->processed_by->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.material_required_monthly_cross_company.fields.processed_by.autoSuggestOptions));
});
</script>
<?= $Page->processed_by->Lookup->getParamTag($Page, "p_x_processed_by") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fmaterial_required_monthly_cross_companysrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fmaterial_required_monthly_cross_companysrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fmaterial_required_monthly_cross_companysrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fmaterial_required_monthly_cross_companysrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fmaterial_required_monthly_cross_companysrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fmaterial_required_monthly_cross_companysrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fmaterial_required_monthly_cross_companysrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_required_monthly_cross_company">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_material_required_monthly_cross_company" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_material_required_monthly_cross_companylist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->month->Visible) { // month ?>
        <th data-name="month" class="<?= $Page->month->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_month" class="material_required_monthly_cross_company_month"><?= $Page->renderFieldHeader($Page->month) ?></div></th>
<?php } ?>
<?php if ($Page->buyer->Visible) { // buyer ?>
        <th data-name="buyer" class="<?= $Page->buyer->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_buyer" class="material_required_monthly_cross_company_buyer"><?= $Page->renderFieldHeader($Page->buyer) ?></div></th>
<?php } ?>
<?php if ($Page->processed_by->Visible) { // processed_by ?>
        <th data-name="processed_by" class="<?= $Page->processed_by->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_processed_by" class="material_required_monthly_cross_company_processed_by"><?= $Page->renderFieldHeader($Page->processed_by) ?></div></th>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
        <th data-name="design_id" class="<?= $Page->design_id->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_design_id" class="material_required_monthly_cross_company_design_id"><?= $Page->renderFieldHeader($Page->design_id) ?></div></th>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
        <th data-name="size_cm" class="<?= $Page->size_cm->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_size_cm" class="material_required_monthly_cross_company_size_cm"><?= $Page->renderFieldHeader($Page->size_cm) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_sqm" class="material_required_monthly_cross_company_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <th data-name="req_material_rid" class="<?= $Page->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_req_material_rid" class="material_required_monthly_cross_company_req_material_rid"><?= $Page->renderFieldHeader($Page->req_material_rid) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <th data-name="req_material_packing" class="<?= $Page->req_material_packing->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_req_material_packing" class="material_required_monthly_cross_company_req_material_packing"><?= $Page->renderFieldHeader($Page->req_material_packing) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <th data-name="req_material_qty" class="<?= $Page->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_req_material_qty" class="material_required_monthly_cross_company_req_material_qty"><?= $Page->renderFieldHeader($Page->req_material_qty) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company__barcode" class="material_required_monthly_cross_company__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->no->Visible) { // no ?>
        <th data-name="no" class="<?= $Page->no->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_no" class="material_required_monthly_cross_company_no"><?= $Page->renderFieldHeader($Page->no) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_datetime" class="material_required_monthly_cross_company_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->month->Visible) { // month ?>
        <td data-name="month"<?= $Page->month->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_monthly_cross_company_month" class="el_material_required_monthly_cross_company_month">
<span<?= $Page->month->viewAttributes() ?>>
<?= $Page->month->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer->Visible) { // buyer ?>
        <td data-name="buyer"<?= $Page->buyer->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_monthly_cross_company_buyer" class="el_material_required_monthly_cross_company_buyer">
<span<?= $Page->buyer->viewAttributes() ?>>
<?= $Page->buyer->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->processed_by->Visible) { // processed_by ?>
        <td data-name="processed_by"<?= $Page->processed_by->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_monthly_cross_company_processed_by" class="el_material_required_monthly_cross_company_processed_by">
<span<?= $Page->processed_by->viewAttributes() ?>>
<?= $Page->processed_by->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design_id->Visible) { // design_id ?>
        <td data-name="design_id"<?= $Page->design_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_monthly_cross_company_design_id" class="el_material_required_monthly_cross_company_design_id">
<span<?= $Page->design_id->viewAttributes() ?>>
<?= $Page->design_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm"<?= $Page->size_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_monthly_cross_company_size_cm" class="el_material_required_monthly_cross_company_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<?= $Page->size_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_monthly_cross_company_sqm" class="el_material_required_monthly_cross_company_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <td data-name="req_material_rid"<?= $Page->req_material_rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_monthly_cross_company_req_material_rid" class="el_material_required_monthly_cross_company_req_material_rid">
<span<?= $Page->req_material_rid->viewAttributes() ?>>
<?= $Page->req_material_rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <td data-name="req_material_packing"<?= $Page->req_material_packing->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_monthly_cross_company_req_material_packing" class="el_material_required_monthly_cross_company_req_material_packing">
<span<?= $Page->req_material_packing->viewAttributes() ?>>
<?= $Page->req_material_packing->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <td data-name="req_material_qty"<?= $Page->req_material_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_monthly_cross_company_req_material_qty" class="el_material_required_monthly_cross_company_req_material_qty">
<span<?= $Page->req_material_qty->viewAttributes() ?>>
<?= $Page->req_material_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_monthly_cross_company__barcode" class="el_material_required_monthly_cross_company__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->no->Visible) { // no ?>
        <td data-name="no"<?= $Page->no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_monthly_cross_company_no" class="el_material_required_monthly_cross_company_no">
<span<?= $Page->no->viewAttributes() ?>>
<?= $Page->no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_monthly_cross_company_datetime" class="el_material_required_monthly_cross_company_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->month->Visible) { // month ?>
        <td data-name="month" class="<?= $Page->month->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_month" class="material_required_monthly_cross_company_month">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer->Visible) { // buyer ?>
        <td data-name="buyer" class="<?= $Page->buyer->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_buyer" class="material_required_monthly_cross_company_buyer">
        </span></td>
    <?php } ?>
    <?php if ($Page->processed_by->Visible) { // processed_by ?>
        <td data-name="processed_by" class="<?= $Page->processed_by->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_processed_by" class="material_required_monthly_cross_company_processed_by">
        </span></td>
    <?php } ?>
    <?php if ($Page->design_id->Visible) { // design_id ?>
        <td data-name="design_id" class="<?= $Page->design_id->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_design_id" class="material_required_monthly_cross_company_design_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm" class="<?= $Page->size_cm->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_size_cm" class="material_required_monthly_cross_company_size_cm">
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Page->sqm->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_sqm" class="material_required_monthly_cross_company_sqm">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <td data-name="req_material_rid" class="<?= $Page->req_material_rid->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_req_material_rid" class="material_required_monthly_cross_company_req_material_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <td data-name="req_material_packing" class="<?= $Page->req_material_packing->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_req_material_packing" class="material_required_monthly_cross_company_req_material_packing">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <td data-name="req_material_qty" class="<?= $Page->req_material_qty->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_req_material_qty" class="material_required_monthly_cross_company_req_material_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->req_material_qty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode" class="<?= $Page->_barcode->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company__barcode" class="material_required_monthly_cross_company__barcode">
        </span></td>
    <?php } ?>
    <?php if ($Page->no->Visible) { // no ?>
        <td data-name="no" class="<?= $Page->no->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_no" class="material_required_monthly_cross_company_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Page->datetime->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_datetime" class="material_required_monthly_cross_company_datetime">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required_monthly_cross_company");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
