<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("MaterialRequiredLiveGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fmaterial_required_livegrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { material_required_live: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmaterial_required_livegrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["poid", [fields.poid.visible && fields.poid.required ? ew.Validators.required(fields.poid.caption) : null], fields.poid.isInvalid],
            ["weaving_works", [fields.weaving_works.visible && fields.weaving_works.required ? ew.Validators.required(fields.weaving_works.caption) : null], fields.weaving_works.isInvalid],
            ["week", [fields.week.visible && fields.week.required ? ew.Validators.required(fields.week.caption) : null], fields.week.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null], fields.po.isInvalid],
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null], fields.buyer_id.isInvalid],
            ["product_id", [fields.product_id.visible && fields.product_id.required ? ew.Validators.required(fields.product_id.caption) : null], fields.product_id.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null], fields.quantity.isInvalid],
            ["Size_wl", [fields.Size_wl.visible && fields.Size_wl.required ? ew.Validators.required(fields.Size_wl.caption) : null], fields.Size_wl.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null], fields.sqm.isInvalid],
            ["req_material_rid", [fields.req_material_rid.visible && fields.req_material_rid.required ? ew.Validators.required(fields.req_material_rid.caption) : null], fields.req_material_rid.isInvalid],
            ["req_material_qty", [fields.req_material_qty.visible && fields.req_material_qty.required ? ew.Validators.required(fields.req_material_qty.caption) : null], fields.req_material_qty.isInvalid],
            ["req_material_packing", [fields.req_material_packing.visible && fields.req_material_packing.required ? ew.Validators.required(fields.req_material_packing.caption) : null], fields.req_material_packing.isInvalid],
            ["unit", [fields.unit.visible && fields.unit.required ? ew.Validators.required(fields.unit.caption) : null], fields.unit.isInvalid],
            ["material_qty", [fields.material_qty.visible && fields.material_qty.required ? ew.Validators.required(fields.material_qty.caption) : null], fields.material_qty.isInvalid],
            ["method", [fields.method.visible && fields.method.required ? ew.Validators.required(fields.method.caption) : null], fields.method.isInvalid],
            ["despatch_week", [fields.despatch_week.visible && fields.despatch_week.required ? ew.Validators.required(fields.despatch_week.caption) : null], fields.despatch_week.isInvalid],
            ["despatch_date", [fields.despatch_date.visible && fields.despatch_date.required ? ew.Validators.required(fields.despatch_date.caption) : null, ew.Validators.datetime(fields.despatch_date.clientFormatPattern)], fields.despatch_date.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["material_out", [fields.material_out.visible && fields.material_out.required ? ew.Validators.required(fields.material_out.caption) : null], fields.material_out.isInvalid],
            ["order_id", [fields.order_id.visible && fields.order_id.required ? ew.Validators.required(fields.order_id.caption) : null], fields.order_id.isInvalid],
            ["issue_to", [fields.issue_to.visible && fields.issue_to.required ? ew.Validators.required(fields.issue_to.caption) : null], fields.issue_to.isInvalid],
            ["pp_id", [fields.pp_id.visible && fields.pp_id.required ? ew.Validators.required(fields.pp_id.caption) : null, ew.Validators.integer], fields.pp_id.isInvalid],
            ["level", [fields.level.visible && fields.level.required ? ew.Validators.required(fields.level.caption) : null, ew.Validators.integer], fields.level.isInvalid],
            ["product_category", [fields.product_category.visible && fields.product_category.required ? ew.Validators.required(fields.product_category.caption) : null], fields.product_category.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["poid",false],["weaving_works",false],["week",false],["po",false],["buyer_id",false],["product_id",false],["batch_no",false],["quantity",false],["Size_wl",false],["sqm",false],["req_material_rid",false],["req_material_qty",false],["req_material_packing",false],["unit",false],["material_qty",false],["method",false],["despatch_week",false],["despatch_date",false],["material_out",false],["order_id",false],["issue_to",false],["pp_id",false],["level",false],["product_category",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "weaving_works": <?= $Grid->weaving_works->toClientList($Grid) ?>,
            "week": <?= $Grid->week->toClientList($Grid) ?>,
            "buyer_id": <?= $Grid->buyer_id->toClientList($Grid) ?>,
            "product_id": <?= $Grid->product_id->toClientList($Grid) ?>,
            "batch_no": <?= $Grid->batch_no->toClientList($Grid) ?>,
            "req_material_rid": <?= $Grid->req_material_rid->toClientList($Grid) ?>,
            "req_material_packing": <?= $Grid->req_material_packing->toClientList($Grid) ?>,
            "unit": <?= $Grid->unit->toClientList($Grid) ?>,
            "material_qty": <?= $Grid->material_qty->toClientList($Grid) ?>,
            "method": <?= $Grid->method->toClientList($Grid) ?>,
            "despatch_week": <?= $Grid->despatch_week->toClientList($Grid) ?>,
            "operator": <?= $Grid->operator->toClientList($Grid) ?>,
            "material_out": <?= $Grid->material_out->toClientList($Grid) ?>,
            "issue_to": <?= $Grid->issue_to->toClientList($Grid) ?>,
            "product_category": <?= $Grid->product_category->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fmaterial_required_livegrid" class="ew-form ew-list-form">
<div id="gmp_material_required_live" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_material_required_livegrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_material_required_live_id" class="material_required_live_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->poid->Visible) { // poid ?>
        <th data-name="poid" class="<?= $Grid->poid->headerCellClass() ?>"><div id="elh_material_required_live_poid" class="material_required_live_poid"><?= $Grid->renderFieldHeader($Grid->poid) ?></div></th>
<?php } ?>
<?php if ($Grid->weaving_works->Visible) { // weaving_works ?>
        <th data-name="weaving_works" class="<?= $Grid->weaving_works->headerCellClass() ?>"><div id="elh_material_required_live_weaving_works" class="material_required_live_weaving_works"><?= $Grid->renderFieldHeader($Grid->weaving_works) ?></div></th>
<?php } ?>
<?php if ($Grid->week->Visible) { // week ?>
        <th data-name="week" class="<?= $Grid->week->headerCellClass() ?>"><div id="elh_material_required_live_week" class="material_required_live_week"><?= $Grid->renderFieldHeader($Grid->week) ?></div></th>
<?php } ?>
<?php if ($Grid->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Grid->po->headerCellClass() ?>"><div id="elh_material_required_live_po" class="material_required_live_po"><?= $Grid->renderFieldHeader($Grid->po) ?></div></th>
<?php } ?>
<?php if ($Grid->buyer_id->Visible) { // buyer_id ?>
        <th data-name="buyer_id" class="<?= $Grid->buyer_id->headerCellClass() ?>"><div id="elh_material_required_live_buyer_id" class="material_required_live_buyer_id"><?= $Grid->renderFieldHeader($Grid->buyer_id) ?></div></th>
<?php } ?>
<?php if ($Grid->product_id->Visible) { // product_id ?>
        <th data-name="product_id" class="<?= $Grid->product_id->headerCellClass() ?>"><div id="elh_material_required_live_product_id" class="material_required_live_product_id"><?= $Grid->renderFieldHeader($Grid->product_id) ?></div></th>
<?php } ?>
<?php if ($Grid->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Grid->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_required_live_batch_no" class="material_required_live_batch_no"><?= $Grid->renderFieldHeader($Grid->batch_no) ?></div></th>
<?php } ?>
<?php if ($Grid->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Grid->quantity->headerCellClass() ?>"><div id="elh_material_required_live_quantity" class="material_required_live_quantity"><?= $Grid->renderFieldHeader($Grid->quantity) ?></div></th>
<?php } ?>
<?php if ($Grid->Size_wl->Visible) { // Size_wl ?>
        <th data-name="Size_wl" class="<?= $Grid->Size_wl->headerCellClass() ?>"><div id="elh_material_required_live_Size_wl" class="material_required_live_Size_wl"><?= $Grid->renderFieldHeader($Grid->Size_wl) ?></div></th>
<?php } ?>
<?php if ($Grid->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Grid->sqm->headerCellClass() ?>"><div id="elh_material_required_live_sqm" class="material_required_live_sqm"><?= $Grid->renderFieldHeader($Grid->sqm) ?></div></th>
<?php } ?>
<?php if ($Grid->req_material_rid->Visible) { // req_material_rid ?>
        <th data-name="req_material_rid" class="<?= $Grid->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_live_req_material_rid" class="material_required_live_req_material_rid"><?= $Grid->renderFieldHeader($Grid->req_material_rid) ?></div></th>
<?php } ?>
<?php if ($Grid->req_material_qty->Visible) { // req_material_qty ?>
        <th data-name="req_material_qty" class="<?= $Grid->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_live_req_material_qty" class="material_required_live_req_material_qty"><?= $Grid->renderFieldHeader($Grid->req_material_qty) ?></div></th>
<?php } ?>
<?php if ($Grid->req_material_packing->Visible) { // req_material_packing ?>
        <th data-name="req_material_packing" class="<?= $Grid->req_material_packing->headerCellClass() ?>"><div id="elh_material_required_live_req_material_packing" class="material_required_live_req_material_packing"><?= $Grid->renderFieldHeader($Grid->req_material_packing) ?></div></th>
<?php } ?>
<?php if ($Grid->unit->Visible) { // unit ?>
        <th data-name="unit" class="<?= $Grid->unit->headerCellClass() ?>"><div id="elh_material_required_live_unit" class="material_required_live_unit"><?= $Grid->renderFieldHeader($Grid->unit) ?></div></th>
<?php } ?>
<?php if ($Grid->material_qty->Visible) { // material_qty ?>
        <th data-name="material_qty" class="<?= $Grid->material_qty->headerCellClass() ?>"><div id="elh_material_required_live_material_qty" class="material_required_live_material_qty"><?= $Grid->renderFieldHeader($Grid->material_qty) ?></div></th>
<?php } ?>
<?php if ($Grid->method->Visible) { // method ?>
        <th data-name="method" class="<?= $Grid->method->headerCellClass() ?>"><div id="elh_material_required_live_method" class="material_required_live_method"><?= $Grid->renderFieldHeader($Grid->method) ?></div></th>
<?php } ?>
<?php if ($Grid->despatch_week->Visible) { // despatch_week ?>
        <th data-name="despatch_week" class="<?= $Grid->despatch_week->headerCellClass() ?>"><div id="elh_material_required_live_despatch_week" class="material_required_live_despatch_week"><?= $Grid->renderFieldHeader($Grid->despatch_week) ?></div></th>
<?php } ?>
<?php if ($Grid->despatch_date->Visible) { // despatch_date ?>
        <th data-name="despatch_date" class="<?= $Grid->despatch_date->headerCellClass() ?>"><div id="elh_material_required_live_despatch_date" class="material_required_live_despatch_date"><?= $Grid->renderFieldHeader($Grid->despatch_date) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_material_required_live_operator" class="material_required_live_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->material_out->Visible) { // material_out ?>
        <th data-name="material_out" class="<?= $Grid->material_out->headerCellClass() ?>"><div id="elh_material_required_live_material_out" class="material_required_live_material_out"><?= $Grid->renderFieldHeader($Grid->material_out) ?></div></th>
<?php } ?>
<?php if ($Grid->order_id->Visible) { // order_id ?>
        <th data-name="order_id" class="<?= $Grid->order_id->headerCellClass() ?>"><div id="elh_material_required_live_order_id" class="material_required_live_order_id"><?= $Grid->renderFieldHeader($Grid->order_id) ?></div></th>
<?php } ?>
<?php if ($Grid->issue_to->Visible) { // issue_to ?>
        <th data-name="issue_to" class="<?= $Grid->issue_to->headerCellClass() ?>"><div id="elh_material_required_live_issue_to" class="material_required_live_issue_to"><?= $Grid->renderFieldHeader($Grid->issue_to) ?></div></th>
<?php } ?>
<?php if ($Grid->pp_id->Visible) { // pp_id ?>
        <th data-name="pp_id" class="<?= $Grid->pp_id->headerCellClass() ?>"><div id="elh_material_required_live_pp_id" class="material_required_live_pp_id"><?= $Grid->renderFieldHeader($Grid->pp_id) ?></div></th>
<?php } ?>
<?php if ($Grid->level->Visible) { // level ?>
        <th data-name="level" class="<?= $Grid->level->headerCellClass() ?>"><div id="elh_material_required_live_level" class="material_required_live_level"><?= $Grid->renderFieldHeader($Grid->level) ?></div></th>
<?php } ?>
<?php if ($Grid->product_category->Visible) { // product_category ?>
        <th data-name="product_category" class="<?= $Grid->product_category->headerCellClass() ?>"><div id="elh_material_required_live_product_category" class="material_required_live_product_category"><?= $Grid->renderFieldHeader($Grid->product_category) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_id" class="el_material_required_live_id"></span>
<input type="hidden" data-table="material_required_live" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_id" class="el_material_required_live_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_live" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_id" class="el_material_required_live_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_id" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_id" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_id" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_id" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="material_required_live" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->poid->Visible) { // poid ?>
        <td data-name="poid"<?= $Grid->poid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_poid" class="el_material_required_live_poid">
<input type="<?= $Grid->poid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_poid" id="x<?= $Grid->RowIndex ?>_poid" data-table="material_required_live" data-field="x_poid" value="<?= $Grid->poid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->poid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->poid->formatPattern()) ?>"<?= $Grid->poid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->poid->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_poid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_poid" id="o<?= $Grid->RowIndex ?>_poid" value="<?= HtmlEncode($Grid->poid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_poid" class="el_material_required_live_poid">
<span<?= $Grid->poid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->poid->getDisplayValue($Grid->poid->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_live" data-field="x_poid" data-hidden="1" name="x<?= $Grid->RowIndex ?>_poid" id="x<?= $Grid->RowIndex ?>_poid" value="<?= HtmlEncode($Grid->poid->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_poid" class="el_material_required_live_poid">
<span<?= $Grid->poid->viewAttributes() ?>>
<?= $Grid->poid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_poid" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_poid" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_poid" value="<?= HtmlEncode($Grid->poid->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_poid" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_poid" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_poid" value="<?= HtmlEncode($Grid->poid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->weaving_works->Visible) { // weaving_works ?>
        <td data-name="weaving_works"<?= $Grid->weaving_works->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_weaving_works" class="el_material_required_live_weaving_works">
    <select
        id="x<?= $Grid->RowIndex ?>_weaving_works"
        name="x<?= $Grid->RowIndex ?>_weaving_works"
        class="form-select ew-select<?= $Grid->weaving_works->isInvalidClass() ?>"
        <?php if (!$Grid->weaving_works->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_weaving_works"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_weaving_works"
        data-value-separator="<?= $Grid->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->weaving_works->getPlaceHolder()) ?>"
        <?= $Grid->weaving_works->editAttributes() ?>>
        <?= $Grid->weaving_works->selectOptionListHtml("x{$Grid->RowIndex}_weaving_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->weaving_works->getErrorMessage() ?></div>
<?= $Grid->weaving_works->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_weaving_works") ?>
<?php if (!$Grid->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_weaving_works", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_weaving_works", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_weaving_works", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_weaving_works" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_weaving_works" id="o<?= $Grid->RowIndex ?>_weaving_works" value="<?= HtmlEncode($Grid->weaving_works->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_weaving_works" class="el_material_required_live_weaving_works">
    <select
        id="x<?= $Grid->RowIndex ?>_weaving_works"
        name="x<?= $Grid->RowIndex ?>_weaving_works"
        class="form-select ew-select<?= $Grid->weaving_works->isInvalidClass() ?>"
        <?php if (!$Grid->weaving_works->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_weaving_works"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_weaving_works"
        data-value-separator="<?= $Grid->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->weaving_works->getPlaceHolder()) ?>"
        <?= $Grid->weaving_works->editAttributes() ?>>
        <?= $Grid->weaving_works->selectOptionListHtml("x{$Grid->RowIndex}_weaving_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->weaving_works->getErrorMessage() ?></div>
<?= $Grid->weaving_works->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_weaving_works") ?>
<?php if (!$Grid->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_weaving_works", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_weaving_works", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_weaving_works", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_weaving_works" class="el_material_required_live_weaving_works">
<span<?= $Grid->weaving_works->viewAttributes() ?>>
<?= $Grid->weaving_works->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_weaving_works" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_weaving_works" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_weaving_works" value="<?= HtmlEncode($Grid->weaving_works->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_weaving_works" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_weaving_works" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_weaving_works" value="<?= HtmlEncode($Grid->weaving_works->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->week->Visible) { // week ?>
        <td data-name="week"<?= $Grid->week->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_week" class="el_material_required_live_week">
    <select
        id="x<?= $Grid->RowIndex ?>_week"
        name="x<?= $Grid->RowIndex ?>_week"
        class="form-select ew-select<?= $Grid->week->isInvalidClass() ?>"
        <?php if (!$Grid->week->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_week"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_week"
        data-value-separator="<?= $Grid->week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->week->getPlaceHolder()) ?>"
        <?= $Grid->week->editAttributes() ?>>
        <?= $Grid->week->selectOptionListHtml("x{$Grid->RowIndex}_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->week->getErrorMessage() ?></div>
<?= $Grid->week->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_week") ?>
<?php if (!$Grid->week->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_week", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.week?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_week", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_week", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_week" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_week" id="o<?= $Grid->RowIndex ?>_week" value="<?= HtmlEncode($Grid->week->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_week" class="el_material_required_live_week">
<span<?= $Grid->week->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->week->getDisplayValue($Grid->week->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_live" data-field="x_week" data-hidden="1" name="x<?= $Grid->RowIndex ?>_week" id="x<?= $Grid->RowIndex ?>_week" value="<?= HtmlEncode($Grid->week->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_week" class="el_material_required_live_week">
<span<?= $Grid->week->viewAttributes() ?>>
<?= $Grid->week->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_week" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_week" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_week" value="<?= HtmlEncode($Grid->week->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_week" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_week" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_week" value="<?= HtmlEncode($Grid->week->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->po->Visible) { // po ?>
        <td data-name="po"<?= $Grid->po->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->po->getSessionValue() != "") { ?>
<span<?= $Grid->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->po->getDisplayValue($Grid->po->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_po" name="x<?= $Grid->RowIndex ?>_po" value="<?= HtmlEncode($Grid->po->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_po" class="el_material_required_live_po">
<input type="<?= $Grid->po->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_po" id="x<?= $Grid->RowIndex ?>_po" data-table="material_required_live" data-field="x_po" value="<?= $Grid->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->po->formatPattern()) ?>"<?= $Grid->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->po->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="material_required_live" data-field="x_po" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_po" id="o<?= $Grid->RowIndex ?>_po" value="<?= HtmlEncode($Grid->po->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_po" class="el_material_required_live_po">
<span<?= $Grid->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->po->getDisplayValue($Grid->po->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_live" data-field="x_po" data-hidden="1" name="x<?= $Grid->RowIndex ?>_po" id="x<?= $Grid->RowIndex ?>_po" value="<?= HtmlEncode($Grid->po->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_po" class="el_material_required_live_po">
<span<?= $Grid->po->viewAttributes() ?>>
<?= $Grid->po->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_po" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_po" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_po" value="<?= HtmlEncode($Grid->po->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_po" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_po" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_po" value="<?= HtmlEncode($Grid->po->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id"<?= $Grid->buyer_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_buyer_id" class="el_material_required_live_buyer_id">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_buyer_id"
        name="x<?= $Grid->RowIndex ?>_buyer_id"
        class="form-select ew-select<?= $Grid->buyer_id->isInvalidClass() ?>"
        <?php if (!$Grid->buyer_id->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_buyer_id"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_buyer_id"
        data-value-separator="<?= $Grid->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->buyer_id->getPlaceHolder()) ?>"
        <?= $Grid->buyer_id->editAttributes() ?>>
        <?= $Grid->buyer_id->selectOptionListHtml("x{$Grid->RowIndex}_buyer_id") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "buyer") && !$Grid->buyer_id->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_buyer_id" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->buyer_id->caption() ?>" data-title="<?= $Grid->buyer_id->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_buyer_id" data-url="<?= GetUrl("buyeraddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->buyer_id->getErrorMessage() ?></div>
<?= $Grid->buyer_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_buyer_id") ?>
<?php if (!$Grid->buyer_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_buyer_id", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_buyer_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_buyer_id", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_buyer_id", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.buyer_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_buyer_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_buyer_id" id="o<?= $Grid->RowIndex ?>_buyer_id" value="<?= HtmlEncode($Grid->buyer_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_buyer_id" class="el_material_required_live_buyer_id">
<span<?= $Grid->buyer_id->viewAttributes() ?>>
<?php if (!EmptyString($Grid->buyer_id->EditValue) && $Grid->buyer_id->linkAttributes() != "") { ?>
<a<?= $Grid->buyer_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->buyer_id->getDisplayValue($Grid->buyer_id->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->buyer_id->getDisplayValue($Grid->buyer_id->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_buyer_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_buyer_id" id="x<?= $Grid->RowIndex ?>_buyer_id" value="<?= HtmlEncode($Grid->buyer_id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_buyer_id" class="el_material_required_live_buyer_id">
<span<?= $Grid->buyer_id->viewAttributes() ?>>
<?php if (!EmptyString($Grid->buyer_id->getViewValue()) && $Grid->buyer_id->linkAttributes() != "") { ?>
<a<?= $Grid->buyer_id->linkAttributes() ?>><?= $Grid->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_buyer_id" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_buyer_id" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_buyer_id" value="<?= HtmlEncode($Grid->buyer_id->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_buyer_id" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_buyer_id" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_buyer_id" value="<?= HtmlEncode($Grid->buyer_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->product_id->Visible) { // product_id ?>
        <td data-name="product_id"<?= $Grid->product_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_product_id" class="el_material_required_live_product_id">
    <select
        id="x<?= $Grid->RowIndex ?>_product_id"
        name="x<?= $Grid->RowIndex ?>_product_id"
        class="form-select ew-select<?= $Grid->product_id->isInvalidClass() ?>"
        <?php if (!$Grid->product_id->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_product_id"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_product_id"
        data-value-separator="<?= $Grid->product_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product_id->getPlaceHolder()) ?>"
        <?= $Grid->product_id->editAttributes() ?>>
        <?= $Grid->product_id->selectOptionListHtml("x{$Grid->RowIndex}_product_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product_id->getErrorMessage() ?></div>
<?= $Grid->product_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product_id") ?>
<?php if (!$Grid->product_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product_id", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_product_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.product_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product_id", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product_id", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.product_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_product_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product_id" id="o<?= $Grid->RowIndex ?>_product_id" value="<?= HtmlEncode($Grid->product_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_product_id" class="el_material_required_live_product_id">
<span<?= $Grid->product_id->viewAttributes() ?>>
<?php if (!EmptyString($Grid->product_id->EditValue) && $Grid->product_id->linkAttributes() != "") { ?>
<a<?= $Grid->product_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->product_id->getDisplayValue($Grid->product_id->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->product_id->getDisplayValue($Grid->product_id->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_product_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_product_id" id="x<?= $Grid->RowIndex ?>_product_id" value="<?= HtmlEncode($Grid->product_id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_product_id" class="el_material_required_live_product_id">
<span<?= $Grid->product_id->viewAttributes() ?>>
<?php if (!EmptyString($Grid->product_id->getViewValue()) && $Grid->product_id->linkAttributes() != "") { ?>
<a<?= $Grid->product_id->linkAttributes() ?>><?= $Grid->product_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->product_id->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_product_id" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_product_id" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_product_id" value="<?= HtmlEncode($Grid->product_id->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_product_id" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_product_id" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_product_id" value="<?= HtmlEncode($Grid->product_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Grid->batch_no->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_batch_no" class="el_material_required_live_batch_no">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_batch_no"
        name="x<?= $Grid->RowIndex ?>_batch_no"
        class="form-control ew-select<?= $Grid->batch_no->isInvalidClass() ?>"
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_batch_no"
        data-table="material_required_live"
        data-field="x_batch_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->batch_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->batch_no->getPlaceHolder()) ?>"
        <?= $Grid->batch_no->editAttributes() ?>>
        <?= $Grid->batch_no->selectOptionListHtml("x{$Grid->RowIndex}_batch_no") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "batch_no") && !$Grid->batch_no->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_batch_no" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->batch_no->caption() ?>" data-title="<?= $Grid->batch_no->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_batch_no" data-url="<?= GetUrl("batchnoaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->batch_no->getErrorMessage() ?></div>
<?= $Grid->batch_no->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_batch_no") ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_batch_no", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_batch_no" };
    if (fmaterial_required_livegrid.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_batch_no", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_batch_no", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.material_required_live.fields.batch_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_batch_no" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_batch_no" id="o<?= $Grid->RowIndex ?>_batch_no" value="<?= HtmlEncode($Grid->batch_no->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_batch_no" class="el_material_required_live_batch_no">
<span<?= $Grid->batch_no->viewAttributes() ?>>
<?php if (!EmptyString($Grid->batch_no->EditValue) && $Grid->batch_no->linkAttributes() != "") { ?>
<a<?= $Grid->batch_no->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->batch_no->getDisplayValue($Grid->batch_no->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->batch_no->getDisplayValue($Grid->batch_no->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_batch_no" data-hidden="1" name="x<?= $Grid->RowIndex ?>_batch_no" id="x<?= $Grid->RowIndex ?>_batch_no" value="<?= HtmlEncode($Grid->batch_no->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_batch_no" class="el_material_required_live_batch_no">
<span<?= $Grid->batch_no->viewAttributes() ?>>
<?php if (!EmptyString($Grid->batch_no->getViewValue()) && $Grid->batch_no->linkAttributes() != "") { ?>
<a<?= $Grid->batch_no->linkAttributes() ?>><?= $Grid->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_batch_no" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_batch_no" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_batch_no" value="<?= HtmlEncode($Grid->batch_no->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_batch_no" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_batch_no" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_batch_no" value="<?= HtmlEncode($Grid->batch_no->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Grid->quantity->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_quantity" class="el_material_required_live_quantity">
<input type="<?= $Grid->quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_quantity" id="x<?= $Grid->RowIndex ?>_quantity" data-table="material_required_live" data-field="x_quantity" value="<?= $Grid->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->quantity->formatPattern()) ?>"<?= $Grid->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->quantity->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_quantity" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_quantity" id="o<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_quantity" class="el_material_required_live_quantity">
<span<?= $Grid->quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->quantity->getDisplayValue($Grid->quantity->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_live" data-field="x_quantity" data-hidden="1" name="x<?= $Grid->RowIndex ?>_quantity" id="x<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_quantity" class="el_material_required_live_quantity">
<span<?= $Grid->quantity->viewAttributes() ?>>
<?= $Grid->quantity->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_quantity" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_quantity" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_quantity" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_quantity" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Size_wl->Visible) { // Size_wl ?>
        <td data-name="Size_wl"<?= $Grid->Size_wl->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_Size_wl" class="el_material_required_live_Size_wl">
<input type="<?= $Grid->Size_wl->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Size_wl" id="x<?= $Grid->RowIndex ?>_Size_wl" data-table="material_required_live" data-field="x_Size_wl" value="<?= $Grid->Size_wl->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Grid->Size_wl->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Size_wl->formatPattern()) ?>"<?= $Grid->Size_wl->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Size_wl->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_Size_wl" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Size_wl" id="o<?= $Grid->RowIndex ?>_Size_wl" value="<?= HtmlEncode($Grid->Size_wl->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_Size_wl" class="el_material_required_live_Size_wl">
<span<?= $Grid->Size_wl->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->Size_wl->getDisplayValue($Grid->Size_wl->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_live" data-field="x_Size_wl" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Size_wl" id="x<?= $Grid->RowIndex ?>_Size_wl" value="<?= HtmlEncode($Grid->Size_wl->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_Size_wl" class="el_material_required_live_Size_wl">
<span<?= $Grid->Size_wl->viewAttributes() ?>>
<?= $Grid->Size_wl->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_Size_wl" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_Size_wl" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_Size_wl" value="<?= HtmlEncode($Grid->Size_wl->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_Size_wl" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_Size_wl" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_Size_wl" value="<?= HtmlEncode($Grid->Size_wl->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Grid->sqm->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_sqm" class="el_material_required_live_sqm">
<input type="<?= $Grid->sqm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_sqm" id="x<?= $Grid->RowIndex ?>_sqm" data-table="material_required_live" data-field="x_sqm" value="<?= $Grid->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->sqm->formatPattern()) ?>"<?= $Grid->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->sqm->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_sqm" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_sqm" id="o<?= $Grid->RowIndex ?>_sqm" value="<?= HtmlEncode($Grid->sqm->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_sqm" class="el_material_required_live_sqm">
<span<?= $Grid->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->sqm->getDisplayValue($Grid->sqm->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_live" data-field="x_sqm" data-hidden="1" name="x<?= $Grid->RowIndex ?>_sqm" id="x<?= $Grid->RowIndex ?>_sqm" value="<?= HtmlEncode($Grid->sqm->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_sqm" class="el_material_required_live_sqm">
<span<?= $Grid->sqm->viewAttributes() ?>>
<?= $Grid->sqm->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_sqm" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_sqm" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_sqm" value="<?= HtmlEncode($Grid->sqm->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_sqm" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_sqm" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_sqm" value="<?= HtmlEncode($Grid->sqm->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->req_material_rid->Visible) { // req_material_rid ?>
        <td data-name="req_material_rid"<?= $Grid->req_material_rid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->req_material_rid->getSessionValue() != "") { ?>
<span<?= $Grid->req_material_rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->req_material_rid->getDisplayValue($Grid->req_material_rid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_req_material_rid" name="x<?= $Grid->RowIndex ?>_req_material_rid" value="<?= HtmlEncode($Grid->req_material_rid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_req_material_rid" class="el_material_required_live_req_material_rid">
<template id="tp_x<?= $Grid->RowIndex ?>_req_material_rid">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="material_required_live" data-field="x_req_material_rid" name="x<?= $Grid->RowIndex ?>_req_material_rid" id="x<?= $Grid->RowIndex ?>_req_material_rid"<?= $Grid->req_material_rid->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_req_material_rid" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_req_material_rid"
    name="x<?= $Grid->RowIndex ?>_req_material_rid"
    value="<?= HtmlEncode($Grid->req_material_rid->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Grid->RowIndex ?>_req_material_rid"
    data-target="dsl_x<?= $Grid->RowIndex ?>_req_material_rid"
    data-repeatcolumn="5"
    class="form-control<?= $Grid->req_material_rid->isInvalidClass() ?>"
    data-table="material_required_live"
    data-field="x_req_material_rid"
    data-value-separator="<?= $Grid->req_material_rid->displayValueSeparatorAttribute() ?>"
    <?= $Grid->req_material_rid->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->req_material_rid->getErrorMessage() ?></div>
<?= $Grid->req_material_rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_req_material_rid") ?>
</span>
<?php } ?>
<input type="hidden" data-table="material_required_live" data-field="x_req_material_rid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_req_material_rid" id="o<?= $Grid->RowIndex ?>_req_material_rid" value="<?= HtmlEncode($Grid->req_material_rid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_req_material_rid" class="el_material_required_live_req_material_rid">
<span<?= $Grid->req_material_rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->req_material_rid->getDisplayValue($Grid->req_material_rid->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_live" data-field="x_req_material_rid" data-hidden="1" name="x<?= $Grid->RowIndex ?>_req_material_rid" id="x<?= $Grid->RowIndex ?>_req_material_rid" value="<?= HtmlEncode($Grid->req_material_rid->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_req_material_rid" class="el_material_required_live_req_material_rid">
<span<?= $Grid->req_material_rid->viewAttributes() ?>>
<?= $Grid->req_material_rid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_req_material_rid" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_req_material_rid" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_req_material_rid" value="<?= HtmlEncode($Grid->req_material_rid->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_req_material_rid" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_req_material_rid" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_req_material_rid" value="<?= HtmlEncode($Grid->req_material_rid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->req_material_qty->Visible) { // req_material_qty ?>
        <td data-name="req_material_qty"<?= $Grid->req_material_qty->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_req_material_qty" class="el_material_required_live_req_material_qty">
<input type="<?= $Grid->req_material_qty->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_req_material_qty" id="x<?= $Grid->RowIndex ?>_req_material_qty" data-table="material_required_live" data-field="x_req_material_qty" value="<?= $Grid->req_material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->req_material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->req_material_qty->formatPattern()) ?>"<?= $Grid->req_material_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->req_material_qty->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_req_material_qty" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_req_material_qty" id="o<?= $Grid->RowIndex ?>_req_material_qty" value="<?= HtmlEncode($Grid->req_material_qty->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_req_material_qty" class="el_material_required_live_req_material_qty">
<span<?= $Grid->req_material_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->req_material_qty->getDisplayValue($Grid->req_material_qty->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_live" data-field="x_req_material_qty" data-hidden="1" name="x<?= $Grid->RowIndex ?>_req_material_qty" id="x<?= $Grid->RowIndex ?>_req_material_qty" value="<?= HtmlEncode($Grid->req_material_qty->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_req_material_qty" class="el_material_required_live_req_material_qty">
<span<?= $Grid->req_material_qty->viewAttributes() ?>>
<?= $Grid->req_material_qty->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_req_material_qty" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_req_material_qty" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_req_material_qty" value="<?= HtmlEncode($Grid->req_material_qty->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_req_material_qty" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_req_material_qty" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_req_material_qty" value="<?= HtmlEncode($Grid->req_material_qty->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->req_material_packing->Visible) { // req_material_packing ?>
        <td data-name="req_material_packing"<?= $Grid->req_material_packing->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_req_material_packing" class="el_material_required_live_req_material_packing">
    <select
        id="x<?= $Grid->RowIndex ?>_req_material_packing"
        name="x<?= $Grid->RowIndex ?>_req_material_packing"
        class="form-select ew-select<?= $Grid->req_material_packing->isInvalidClass() ?>"
        <?php if (!$Grid->req_material_packing->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_req_material_packing"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_req_material_packing"
        data-value-separator="<?= $Grid->req_material_packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->req_material_packing->getPlaceHolder()) ?>"
        <?= $Grid->req_material_packing->editAttributes() ?>>
        <?= $Grid->req_material_packing->selectOptionListHtml("x{$Grid->RowIndex}_req_material_packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->req_material_packing->getErrorMessage() ?></div>
<?= $Grid->req_material_packing->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_req_material_packing") ?>
<?php if (!$Grid->req_material_packing->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_req_material_packing", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_req_material_packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.req_material_packing?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_req_material_packing", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_req_material_packing", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.req_material_packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_req_material_packing" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_req_material_packing" id="o<?= $Grid->RowIndex ?>_req_material_packing" value="<?= HtmlEncode($Grid->req_material_packing->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_req_material_packing" class="el_material_required_live_req_material_packing">
    <select
        id="x<?= $Grid->RowIndex ?>_req_material_packing"
        name="x<?= $Grid->RowIndex ?>_req_material_packing"
        class="form-select ew-select<?= $Grid->req_material_packing->isInvalidClass() ?>"
        <?php if (!$Grid->req_material_packing->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_req_material_packing"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_req_material_packing"
        data-value-separator="<?= $Grid->req_material_packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->req_material_packing->getPlaceHolder()) ?>"
        <?= $Grid->req_material_packing->editAttributes() ?>>
        <?= $Grid->req_material_packing->selectOptionListHtml("x{$Grid->RowIndex}_req_material_packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->req_material_packing->getErrorMessage() ?></div>
<?= $Grid->req_material_packing->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_req_material_packing") ?>
<?php if (!$Grid->req_material_packing->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_req_material_packing", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_req_material_packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.req_material_packing?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_req_material_packing", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_req_material_packing", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.req_material_packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_req_material_packing" class="el_material_required_live_req_material_packing">
<span<?= $Grid->req_material_packing->viewAttributes() ?>>
<?= $Grid->req_material_packing->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_req_material_packing" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_req_material_packing" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_req_material_packing" value="<?= HtmlEncode($Grid->req_material_packing->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_req_material_packing" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_req_material_packing" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_req_material_packing" value="<?= HtmlEncode($Grid->req_material_packing->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->unit->Visible) { // unit ?>
        <td data-name="unit"<?= $Grid->unit->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_unit" class="el_material_required_live_unit">
    <select
        id="x<?= $Grid->RowIndex ?>_unit"
        name="x<?= $Grid->RowIndex ?>_unit"
        class="form-select ew-select<?= $Grid->unit->isInvalidClass() ?>"
        <?php if (!$Grid->unit->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_unit"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_unit"
        data-value-separator="<?= $Grid->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->unit->getPlaceHolder()) ?>"
        <?= $Grid->unit->editAttributes() ?>>
        <?= $Grid->unit->selectOptionListHtml("x{$Grid->RowIndex}_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->unit->getErrorMessage() ?></div>
<?= $Grid->unit->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_unit") ?>
<?php if (!$Grid->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_unit", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.unit?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_unit", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_unit", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_unit" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_unit" id="o<?= $Grid->RowIndex ?>_unit" value="<?= HtmlEncode($Grid->unit->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_unit" class="el_material_required_live_unit">
<span<?= $Grid->unit->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->unit->getDisplayValue($Grid->unit->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_live" data-field="x_unit" data-hidden="1" name="x<?= $Grid->RowIndex ?>_unit" id="x<?= $Grid->RowIndex ?>_unit" value="<?= HtmlEncode($Grid->unit->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_unit" class="el_material_required_live_unit">
<span<?= $Grid->unit->viewAttributes() ?>>
<?= $Grid->unit->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_unit" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_unit" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_unit" value="<?= HtmlEncode($Grid->unit->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_unit" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_unit" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_unit" value="<?= HtmlEncode($Grid->unit->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->material_qty->Visible) { // material_qty ?>
        <td data-name="material_qty"<?= $Grid->material_qty->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_material_qty" class="el_material_required_live_material_qty">
<?php
if (IsRTL()) {
    $Grid->material_qty->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_material_qty" class="ew-auto-suggest">
    <input type="<?= $Grid->material_qty->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_material_qty" id="sv_x<?= $Grid->RowIndex ?>_material_qty" value="<?= RemoveHtml($Grid->material_qty->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->material_qty->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->material_qty->formatPattern()) ?>"<?= $Grid->material_qty->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="material_required_live" data-field="x_material_qty" data-input="sv_x<?= $Grid->RowIndex ?>_material_qty" data-value-separator="<?= $Grid->material_qty->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_material_qty" id="x<?= $Grid->RowIndex ?>_material_qty" value="<?= HtmlEncode($Grid->material_qty->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->material_qty->getErrorMessage() ?></div>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    fmaterial_required_livegrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_material_qty","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->material_qty->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.material_required_live.fields.material_qty.autoSuggestOptions));
});
</script>
<?= $Grid->material_qty->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_material_qty") ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_material_qty" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_material_qty" id="o<?= $Grid->RowIndex ?>_material_qty" value="<?= HtmlEncode($Grid->material_qty->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_material_qty" class="el_material_required_live_material_qty">
<span<?= $Grid->material_qty->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->material_qty->getDisplayValue($Grid->material_qty->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_live" data-field="x_material_qty" data-hidden="1" name="x<?= $Grid->RowIndex ?>_material_qty" id="x<?= $Grid->RowIndex ?>_material_qty" value="<?= HtmlEncode($Grid->material_qty->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_material_qty" class="el_material_required_live_material_qty">
<span<?= $Grid->material_qty->viewAttributes() ?>>
<?= $Grid->material_qty->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_material_qty" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_material_qty" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_material_qty" value="<?= HtmlEncode($Grid->material_qty->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_material_qty" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_material_qty" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_material_qty" value="<?= HtmlEncode($Grid->material_qty->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->method->Visible) { // method ?>
        <td data-name="method"<?= $Grid->method->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_method" class="el_material_required_live_method">
    <select
        id="x<?= $Grid->RowIndex ?>_method"
        name="x<?= $Grid->RowIndex ?>_method"
        class="form-select ew-select<?= $Grid->method->isInvalidClass() ?>"
        <?php if (!$Grid->method->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_method"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_method"
        data-value-separator="<?= $Grid->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->method->getPlaceHolder()) ?>"
        <?= $Grid->method->editAttributes() ?>>
        <?= $Grid->method->selectOptionListHtml("x{$Grid->RowIndex}_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->method->getErrorMessage() ?></div>
<?= $Grid->method->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_method") ?>
<?php if (!$Grid->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_method", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.method?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_method", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_method", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_method" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_method" id="o<?= $Grid->RowIndex ?>_method" value="<?= HtmlEncode($Grid->method->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_method" class="el_material_required_live_method">
<span<?= $Grid->method->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->method->getDisplayValue($Grid->method->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_live" data-field="x_method" data-hidden="1" name="x<?= $Grid->RowIndex ?>_method" id="x<?= $Grid->RowIndex ?>_method" value="<?= HtmlEncode($Grid->method->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_method" class="el_material_required_live_method">
<span<?= $Grid->method->viewAttributes() ?>>
<?= $Grid->method->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_method" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_method" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_method" value="<?= HtmlEncode($Grid->method->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_method" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_method" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_method" value="<?= HtmlEncode($Grid->method->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week"<?= $Grid->despatch_week->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_despatch_week" class="el_material_required_live_despatch_week">
    <select
        id="x<?= $Grid->RowIndex ?>_despatch_week"
        name="x<?= $Grid->RowIndex ?>_despatch_week"
        class="form-select ew-select<?= $Grid->despatch_week->isInvalidClass() ?>"
        <?php if (!$Grid->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_despatch_week"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_despatch_week"
        data-value-separator="<?= $Grid->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->despatch_week->getPlaceHolder()) ?>"
        <?= $Grid->despatch_week->editAttributes() ?>>
        <?= $Grid->despatch_week->selectOptionListHtml("x{$Grid->RowIndex}_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->despatch_week->getErrorMessage() ?></div>
<?= $Grid->despatch_week->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_despatch_week") ?>
<?php if (!$Grid->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_despatch_week", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_despatch_week", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_despatch_week", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_despatch_week" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_despatch_week" id="o<?= $Grid->RowIndex ?>_despatch_week" value="<?= HtmlEncode($Grid->despatch_week->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_despatch_week" class="el_material_required_live_despatch_week">
<span<?= $Grid->despatch_week->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->despatch_week->getDisplayValue($Grid->despatch_week->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_live" data-field="x_despatch_week" data-hidden="1" name="x<?= $Grid->RowIndex ?>_despatch_week" id="x<?= $Grid->RowIndex ?>_despatch_week" value="<?= HtmlEncode($Grid->despatch_week->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_despatch_week" class="el_material_required_live_despatch_week">
<span<?= $Grid->despatch_week->viewAttributes() ?>>
<?= $Grid->despatch_week->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_despatch_week" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_despatch_week" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_despatch_week" value="<?= HtmlEncode($Grid->despatch_week->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_despatch_week" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_despatch_week" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_despatch_week" value="<?= HtmlEncode($Grid->despatch_week->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->despatch_date->Visible) { // despatch_date ?>
        <td data-name="despatch_date"<?= $Grid->despatch_date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_despatch_date" class="el_material_required_live_despatch_date">
<input type="<?= $Grid->despatch_date->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_despatch_date" id="x<?= $Grid->RowIndex ?>_despatch_date" data-table="material_required_live" data-field="x_despatch_date" value="<?= $Grid->despatch_date->EditValue ?>" placeholder="<?= HtmlEncode($Grid->despatch_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->despatch_date->formatPattern()) ?>"<?= $Grid->despatch_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->despatch_date->getErrorMessage() ?></div>
<?php if (!$Grid->despatch_date->ReadOnly && !$Grid->despatch_date->Disabled && !isset($Grid->despatch_date->EditAttrs["readonly"]) && !isset($Grid->despatch_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_required_livegrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_required_livegrid", "x<?= $Grid->RowIndex ?>_despatch_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_despatch_date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_despatch_date" id="o<?= $Grid->RowIndex ?>_despatch_date" value="<?= HtmlEncode($Grid->despatch_date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_despatch_date" class="el_material_required_live_despatch_date">
<input type="<?= $Grid->despatch_date->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_despatch_date" id="x<?= $Grid->RowIndex ?>_despatch_date" data-table="material_required_live" data-field="x_despatch_date" value="<?= $Grid->despatch_date->EditValue ?>" placeholder="<?= HtmlEncode($Grid->despatch_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->despatch_date->formatPattern()) ?>"<?= $Grid->despatch_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->despatch_date->getErrorMessage() ?></div>
<?php if (!$Grid->despatch_date->ReadOnly && !$Grid->despatch_date->Disabled && !isset($Grid->despatch_date->EditAttrs["readonly"]) && !isset($Grid->despatch_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_required_livegrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_required_livegrid", "x<?= $Grid->RowIndex ?>_despatch_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_despatch_date" class="el_material_required_live_despatch_date">
<span<?= $Grid->despatch_date->viewAttributes() ?>>
<?= $Grid->despatch_date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_despatch_date" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_despatch_date" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_despatch_date" value="<?= HtmlEncode($Grid->despatch_date->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_despatch_date" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_despatch_date" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_despatch_date" value="<?= HtmlEncode($Grid->despatch_date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="material_required_live" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_operator" class="el_material_required_live_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_operator" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_operator" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_operator" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_operator" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->material_out->Visible) { // material_out ?>
        <td data-name="material_out"<?= $Grid->material_out->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_material_out" class="el_material_required_live_material_out">
<template id="tp_x<?= $Grid->RowIndex ?>_material_out">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="material_required_live" data-field="x_material_out" name="x<?= $Grid->RowIndex ?>_material_out" id="x<?= $Grid->RowIndex ?>_material_out"<?= $Grid->material_out->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_material_out" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_material_out"
    name="x<?= $Grid->RowIndex ?>_material_out"
    value="<?= HtmlEncode($Grid->material_out->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Grid->RowIndex ?>_material_out"
    data-target="dsl_x<?= $Grid->RowIndex ?>_material_out"
    data-repeatcolumn="5"
    class="form-control<?= $Grid->material_out->isInvalidClass() ?>"
    data-table="material_required_live"
    data-field="x_material_out"
    data-value-separator="<?= $Grid->material_out->displayValueSeparatorAttribute() ?>"
    <?= $Grid->material_out->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->material_out->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_material_out" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_material_out" id="o<?= $Grid->RowIndex ?>_material_out" value="<?= HtmlEncode($Grid->material_out->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_material_out" class="el_material_required_live_material_out">
<template id="tp_x<?= $Grid->RowIndex ?>_material_out">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="material_required_live" data-field="x_material_out" name="x<?= $Grid->RowIndex ?>_material_out" id="x<?= $Grid->RowIndex ?>_material_out"<?= $Grid->material_out->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_material_out" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_material_out"
    name="x<?= $Grid->RowIndex ?>_material_out"
    value="<?= HtmlEncode($Grid->material_out->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Grid->RowIndex ?>_material_out"
    data-target="dsl_x<?= $Grid->RowIndex ?>_material_out"
    data-repeatcolumn="5"
    class="form-control<?= $Grid->material_out->isInvalidClass() ?>"
    data-table="material_required_live"
    data-field="x_material_out"
    data-value-separator="<?= $Grid->material_out->displayValueSeparatorAttribute() ?>"
    <?= $Grid->material_out->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->material_out->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_material_out" class="el_material_required_live_material_out">
<span<?= $Grid->material_out->viewAttributes() ?>>
<?= $Grid->material_out->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_material_out" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_material_out" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_material_out" value="<?= HtmlEncode($Grid->material_out->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_material_out" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_material_out" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_material_out" value="<?= HtmlEncode($Grid->material_out->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->order_id->Visible) { // order_id ?>
        <td data-name="order_id"<?= $Grid->order_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_order_id" class="el_material_required_live_order_id">
<input type="<?= $Grid->order_id->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_order_id" id="x<?= $Grid->RowIndex ?>_order_id" data-table="material_required_live" data-field="x_order_id" value="<?= $Grid->order_id->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->order_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->order_id->formatPattern()) ?>"<?= $Grid->order_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->order_id->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_order_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_order_id" id="o<?= $Grid->RowIndex ?>_order_id" value="<?= HtmlEncode($Grid->order_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_order_id" class="el_material_required_live_order_id">
<input type="<?= $Grid->order_id->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_order_id" id="x<?= $Grid->RowIndex ?>_order_id" data-table="material_required_live" data-field="x_order_id" value="<?= $Grid->order_id->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->order_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->order_id->formatPattern()) ?>"<?= $Grid->order_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->order_id->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_order_id" class="el_material_required_live_order_id">
<span<?= $Grid->order_id->viewAttributes() ?>>
<?= $Grid->order_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_order_id" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_order_id" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_order_id" value="<?= HtmlEncode($Grid->order_id->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_order_id" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_order_id" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_order_id" value="<?= HtmlEncode($Grid->order_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->issue_to->Visible) { // issue_to ?>
        <td data-name="issue_to"<?= $Grid->issue_to->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_issue_to" class="el_material_required_live_issue_to">
    <select
        id="x<?= $Grid->RowIndex ?>_issue_to"
        name="x<?= $Grid->RowIndex ?>_issue_to"
        class="form-select ew-select<?= $Grid->issue_to->isInvalidClass() ?>"
        <?php if (!$Grid->issue_to->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_issue_to"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_issue_to"
        data-value-separator="<?= $Grid->issue_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->issue_to->getPlaceHolder()) ?>"
        <?= $Grid->issue_to->editAttributes() ?>>
        <?= $Grid->issue_to->selectOptionListHtml("x{$Grid->RowIndex}_issue_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->issue_to->getErrorMessage() ?></div>
<?= $Grid->issue_to->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_issue_to") ?>
<?php if (!$Grid->issue_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_issue_to", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_issue_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.issue_to?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_issue_to", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_issue_to", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.issue_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_issue_to" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_issue_to" id="o<?= $Grid->RowIndex ?>_issue_to" value="<?= HtmlEncode($Grid->issue_to->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_issue_to" class="el_material_required_live_issue_to">
    <select
        id="x<?= $Grid->RowIndex ?>_issue_to"
        name="x<?= $Grid->RowIndex ?>_issue_to"
        class="form-select ew-select<?= $Grid->issue_to->isInvalidClass() ?>"
        <?php if (!$Grid->issue_to->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_issue_to"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_issue_to"
        data-value-separator="<?= $Grid->issue_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->issue_to->getPlaceHolder()) ?>"
        <?= $Grid->issue_to->editAttributes() ?>>
        <?= $Grid->issue_to->selectOptionListHtml("x{$Grid->RowIndex}_issue_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->issue_to->getErrorMessage() ?></div>
<?= $Grid->issue_to->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_issue_to") ?>
<?php if (!$Grid->issue_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_issue_to", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_issue_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.issue_to?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_issue_to", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_issue_to", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.issue_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_issue_to" class="el_material_required_live_issue_to">
<span<?= $Grid->issue_to->viewAttributes() ?>>
<?= $Grid->issue_to->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_issue_to" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_issue_to" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_issue_to" value="<?= HtmlEncode($Grid->issue_to->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_issue_to" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_issue_to" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_issue_to" value="<?= HtmlEncode($Grid->issue_to->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->pp_id->Visible) { // pp_id ?>
        <td data-name="pp_id"<?= $Grid->pp_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_pp_id" class="el_material_required_live_pp_id">
<input type="<?= $Grid->pp_id->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_pp_id" id="x<?= $Grid->RowIndex ?>_pp_id" data-table="material_required_live" data-field="x_pp_id" value="<?= $Grid->pp_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->pp_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->pp_id->formatPattern()) ?>"<?= $Grid->pp_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->pp_id->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_pp_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_pp_id" id="o<?= $Grid->RowIndex ?>_pp_id" value="<?= HtmlEncode($Grid->pp_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_pp_id" class="el_material_required_live_pp_id">
<input type="<?= $Grid->pp_id->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_pp_id" id="x<?= $Grid->RowIndex ?>_pp_id" data-table="material_required_live" data-field="x_pp_id" value="<?= $Grid->pp_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->pp_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->pp_id->formatPattern()) ?>"<?= $Grid->pp_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->pp_id->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_pp_id" class="el_material_required_live_pp_id">
<span<?= $Grid->pp_id->viewAttributes() ?>>
<?= $Grid->pp_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_pp_id" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_pp_id" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_pp_id" value="<?= HtmlEncode($Grid->pp_id->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_pp_id" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_pp_id" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_pp_id" value="<?= HtmlEncode($Grid->pp_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->level->Visible) { // level ?>
        <td data-name="level"<?= $Grid->level->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_level" class="el_material_required_live_level">
<input type="<?= $Grid->level->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_level" id="x<?= $Grid->RowIndex ?>_level" data-table="material_required_live" data-field="x_level" value="<?= $Grid->level->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->level->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->level->formatPattern()) ?>"<?= $Grid->level->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->level->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_level" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_level" id="o<?= $Grid->RowIndex ?>_level" value="<?= HtmlEncode($Grid->level->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_level" class="el_material_required_live_level">
<input type="<?= $Grid->level->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_level" id="x<?= $Grid->RowIndex ?>_level" data-table="material_required_live" data-field="x_level" value="<?= $Grid->level->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->level->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->level->formatPattern()) ?>"<?= $Grid->level->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->level->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_level" class="el_material_required_live_level">
<span<?= $Grid->level->viewAttributes() ?>>
<?= $Grid->level->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_level" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_level" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_level" value="<?= HtmlEncode($Grid->level->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_level" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_level" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_level" value="<?= HtmlEncode($Grid->level->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->product_category->Visible) { // product_category ?>
        <td data-name="product_category"<?= $Grid->product_category->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_product_category" class="el_material_required_live_product_category">
    <select
        id="x<?= $Grid->RowIndex ?>_product_category"
        name="x<?= $Grid->RowIndex ?>_product_category"
        class="form-select ew-select<?= $Grid->product_category->isInvalidClass() ?>"
        <?php if (!$Grid->product_category->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_product_category"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_product_category"
        data-value-separator="<?= $Grid->product_category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product_category->getPlaceHolder()) ?>"
        <?= $Grid->product_category->editAttributes() ?>>
        <?= $Grid->product_category->selectOptionListHtml("x{$Grid->RowIndex}_product_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product_category->getErrorMessage() ?></div>
<?= $Grid->product_category->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product_category") ?>
<?php if (!$Grid->product_category->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product_category", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_product_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.product_category?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product_category", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product_category", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.product_category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_product_category" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product_category" id="o<?= $Grid->RowIndex ?>_product_category" value="<?= HtmlEncode($Grid->product_category->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_product_category" class="el_material_required_live_product_category">
    <select
        id="x<?= $Grid->RowIndex ?>_product_category"
        name="x<?= $Grid->RowIndex ?>_product_category"
        class="form-select ew-select<?= $Grid->product_category->isInvalidClass() ?>"
        <?php if (!$Grid->product_category->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_product_category"
        <?php } ?>
        data-table="material_required_live"
        data-field="x_product_category"
        data-value-separator="<?= $Grid->product_category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product_category->getPlaceHolder()) ?>"
        <?= $Grid->product_category->editAttributes() ?>>
        <?= $Grid->product_category->selectOptionListHtml("x{$Grid->RowIndex}_product_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product_category->getErrorMessage() ?></div>
<?= $Grid->product_category->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product_category") ?>
<?php if (!$Grid->product_category->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_livegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product_category", selectId: "fmaterial_required_livegrid_x<?= $Grid->RowIndex ?>_product_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_livegrid.lists.product_category?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product_category", form: "fmaterial_required_livegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product_category", form: "fmaterial_required_livegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_live.fields.product_category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_material_required_live_product_category" class="el_material_required_live_product_category">
<span<?= $Grid->product_category->viewAttributes() ?>>
<?= $Grid->product_category->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="material_required_live" data-field="x_product_category" data-hidden="1" name="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_product_category" id="fmaterial_required_livegrid$x<?= $Grid->RowIndex ?>_product_category" value="<?= HtmlEncode($Grid->product_category->FormValue) ?>">
<input type="hidden" data-table="material_required_live" data-field="x_product_category" data-hidden="1" data-old name="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_product_category" id="fmaterial_required_livegrid$o<?= $Grid->RowIndex ?>_product_category" value="<?= HtmlEncode($Grid->product_category->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fmaterial_required_livegrid","load"], () => fmaterial_required_livegrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Grid->RowType = RowType::AGGREGATE;
$Grid->resetAttributes();
$Grid->renderRow();
?>
<?php if ($Grid->TotalRecords > 0 && $Grid->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Grid->renderListOptions();

// Render list options (footer, left)
$Grid->ListOptions->render("footer", "left");
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Grid->id->footerCellClass() ?>"><span id="elf_material_required_live_id" class="material_required_live_id">
        </span></td>
    <?php } ?>
    <?php if ($Grid->poid->Visible) { // poid ?>
        <td data-name="poid" class="<?= $Grid->poid->footerCellClass() ?>"><span id="elf_material_required_live_poid" class="material_required_live_poid">
        </span></td>
    <?php } ?>
    <?php if ($Grid->weaving_works->Visible) { // weaving_works ?>
        <td data-name="weaving_works" class="<?= $Grid->weaving_works->footerCellClass() ?>"><span id="elf_material_required_live_weaving_works" class="material_required_live_weaving_works">
        </span></td>
    <?php } ?>
    <?php if ($Grid->week->Visible) { // week ?>
        <td data-name="week" class="<?= $Grid->week->footerCellClass() ?>"><span id="elf_material_required_live_week" class="material_required_live_week">
        </span></td>
    <?php } ?>
    <?php if ($Grid->po->Visible) { // po ?>
        <td data-name="po" class="<?= $Grid->po->footerCellClass() ?>"><span id="elf_material_required_live_po" class="material_required_live_po">
        </span></td>
    <?php } ?>
    <?php if ($Grid->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id" class="<?= $Grid->buyer_id->footerCellClass() ?>"><span id="elf_material_required_live_buyer_id" class="material_required_live_buyer_id">
        </span></td>
    <?php } ?>
    <?php if ($Grid->product_id->Visible) { // product_id ?>
        <td data-name="product_id" class="<?= $Grid->product_id->footerCellClass() ?>"><span id="elf_material_required_live_product_id" class="material_required_live_product_id">
        </span></td>
    <?php } ?>
    <?php if ($Grid->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no" class="<?= $Grid->batch_no->footerCellClass() ?>"><span id="elf_material_required_live_batch_no" class="material_required_live_batch_no">
        </span></td>
    <?php } ?>
    <?php if ($Grid->quantity->Visible) { // quantity ?>
        <td data-name="quantity" class="<?= $Grid->quantity->footerCellClass() ?>"><span id="elf_material_required_live_quantity" class="material_required_live_quantity">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Size_wl->Visible) { // Size_wl ?>
        <td data-name="Size_wl" class="<?= $Grid->Size_wl->footerCellClass() ?>"><span id="elf_material_required_live_Size_wl" class="material_required_live_Size_wl">
        </span></td>
    <?php } ?>
    <?php if ($Grid->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Grid->sqm->footerCellClass() ?>"><span id="elf_material_required_live_sqm" class="material_required_live_sqm">
        </span></td>
    <?php } ?>
    <?php if ($Grid->req_material_rid->Visible) { // req_material_rid ?>
        <td data-name="req_material_rid" class="<?= $Grid->req_material_rid->footerCellClass() ?>"><span id="elf_material_required_live_req_material_rid" class="material_required_live_req_material_rid">
        </span></td>
    <?php } ?>
    <?php if ($Grid->req_material_qty->Visible) { // req_material_qty ?>
        <td data-name="req_material_qty" class="<?= $Grid->req_material_qty->footerCellClass() ?>"><span id="elf_material_required_live_req_material_qty" class="material_required_live_req_material_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->req_material_qty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->req_material_packing->Visible) { // req_material_packing ?>
        <td data-name="req_material_packing" class="<?= $Grid->req_material_packing->footerCellClass() ?>"><span id="elf_material_required_live_req_material_packing" class="material_required_live_req_material_packing">
        </span></td>
    <?php } ?>
    <?php if ($Grid->unit->Visible) { // unit ?>
        <td data-name="unit" class="<?= $Grid->unit->footerCellClass() ?>"><span id="elf_material_required_live_unit" class="material_required_live_unit">
        </span></td>
    <?php } ?>
    <?php if ($Grid->material_qty->Visible) { // material_qty ?>
        <td data-name="material_qty" class="<?= $Grid->material_qty->footerCellClass() ?>"><span id="elf_material_required_live_material_qty" class="material_required_live_material_qty">
        </span></td>
    <?php } ?>
    <?php if ($Grid->method->Visible) { // method ?>
        <td data-name="method" class="<?= $Grid->method->footerCellClass() ?>"><span id="elf_material_required_live_method" class="material_required_live_method">
        </span></td>
    <?php } ?>
    <?php if ($Grid->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week" class="<?= $Grid->despatch_week->footerCellClass() ?>"><span id="elf_material_required_live_despatch_week" class="material_required_live_despatch_week">
        </span></td>
    <?php } ?>
    <?php if ($Grid->despatch_date->Visible) { // despatch_date ?>
        <td data-name="despatch_date" class="<?= $Grid->despatch_date->footerCellClass() ?>"><span id="elf_material_required_live_despatch_date" class="material_required_live_despatch_date">
        </span></td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator" class="<?= $Grid->operator->footerCellClass() ?>"><span id="elf_material_required_live_operator" class="material_required_live_operator">
        </span></td>
    <?php } ?>
    <?php if ($Grid->material_out->Visible) { // material_out ?>
        <td data-name="material_out" class="<?= $Grid->material_out->footerCellClass() ?>"><span id="elf_material_required_live_material_out" class="material_required_live_material_out">
        </span></td>
    <?php } ?>
    <?php if ($Grid->order_id->Visible) { // order_id ?>
        <td data-name="order_id" class="<?= $Grid->order_id->footerCellClass() ?>"><span id="elf_material_required_live_order_id" class="material_required_live_order_id">
        </span></td>
    <?php } ?>
    <?php if ($Grid->issue_to->Visible) { // issue_to ?>
        <td data-name="issue_to" class="<?= $Grid->issue_to->footerCellClass() ?>"><span id="elf_material_required_live_issue_to" class="material_required_live_issue_to">
        </span></td>
    <?php } ?>
    <?php if ($Grid->pp_id->Visible) { // pp_id ?>
        <td data-name="pp_id" class="<?= $Grid->pp_id->footerCellClass() ?>"><span id="elf_material_required_live_pp_id" class="material_required_live_pp_id">
        </span></td>
    <?php } ?>
    <?php if ($Grid->level->Visible) { // level ?>
        <td data-name="level" class="<?= $Grid->level->footerCellClass() ?>"><span id="elf_material_required_live_level" class="material_required_live_level">
        </span></td>
    <?php } ?>
    <?php if ($Grid->product_category->Visible) { // product_category ?>
        <td data-name="product_category" class="<?= $Grid->product_category->footerCellClass() ?>"><span id="elf_material_required_live_product_category" class="material_required_live_product_category">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Grid->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fmaterial_required_livegrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required_live");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
