<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialRequiredJobCardList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_job_card: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fmaterial_required_job_cardsrch" id="fmaterial_required_job_cardsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fmaterial_required_job_cardsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_job_card: currentTable } });
var currentForm;
var fmaterial_required_job_cardsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmaterial_required_job_cardsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fmaterial_required_job_cardsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fmaterial_required_job_cardsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fmaterial_required_job_cardsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fmaterial_required_job_cardsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fmaterial_required_job_cardsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fmaterial_required_job_cardsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fmaterial_required_job_cardsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_required_job_card">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_material_required_job_card" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_material_required_job_cardlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_material_required_job_card_id" class="material_required_job_card_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->poid->Visible) { // poid ?>
        <th data-name="poid" class="<?= $Page->poid->headerCellClass() ?>"><div id="elh_material_required_job_card_poid" class="material_required_job_card_poid"><?= $Page->renderFieldHeader($Page->poid) ?></div></th>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
        <th data-name="jc_no" class="<?= $Page->jc_no->headerCellClass() ?>"><div id="elh_material_required_job_card_jc_no" class="material_required_job_card_jc_no"><?= $Page->renderFieldHeader($Page->jc_no) ?></div></th>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Page->location->headerCellClass() ?>"><div id="elh_material_required_job_card_location" class="material_required_job_card_location"><?= $Page->renderFieldHeader($Page->location) ?></div></th>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
        <th data-name="issue_to" class="<?= $Page->issue_to->headerCellClass() ?>"><div id="elh_material_required_job_card_issue_to" class="material_required_job_card_issue_to"><?= $Page->renderFieldHeader($Page->issue_to) ?></div></th>
<?php } ?>
<?php if ($Page->week->Visible) { // week ?>
        <th data-name="week" class="<?= $Page->week->headerCellClass() ?>"><div id="elh_material_required_job_card_week" class="material_required_job_card_week"><?= $Page->renderFieldHeader($Page->week) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_material_required_job_card_po" class="material_required_job_card_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <th data-name="buyer_id" class="<?= $Page->buyer_id->headerCellClass() ?>"><div id="elh_material_required_job_card_buyer_id" class="material_required_job_card_buyer_id"><?= $Page->renderFieldHeader($Page->buyer_id) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_material_required_job_card_grp" class="material_required_job_card_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>"><div id="elh_material_required_job_card_s_grp" class="material_required_job_card_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_material_required_job_card_product" class="material_required_job_card_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->product_id->Visible) { // product_id ?>
        <th data-name="product_id" class="<?= $Page->product_id->headerCellClass() ?>"><div id="elh_material_required_job_card_product_id" class="material_required_job_card_product_id"><?= $Page->renderFieldHeader($Page->product_id) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_material_required_job_card_batch_no" class="material_required_job_card_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_material_required_job_card_quantity" class="material_required_job_card_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
        <th data-name="size_cm" class="<?= $Page->size_cm->headerCellClass() ?>"><div id="elh_material_required_job_card_size_cm" class="material_required_job_card_size_cm"><?= $Page->renderFieldHeader($Page->size_cm) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_material_required_job_card_sqm" class="material_required_job_card_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->t_sqm->Visible) { // t_sqm ?>
        <th data-name="t_sqm" class="<?= $Page->t_sqm->headerCellClass() ?>"><div id="elh_material_required_job_card_t_sqm" class="material_required_job_card_t_sqm"><?= $Page->renderFieldHeader($Page->t_sqm) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_grp->Visible) { // req_material_grp ?>
        <th data-name="req_material_grp" class="<?= $Page->req_material_grp->headerCellClass() ?>"><div id="elh_material_required_job_card_req_material_grp" class="material_required_job_card_req_material_grp"><?= $Page->renderFieldHeader($Page->req_material_grp) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_sgrp->Visible) { // req_material_sgrp ?>
        <th data-name="req_material_sgrp" class="<?= $Page->req_material_sgrp->headerCellClass() ?>"><div id="elh_material_required_job_card_req_material_sgrp" class="material_required_job_card_req_material_sgrp"><?= $Page->renderFieldHeader($Page->req_material_sgrp) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_product->Visible) { // req_material_product ?>
        <th data-name="req_material_product" class="<?= $Page->req_material_product->headerCellClass() ?>"><div id="elh_material_required_job_card_req_material_product" class="material_required_job_card_req_material_product"><?= $Page->renderFieldHeader($Page->req_material_product) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <th data-name="req_material_rid" class="<?= $Page->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_job_card_req_material_rid" class="material_required_job_card_req_material_rid"><?= $Page->renderFieldHeader($Page->req_material_rid) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <th data-name="req_material_qty" class="<?= $Page->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_job_card_req_material_qty" class="material_required_job_card_req_material_qty"><?= $Page->renderFieldHeader($Page->req_material_qty) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <th data-name="req_material_packing" class="<?= $Page->req_material_packing->headerCellClass() ?>"><div id="elh_material_required_job_card_req_material_packing" class="material_required_job_card_req_material_packing"><?= $Page->renderFieldHeader($Page->req_material_packing) ?></div></th>
<?php } ?>
<?php if ($Page->stock->Visible) { // stock ?>
        <th data-name="stock" class="<?= $Page->stock->headerCellClass() ?>"><div id="elh_material_required_job_card_stock" class="material_required_job_card_stock"><?= $Page->renderFieldHeader($Page->stock) ?></div></th>
<?php } ?>
<?php if ($Page->short->Visible) { // short ?>
        <th data-name="short" class="<?= $Page->short->headerCellClass() ?>"><div id="elh_material_required_job_card_short" class="material_required_job_card_short"><?= $Page->renderFieldHeader($Page->short) ?></div></th>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
        <th data-name="unit" class="<?= $Page->unit->headerCellClass() ?>"><div id="elh_material_required_job_card_unit" class="material_required_job_card_unit"><?= $Page->renderFieldHeader($Page->unit) ?></div></th>
<?php } ?>
<?php if ($Page->material_qty->Visible) { // material_qty ?>
        <th data-name="material_qty" class="<?= $Page->material_qty->headerCellClass() ?>"><div id="elh_material_required_job_card_material_qty" class="material_required_job_card_material_qty"><?= $Page->renderFieldHeader($Page->material_qty) ?></div></th>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
        <th data-name="method" class="<?= $Page->method->headerCellClass() ?>"><div id="elh_material_required_job_card_method" class="material_required_job_card_method"><?= $Page->renderFieldHeader($Page->method) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <th data-name="despatch_week" class="<?= $Page->despatch_week->headerCellClass() ?>"><div id="elh_material_required_job_card_despatch_week" class="material_required_job_card_despatch_week"><?= $Page->renderFieldHeader($Page->despatch_week) ?></div></th>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <th data-name="despatch_date" class="<?= $Page->despatch_date->headerCellClass() ?>"><div id="elh_material_required_job_card_despatch_date" class="material_required_job_card_despatch_date"><?= $Page->renderFieldHeader($Page->despatch_date) ?></div></th>
<?php } ?>
<?php if ($Page->production_plan->Visible) { // production_plan ?>
        <th data-name="production_plan" class="<?= $Page->production_plan->headerCellClass() ?>"><div id="elh_material_required_job_card_production_plan" class="material_required_job_card_production_plan"><?= $Page->renderFieldHeader($Page->production_plan) ?></div></th>
<?php } ?>
<?php if ($Page->updated->Visible) { // updated ?>
        <th data-name="updated" class="<?= $Page->updated->headerCellClass() ?>"><div id="elh_material_required_job_card_updated" class="material_required_job_card_updated"><?= $Page->renderFieldHeader($Page->updated) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_material_required_job_card_operator" class="material_required_job_card_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_material_required_job_card_datetime" class="material_required_job_card_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->jc_datetime->Visible) { // jc_datetime ?>
        <th data-name="jc_datetime" class="<?= $Page->jc_datetime->headerCellClass() ?>"><div id="elh_material_required_job_card_jc_datetime" class="material_required_job_card_jc_datetime"><?= $Page->renderFieldHeader($Page->jc_datetime) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_material_required_job_card_company_id" class="material_required_job_card_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->m_out_id->Visible) { // m_out_id ?>
        <th data-name="m_out_id" class="<?= $Page->m_out_id->headerCellClass() ?>"><div id="elh_material_required_job_card_m_out_id" class="material_required_job_card_m_out_id"><?= $Page->renderFieldHeader($Page->m_out_id) ?></div></th>
<?php } ?>
<?php if ($Page->issued_qty->Visible) { // issued_qty ?>
        <th data-name="issued_qty" class="<?= $Page->issued_qty->headerCellClass() ?>"><div id="elh_material_required_job_card_issued_qty" class="material_required_job_card_issued_qty"><?= $Page->renderFieldHeader($Page->issued_qty) ?></div></th>
<?php } ?>
<?php if ($Page->pending_qty->Visible) { // pending_qty ?>
        <th data-name="pending_qty" class="<?= $Page->pending_qty->headerCellClass() ?>"><div id="elh_material_required_job_card_pending_qty" class="material_required_job_card_pending_qty"><?= $Page->renderFieldHeader($Page->pending_qty) ?></div></th>
<?php } ?>
<?php if ($Page->m_out_remarks->Visible) { // m_out_remarks ?>
        <th data-name="m_out_remarks" class="<?= $Page->m_out_remarks->headerCellClass() ?>"><div id="elh_material_required_job_card_m_out_remarks" class="material_required_job_card_m_out_remarks"><?= $Page->renderFieldHeader($Page->m_out_remarks) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_id" class="el_material_required_job_card_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->poid->Visible) { // poid ?>
        <td data-name="poid"<?= $Page->poid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_poid" class="el_material_required_job_card_poid">
<span<?= $Page->poid->viewAttributes() ?>>
<?= $Page->poid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_no->Visible) { // jc_no ?>
        <td data-name="jc_no"<?= $Page->jc_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_jc_no" class="el_material_required_job_card_jc_no">
<span<?= $Page->jc_no->viewAttributes() ?>>
<?= $Page->jc_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location"<?= $Page->location->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_location" class="el_material_required_job_card_location">
<span<?= $Page->location->viewAttributes() ?>>
<?= $Page->location->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->issue_to->Visible) { // issue_to ?>
        <td data-name="issue_to"<?= $Page->issue_to->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_issue_to" class="el_material_required_job_card_issue_to">
<span<?= $Page->issue_to->viewAttributes() ?>>
<?= $Page->issue_to->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->week->Visible) { // week ?>
        <td data-name="week"<?= $Page->week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_week" class="el_material_required_job_card_week">
<span<?= $Page->week->viewAttributes() ?>>
<?= $Page->week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_po" class="el_material_required_job_card_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id"<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_buyer_id" class="el_material_required_job_card_buyer_id">
<span<?= $Page->buyer_id->viewAttributes() ?>>
<?= $Page->buyer_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_grp" class="el_material_required_job_card_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_s_grp" class="el_material_required_job_card_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?= $Page->s_grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_product" class="el_material_required_job_card_product">
<span<?= $Page->product->viewAttributes() ?>>
<?= $Page->product->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_id->Visible) { // product_id ?>
        <td data-name="product_id"<?= $Page->product_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_product_id" class="el_material_required_job_card_product_id">
<span<?= $Page->product_id->viewAttributes() ?>>
<?= $Page->product_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_batch_no" class="el_material_required_job_card_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?= $Page->batch_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_quantity" class="el_material_required_job_card_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm"<?= $Page->size_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_size_cm" class="el_material_required_job_card_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<?= $Page->size_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_sqm" class="el_material_required_job_card_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_sqm->Visible) { // t_sqm ?>
        <td data-name="t_sqm"<?= $Page->t_sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_t_sqm" class="el_material_required_job_card_t_sqm">
<span<?= $Page->t_sqm->viewAttributes() ?>>
<?= $Page->t_sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_grp->Visible) { // req_material_grp ?>
        <td data-name="req_material_grp"<?= $Page->req_material_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_req_material_grp" class="el_material_required_job_card_req_material_grp">
<span<?= $Page->req_material_grp->viewAttributes() ?>>
<?= $Page->req_material_grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_sgrp->Visible) { // req_material_sgrp ?>
        <td data-name="req_material_sgrp"<?= $Page->req_material_sgrp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_req_material_sgrp" class="el_material_required_job_card_req_material_sgrp">
<span<?= $Page->req_material_sgrp->viewAttributes() ?>>
<?= $Page->req_material_sgrp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_product->Visible) { // req_material_product ?>
        <td data-name="req_material_product"<?= $Page->req_material_product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_req_material_product" class="el_material_required_job_card_req_material_product">
<span<?= $Page->req_material_product->viewAttributes() ?>>
<?= $Page->req_material_product->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <td data-name="req_material_rid"<?= $Page->req_material_rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_req_material_rid" class="el_material_required_job_card_req_material_rid">
<span<?= $Page->req_material_rid->viewAttributes() ?>>
<?= $Page->req_material_rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <td data-name="req_material_qty"<?= $Page->req_material_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_req_material_qty" class="el_material_required_job_card_req_material_qty">
<span<?= $Page->req_material_qty->viewAttributes() ?>>
<?= $Page->req_material_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <td data-name="req_material_packing"<?= $Page->req_material_packing->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_req_material_packing" class="el_material_required_job_card_req_material_packing">
<span<?= $Page->req_material_packing->viewAttributes() ?>>
<?= $Page->req_material_packing->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->stock->Visible) { // stock ?>
        <td data-name="stock"<?= $Page->stock->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_stock" class="el_material_required_job_card_stock">
<span<?= $Page->stock->viewAttributes() ?>>
<?= $Page->stock->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->short->Visible) { // short ?>
        <td data-name="short"<?= $Page->short->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_short" class="el_material_required_job_card_short">
<span<?= $Page->short->viewAttributes() ?>>
<?= $Page->short->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->unit->Visible) { // unit ?>
        <td data-name="unit"<?= $Page->unit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_unit" class="el_material_required_job_card_unit">
<span<?= $Page->unit->viewAttributes() ?>>
<?= $Page->unit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->material_qty->Visible) { // material_qty ?>
        <td data-name="material_qty"<?= $Page->material_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_material_qty" class="el_material_required_job_card_material_qty">
<span<?= $Page->material_qty->viewAttributes() ?>>
<?= $Page->material_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->method->Visible) { // method ?>
        <td data-name="method"<?= $Page->method->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_method" class="el_material_required_job_card_method">
<span<?= $Page->method->viewAttributes() ?>>
<?= $Page->method->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_week->Visible) { // despatch_week ?>
        <td data-name="despatch_week"<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_despatch_week" class="el_material_required_job_card_despatch_week">
<span<?= $Page->despatch_week->viewAttributes() ?>>
<?= $Page->despatch_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatch_date->Visible) { // despatch_date ?>
        <td data-name="despatch_date"<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_despatch_date" class="el_material_required_job_card_despatch_date">
<span<?= $Page->despatch_date->viewAttributes() ?>>
<?= $Page->despatch_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->production_plan->Visible) { // production_plan ?>
        <td data-name="production_plan"<?= $Page->production_plan->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_production_plan" class="el_material_required_job_card_production_plan">
<span<?= $Page->production_plan->viewAttributes() ?>>
<?= $Page->production_plan->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->updated->Visible) { // updated ?>
        <td data-name="updated"<?= $Page->updated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_updated" class="el_material_required_job_card_updated">
<span<?= $Page->updated->viewAttributes() ?>>
<?= $Page->updated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_operator" class="el_material_required_job_card_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_datetime" class="el_material_required_job_card_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_datetime->Visible) { // jc_datetime ?>
        <td data-name="jc_datetime"<?= $Page->jc_datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_jc_datetime" class="el_material_required_job_card_jc_datetime">
<span<?= $Page->jc_datetime->viewAttributes() ?>>
<?= $Page->jc_datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_company_id" class="el_material_required_job_card_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_out_id->Visible) { // m_out_id ?>
        <td data-name="m_out_id"<?= $Page->m_out_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_m_out_id" class="el_material_required_job_card_m_out_id">
<span<?= $Page->m_out_id->viewAttributes() ?>>
<?= $Page->m_out_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->issued_qty->Visible) { // issued_qty ?>
        <td data-name="issued_qty"<?= $Page->issued_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_issued_qty" class="el_material_required_job_card_issued_qty">
<span<?= $Page->issued_qty->viewAttributes() ?>>
<?= $Page->issued_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending_qty->Visible) { // pending_qty ?>
        <td data-name="pending_qty"<?= $Page->pending_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_pending_qty" class="el_material_required_job_card_pending_qty">
<span<?= $Page->pending_qty->viewAttributes() ?>>
<?= $Page->pending_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_out_remarks->Visible) { // m_out_remarks ?>
        <td data-name="m_out_remarks"<?= $Page->m_out_remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_material_required_job_card_m_out_remarks" class="el_material_required_job_card_m_out_remarks">
<span<?= $Page->m_out_remarks->viewAttributes() ?>>
<?= $Page->m_out_remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required_job_card");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
