<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialRequiredJobCardAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_job_card: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fmaterial_required_job_cardadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmaterial_required_job_cardadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["poid", [fields.poid.visible && fields.poid.required ? ew.Validators.required(fields.poid.caption) : null, ew.Validators.integer], fields.poid.isInvalid],
            ["jc_no", [fields.jc_no.visible && fields.jc_no.required ? ew.Validators.required(fields.jc_no.caption) : null, ew.Validators.integer], fields.jc_no.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null, ew.Validators.integer], fields.location.isInvalid],
            ["issue_to", [fields.issue_to.visible && fields.issue_to.required ? ew.Validators.required(fields.issue_to.caption) : null, ew.Validators.integer], fields.issue_to.isInvalid],
            ["week", [fields.week.visible && fields.week.required ? ew.Validators.required(fields.week.caption) : null, ew.Validators.integer], fields.week.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null, ew.Validators.integer], fields.po.isInvalid],
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null, ew.Validators.integer], fields.buyer_id.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null, ew.Validators.integer], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null, ew.Validators.integer], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null, ew.Validators.integer], fields.product.isInvalid],
            ["product_id", [fields.product_id.visible && fields.product_id.required ? ew.Validators.required(fields.product_id.caption) : null, ew.Validators.integer], fields.product_id.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null, ew.Validators.integer], fields.batch_no.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["size_cm", [fields.size_cm.visible && fields.size_cm.required ? ew.Validators.required(fields.size_cm.caption) : null], fields.size_cm.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null, ew.Validators.float], fields.sqm.isInvalid],
            ["t_sqm", [fields.t_sqm.visible && fields.t_sqm.required ? ew.Validators.required(fields.t_sqm.caption) : null, ew.Validators.float], fields.t_sqm.isInvalid],
            ["req_material_grp", [fields.req_material_grp.visible && fields.req_material_grp.required ? ew.Validators.required(fields.req_material_grp.caption) : null, ew.Validators.integer], fields.req_material_grp.isInvalid],
            ["req_material_sgrp", [fields.req_material_sgrp.visible && fields.req_material_sgrp.required ? ew.Validators.required(fields.req_material_sgrp.caption) : null, ew.Validators.integer], fields.req_material_sgrp.isInvalid],
            ["req_material_product", [fields.req_material_product.visible && fields.req_material_product.required ? ew.Validators.required(fields.req_material_product.caption) : null, ew.Validators.integer], fields.req_material_product.isInvalid],
            ["req_material_rid", [fields.req_material_rid.visible && fields.req_material_rid.required ? ew.Validators.required(fields.req_material_rid.caption) : null, ew.Validators.integer], fields.req_material_rid.isInvalid],
            ["req_material_qty", [fields.req_material_qty.visible && fields.req_material_qty.required ? ew.Validators.required(fields.req_material_qty.caption) : null, ew.Validators.float], fields.req_material_qty.isInvalid],
            ["req_material_packing", [fields.req_material_packing.visible && fields.req_material_packing.required ? ew.Validators.required(fields.req_material_packing.caption) : null, ew.Validators.integer], fields.req_material_packing.isInvalid],
            ["stock", [fields.stock.visible && fields.stock.required ? ew.Validators.required(fields.stock.caption) : null, ew.Validators.float], fields.stock.isInvalid],
            ["short", [fields.short.visible && fields.short.required ? ew.Validators.required(fields.short.caption) : null, ew.Validators.float], fields.short.isInvalid],
            ["unit", [fields.unit.visible && fields.unit.required ? ew.Validators.required(fields.unit.caption) : null], fields.unit.isInvalid],
            ["material_qty", [fields.material_qty.visible && fields.material_qty.required ? ew.Validators.required(fields.material_qty.caption) : null, ew.Validators.float], fields.material_qty.isInvalid],
            ["method", [fields.method.visible && fields.method.required ? ew.Validators.required(fields.method.caption) : null, ew.Validators.integer], fields.method.isInvalid],
            ["despatch_week", [fields.despatch_week.visible && fields.despatch_week.required ? ew.Validators.required(fields.despatch_week.caption) : null, ew.Validators.integer], fields.despatch_week.isInvalid],
            ["despatch_date", [fields.despatch_date.visible && fields.despatch_date.required ? ew.Validators.required(fields.despatch_date.caption) : null, ew.Validators.datetime(fields.despatch_date.clientFormatPattern)], fields.despatch_date.isInvalid],
            ["production_plan", [fields.production_plan.visible && fields.production_plan.required ? ew.Validators.required(fields.production_plan.caption) : null, ew.Validators.integer], fields.production_plan.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["updated", [fields.updated.visible && fields.updated.required ? ew.Validators.required(fields.updated.caption) : null, ew.Validators.integer], fields.updated.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null, ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null, ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["jc_datetime", [fields.jc_datetime.visible && fields.jc_datetime.required ? ew.Validators.required(fields.jc_datetime.caption) : null, ew.Validators.datetime(fields.jc_datetime.clientFormatPattern)], fields.jc_datetime.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null, ew.Validators.integer], fields.company_id.isInvalid],
            ["m_out_id", [fields.m_out_id.visible && fields.m_out_id.required ? ew.Validators.required(fields.m_out_id.caption) : null], fields.m_out_id.isInvalid],
            ["issued_qty", [fields.issued_qty.visible && fields.issued_qty.required ? ew.Validators.required(fields.issued_qty.caption) : null, ew.Validators.float], fields.issued_qty.isInvalid],
            ["pending_qty", [fields.pending_qty.visible && fields.pending_qty.required ? ew.Validators.required(fields.pending_qty.caption) : null, ew.Validators.float], fields.pending_qty.isInvalid],
            ["m_out_remarks", [fields.m_out_remarks.visible && fields.m_out_remarks.required ? ew.Validators.required(fields.m_out_remarks.caption) : null], fields.m_out_remarks.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmaterial_required_job_cardadd" id="fmaterial_required_job_cardadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_required_job_card">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->poid->Visible) { // poid ?>
    <div id="r_poid"<?= $Page->poid->rowAttributes() ?>>
        <label id="elh_material_required_job_card_poid" for="x_poid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->poid->caption() ?><?= $Page->poid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->poid->cellAttributes() ?>>
<span id="el_material_required_job_card_poid">
<input type="<?= $Page->poid->getInputTextType() ?>" name="x_poid" id="x_poid" data-table="material_required_job_card" data-field="x_poid" value="<?= $Page->poid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->poid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->poid->formatPattern()) ?>"<?= $Page->poid->editAttributes() ?> aria-describedby="x_poid_help">
<?= $Page->poid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->poid->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no"<?= $Page->jc_no->rowAttributes() ?>>
        <label id="elh_material_required_job_card_jc_no" for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->jc_no->caption() ?><?= $Page->jc_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->jc_no->cellAttributes() ?>>
<span id="el_material_required_job_card_jc_no">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="material_required_job_card" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?> aria-describedby="x_jc_no_help">
<?= $Page->jc_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_material_required_job_card_location" for="x_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_material_required_job_card_location">
<input type="<?= $Page->location->getInputTextType() ?>" name="x_location" id="x_location" data-table="material_required_job_card" data-field="x_location" value="<?= $Page->location->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->location->formatPattern()) ?>"<?= $Page->location->editAttributes() ?> aria-describedby="x_location_help">
<?= $Page->location->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
    <div id="r_issue_to"<?= $Page->issue_to->rowAttributes() ?>>
        <label id="elh_material_required_job_card_issue_to" for="x_issue_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_to->caption() ?><?= $Page->issue_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_to->cellAttributes() ?>>
<span id="el_material_required_job_card_issue_to">
<input type="<?= $Page->issue_to->getInputTextType() ?>" name="x_issue_to" id="x_issue_to" data-table="material_required_job_card" data-field="x_issue_to" value="<?= $Page->issue_to->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_to->formatPattern()) ?>"<?= $Page->issue_to->editAttributes() ?> aria-describedby="x_issue_to_help">
<?= $Page->issue_to->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->week->Visible) { // week ?>
    <div id="r_week"<?= $Page->week->rowAttributes() ?>>
        <label id="elh_material_required_job_card_week" for="x_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->week->caption() ?><?= $Page->week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->week->cellAttributes() ?>>
<span id="el_material_required_job_card_week">
<input type="<?= $Page->week->getInputTextType() ?>" name="x_week" id="x_week" data-table="material_required_job_card" data-field="x_week" value="<?= $Page->week->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->week->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->week->formatPattern()) ?>"<?= $Page->week->editAttributes() ?> aria-describedby="x_week_help">
<?= $Page->week->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->week->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po"<?= $Page->po->rowAttributes() ?>>
        <label id="elh_material_required_job_card_po" for="x_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po->caption() ?><?= $Page->po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po->cellAttributes() ?>>
<span id="el_material_required_job_card_po">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="material_required_job_card" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?> aria-describedby="x_po_help">
<?= $Page->po->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id"<?= $Page->buyer_id->rowAttributes() ?>>
        <label id="elh_material_required_job_card_buyer_id" for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_id->caption() ?><?= $Page->buyer_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el_material_required_job_card_buyer_id">
<input type="<?= $Page->buyer_id->getInputTextType() ?>" name="x_buyer_id" id="x_buyer_id" data-table="material_required_job_card" data-field="x_buyer_id" value="<?= $Page->buyer_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_id->formatPattern()) ?>"<?= $Page->buyer_id->editAttributes() ?> aria-describedby="x_buyer_id_help">
<?= $Page->buyer_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_material_required_job_card_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_material_required_job_card_grp">
<input type="<?= $Page->grp->getInputTextType() ?>" name="x_grp" id="x_grp" data-table="material_required_job_card" data-field="x_grp" value="<?= $Page->grp->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->grp->formatPattern()) ?>"<?= $Page->grp->editAttributes() ?> aria-describedby="x_grp_help">
<?= $Page->grp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_material_required_job_card_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_material_required_job_card_s_grp">
<input type="<?= $Page->s_grp->getInputTextType() ?>" name="x_s_grp" id="x_s_grp" data-table="material_required_job_card" data-field="x_s_grp" value="<?= $Page->s_grp->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->s_grp->formatPattern()) ?>"<?= $Page->s_grp->editAttributes() ?> aria-describedby="x_s_grp_help">
<?= $Page->s_grp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_material_required_job_card_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_material_required_job_card_product">
<input type="<?= $Page->product->getInputTextType() ?>" name="x_product" id="x_product" data-table="material_required_job_card" data-field="x_product" value="<?= $Page->product->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product->formatPattern()) ?>"<?= $Page->product->editAttributes() ?> aria-describedby="x_product_help">
<?= $Page->product->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_id->Visible) { // product_id ?>
    <div id="r_product_id"<?= $Page->product_id->rowAttributes() ?>>
        <label id="elh_material_required_job_card_product_id" for="x_product_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_id->caption() ?><?= $Page->product_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_id->cellAttributes() ?>>
<span id="el_material_required_job_card_product_id">
<input type="<?= $Page->product_id->getInputTextType() ?>" name="x_product_id" id="x_product_id" data-table="material_required_job_card" data-field="x_product_id" value="<?= $Page->product_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->product_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_id->formatPattern()) ?>"<?= $Page->product_id->editAttributes() ?> aria-describedby="x_product_id_help">
<?= $Page->product_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->product_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no"<?= $Page->batch_no->rowAttributes() ?>>
        <label id="elh_material_required_job_card_batch_no" for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->batch_no->caption() ?><?= $Page->batch_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->batch_no->cellAttributes() ?>>
<span id="el_material_required_job_card_batch_no">
<input type="<?= $Page->batch_no->getInputTextType() ?>" name="x_batch_no" id="x_batch_no" data-table="material_required_job_card" data-field="x_batch_no" value="<?= $Page->batch_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?> aria-describedby="x_batch_no_help">
<?= $Page->batch_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_material_required_job_card_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_material_required_job_card_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="material_required_job_card" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm"<?= $Page->size_cm->rowAttributes() ?>>
        <label id="elh_material_required_job_card_size_cm" for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size_cm->caption() ?><?= $Page->size_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size_cm->cellAttributes() ?>>
<span id="el_material_required_job_card_size_cm">
<input type="<?= $Page->size_cm->getInputTextType() ?>" name="x_size_cm" id="x_size_cm" data-table="material_required_job_card" data-field="x_size_cm" value="<?= $Page->size_cm->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->size_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_cm->formatPattern()) ?>"<?= $Page->size_cm->editAttributes() ?> aria-describedby="x_size_cm_help">
<?= $Page->size_cm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->size_cm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm"<?= $Page->sqm->rowAttributes() ?>>
        <label id="elh_material_required_job_card_sqm" for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm->caption() ?><?= $Page->sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm->cellAttributes() ?>>
<span id="el_material_required_job_card_sqm">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="material_required_job_card" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?> aria-describedby="x_sqm_help">
<?= $Page->sqm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->t_sqm->Visible) { // t_sqm ?>
    <div id="r_t_sqm"<?= $Page->t_sqm->rowAttributes() ?>>
        <label id="elh_material_required_job_card_t_sqm" for="x_t_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->t_sqm->caption() ?><?= $Page->t_sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->t_sqm->cellAttributes() ?>>
<span id="el_material_required_job_card_t_sqm">
<input type="<?= $Page->t_sqm->getInputTextType() ?>" name="x_t_sqm" id="x_t_sqm" data-table="material_required_job_card" data-field="x_t_sqm" value="<?= $Page->t_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->t_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_sqm->formatPattern()) ?>"<?= $Page->t_sqm->editAttributes() ?> aria-describedby="x_t_sqm_help">
<?= $Page->t_sqm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->t_sqm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_grp->Visible) { // req_material_grp ?>
    <div id="r_req_material_grp"<?= $Page->req_material_grp->rowAttributes() ?>>
        <label id="elh_material_required_job_card_req_material_grp" for="x_req_material_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_grp->caption() ?><?= $Page->req_material_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_grp->cellAttributes() ?>>
<span id="el_material_required_job_card_req_material_grp">
<input type="<?= $Page->req_material_grp->getInputTextType() ?>" name="x_req_material_grp" id="x_req_material_grp" data-table="material_required_job_card" data-field="x_req_material_grp" value="<?= $Page->req_material_grp->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_grp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_grp->formatPattern()) ?>"<?= $Page->req_material_grp->editAttributes() ?> aria-describedby="x_req_material_grp_help">
<?= $Page->req_material_grp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->req_material_grp->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_sgrp->Visible) { // req_material_sgrp ?>
    <div id="r_req_material_sgrp"<?= $Page->req_material_sgrp->rowAttributes() ?>>
        <label id="elh_material_required_job_card_req_material_sgrp" for="x_req_material_sgrp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_sgrp->caption() ?><?= $Page->req_material_sgrp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_sgrp->cellAttributes() ?>>
<span id="el_material_required_job_card_req_material_sgrp">
<input type="<?= $Page->req_material_sgrp->getInputTextType() ?>" name="x_req_material_sgrp" id="x_req_material_sgrp" data-table="material_required_job_card" data-field="x_req_material_sgrp" value="<?= $Page->req_material_sgrp->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_sgrp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_sgrp->formatPattern()) ?>"<?= $Page->req_material_sgrp->editAttributes() ?> aria-describedby="x_req_material_sgrp_help">
<?= $Page->req_material_sgrp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->req_material_sgrp->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_product->Visible) { // req_material_product ?>
    <div id="r_req_material_product"<?= $Page->req_material_product->rowAttributes() ?>>
        <label id="elh_material_required_job_card_req_material_product" for="x_req_material_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_product->caption() ?><?= $Page->req_material_product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_product->cellAttributes() ?>>
<span id="el_material_required_job_card_req_material_product">
<input type="<?= $Page->req_material_product->getInputTextType() ?>" name="x_req_material_product" id="x_req_material_product" data-table="material_required_job_card" data-field="x_req_material_product" value="<?= $Page->req_material_product->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_product->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_product->formatPattern()) ?>"<?= $Page->req_material_product->editAttributes() ?> aria-describedby="x_req_material_product_help">
<?= $Page->req_material_product->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->req_material_product->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
    <div id="r_req_material_rid"<?= $Page->req_material_rid->rowAttributes() ?>>
        <label id="elh_material_required_job_card_req_material_rid" for="x_req_material_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_rid->caption() ?><?= $Page->req_material_rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_rid->cellAttributes() ?>>
<span id="el_material_required_job_card_req_material_rid">
<input type="<?= $Page->req_material_rid->getInputTextType() ?>" name="x_req_material_rid" id="x_req_material_rid" data-table="material_required_job_card" data-field="x_req_material_rid" value="<?= $Page->req_material_rid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_rid->formatPattern()) ?>"<?= $Page->req_material_rid->editAttributes() ?> aria-describedby="x_req_material_rid_help">
<?= $Page->req_material_rid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->req_material_rid->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
    <div id="r_req_material_qty"<?= $Page->req_material_qty->rowAttributes() ?>>
        <label id="elh_material_required_job_card_req_material_qty" for="x_req_material_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_qty->caption() ?><?= $Page->req_material_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_qty->cellAttributes() ?>>
<span id="el_material_required_job_card_req_material_qty">
<input type="<?= $Page->req_material_qty->getInputTextType() ?>" name="x_req_material_qty" id="x_req_material_qty" data-table="material_required_job_card" data-field="x_req_material_qty" value="<?= $Page->req_material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_qty->formatPattern()) ?>"<?= $Page->req_material_qty->editAttributes() ?> aria-describedby="x_req_material_qty_help">
<?= $Page->req_material_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->req_material_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
    <div id="r_req_material_packing"<?= $Page->req_material_packing->rowAttributes() ?>>
        <label id="elh_material_required_job_card_req_material_packing" for="x_req_material_packing" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_packing->caption() ?><?= $Page->req_material_packing->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_packing->cellAttributes() ?>>
<span id="el_material_required_job_card_req_material_packing">
<input type="<?= $Page->req_material_packing->getInputTextType() ?>" name="x_req_material_packing" id="x_req_material_packing" data-table="material_required_job_card" data-field="x_req_material_packing" value="<?= $Page->req_material_packing->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_packing->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_packing->formatPattern()) ?>"<?= $Page->req_material_packing->editAttributes() ?> aria-describedby="x_req_material_packing_help">
<?= $Page->req_material_packing->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->req_material_packing->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->stock->Visible) { // stock ?>
    <div id="r_stock"<?= $Page->stock->rowAttributes() ?>>
        <label id="elh_material_required_job_card_stock" for="x_stock" class="<?= $Page->LeftColumnClass ?>"><?= $Page->stock->caption() ?><?= $Page->stock->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->stock->cellAttributes() ?>>
<span id="el_material_required_job_card_stock">
<input type="<?= $Page->stock->getInputTextType() ?>" name="x_stock" id="x_stock" data-table="material_required_job_card" data-field="x_stock" value="<?= $Page->stock->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->stock->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->stock->formatPattern()) ?>"<?= $Page->stock->editAttributes() ?> aria-describedby="x_stock_help">
<?= $Page->stock->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->stock->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->short->Visible) { // short ?>
    <div id="r_short"<?= $Page->short->rowAttributes() ?>>
        <label id="elh_material_required_job_card_short" for="x_short" class="<?= $Page->LeftColumnClass ?>"><?= $Page->short->caption() ?><?= $Page->short->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->short->cellAttributes() ?>>
<span id="el_material_required_job_card_short">
<input type="<?= $Page->short->getInputTextType() ?>" name="x_short" id="x_short" data-table="material_required_job_card" data-field="x_short" value="<?= $Page->short->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->short->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->short->formatPattern()) ?>"<?= $Page->short->editAttributes() ?> aria-describedby="x_short_help">
<?= $Page->short->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->short->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit"<?= $Page->unit->rowAttributes() ?>>
        <label id="elh_material_required_job_card_unit" for="x_unit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->unit->caption() ?><?= $Page->unit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->unit->cellAttributes() ?>>
<span id="el_material_required_job_card_unit">
<input type="<?= $Page->unit->getInputTextType() ?>" name="x_unit" id="x_unit" data-table="material_required_job_card" data-field="x_unit" value="<?= $Page->unit->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->unit->formatPattern()) ?>"<?= $Page->unit->editAttributes() ?> aria-describedby="x_unit_help">
<?= $Page->unit->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->unit->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->material_qty->Visible) { // material_qty ?>
    <div id="r_material_qty"<?= $Page->material_qty->rowAttributes() ?>>
        <label id="elh_material_required_job_card_material_qty" for="x_material_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->material_qty->caption() ?><?= $Page->material_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->material_qty->cellAttributes() ?>>
<span id="el_material_required_job_card_material_qty">
<input type="<?= $Page->material_qty->getInputTextType() ?>" name="x_material_qty" id="x_material_qty" data-table="material_required_job_card" data-field="x_material_qty" value="<?= $Page->material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->material_qty->formatPattern()) ?>"<?= $Page->material_qty->editAttributes() ?> aria-describedby="x_material_qty_help">
<?= $Page->material_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->material_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method"<?= $Page->method->rowAttributes() ?>>
        <label id="elh_material_required_job_card_method" for="x_method" class="<?= $Page->LeftColumnClass ?>"><?= $Page->method->caption() ?><?= $Page->method->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->method->cellAttributes() ?>>
<span id="el_material_required_job_card_method">
<input type="<?= $Page->method->getInputTextType() ?>" name="x_method" id="x_method" data-table="material_required_job_card" data-field="x_method" value="<?= $Page->method->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->method->formatPattern()) ?>"<?= $Page->method->editAttributes() ?> aria-describedby="x_method_help">
<?= $Page->method->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->method->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week"<?= $Page->despatch_week->rowAttributes() ?>>
        <label id="elh_material_required_job_card_despatch_week" for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_week->caption() ?><?= $Page->despatch_week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el_material_required_job_card_despatch_week">
<input type="<?= $Page->despatch_week->getInputTextType() ?>" name="x_despatch_week" id="x_despatch_week" data-table="material_required_job_card" data-field="x_despatch_week" value="<?= $Page->despatch_week->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->despatch_week->formatPattern()) ?>"<?= $Page->despatch_week->editAttributes() ?> aria-describedby="x_despatch_week_help">
<?= $Page->despatch_week->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
    <div id="r_despatch_date"<?= $Page->despatch_date->rowAttributes() ?>>
        <label id="elh_material_required_job_card_despatch_date" for="x_despatch_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_date->caption() ?><?= $Page->despatch_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el_material_required_job_card_despatch_date">
<input type="<?= $Page->despatch_date->getInputTextType() ?>" name="x_despatch_date" id="x_despatch_date" data-table="material_required_job_card" data-field="x_despatch_date" value="<?= $Page->despatch_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->despatch_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->despatch_date->formatPattern()) ?>"<?= $Page->despatch_date->editAttributes() ?> aria-describedby="x_despatch_date_help">
<?= $Page->despatch_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->despatch_date->getErrorMessage() ?></div>
<?php if (!$Page->despatch_date->ReadOnly && !$Page->despatch_date->Disabled && !isset($Page->despatch_date->EditAttrs["readonly"]) && !isset($Page->despatch_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_required_job_cardadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_required_job_cardadd", "x_despatch_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->production_plan->Visible) { // production_plan ?>
    <div id="r_production_plan"<?= $Page->production_plan->rowAttributes() ?>>
        <label id="elh_material_required_job_card_production_plan" for="x_production_plan" class="<?= $Page->LeftColumnClass ?>"><?= $Page->production_plan->caption() ?><?= $Page->production_plan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->production_plan->cellAttributes() ?>>
<span id="el_material_required_job_card_production_plan">
<input type="<?= $Page->production_plan->getInputTextType() ?>" name="x_production_plan" id="x_production_plan" data-table="material_required_job_card" data-field="x_production_plan" value="<?= $Page->production_plan->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->production_plan->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->production_plan->formatPattern()) ?>"<?= $Page->production_plan->editAttributes() ?> aria-describedby="x_production_plan_help">
<?= $Page->production_plan->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->production_plan->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_material_required_job_card_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_material_required_job_card_remarks">
<textarea data-table="material_required_job_card" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->updated->Visible) { // updated ?>
    <div id="r_updated"<?= $Page->updated->rowAttributes() ?>>
        <label id="elh_material_required_job_card_updated" for="x_updated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->updated->caption() ?><?= $Page->updated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->updated->cellAttributes() ?>>
<span id="el_material_required_job_card_updated">
<input type="<?= $Page->updated->getInputTextType() ?>" name="x_updated" id="x_updated" data-table="material_required_job_card" data-field="x_updated" value="<?= $Page->updated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->updated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->updated->formatPattern()) ?>"<?= $Page->updated->editAttributes() ?> aria-describedby="x_updated_help">
<?= $Page->updated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->updated->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <label id="elh_material_required_job_card_operator" for="x_operator" class="<?= $Page->LeftColumnClass ?>"><?= $Page->operator->caption() ?><?= $Page->operator->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->operator->cellAttributes() ?>>
<span id="el_material_required_job_card_operator">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="material_required_job_card" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?> aria-describedby="x_operator_help">
<?= $Page->operator->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <label id="elh_material_required_job_card_datetime" for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><?= $Page->datetime->caption() ?><?= $Page->datetime->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->datetime->cellAttributes() ?>>
<span id="el_material_required_job_card_datetime">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="material_required_job_card" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?> aria-describedby="x_datetime_help">
<?= $Page->datetime->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage() ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_required_job_cardadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_required_job_cardadd", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->jc_datetime->Visible) { // jc_datetime ?>
    <div id="r_jc_datetime"<?= $Page->jc_datetime->rowAttributes() ?>>
        <label id="elh_material_required_job_card_jc_datetime" for="x_jc_datetime" class="<?= $Page->LeftColumnClass ?>"><?= $Page->jc_datetime->caption() ?><?= $Page->jc_datetime->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->jc_datetime->cellAttributes() ?>>
<span id="el_material_required_job_card_jc_datetime">
<input type="<?= $Page->jc_datetime->getInputTextType() ?>" name="x_jc_datetime" id="x_jc_datetime" data-table="material_required_job_card" data-field="x_jc_datetime" value="<?= $Page->jc_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->jc_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_datetime->formatPattern()) ?>"<?= $Page->jc_datetime->editAttributes() ?> aria-describedby="x_jc_datetime_help">
<?= $Page->jc_datetime->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->jc_datetime->getErrorMessage() ?></div>
<?php if (!$Page->jc_datetime->ReadOnly && !$Page->jc_datetime->Disabled && !isset($Page->jc_datetime->EditAttrs["readonly"]) && !isset($Page->jc_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_required_job_cardadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_required_job_cardadd", "x_jc_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label id="elh_material_required_job_card_company_id" for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->company_id->caption() ?><?= $Page->company_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->company_id->cellAttributes() ?>>
<span id="el_material_required_job_card_company_id">
<input type="<?= $Page->company_id->getInputTextType() ?>" name="x_company_id" id="x_company_id" data-table="material_required_job_card" data-field="x_company_id" value="<?= $Page->company_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?> aria-describedby="x_company_id_help">
<?= $Page->company_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->m_out_id->Visible) { // m_out_id ?>
    <div id="r_m_out_id"<?= $Page->m_out_id->rowAttributes() ?>>
        <label id="elh_material_required_job_card_m_out_id" for="x_m_out_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->m_out_id->caption() ?><?= $Page->m_out_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->m_out_id->cellAttributes() ?>>
<span id="el_material_required_job_card_m_out_id">
<input type="<?= $Page->m_out_id->getInputTextType() ?>" name="x_m_out_id" id="x_m_out_id" data-table="material_required_job_card" data-field="x_m_out_id" value="<?= $Page->m_out_id->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->m_out_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->m_out_id->formatPattern()) ?>"<?= $Page->m_out_id->editAttributes() ?> aria-describedby="x_m_out_id_help">
<?= $Page->m_out_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->m_out_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issued_qty->Visible) { // issued_qty ?>
    <div id="r_issued_qty"<?= $Page->issued_qty->rowAttributes() ?>>
        <label id="elh_material_required_job_card_issued_qty" for="x_issued_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issued_qty->caption() ?><?= $Page->issued_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issued_qty->cellAttributes() ?>>
<span id="el_material_required_job_card_issued_qty">
<input type="<?= $Page->issued_qty->getInputTextType() ?>" name="x_issued_qty" id="x_issued_qty" data-table="material_required_job_card" data-field="x_issued_qty" value="<?= $Page->issued_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->issued_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issued_qty->formatPattern()) ?>"<?= $Page->issued_qty->editAttributes() ?> aria-describedby="x_issued_qty_help">
<?= $Page->issued_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issued_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pending_qty->Visible) { // pending_qty ?>
    <div id="r_pending_qty"<?= $Page->pending_qty->rowAttributes() ?>>
        <label id="elh_material_required_job_card_pending_qty" for="x_pending_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pending_qty->caption() ?><?= $Page->pending_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pending_qty->cellAttributes() ?>>
<span id="el_material_required_job_card_pending_qty">
<input type="<?= $Page->pending_qty->getInputTextType() ?>" name="x_pending_qty" id="x_pending_qty" data-table="material_required_job_card" data-field="x_pending_qty" value="<?= $Page->pending_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_qty->formatPattern()) ?>"<?= $Page->pending_qty->editAttributes() ?> aria-describedby="x_pending_qty_help">
<?= $Page->pending_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->pending_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->m_out_remarks->Visible) { // m_out_remarks ?>
    <div id="r_m_out_remarks"<?= $Page->m_out_remarks->rowAttributes() ?>>
        <label id="elh_material_required_job_card_m_out_remarks" for="x_m_out_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->m_out_remarks->caption() ?><?= $Page->m_out_remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->m_out_remarks->cellAttributes() ?>>
<span id="el_material_required_job_card_m_out_remarks">
<input type="<?= $Page->m_out_remarks->getInputTextType() ?>" name="x_m_out_remarks" id="x_m_out_remarks" data-table="material_required_job_card" data-field="x_m_out_remarks" value="<?= $Page->m_out_remarks->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->m_out_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->m_out_remarks->formatPattern()) ?>"<?= $Page->m_out_remarks->editAttributes() ?> aria-describedby="x_m_out_remarks_help">
<?= $Page->m_out_remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->m_out_remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmaterial_required_job_cardadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmaterial_required_job_cardadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required_job_card");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
