<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialRequiredIssueSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_issue: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmaterial_required_issuesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmaterial_required_issuesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["jc_no", [], fields.jc_no.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["week", [], fields.week.isInvalid],
            ["buyer_id", [], fields.buyer_id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["product_id", [], fields.product_id.isInvalid],
            ["batch_no", [ew.Validators.integer], fields.batch_no.isInvalid],
            ["quantity", [ew.Validators.integer], fields.quantity.isInvalid],
            ["req_material_sgrp", [], fields.req_material_sgrp.isInvalid],
            ["issue_material_sgrp", [], fields.issue_material_sgrp.isInvalid],
            ["req_material_product", [], fields.req_material_product.isInvalid],
            ["issue_material_product", [], fields.issue_material_product.isInvalid],
            ["req_material_rid", [], fields.req_material_rid.isInvalid],
            ["issue_material_rid", [ew.Validators.integer], fields.issue_material_rid.isInvalid],
            ["req_material_qty", [ew.Validators.float], fields.req_material_qty.isInvalid],
            ["issue_material_qty", [ew.Validators.float], fields.issue_material_qty.isInvalid],
            ["material_qty", [ew.Validators.float], fields.material_qty.isInvalid],
            ["unit", [], fields.unit.isInvalid],
            ["method", [], fields.method.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["production_plan", [], fields.production_plan.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["material_out", [], fields.material_out.isInvalid],
            ["material_out_id", [], fields.material_out_id.isInvalid],
            ["size_wl", [], fields.size_wl.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["req_material_grp", [], fields.req_material_grp.isInvalid],
            ["issue_material_grp", [ew.Validators.integer], fields.issue_material_grp.isInvalid],
            ["updated", [ew.Validators.integer], fields.updated.isInvalid],
            ["poid", [], fields.poid.isInvalid],
            ["issue_to", [ew.Validators.integer], fields.issue_to.isInvalid],
            ["despatch_date", [ew.Validators.datetime(fields.despatch_date.clientFormatPattern)], fields.despatch_date.isInvalid],
            ["issue_material_id", [], fields.issue_material_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "jc_no": <?= $Page->jc_no->toClientList($Page) ?>,
            "week": <?= $Page->week->toClientList($Page) ?>,
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "product_id": <?= $Page->product_id->toClientList($Page) ?>,
            "req_material_sgrp": <?= $Page->req_material_sgrp->toClientList($Page) ?>,
            "issue_material_sgrp": <?= $Page->issue_material_sgrp->toClientList($Page) ?>,
            "req_material_product": <?= $Page->req_material_product->toClientList($Page) ?>,
            "issue_material_product": <?= $Page->issue_material_product->toClientList($Page) ?>,
            "req_material_rid": <?= $Page->req_material_rid->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "method": <?= $Page->method->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "production_plan": <?= $Page->production_plan->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "material_out": <?= $Page->material_out->toClientList($Page) ?>,
            "material_out_id": <?= $Page->material_out_id->toClientList($Page) ?>,
            "req_material_grp": <?= $Page->req_material_grp->toClientList($Page) ?>,
            "poid": <?= $Page->poid->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmaterial_required_issuesearch" id="fmaterial_required_issuesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_required_issue">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="material_required_issue" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no" class="row"<?= $Page->jc_no->rowAttributes() ?>>
        <label for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_jc_no"><?= $Page->jc_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_no" id="z_jc_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_jc_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_jc_no"
        name="x_jc_no"
        class="form-select ew-select<?= $Page->jc_no->isInvalidClass() ?>"
        <?php if (!$Page->jc_no->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_jc_no"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_jc_no"
        data-value-separator="<?= $Page->jc_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>"
        <?= $Page->jc_no->editAttributes() ?>>
        <?= $Page->jc_no->selectOptionListHtml("x_jc_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
<?= $Page->jc_no->Lookup->getParamTag($Page, "p_x_jc_no") ?>
<?php if (!$Page->jc_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_jc_no", selectId: "fmaterial_required_issuesearch_x_jc_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.jc_no?.lookupOptions.length) {
        options.data = { id: "x_jc_no", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_jc_no", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.jc_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_po"><?= $Page->po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="material_required_issue" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->week->Visible) { // week ?>
    <div id="r_week" class="row"<?= $Page->week->rowAttributes() ?>>
        <label for="x_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_week"><?= $Page->week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_week" id="z_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_week"
        name="x_week"
        class="form-select ew-select<?= $Page->week->isInvalidClass() ?>"
        <?php if (!$Page->week->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_week"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_week"
        data-value-separator="<?= $Page->week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->week->getPlaceHolder()) ?>"
        <?= $Page->week->editAttributes() ?>>
        <?= $Page->week->selectOptionListHtml("x_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->week->getErrorMessage(false) ?></div>
<?= $Page->week->Lookup->getParamTag($Page, "p_x_week") ?>
<?php if (!$Page->week->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_week", selectId: "fmaterial_required_issuesearch_x_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.week?.lookupOptions.length) {
        options.data = { id: "x_week", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_week", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id" class="row"<?= $Page->buyer_id->rowAttributes() ?>>
        <label for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_buyer_id"><?= $Page->buyer_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_buyer_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-select ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        <?php if (!$Page->buyer_id->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_buyer_id"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_buyer_id"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<?php if (!$Page->buyer_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_buyer_id", selectId: "fmaterial_required_issuesearch_x_buyer_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.buyer_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_grp"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_grp", selectId: "fmaterial_required_issuesearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_s_grp"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_s_grp", selectId: "fmaterial_required_issuesearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_product"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_product", selectId: "fmaterial_required_issuesearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_product", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_id->Visible) { // product_id ?>
    <div id="r_product_id" class="row"<?= $Page->product_id->rowAttributes() ?>>
        <label for="x_product_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_product_id"><?= $Page->product_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_id" id="z_product_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_product_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_id"
        name="x_product_id"
        class="form-select ew-select<?= $Page->product_id->isInvalidClass() ?>"
        <?php if (!$Page->product_id->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_product_id"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_product_id"
        data-value-separator="<?= $Page->product_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product_id->editAttributes() ?>>
        <?= $Page->product_id->selectOptionListHtml("x_product_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_id->getErrorMessage(false) ?></div>
<?= $Page->product_id->Lookup->getParamTag($Page, "p_x_product_id") ?>
<?php if (!$Page->product_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_product_id", selectId: "fmaterial_required_issuesearch_x_product_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.product_id?.lookupOptions.length) {
        options.data = { id: "x_product_id", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_product_id", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.product_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_batch_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->batch_no->getInputTextType() ?>" name="x_batch_no" id="x_batch_no" data-table="material_required_issue" data-field="x_batch_no" value="<?= $Page->batch_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="material_required_issue" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_sgrp->Visible) { // req_material_sgrp ?>
    <div id="r_req_material_sgrp" class="row"<?= $Page->req_material_sgrp->rowAttributes() ?>>
        <label for="x_req_material_sgrp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_req_material_sgrp"><?= $Page->req_material_sgrp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_sgrp" id="z_req_material_sgrp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_sgrp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_req_material_sgrp" class="ew-search-field ew-search-field-single">
    <select
        id="x_req_material_sgrp"
        name="x_req_material_sgrp"
        class="form-select ew-select<?= $Page->req_material_sgrp->isInvalidClass() ?>"
        <?php if (!$Page->req_material_sgrp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_req_material_sgrp"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_req_material_sgrp"
        data-value-separator="<?= $Page->req_material_sgrp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_sgrp->getPlaceHolder()) ?>"
        <?= $Page->req_material_sgrp->editAttributes() ?>>
        <?= $Page->req_material_sgrp->selectOptionListHtml("x_req_material_sgrp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_sgrp->getErrorMessage(false) ?></div>
<?= $Page->req_material_sgrp->Lookup->getParamTag($Page, "p_x_req_material_sgrp") ?>
<?php if (!$Page->req_material_sgrp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_req_material_sgrp", selectId: "fmaterial_required_issuesearch_x_req_material_sgrp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.req_material_sgrp?.lookupOptions.length) {
        options.data = { id: "x_req_material_sgrp", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_req_material_sgrp", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.req_material_sgrp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_sgrp->Visible) { // issue_material_sgrp ?>
    <div id="r_issue_material_sgrp" class="row"<?= $Page->issue_material_sgrp->rowAttributes() ?>>
        <label for="x_issue_material_sgrp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_material_sgrp"><?= $Page->issue_material_sgrp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_material_sgrp" id="z_issue_material_sgrp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_material_sgrp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_issue_material_sgrp" class="ew-search-field ew-search-field-single">
    <select
        id="x_issue_material_sgrp"
        name="x_issue_material_sgrp"
        class="form-select ew-select<?= $Page->issue_material_sgrp->isInvalidClass() ?>"
        <?php if (!$Page->issue_material_sgrp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_issue_material_sgrp"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_issue_material_sgrp"
        data-value-separator="<?= $Page->issue_material_sgrp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_material_sgrp->getPlaceHolder()) ?>"
        <?= $Page->issue_material_sgrp->editAttributes() ?>>
        <?= $Page->issue_material_sgrp->selectOptionListHtml("x_issue_material_sgrp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_material_sgrp->getErrorMessage(false) ?></div>
<?= $Page->issue_material_sgrp->Lookup->getParamTag($Page, "p_x_issue_material_sgrp") ?>
<?php if (!$Page->issue_material_sgrp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_issue_material_sgrp", selectId: "fmaterial_required_issuesearch_x_issue_material_sgrp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.issue_material_sgrp?.lookupOptions.length) {
        options.data = { id: "x_issue_material_sgrp", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_issue_material_sgrp", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.issue_material_sgrp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_product->Visible) { // req_material_product ?>
    <div id="r_req_material_product" class="row"<?= $Page->req_material_product->rowAttributes() ?>>
        <label for="x_req_material_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_req_material_product"><?= $Page->req_material_product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_product" id="z_req_material_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_req_material_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_req_material_product"
        name="x_req_material_product"
        class="form-select ew-select<?= $Page->req_material_product->isInvalidClass() ?>"
        <?php if (!$Page->req_material_product->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_req_material_product"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_req_material_product"
        data-value-separator="<?= $Page->req_material_product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_product->getPlaceHolder()) ?>"
        <?= $Page->req_material_product->editAttributes() ?>>
        <?= $Page->req_material_product->selectOptionListHtml("x_req_material_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_product->getErrorMessage(false) ?></div>
<?= $Page->req_material_product->Lookup->getParamTag($Page, "p_x_req_material_product") ?>
<?php if (!$Page->req_material_product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_req_material_product", selectId: "fmaterial_required_issuesearch_x_req_material_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.req_material_product?.lookupOptions.length) {
        options.data = { id: "x_req_material_product", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_req_material_product", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.req_material_product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_product->Visible) { // issue_material_product ?>
    <div id="r_issue_material_product" class="row"<?= $Page->issue_material_product->rowAttributes() ?>>
        <label for="x_issue_material_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_material_product"><?= $Page->issue_material_product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_material_product" id="z_issue_material_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_material_product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_issue_material_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_issue_material_product"
        name="x_issue_material_product"
        class="form-select ew-select<?= $Page->issue_material_product->isInvalidClass() ?>"
        <?php if (!$Page->issue_material_product->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_issue_material_product"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_issue_material_product"
        data-value-separator="<?= $Page->issue_material_product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_material_product->getPlaceHolder()) ?>"
        <?= $Page->issue_material_product->editAttributes() ?>>
        <?= $Page->issue_material_product->selectOptionListHtml("x_issue_material_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_material_product->getErrorMessage(false) ?></div>
<?= $Page->issue_material_product->Lookup->getParamTag($Page, "p_x_issue_material_product") ?>
<?php if (!$Page->issue_material_product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_issue_material_product", selectId: "fmaterial_required_issuesearch_x_issue_material_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.issue_material_product?.lookupOptions.length) {
        options.data = { id: "x_issue_material_product", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_issue_material_product", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.issue_material_product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
    <div id="r_req_material_rid" class="row"<?= $Page->req_material_rid->rowAttributes() ?>>
        <label for="x_req_material_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_req_material_rid"><?= $Page->req_material_rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_req_material_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_req_material_rid"
        name="x_req_material_rid"
        class="form-select ew-select<?= $Page->req_material_rid->isInvalidClass() ?>"
        <?php if (!$Page->req_material_rid->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_req_material_rid"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_req_material_rid"
        data-value-separator="<?= $Page->req_material_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_rid->getPlaceHolder()) ?>"
        <?= $Page->req_material_rid->editAttributes() ?>>
        <?= $Page->req_material_rid->selectOptionListHtml("x_req_material_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_rid->getErrorMessage(false) ?></div>
<?= $Page->req_material_rid->Lookup->getParamTag($Page, "p_x_req_material_rid") ?>
<?php if (!$Page->req_material_rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_req_material_rid", selectId: "fmaterial_required_issuesearch_x_req_material_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.req_material_rid?.lookupOptions.length) {
        options.data = { id: "x_req_material_rid", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_req_material_rid", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.req_material_rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_rid->Visible) { // issue_material_rid ?>
    <div id="r_issue_material_rid" class="row"<?= $Page->issue_material_rid->rowAttributes() ?>>
        <label for="x_issue_material_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_material_rid"><?= $Page->issue_material_rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_material_rid" id="z_issue_material_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_material_rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_issue_material_rid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->issue_material_rid->getInputTextType() ?>" name="x_issue_material_rid" id="x_issue_material_rid" data-table="material_required_issue" data-field="x_issue_material_rid" value="<?= $Page->issue_material_rid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->issue_material_rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_material_rid->formatPattern()) ?>"<?= $Page->issue_material_rid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->issue_material_rid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
    <div id="r_req_material_qty" class="row"<?= $Page->req_material_qty->rowAttributes() ?>>
        <label for="x_req_material_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_req_material_qty"><?= $Page->req_material_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_qty" id="z_req_material_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_req_material_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->req_material_qty->getInputTextType() ?>" name="x_req_material_qty" id="x_req_material_qty" data-table="material_required_issue" data-field="x_req_material_qty" value="<?= $Page->req_material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_qty->formatPattern()) ?>"<?= $Page->req_material_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->req_material_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_qty->Visible) { // issue_material_qty ?>
    <div id="r_issue_material_qty" class="row"<?= $Page->issue_material_qty->rowAttributes() ?>>
        <label for="x_issue_material_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_material_qty"><?= $Page->issue_material_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_material_qty" id="z_issue_material_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_material_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_issue_material_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->issue_material_qty->getInputTextType() ?>" name="x_issue_material_qty" id="x_issue_material_qty" data-table="material_required_issue" data-field="x_issue_material_qty" value="<?= $Page->issue_material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->issue_material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_material_qty->formatPattern()) ?>"<?= $Page->issue_material_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->issue_material_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->material_qty->Visible) { // material_qty ?>
    <div id="r_material_qty" class="row"<?= $Page->material_qty->rowAttributes() ?>>
        <label for="x_material_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_material_qty"><?= $Page->material_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_material_qty" id="z_material_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->material_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_material_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->material_qty->getInputTextType() ?>" name="x_material_qty" id="x_material_qty" data-table="material_required_issue" data-field="x_material_qty" value="<?= $Page->material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->material_qty->formatPattern()) ?>"<?= $Page->material_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->material_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit" class="row"<?= $Page->unit->rowAttributes() ?>>
        <label for="x_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_unit"><?= $Page->unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_unit" id="z_unit" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_unit"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage(false) ?></div>
<?= $Page->unit->Lookup->getParamTag($Page, "p_x_unit") ?>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_unit", selectId: "fmaterial_required_issuesearch_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_unit", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method" class="row"<?= $Page->method->rowAttributes() ?>>
        <label for="x_method" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_method"><?= $Page->method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_method" id="z_method" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_method" class="ew-search-field ew-search-field-single">
    <select
        id="x_method"
        name="x_method"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_method"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_method"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage(false) ?></div>
<?= $Page->method->Lookup->getParamTag($Page, "p_x_method") ?>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_method", selectId: "fmaterial_required_issuesearch_x_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.method?.lookupOptions.length) {
        options.data = { id: "x_method", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_method", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week" class="row"<?= $Page->despatch_week->rowAttributes() ?>>
        <label for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_despatch_week"><?= $Page->despatch_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_week" id="z_despatch_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_despatch_week"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_despatch_week", selectId: "fmaterial_required_issuesearch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->production_plan->Visible) { // production_plan ?>
    <div id="r_production_plan" class="row"<?= $Page->production_plan->rowAttributes() ?>>
        <label for="x_production_plan" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_production_plan"><?= $Page->production_plan->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_production_plan" id="z_production_plan" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->production_plan->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_production_plan" class="ew-search-field ew-search-field-single">
    <select
        id="x_production_plan"
        name="x_production_plan"
        class="form-select ew-select<?= $Page->production_plan->isInvalidClass() ?>"
        <?php if (!$Page->production_plan->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_production_plan"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_production_plan"
        data-value-separator="<?= $Page->production_plan->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->production_plan->getPlaceHolder()) ?>"
        <?= $Page->production_plan->editAttributes() ?>>
        <?= $Page->production_plan->selectOptionListHtml("x_production_plan") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->production_plan->getErrorMessage(false) ?></div>
<?php if (!$Page->production_plan->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_production_plan", selectId: "fmaterial_required_issuesearch_x_production_plan" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.production_plan?.lookupOptions.length) {
        options.data = { id: "x_production_plan", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_production_plan", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.production_plan.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="material_required_issue" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_operator"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_operator", selectId: "fmaterial_required_issuesearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="material_required_issue" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_required_issuesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_required_issuesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->material_out->Visible) { // material_out ?>
    <div id="r_material_out" class="row"<?= $Page->material_out->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_material_out"><?= $Page->material_out->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_material_out" id="z_material_out" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->material_out->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_material_out" class="ew-search-field ew-search-field-single">
<template id="tp_x_material_out">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="material_required_issue" data-field="x_material_out" name="x_material_out" id="x_material_out"<?= $Page->material_out->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_material_out" class="ew-item-list"></div>
<selection-list hidden
    id="x_material_out"
    name="x_material_out"
    value="<?= HtmlEncode($Page->material_out->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_material_out"
    data-target="dsl_x_material_out"
    data-repeatcolumn="5"
    class="form-control<?= $Page->material_out->isInvalidClass() ?>"
    data-table="material_required_issue"
    data-field="x_material_out"
    data-value-separator="<?= $Page->material_out->displayValueSeparatorAttribute() ?>"
    <?= $Page->material_out->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->material_out->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->material_out_id->Visible) { // material_out_id ?>
    <div id="r_material_out_id" class="row"<?= $Page->material_out_id->rowAttributes() ?>>
        <label for="x_material_out_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_material_out_id"><?= $Page->material_out_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_material_out_id" id="z_material_out_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->material_out_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_material_out_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_material_out_id"
        name="x_material_out_id"
        class="form-select ew-select<?= $Page->material_out_id->isInvalidClass() ?>"
        <?php if (!$Page->material_out_id->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_material_out_id"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_material_out_id"
        data-value-separator="<?= $Page->material_out_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->material_out_id->getPlaceHolder()) ?>"
        <?= $Page->material_out_id->editAttributes() ?>>
        <?= $Page->material_out_id->selectOptionListHtml("x_material_out_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->material_out_id->getErrorMessage(false) ?></div>
<?= $Page->material_out_id->Lookup->getParamTag($Page, "p_x_material_out_id") ?>
<?php if (!$Page->material_out_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_material_out_id", selectId: "fmaterial_required_issuesearch_x_material_out_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.material_out_id?.lookupOptions.length) {
        options.data = { id: "x_material_out_id", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_material_out_id", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.material_out_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_wl->Visible) { // size_wl ?>
    <div id="r_size_wl" class="row"<?= $Page->size_wl->rowAttributes() ?>>
        <label for="x_size_wl" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_size_wl"><?= $Page->size_wl->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_wl" id="z_size_wl" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_wl->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_size_wl" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_wl->getInputTextType() ?>" name="x_size_wl" id="x_size_wl" data-table="material_required_issue" data-field="x_size_wl" value="<?= $Page->size_wl->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->size_wl->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_wl->formatPattern()) ?>"<?= $Page->size_wl->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_wl->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="material_required_issue" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_grp->Visible) { // req_material_grp ?>
    <div id="r_req_material_grp" class="row"<?= $Page->req_material_grp->rowAttributes() ?>>
        <label for="x_req_material_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_req_material_grp"><?= $Page->req_material_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_grp" id="z_req_material_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_req_material_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_req_material_grp"
        name="x_req_material_grp"
        class="form-select ew-select<?= $Page->req_material_grp->isInvalidClass() ?>"
        <?php if (!$Page->req_material_grp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_req_material_grp"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_req_material_grp"
        data-value-separator="<?= $Page->req_material_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_grp->getPlaceHolder()) ?>"
        <?= $Page->req_material_grp->editAttributes() ?>>
        <?= $Page->req_material_grp->selectOptionListHtml("x_req_material_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_grp->getErrorMessage(false) ?></div>
<?= $Page->req_material_grp->Lookup->getParamTag($Page, "p_x_req_material_grp") ?>
<?php if (!$Page->req_material_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_req_material_grp", selectId: "fmaterial_required_issuesearch_x_req_material_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.req_material_grp?.lookupOptions.length) {
        options.data = { id: "x_req_material_grp", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_req_material_grp", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.req_material_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_grp->Visible) { // issue_material_grp ?>
    <div id="r_issue_material_grp" class="row"<?= $Page->issue_material_grp->rowAttributes() ?>>
        <label for="x_issue_material_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_material_grp"><?= $Page->issue_material_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_material_grp" id="z_issue_material_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_material_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_issue_material_grp" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->issue_material_grp->getInputTextType() ?>" name="x_issue_material_grp" id="x_issue_material_grp" data-table="material_required_issue" data-field="x_issue_material_grp" value="<?= $Page->issue_material_grp->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->issue_material_grp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_material_grp->formatPattern()) ?>"<?= $Page->issue_material_grp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->issue_material_grp->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->updated->Visible) { // updated ?>
    <div id="r_updated" class="row"<?= $Page->updated->rowAttributes() ?>>
        <label for="x_updated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_updated"><?= $Page->updated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_updated" id="z_updated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->updated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_updated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->updated->getInputTextType() ?>" name="x_updated" id="x_updated" data-table="material_required_issue" data-field="x_updated" value="<?= $Page->updated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->updated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->updated->formatPattern()) ?>"<?= $Page->updated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->updated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->poid->Visible) { // poid ?>
    <div id="r_poid" class="row"<?= $Page->poid->rowAttributes() ?>>
        <label for="x_poid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_poid"><?= $Page->poid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_poid" id="z_poid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->poid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_poid" class="ew-search-field ew-search-field-single">
    <select
        id="x_poid"
        name="x_poid"
        class="form-select ew-select<?= $Page->poid->isInvalidClass() ?>"
        <?php if (!$Page->poid->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issuesearch_x_poid"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_poid"
        data-value-separator="<?= $Page->poid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->poid->getPlaceHolder()) ?>"
        <?= $Page->poid->editAttributes() ?>>
        <?= $Page->poid->selectOptionListHtml("x_poid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->poid->getErrorMessage(false) ?></div>
<?= $Page->poid->Lookup->getParamTag($Page, "p_x_poid") ?>
<?php if (!$Page->poid->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issuesearch", function() {
    var options = { name: "x_poid", selectId: "fmaterial_required_issuesearch_x_poid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issuesearch.lists.poid?.lookupOptions.length) {
        options.data = { id: "x_poid", form: "fmaterial_required_issuesearch" };
    } else {
        options.ajax = { id: "x_poid", form: "fmaterial_required_issuesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.poid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
    <div id="r_issue_to" class="row"<?= $Page->issue_to->rowAttributes() ?>>
        <label for="x_issue_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_to"><?= $Page->issue_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_to" id="z_issue_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_issue_to" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->issue_to->getInputTextType() ?>" name="x_issue_to" id="x_issue_to" data-table="material_required_issue" data-field="x_issue_to" value="<?= $Page->issue_to->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_to->formatPattern()) ?>"<?= $Page->issue_to->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
    <div id="r_despatch_date" class="row"<?= $Page->despatch_date->rowAttributes() ?>>
        <label for="x_despatch_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_despatch_date"><?= $Page->despatch_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_date" id="z_despatch_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_despatch_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->despatch_date->getInputTextType() ?>" name="x_despatch_date" id="x_despatch_date" data-table="material_required_issue" data-field="x_despatch_date" value="<?= $Page->despatch_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->despatch_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->despatch_date->formatPattern()) ?>"<?= $Page->despatch_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->despatch_date->getErrorMessage(false) ?></div>
<?php if (!$Page->despatch_date->ReadOnly && !$Page->despatch_date->Disabled && !isset($Page->despatch_date->EditAttrs["readonly"]) && !isset($Page->despatch_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_required_issuesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_required_issuesearch", "x_despatch_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_id->Visible) { // issue_material_id ?>
    <div id="r_issue_material_id" class="row"<?= $Page->issue_material_id->rowAttributes() ?>>
        <label for="x_issue_material_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_material_id"><?= $Page->issue_material_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_issue_material_id" id="z_issue_material_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_material_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_required_issue_issue_material_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->issue_material_id->getInputTextType() ?>" name="x_issue_material_id" id="x_issue_material_id" data-table="material_required_issue" data-field="x_issue_material_id" value="<?= $Page->issue_material_id->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->issue_material_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_material_id->formatPattern()) ?>"<?= $Page->issue_material_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->issue_material_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmaterial_required_issuesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmaterial_required_issuesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmaterial_required_issuesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required_issue");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
