<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialRequiredIssueEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fmaterial_required_issueedit" id="fmaterial_required_issueedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required_issue: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fmaterial_required_issueedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmaterial_required_issueedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["jc_no", [fields.jc_no.visible && fields.jc_no.required ? ew.Validators.required(fields.jc_no.caption) : null], fields.jc_no.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null], fields.po.isInvalid],
            ["week", [fields.week.visible && fields.week.required ? ew.Validators.required(fields.week.caption) : null], fields.week.isInvalid],
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null], fields.buyer_id.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["product_id", [fields.product_id.visible && fields.product_id.required ? ew.Validators.required(fields.product_id.caption) : null], fields.product_id.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.integer], fields.quantity.isInvalid],
            ["req_material_sgrp", [fields.req_material_sgrp.visible && fields.req_material_sgrp.required ? ew.Validators.required(fields.req_material_sgrp.caption) : null], fields.req_material_sgrp.isInvalid],
            ["issue_material_sgrp", [fields.issue_material_sgrp.visible && fields.issue_material_sgrp.required ? ew.Validators.required(fields.issue_material_sgrp.caption) : null], fields.issue_material_sgrp.isInvalid],
            ["req_material_product", [fields.req_material_product.visible && fields.req_material_product.required ? ew.Validators.required(fields.req_material_product.caption) : null], fields.req_material_product.isInvalid],
            ["issue_material_product", [fields.issue_material_product.visible && fields.issue_material_product.required ? ew.Validators.required(fields.issue_material_product.caption) : null], fields.issue_material_product.isInvalid],
            ["req_material_rid", [fields.req_material_rid.visible && fields.req_material_rid.required ? ew.Validators.required(fields.req_material_rid.caption) : null], fields.req_material_rid.isInvalid],
            ["issue_material_rid", [fields.issue_material_rid.visible && fields.issue_material_rid.required ? ew.Validators.required(fields.issue_material_rid.caption) : null, ew.Validators.integer], fields.issue_material_rid.isInvalid],
            ["req_material_qty", [fields.req_material_qty.visible && fields.req_material_qty.required ? ew.Validators.required(fields.req_material_qty.caption) : null], fields.req_material_qty.isInvalid],
            ["issue_material_qty", [fields.issue_material_qty.visible && fields.issue_material_qty.required ? ew.Validators.required(fields.issue_material_qty.caption) : null, ew.Validators.float], fields.issue_material_qty.isInvalid],
            ["material_qty", [fields.material_qty.visible && fields.material_qty.required ? ew.Validators.required(fields.material_qty.caption) : null], fields.material_qty.isInvalid],
            ["unit", [fields.unit.visible && fields.unit.required ? ew.Validators.required(fields.unit.caption) : null], fields.unit.isInvalid],
            ["method", [fields.method.visible && fields.method.required ? ew.Validators.required(fields.method.caption) : null], fields.method.isInvalid],
            ["despatch_week", [fields.despatch_week.visible && fields.despatch_week.required ? ew.Validators.required(fields.despatch_week.caption) : null], fields.despatch_week.isInvalid],
            ["production_plan", [fields.production_plan.visible && fields.production_plan.required ? ew.Validators.required(fields.production_plan.caption) : null], fields.production_plan.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["material_out", [fields.material_out.visible && fields.material_out.required ? ew.Validators.required(fields.material_out.caption) : null], fields.material_out.isInvalid],
            ["despatch_date", [fields.despatch_date.visible && fields.despatch_date.required ? ew.Validators.required(fields.despatch_date.caption) : null, ew.Validators.datetime(fields.despatch_date.clientFormatPattern)], fields.despatch_date.isInvalid],
            ["issue_material_id", [fields.issue_material_id.visible && fields.issue_material_id.required ? ew.Validators.required(fields.issue_material_id.caption) : null], fields.issue_material_id.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "issue_material_sgrp": <?= $Page->issue_material_sgrp->toClientList($Page) ?>,
            "issue_material_product": <?= $Page->issue_material_product->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "material_out": <?= $Page->material_out->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_required_issue">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_material_required_issue_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_material_required_issue_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_issue" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no"<?= $Page->jc_no->rowAttributes() ?>>
        <label id="elh_material_required_issue_jc_no" for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->jc_no->caption() ?><?= $Page->jc_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->jc_no->cellAttributes() ?>>
<span id="el_material_required_issue_jc_no">
<span<?= $Page->jc_no->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->jc_no->getDisplayValue($Page->jc_no->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_jc_no" data-hidden="1" name="x_jc_no" id="x_jc_no" value="<?= HtmlEncode($Page->jc_no->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po"<?= $Page->po->rowAttributes() ?>>
        <label id="elh_material_required_issue_po" for="x_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po->caption() ?><?= $Page->po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po->cellAttributes() ?>>
<span id="el_material_required_issue_po">
<span<?= $Page->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po->getDisplayValue($Page->po->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_issue" data-field="x_po" data-hidden="1" name="x_po" id="x_po" value="<?= HtmlEncode($Page->po->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->week->Visible) { // week ?>
    <div id="r_week"<?= $Page->week->rowAttributes() ?>>
        <label id="elh_material_required_issue_week" for="x_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->week->caption() ?><?= $Page->week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->week->cellAttributes() ?>>
<span id="el_material_required_issue_week">
<span<?= $Page->week->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->week->getDisplayValue($Page->week->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_week" data-hidden="1" name="x_week" id="x_week" value="<?= HtmlEncode($Page->week->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id"<?= $Page->buyer_id->rowAttributes() ?>>
        <label id="elh_material_required_issue_buyer_id" for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_id->caption() ?><?= $Page->buyer_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el_material_required_issue_buyer_id">
<span<?= $Page->buyer_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->buyer_id->getDisplayValue($Page->buyer_id->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_buyer_id" data-hidden="1" name="x_buyer_id" id="x_buyer_id" value="<?= HtmlEncode($Page->buyer_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_material_required_issue_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_material_required_issue_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->grp->getDisplayValue($Page->grp->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_grp" data-hidden="1" name="x_grp" id="x_grp" value="<?= HtmlEncode($Page->grp->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_material_required_issue_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_material_required_issue_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->s_grp->getDisplayValue($Page->s_grp->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_s_grp" data-hidden="1" name="x_s_grp" id="x_s_grp" value="<?= HtmlEncode($Page->s_grp->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_material_required_issue_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_material_required_issue_product">
<span<?= $Page->product->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->product->getDisplayValue($Page->product->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_product" data-hidden="1" name="x_product" id="x_product" value="<?= HtmlEncode($Page->product->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_id->Visible) { // product_id ?>
    <div id="r_product_id"<?= $Page->product_id->rowAttributes() ?>>
        <label id="elh_material_required_issue_product_id" for="x_product_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_id->caption() ?><?= $Page->product_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_id->cellAttributes() ?>>
<span id="el_material_required_issue_product_id">
<span<?= $Page->product_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->product_id->getDisplayValue($Page->product_id->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_product_id" data-hidden="1" name="x_product_id" id="x_product_id" value="<?= HtmlEncode($Page->product_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no"<?= $Page->batch_no->rowAttributes() ?>>
        <label id="elh_material_required_issue_batch_no" for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->batch_no->caption() ?><?= $Page->batch_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->batch_no->cellAttributes() ?>>
<span id="el_material_required_issue_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->batch_no->getDisplayValue($Page->batch_no->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_issue" data-field="x_batch_no" data-hidden="1" name="x_batch_no" id="x_batch_no" value="<?= HtmlEncode($Page->batch_no->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_material_required_issue_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_material_required_issue_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="material_required_issue" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_sgrp->Visible) { // req_material_sgrp ?>
    <div id="r_req_material_sgrp"<?= $Page->req_material_sgrp->rowAttributes() ?>>
        <label id="elh_material_required_issue_req_material_sgrp" for="x_req_material_sgrp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_sgrp->caption() ?><?= $Page->req_material_sgrp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_sgrp->cellAttributes() ?>>
<span id="el_material_required_issue_req_material_sgrp">
<span<?= $Page->req_material_sgrp->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->req_material_sgrp->getDisplayValue($Page->req_material_sgrp->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_req_material_sgrp" data-hidden="1" name="x_req_material_sgrp" id="x_req_material_sgrp" value="<?= HtmlEncode($Page->req_material_sgrp->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_sgrp->Visible) { // issue_material_sgrp ?>
    <div id="r_issue_material_sgrp"<?= $Page->issue_material_sgrp->rowAttributes() ?>>
        <label id="elh_material_required_issue_issue_material_sgrp" for="x_issue_material_sgrp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_material_sgrp->caption() ?><?= $Page->issue_material_sgrp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_material_sgrp->cellAttributes() ?>>
<span id="el_material_required_issue_issue_material_sgrp">
    <select
        id="x_issue_material_sgrp"
        name="x_issue_material_sgrp"
        class="form-select ew-select<?= $Page->issue_material_sgrp->isInvalidClass() ?>"
        <?php if (!$Page->issue_material_sgrp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issueedit_x_issue_material_sgrp"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_issue_material_sgrp"
        data-value-separator="<?= $Page->issue_material_sgrp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_material_sgrp->getPlaceHolder()) ?>"
        <?= $Page->issue_material_sgrp->editAttributes() ?>>
        <?= $Page->issue_material_sgrp->selectOptionListHtml("x_issue_material_sgrp") ?>
    </select>
    <?= $Page->issue_material_sgrp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->issue_material_sgrp->getErrorMessage() ?></div>
<?= $Page->issue_material_sgrp->Lookup->getParamTag($Page, "p_x_issue_material_sgrp") ?>
<?php if (!$Page->issue_material_sgrp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issueedit", function() {
    var options = { name: "x_issue_material_sgrp", selectId: "fmaterial_required_issueedit_x_issue_material_sgrp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issueedit.lists.issue_material_sgrp?.lookupOptions.length) {
        options.data = { id: "x_issue_material_sgrp", form: "fmaterial_required_issueedit" };
    } else {
        options.ajax = { id: "x_issue_material_sgrp", form: "fmaterial_required_issueedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.issue_material_sgrp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_product->Visible) { // req_material_product ?>
    <div id="r_req_material_product"<?= $Page->req_material_product->rowAttributes() ?>>
        <label id="elh_material_required_issue_req_material_product" for="x_req_material_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_product->caption() ?><?= $Page->req_material_product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_product->cellAttributes() ?>>
<span id="el_material_required_issue_req_material_product">
<span<?= $Page->req_material_product->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->req_material_product->getDisplayValue($Page->req_material_product->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_req_material_product" data-hidden="1" name="x_req_material_product" id="x_req_material_product" value="<?= HtmlEncode($Page->req_material_product->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_product->Visible) { // issue_material_product ?>
    <div id="r_issue_material_product"<?= $Page->issue_material_product->rowAttributes() ?>>
        <label id="elh_material_required_issue_issue_material_product" for="x_issue_material_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_material_product->caption() ?><?= $Page->issue_material_product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_material_product->cellAttributes() ?>>
<span id="el_material_required_issue_issue_material_product">
    <select
        id="x_issue_material_product"
        name="x_issue_material_product"
        class="form-select ew-select<?= $Page->issue_material_product->isInvalidClass() ?>"
        <?php if (!$Page->issue_material_product->IsNativeSelect) { ?>
        data-select2-id="fmaterial_required_issueedit_x_issue_material_product"
        <?php } ?>
        data-table="material_required_issue"
        data-field="x_issue_material_product"
        data-value-separator="<?= $Page->issue_material_product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_material_product->getPlaceHolder()) ?>"
        <?= $Page->issue_material_product->editAttributes() ?>>
        <?= $Page->issue_material_product->selectOptionListHtml("x_issue_material_product") ?>
    </select>
    <?= $Page->issue_material_product->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->issue_material_product->getErrorMessage() ?></div>
<?= $Page->issue_material_product->Lookup->getParamTag($Page, "p_x_issue_material_product") ?>
<?php if (!$Page->issue_material_product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_required_issueedit", function() {
    var options = { name: "x_issue_material_product", selectId: "fmaterial_required_issueedit_x_issue_material_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_required_issueedit.lists.issue_material_product?.lookupOptions.length) {
        options.data = { id: "x_issue_material_product", form: "fmaterial_required_issueedit" };
    } else {
        options.ajax = { id: "x_issue_material_product", form: "fmaterial_required_issueedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_required_issue.fields.issue_material_product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
    <div id="r_req_material_rid"<?= $Page->req_material_rid->rowAttributes() ?>>
        <label id="elh_material_required_issue_req_material_rid" for="x_req_material_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_rid->caption() ?><?= $Page->req_material_rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_rid->cellAttributes() ?>>
<span id="el_material_required_issue_req_material_rid">
<span<?= $Page->req_material_rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->req_material_rid->getDisplayValue($Page->req_material_rid->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_req_material_rid" data-hidden="1" name="x_req_material_rid" id="x_req_material_rid" value="<?= HtmlEncode($Page->req_material_rid->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_rid->Visible) { // issue_material_rid ?>
    <div id="r_issue_material_rid"<?= $Page->issue_material_rid->rowAttributes() ?>>
        <label id="elh_material_required_issue_issue_material_rid" for="x_issue_material_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_material_rid->caption() ?><?= $Page->issue_material_rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_material_rid->cellAttributes() ?>>
<span id="el_material_required_issue_issue_material_rid">
<input type="<?= $Page->issue_material_rid->getInputTextType() ?>" name="x_issue_material_rid" id="x_issue_material_rid" data-table="material_required_issue" data-field="x_issue_material_rid" value="<?= $Page->issue_material_rid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->issue_material_rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_material_rid->formatPattern()) ?>"<?= $Page->issue_material_rid->editAttributes() ?> aria-describedby="x_issue_material_rid_help">
<?= $Page->issue_material_rid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issue_material_rid->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
    <div id="r_req_material_qty"<?= $Page->req_material_qty->rowAttributes() ?>>
        <label id="elh_material_required_issue_req_material_qty" for="x_req_material_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_qty->caption() ?><?= $Page->req_material_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_qty->cellAttributes() ?>>
<span id="el_material_required_issue_req_material_qty">
<span<?= $Page->req_material_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->req_material_qty->getDisplayValue($Page->req_material_qty->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_issue" data-field="x_req_material_qty" data-hidden="1" name="x_req_material_qty" id="x_req_material_qty" value="<?= HtmlEncode($Page->req_material_qty->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_qty->Visible) { // issue_material_qty ?>
    <div id="r_issue_material_qty"<?= $Page->issue_material_qty->rowAttributes() ?>>
        <label id="elh_material_required_issue_issue_material_qty" for="x_issue_material_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_material_qty->caption() ?><?= $Page->issue_material_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_material_qty->cellAttributes() ?>>
<span id="el_material_required_issue_issue_material_qty">
<input type="<?= $Page->issue_material_qty->getInputTextType() ?>" name="x_issue_material_qty" id="x_issue_material_qty" data-table="material_required_issue" data-field="x_issue_material_qty" value="<?= $Page->issue_material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->issue_material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_material_qty->formatPattern()) ?>"<?= $Page->issue_material_qty->editAttributes() ?> aria-describedby="x_issue_material_qty_help">
<?= $Page->issue_material_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issue_material_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->material_qty->Visible) { // material_qty ?>
    <div id="r_material_qty"<?= $Page->material_qty->rowAttributes() ?>>
        <label id="elh_material_required_issue_material_qty" for="x_material_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->material_qty->caption() ?><?= $Page->material_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->material_qty->cellAttributes() ?>>
<span id="el_material_required_issue_material_qty">
<span<?= $Page->material_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->material_qty->getDisplayValue($Page->material_qty->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required_issue" data-field="x_material_qty" data-hidden="1" name="x_material_qty" id="x_material_qty" value="<?= HtmlEncode($Page->material_qty->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit"<?= $Page->unit->rowAttributes() ?>>
        <label id="elh_material_required_issue_unit" for="x_unit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->unit->caption() ?><?= $Page->unit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->unit->cellAttributes() ?>>
<span id="el_material_required_issue_unit">
<span<?= $Page->unit->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->unit->getDisplayValue($Page->unit->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_unit" data-hidden="1" name="x_unit" id="x_unit" value="<?= HtmlEncode($Page->unit->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method"<?= $Page->method->rowAttributes() ?>>
        <label id="elh_material_required_issue_method" for="x_method" class="<?= $Page->LeftColumnClass ?>"><?= $Page->method->caption() ?><?= $Page->method->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->method->cellAttributes() ?>>
<span id="el_material_required_issue_method">
<span<?= $Page->method->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->method->getDisplayValue($Page->method->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_method" data-hidden="1" name="x_method" id="x_method" value="<?= HtmlEncode($Page->method->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week"<?= $Page->despatch_week->rowAttributes() ?>>
        <label id="elh_material_required_issue_despatch_week" for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_week->caption() ?><?= $Page->despatch_week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el_material_required_issue_despatch_week">
<span<?= $Page->despatch_week->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->despatch_week->getDisplayValue($Page->despatch_week->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_despatch_week" data-hidden="1" name="x_despatch_week" id="x_despatch_week" value="<?= HtmlEncode($Page->despatch_week->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->production_plan->Visible) { // production_plan ?>
    <div id="r_production_plan"<?= $Page->production_plan->rowAttributes() ?>>
        <label id="elh_material_required_issue_production_plan" for="x_production_plan" class="<?= $Page->LeftColumnClass ?>"><?= $Page->production_plan->caption() ?><?= $Page->production_plan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->production_plan->cellAttributes() ?>>
<span id="el_material_required_issue_production_plan">
<span<?= $Page->production_plan->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->production_plan->getDisplayValue($Page->production_plan->EditValue) ?></span></span>
<input type="hidden" data-table="material_required_issue" data-field="x_production_plan" data-hidden="1" name="x_production_plan" id="x_production_plan" value="<?= HtmlEncode($Page->production_plan->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->material_out->Visible) { // material_out ?>
    <div id="r_material_out"<?= $Page->material_out->rowAttributes() ?>>
        <label id="elh_material_required_issue_material_out" class="<?= $Page->LeftColumnClass ?>"><?= $Page->material_out->caption() ?><?= $Page->material_out->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->material_out->cellAttributes() ?>>
<span id="el_material_required_issue_material_out">
<template id="tp_x_material_out">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="material_required_issue" data-field="x_material_out" name="x_material_out" id="x_material_out"<?= $Page->material_out->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_material_out" class="ew-item-list"></div>
<selection-list hidden
    id="x_material_out"
    name="x_material_out"
    value="<?= HtmlEncode($Page->material_out->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_material_out"
    data-target="dsl_x_material_out"
    data-repeatcolumn="5"
    class="form-control<?= $Page->material_out->isInvalidClass() ?>"
    data-table="material_required_issue"
    data-field="x_material_out"
    data-value-separator="<?= $Page->material_out->displayValueSeparatorAttribute() ?>"
    <?= $Page->material_out->editAttributes() ?>></selection-list>
<?= $Page->material_out->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->material_out->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
    <div id="r_despatch_date"<?= $Page->despatch_date->rowAttributes() ?>>
        <label id="elh_material_required_issue_despatch_date" for="x_despatch_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_date->caption() ?><?= $Page->despatch_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el_material_required_issue_despatch_date">
<input type="<?= $Page->despatch_date->getInputTextType() ?>" name="x_despatch_date" id="x_despatch_date" data-table="material_required_issue" data-field="x_despatch_date" value="<?= $Page->despatch_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->despatch_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->despatch_date->formatPattern()) ?>"<?= $Page->despatch_date->editAttributes() ?> aria-describedby="x_despatch_date_help">
<?= $Page->despatch_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->despatch_date->getErrorMessage() ?></div>
<?php if (!$Page->despatch_date->ReadOnly && !$Page->despatch_date->Disabled && !isset($Page->despatch_date->EditAttrs["readonly"]) && !isset($Page->despatch_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_required_issueedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_required_issueedit", "x_despatch_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_id->Visible) { // issue_material_id ?>
    <div id="r_issue_material_id"<?= $Page->issue_material_id->rowAttributes() ?>>
        <label id="elh_material_required_issue_issue_material_id" for="x_issue_material_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_material_id->caption() ?><?= $Page->issue_material_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_material_id->cellAttributes() ?>>
<span id="el_material_required_issue_issue_material_id">
<input type="<?= $Page->issue_material_id->getInputTextType() ?>" name="x_issue_material_id" id="x_issue_material_id" data-table="material_required_issue" data-field="x_issue_material_id" value="<?= $Page->issue_material_id->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->issue_material_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_material_id->formatPattern()) ?>"<?= $Page->issue_material_id->editAttributes() ?> aria-describedby="x_issue_material_id_help">
<?= $Page->issue_material_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issue_material_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmaterial_required_issueedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmaterial_required_issueedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required_issue");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
