<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialRequiredEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fmaterial_requirededit" id="fmaterial_requirededit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_required: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fmaterial_requirededit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmaterial_requirededit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null], fields.company_id.isInvalid],
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null], fields.buyer_id.isInvalid],
            ["poid", [fields.poid.visible && fields.poid.required ? ew.Validators.required(fields.poid.caption) : null], fields.poid.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null], fields.po.isInvalid],
            ["week", [fields.week.visible && fields.week.required ? ew.Validators.required(fields.week.caption) : null], fields.week.isInvalid],
            ["product_id", [fields.product_id.visible && fields.product_id.required ? ew.Validators.required(fields.product_id.caption) : null], fields.product_id.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null], fields.quantity.isInvalid],
            ["Size_wl", [fields.Size_wl.visible && fields.Size_wl.required ? ew.Validators.required(fields.Size_wl.caption) : null], fields.Size_wl.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null], fields.sqm.isInvalid],
            ["t_sqm", [fields.t_sqm.visible && fields.t_sqm.required ? ew.Validators.required(fields.t_sqm.caption) : null], fields.t_sqm.isInvalid],
            ["unit", [fields.unit.visible && fields.unit.required ? ew.Validators.required(fields.unit.caption) : null], fields.unit.isInvalid],
            ["material_qty", [fields.material_qty.visible && fields.material_qty.required ? ew.Validators.required(fields.material_qty.caption) : null], fields.material_qty.isInvalid],
            ["method", [fields.method.visible && fields.method.required ? ew.Validators.required(fields.method.caption) : null], fields.method.isInvalid],
            ["despatch_week", [fields.despatch_week.visible && fields.despatch_week.required ? ew.Validators.required(fields.despatch_week.caption) : null], fields.despatch_week.isInvalid],
            ["production_plan", [fields.production_plan.visible && fields.production_plan.required ? ew.Validators.required(fields.production_plan.caption) : null], fields.production_plan.isInvalid],
            ["req_material_rid", [fields.req_material_rid.visible && fields.req_material_rid.required ? ew.Validators.required(fields.req_material_rid.caption) : null], fields.req_material_rid.isInvalid],
            ["req_material_packing", [fields.req_material_packing.visible && fields.req_material_packing.required ? ew.Validators.required(fields.req_material_packing.caption) : null], fields.req_material_packing.isInvalid],
            ["req_material_qty", [fields.req_material_qty.visible && fields.req_material_qty.required ? ew.Validators.required(fields.req_material_qty.caption) : null], fields.req_material_qty.isInvalid],
            ["issue_material_lcgp_rid", [fields.issue_material_lcgp_rid.visible && fields.issue_material_lcgp_rid.required ? ew.Validators.required(fields.issue_material_lcgp_rid.caption) : null], fields.issue_material_lcgp_rid.isInvalid],
            ["issue_material_qty", [fields.issue_material_qty.visible && fields.issue_material_qty.required ? ew.Validators.required(fields.issue_material_qty.caption) : null, ew.Validators.float], fields.issue_material_qty.isInvalid],
            ["issue_material_packing", [fields.issue_material_packing.visible && fields.issue_material_packing.required ? ew.Validators.required(fields.issue_material_packing.caption) : null, ew.Validators.integer], fields.issue_material_packing.isInvalid],
            ["issue_material_lot_no", [fields.issue_material_lot_no.visible && fields.issue_material_lot_no.required ? ew.Validators.required(fields.issue_material_lot_no.caption) : null], fields.issue_material_lot_no.isInvalid],
            ["issue_material_godown", [fields.issue_material_godown.visible && fields.issue_material_godown.required ? ew.Validators.required(fields.issue_material_godown.caption) : null, ew.Validators.integer], fields.issue_material_godown.isInvalid],
            ["despatch_date", [fields.despatch_date.visible && fields.despatch_date.required ? ew.Validators.required(fields.despatch_date.caption) : null], fields.despatch_date.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "issue_material_lcgp_rid": <?= $Page->issue_material_lcgp_rid->toClientList($Page) ?>,
            "issue_material_packing": <?= $Page->issue_material_packing->toClientList($Page) ?>,
            "issue_material_godown": <?= $Page->issue_material_godown->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_required">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "required_material_compiled") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="required_material_compiled">
<input type="hidden" name="fk_po" value="<?= HtmlEncode($Page->po->getSessionValue()) ?>">
<input type="hidden" name="fk_req_material_rid" value="<?= HtmlEncode($Page->req_material_rid->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_material_required_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_material_required_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label id="elh_material_required_company_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->company_id->caption() ?><?= $Page->company_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->company_id->cellAttributes() ?>>
<span id="el_material_required_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->company_id->getDisplayValue($Page->company_id->EditValue) ?></span></span>
<input type="hidden" data-table="material_required" data-field="x_company_id" data-hidden="1" name="x_company_id" id="x_company_id" value="<?= HtmlEncode($Page->company_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id"<?= $Page->buyer_id->rowAttributes() ?>>
        <label id="elh_material_required_buyer_id" for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_id->caption() ?><?= $Page->buyer_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el_material_required_buyer_id">
<span<?= $Page->buyer_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyer_id->EditValue) && $Page->buyer_id->linkAttributes() != "") { ?>
<a<?= $Page->buyer_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->buyer_id->getDisplayValue($Page->buyer_id->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->buyer_id->getDisplayValue($Page->buyer_id->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="material_required" data-field="x_buyer_id" data-hidden="1" name="x_buyer_id" id="x_buyer_id" value="<?= HtmlEncode($Page->buyer_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->poid->Visible) { // poid ?>
    <div id="r_poid"<?= $Page->poid->rowAttributes() ?>>
        <label id="elh_material_required_poid" for="x_poid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->poid->caption() ?><?= $Page->poid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->poid->cellAttributes() ?>>
<span id="el_material_required_poid">
<span<?= $Page->poid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->poid->getDisplayValue($Page->poid->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required" data-field="x_poid" data-hidden="1" name="x_poid" id="x_poid" value="<?= HtmlEncode($Page->poid->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po"<?= $Page->po->rowAttributes() ?>>
        <label id="elh_material_required_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po->caption() ?><?= $Page->po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po->cellAttributes() ?>>
<span id="el_material_required_po">
<span<?= $Page->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->po->getDisplayValue($Page->po->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required" data-field="x_po" data-hidden="1" name="x_po" id="x_po" value="<?= HtmlEncode($Page->po->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->week->Visible) { // week ?>
    <div id="r_week"<?= $Page->week->rowAttributes() ?>>
        <label id="elh_material_required_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->week->caption() ?><?= $Page->week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->week->cellAttributes() ?>>
<span id="el_material_required_week">
<span<?= $Page->week->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->week->getDisplayValue($Page->week->EditValue) ?></span></span>
<input type="hidden" data-table="material_required" data-field="x_week" data-hidden="1" name="x_week" id="x_week" value="<?= HtmlEncode($Page->week->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_id->Visible) { // product_id ?>
    <div id="r_product_id"<?= $Page->product_id->rowAttributes() ?>>
        <label id="elh_material_required_product_id" for="x_product_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_id->caption() ?><?= $Page->product_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_id->cellAttributes() ?>>
<span id="el_material_required_product_id">
<span<?= $Page->product_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->product_id->EditValue) && $Page->product_id->linkAttributes() != "") { ?>
<a<?= $Page->product_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->product_id->getDisplayValue($Page->product_id->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->product_id->getDisplayValue($Page->product_id->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="material_required" data-field="x_product_id" data-hidden="1" name="x_product_id" id="x_product_id" value="<?= HtmlEncode($Page->product_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no"<?= $Page->batch_no->rowAttributes() ?>>
        <label id="elh_material_required_batch_no" for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->batch_no->caption() ?><?= $Page->batch_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->batch_no->cellAttributes() ?>>
<span id="el_material_required_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?php if (!EmptyString($Page->batch_no->EditValue) && $Page->batch_no->linkAttributes() != "") { ?>
<a<?= $Page->batch_no->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->batch_no->getDisplayValue($Page->batch_no->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->batch_no->getDisplayValue($Page->batch_no->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="material_required" data-field="x_batch_no" data-hidden="1" name="x_batch_no" id="x_batch_no" value="<?= HtmlEncode($Page->batch_no->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_material_required_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_material_required_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->quantity->getDisplayValue($Page->quantity->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required" data-field="x_quantity" data-hidden="1" name="x_quantity" id="x_quantity" value="<?= HtmlEncode($Page->quantity->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Size_wl->Visible) { // Size_wl ?>
    <div id="r_Size_wl"<?= $Page->Size_wl->rowAttributes() ?>>
        <label id="elh_material_required_Size_wl" for="x_Size_wl" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Size_wl->caption() ?><?= $Page->Size_wl->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Size_wl->cellAttributes() ?>>
<span id="el_material_required_Size_wl">
<span<?= $Page->Size_wl->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->Size_wl->getDisplayValue($Page->Size_wl->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required" data-field="x_Size_wl" data-hidden="1" name="x_Size_wl" id="x_Size_wl" value="<?= HtmlEncode($Page->Size_wl->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm"<?= $Page->sqm->rowAttributes() ?>>
        <label id="elh_material_required_sqm" for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm->caption() ?><?= $Page->sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm->cellAttributes() ?>>
<span id="el_material_required_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->sqm->getDisplayValue($Page->sqm->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required" data-field="x_sqm" data-hidden="1" name="x_sqm" id="x_sqm" value="<?= HtmlEncode($Page->sqm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->t_sqm->Visible) { // t_sqm ?>
    <div id="r_t_sqm"<?= $Page->t_sqm->rowAttributes() ?>>
        <label id="elh_material_required_t_sqm" for="x_t_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->t_sqm->caption() ?><?= $Page->t_sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->t_sqm->cellAttributes() ?>>
<span id="el_material_required_t_sqm">
<span<?= $Page->t_sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->t_sqm->getDisplayValue($Page->t_sqm->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required" data-field="x_t_sqm" data-hidden="1" name="x_t_sqm" id="x_t_sqm" value="<?= HtmlEncode($Page->t_sqm->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit"<?= $Page->unit->rowAttributes() ?>>
        <label id="elh_material_required_unit" for="x_unit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->unit->caption() ?><?= $Page->unit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->unit->cellAttributes() ?>>
<span id="el_material_required_unit">
<span<?= $Page->unit->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->unit->getDisplayValue($Page->unit->EditValue) ?></span></span>
<input type="hidden" data-table="material_required" data-field="x_unit" data-hidden="1" name="x_unit" id="x_unit" value="<?= HtmlEncode($Page->unit->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->material_qty->Visible) { // material_qty ?>
    <div id="r_material_qty"<?= $Page->material_qty->rowAttributes() ?>>
        <label id="elh_material_required_material_qty" for="x_material_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->material_qty->caption() ?><?= $Page->material_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->material_qty->cellAttributes() ?>>
<span id="el_material_required_material_qty">
<span<?= $Page->material_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->material_qty->getDisplayValue($Page->material_qty->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required" data-field="x_material_qty" data-hidden="1" name="x_material_qty" id="x_material_qty" value="<?= HtmlEncode($Page->material_qty->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method"<?= $Page->method->rowAttributes() ?>>
        <label id="elh_material_required_method" for="x_method" class="<?= $Page->LeftColumnClass ?>"><?= $Page->method->caption() ?><?= $Page->method->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->method->cellAttributes() ?>>
<span id="el_material_required_method">
<span<?= $Page->method->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->method->getDisplayValue($Page->method->EditValue) ?></span></span>
<input type="hidden" data-table="material_required" data-field="x_method" data-hidden="1" name="x_method" id="x_method" value="<?= HtmlEncode($Page->method->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week"<?= $Page->despatch_week->rowAttributes() ?>>
        <label id="elh_material_required_despatch_week" for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_week->caption() ?><?= $Page->despatch_week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_week->cellAttributes() ?>>
<span id="el_material_required_despatch_week">
<span<?= $Page->despatch_week->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->despatch_week->getDisplayValue($Page->despatch_week->EditValue) ?></span></span>
<input type="hidden" data-table="material_required" data-field="x_despatch_week" data-hidden="1" name="x_despatch_week" id="x_despatch_week" value="<?= HtmlEncode($Page->despatch_week->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->production_plan->Visible) { // production_plan ?>
    <div id="r_production_plan"<?= $Page->production_plan->rowAttributes() ?>>
        <label id="elh_material_required_production_plan" for="x_production_plan" class="<?= $Page->LeftColumnClass ?>"><?= $Page->production_plan->caption() ?><?= $Page->production_plan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->production_plan->cellAttributes() ?>>
<span id="el_material_required_production_plan">
<span<?= $Page->production_plan->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->production_plan->getDisplayValue($Page->production_plan->EditValue) ?></span></span>
<input type="hidden" data-table="material_required" data-field="x_production_plan" data-hidden="1" name="x_production_plan" id="x_production_plan" value="<?= HtmlEncode($Page->production_plan->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
    <div id="r_req_material_rid"<?= $Page->req_material_rid->rowAttributes() ?>>
        <label id="elh_material_required_req_material_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_rid->caption() ?><?= $Page->req_material_rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_rid->cellAttributes() ?>>
<span id="el_material_required_req_material_rid">
<span<?= $Page->req_material_rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->req_material_rid->getDisplayValue($Page->req_material_rid->EditValue) ?></span></span>
<input type="hidden" data-table="material_required" data-field="x_req_material_rid" data-hidden="1" name="x_req_material_rid" id="x_req_material_rid" value="<?= HtmlEncode($Page->req_material_rid->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
    <div id="r_req_material_packing"<?= $Page->req_material_packing->rowAttributes() ?>>
        <label id="elh_material_required_req_material_packing" for="x_req_material_packing" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_packing->caption() ?><?= $Page->req_material_packing->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_packing->cellAttributes() ?>>
<span id="el_material_required_req_material_packing">
<span<?= $Page->req_material_packing->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->req_material_packing->getDisplayValue($Page->req_material_packing->EditValue) ?></span></span>
<input type="hidden" data-table="material_required" data-field="x_req_material_packing" data-hidden="1" name="x_req_material_packing" id="x_req_material_packing" value="<?= HtmlEncode($Page->req_material_packing->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
    <div id="r_req_material_qty"<?= $Page->req_material_qty->rowAttributes() ?>>
        <label id="elh_material_required_req_material_qty" for="x_req_material_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->req_material_qty->caption() ?><?= $Page->req_material_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->req_material_qty->cellAttributes() ?>>
<span id="el_material_required_req_material_qty">
<span<?= $Page->req_material_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->req_material_qty->getDisplayValue($Page->req_material_qty->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required" data-field="x_req_material_qty" data-hidden="1" name="x_req_material_qty" id="x_req_material_qty" value="<?= HtmlEncode($Page->req_material_qty->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_lcgp_rid->Visible) { // issue_material_lcgp_rid ?>
    <div id="r_issue_material_lcgp_rid"<?= $Page->issue_material_lcgp_rid->rowAttributes() ?>>
        <label id="elh_material_required_issue_material_lcgp_rid" for="x_issue_material_lcgp_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_material_lcgp_rid->caption() ?><?= $Page->issue_material_lcgp_rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_material_lcgp_rid->cellAttributes() ?>>
<span id="el_material_required_issue_material_lcgp_rid">
    <select
        id="x_issue_material_lcgp_rid"
        name="x_issue_material_lcgp_rid"
        class="form-control ew-select<?= $Page->issue_material_lcgp_rid->isInvalidClass() ?>"
        data-select2-id="fmaterial_requirededit_x_issue_material_lcgp_rid"
        data-table="material_required"
        data-field="x_issue_material_lcgp_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->issue_material_lcgp_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->issue_material_lcgp_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_material_lcgp_rid->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->issue_material_lcgp_rid->editAttributes() ?>>
        <?= $Page->issue_material_lcgp_rid->selectOptionListHtml("x_issue_material_lcgp_rid") ?>
    </select>
    <?= $Page->issue_material_lcgp_rid->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->issue_material_lcgp_rid->getErrorMessage() ?></div>
<?= $Page->issue_material_lcgp_rid->Lookup->getParamTag($Page, "p_x_issue_material_lcgp_rid") ?>
<script>
loadjs.ready("fmaterial_requirededit", function() {
    var options = { name: "x_issue_material_lcgp_rid", selectId: "fmaterial_requirededit_x_issue_material_lcgp_rid" };
    if (fmaterial_requirededit.lists.issue_material_lcgp_rid?.lookupOptions.length) {
        options.data = { id: "x_issue_material_lcgp_rid", form: "fmaterial_requirededit" };
    } else {
        options.ajax = { id: "x_issue_material_lcgp_rid", form: "fmaterial_requirededit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.material_required.fields.issue_material_lcgp_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_qty->Visible) { // issue_material_qty ?>
    <div id="r_issue_material_qty"<?= $Page->issue_material_qty->rowAttributes() ?>>
        <label id="elh_material_required_issue_material_qty" for="x_issue_material_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_material_qty->caption() ?><?= $Page->issue_material_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_material_qty->cellAttributes() ?>>
<span id="el_material_required_issue_material_qty">
<input type="<?= $Page->issue_material_qty->getInputTextType() ?>" name="x_issue_material_qty" id="x_issue_material_qty" data-table="material_required" data-field="x_issue_material_qty" value="<?= $Page->issue_material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->issue_material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_material_qty->formatPattern()) ?>"<?= $Page->issue_material_qty->editAttributes() ?> aria-describedby="x_issue_material_qty_help">
<?= $Page->issue_material_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issue_material_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_packing->Visible) { // issue_material_packing ?>
    <div id="r_issue_material_packing"<?= $Page->issue_material_packing->rowAttributes() ?>>
        <label id="elh_material_required_issue_material_packing" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_material_packing->caption() ?><?= $Page->issue_material_packing->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_material_packing->cellAttributes() ?>>
<span id="el_material_required_issue_material_packing">
<?php
if (IsRTL()) {
    $Page->issue_material_packing->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_issue_material_packing" class="ew-auto-suggest">
    <input type="<?= $Page->issue_material_packing->getInputTextType() ?>" class="form-control" name="sv_x_issue_material_packing" id="sv_x_issue_material_packing" value="<?= RemoveHtml($Page->issue_material_packing->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->issue_material_packing->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->issue_material_packing->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_material_packing->formatPattern()) ?>"<?= $Page->issue_material_packing->editAttributes() ?> aria-describedby="x_issue_material_packing_help">
</span>
<selection-list hidden class="form-control" data-table="material_required" data-field="x_issue_material_packing" data-input="sv_x_issue_material_packing" data-value-separator="<?= $Page->issue_material_packing->displayValueSeparatorAttribute() ?>" name="x_issue_material_packing" id="x_issue_material_packing" value="<?= HtmlEncode($Page->issue_material_packing->CurrentValue) ?>"></selection-list>
<?= $Page->issue_material_packing->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issue_material_packing->getErrorMessage() ?></div>
<script>
loadjs.ready("fmaterial_requirededit", function() {
    fmaterial_requirededit.createAutoSuggest(Object.assign({"id":"x_issue_material_packing","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->issue_material_packing->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.material_required.fields.issue_material_packing.autoSuggestOptions));
});
</script>
<?= $Page->issue_material_packing->Lookup->getParamTag($Page, "p_x_issue_material_packing") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_lot_no->Visible) { // issue_material_lot_no ?>
    <div id="r_issue_material_lot_no"<?= $Page->issue_material_lot_no->rowAttributes() ?>>
        <label id="elh_material_required_issue_material_lot_no" for="x_issue_material_lot_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_material_lot_no->caption() ?><?= $Page->issue_material_lot_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_material_lot_no->cellAttributes() ?>>
<span id="el_material_required_issue_material_lot_no">
<input type="<?= $Page->issue_material_lot_no->getInputTextType() ?>" name="x_issue_material_lot_no" id="x_issue_material_lot_no" data-table="material_required" data-field="x_issue_material_lot_no" value="<?= $Page->issue_material_lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->issue_material_lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_material_lot_no->formatPattern()) ?>"<?= $Page->issue_material_lot_no->editAttributes() ?> aria-describedby="x_issue_material_lot_no_help">
<?= $Page->issue_material_lot_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issue_material_lot_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_material_godown->Visible) { // issue_material_godown ?>
    <div id="r_issue_material_godown"<?= $Page->issue_material_godown->rowAttributes() ?>>
        <label id="elh_material_required_issue_material_godown" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_material_godown->caption() ?><?= $Page->issue_material_godown->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_material_godown->cellAttributes() ?>>
<span id="el_material_required_issue_material_godown">
<?php
if (IsRTL()) {
    $Page->issue_material_godown->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_issue_material_godown" class="ew-auto-suggest">
    <input type="<?= $Page->issue_material_godown->getInputTextType() ?>" class="form-control" name="sv_x_issue_material_godown" id="sv_x_issue_material_godown" value="<?= RemoveHtml($Page->issue_material_godown->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->issue_material_godown->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->issue_material_godown->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_material_godown->formatPattern()) ?>"<?= $Page->issue_material_godown->editAttributes() ?> aria-describedby="x_issue_material_godown_help">
</span>
<selection-list hidden class="form-control" data-table="material_required" data-field="x_issue_material_godown" data-input="sv_x_issue_material_godown" data-value-separator="<?= $Page->issue_material_godown->displayValueSeparatorAttribute() ?>" name="x_issue_material_godown" id="x_issue_material_godown" value="<?= HtmlEncode($Page->issue_material_godown->CurrentValue) ?>"></selection-list>
<?= $Page->issue_material_godown->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issue_material_godown->getErrorMessage() ?></div>
<script>
loadjs.ready("fmaterial_requirededit", function() {
    fmaterial_requirededit.createAutoSuggest(Object.assign({"id":"x_issue_material_godown","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->issue_material_godown->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.material_required.fields.issue_material_godown.autoSuggestOptions));
});
</script>
<?= $Page->issue_material_godown->Lookup->getParamTag($Page, "p_x_issue_material_godown") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatch_date->Visible) { // despatch_date ?>
    <div id="r_despatch_date"<?= $Page->despatch_date->rowAttributes() ?>>
        <label id="elh_material_required_despatch_date" for="x_despatch_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatch_date->caption() ?><?= $Page->despatch_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatch_date->cellAttributes() ?>>
<span id="el_material_required_despatch_date">
<span<?= $Page->despatch_date->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->despatch_date->getDisplayValue($Page->despatch_date->EditValue))) ?>"></span>
<input type="hidden" data-table="material_required" data-field="x_despatch_date" data-hidden="1" name="x_despatch_date" id="x_despatch_date" value="<?= HtmlEncode($Page->despatch_date->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmaterial_requirededit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmaterial_requirededit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_required");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
