<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialOutWbcSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_out_wbc: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmaterial_out_wbcsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmaterial_out_wbcsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["issue_to", [], fields.issue_to.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["y_dated", [ew.Validators.between], false],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["rid_name", [], fields.rid_name.isInvalid],
            ["jc_no", [], fields.jc_no.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "process": <?= $Page->process->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmaterial_out_wbcsearch" id="fmaterial_out_wbcsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_out_wbc">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_wbc_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_wbc_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="material_out_wbc" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_wbc_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_wbc_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_wbcsearch_x_process"
        <?php } ?>
        data-table="material_out_wbc"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_wbcsearch", function() {
    var options = { name: "x_process", selectId: "fmaterial_out_wbcsearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_wbcsearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fmaterial_out_wbcsearch" };
    } else {
        options.ajax = { id: "x_process", form: "fmaterial_out_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_wbc.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
    <div id="r_issue_to" class="row"<?= $Page->issue_to->rowAttributes() ?>>
        <label for="x_issue_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_wbc_issue_to"><?= $Page->issue_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_to" id="z_issue_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_wbc_issue_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_issue_to"
        name="x_issue_to"
        class="form-select ew-select<?= $Page->issue_to->isInvalidClass() ?>"
        <?php if (!$Page->issue_to->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_wbcsearch_x_issue_to"
        <?php } ?>
        data-table="material_out_wbc"
        data-field="x_issue_to"
        data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>"
        <?= $Page->issue_to->editAttributes() ?>>
        <?= $Page->issue_to->selectOptionListHtml("x_issue_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage(false) ?></div>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
<?php if (!$Page->issue_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_wbcsearch", function() {
    var options = { name: "x_issue_to", selectId: "fmaterial_out_wbcsearch_x_issue_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_wbcsearch.lists.issue_to?.lookupOptions.length) {
        options.data = { id: "x_issue_to", form: "fmaterial_out_wbcsearch" };
    } else {
        options.ajax = { id: "x_issue_to", form: "fmaterial_out_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_wbc.fields.issue_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_wbc_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_wbc_godown" class="ew-search-field ew-search-field-single">
<template id="tp_x_godown">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="material_out_wbc" data-field="x_godown" name="x_godown" id="x_godown"<?= $Page->godown->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_godown" class="ew-item-list"></div>
<selection-list hidden
    id="x_godown"
    name="x_godown"
    value="<?= HtmlEncode($Page->godown->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_godown"
    data-target="dsl_x_godown"
    data-repeatcolumn="5"
    class="form-control<?= $Page->godown->isInvalidClass() ?>"
    data-table="material_out_wbc"
    data-field="x_godown"
    data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
    <?= $Page->godown->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_wbc_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_wbc_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid"
        name="x_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fmaterial_out_wbcsearch_x_rid"
        data-table="material_out_wbc"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fmaterial_out_wbcsearch", function() {
    var options = { name: "x_rid", selectId: "fmaterial_out_wbcsearch_x_rid" };
    if (fmaterial_out_wbcsearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fmaterial_out_wbcsearch" };
    } else {
        options.ajax = { id: "x_rid", form: "fmaterial_out_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.material_out_wbc.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_wbc_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_wbc_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="material_out_wbc" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_wbc_dated"><?= $Page->dated->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_dated" id="z_dated" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->dated->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->dated->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_material_out_wbc_dated" class="ew-search-field">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="material_out_wbc" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_out_wbcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_out_wbcsearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_material_out_wbc_dated" class="ew-search-field2 d-none">
<input type="<?= $Page->dated->getInputTextType() ?>" name="y_dated" id="y_dated" data-table="material_out_wbc" data-field="x_dated" value="<?= $Page->dated->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_out_wbcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_out_wbcsearch", "y_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_wbc_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_wbc_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="material_out_wbc" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_wbc_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_wbc_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_wbcsearch_x_operator"
        <?php } ?>
        data-table="material_out_wbc"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_wbcsearch", function() {
    var options = { name: "x_operator", selectId: "fmaterial_out_wbcsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_wbcsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fmaterial_out_wbcsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fmaterial_out_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_wbc.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_wbc_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_wbc_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="material_out_wbc" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid_name->Visible) { // rid_name ?>
    <div id="r_rid_name" class="row"<?= $Page->rid_name->rowAttributes() ?>>
        <label for="x_rid_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_wbc_rid_name"><?= $Page->rid_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid_name" id="z_rid_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_wbc_rid_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rid_name->getInputTextType() ?>" name="x_rid_name" id="x_rid_name" data-table="material_out_wbc" data-field="x_rid_name" value="<?= $Page->rid_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->rid_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid_name->formatPattern()) ?>"<?= $Page->rid_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rid_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no" class="row"<?= $Page->jc_no->rowAttributes() ?>>
        <label for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_wbc_jc_no"><?= $Page->jc_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_jc_no" id="z_jc_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_wbc_jc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="material_out_wbc" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmaterial_out_wbcsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmaterial_out_wbcsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmaterial_out_wbcsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_out_wbc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
