<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialOutOldSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_out_old: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmaterial_out_oldsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmaterial_out_oldsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["rid_1", [], fields.rid_1.isInvalid],
            ["packets", [], fields.packets.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["quantity_sub", [ew.Validators.float], fields.quantity_sub.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["cart_amount", [ew.Validators.float], fields.cart_amount.isInvalid],
            ["other_amount", [ew.Validators.float], fields.other_amount.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["tax_amount", [ew.Validators.float], fields.tax_amount.isInvalid],
            ["total_amount", [ew.Validators.float], fields.total_amount.isInvalid],
            ["tax_percent", [ew.Validators.float], fields.tax_percent.isInvalid],
            ["hsn_code", [ew.Validators.float], fields.hsn_code.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["godown_po", [], fields.godown_po.isInvalid],
            ["issue_to", [], fields.issue_to.isInvalid],
            ["issue_to_unit", [], fields.issue_to_unit.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["y_dated", [ew.Validators.between], false],
            ["remarks", [], fields.remarks.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["uploads", [], fields.uploads.isInvalid],
            ["cart_ref", [ew.Validators.integer], fields.cart_ref.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "rid_1": <?= $Page->rid_1->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "godown_po": <?= $Page->godown_po->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "issue_to_unit": <?= $Page->issue_to_unit->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmaterial_out_oldsearch" id="fmaterial_out_oldsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_out_old">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="material_out_old" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_oldsearch_x_grp"
        <?php } ?>
        data-table="material_out_old"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_oldsearch", function() {
    var options = { name: "x_grp", selectId: "fmaterial_out_oldsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_oldsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fmaterial_out_oldsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fmaterial_out_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_old.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_oldsearch_x_s_grp"
        <?php } ?>
        data-table="material_out_old"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_oldsearch", function() {
    var options = { name: "x_s_grp", selectId: "fmaterial_out_oldsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_oldsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fmaterial_out_oldsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fmaterial_out_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_old.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_oldsearch_x_product"
        <?php } ?>
        data-table="material_out_old"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_oldsearch", function() {
    var options = { name: "x_product", selectId: "fmaterial_out_oldsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_oldsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fmaterial_out_oldsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fmaterial_out_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_old.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_rid" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="40" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="material_out_old" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fmaterial_out_oldsearch", function() {
    fmaterial_out_oldsearch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.material_out_old.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid_1->Visible) { // rid_1 ?>
    <div id="r_rid_1" class="row"<?= $Page->rid_1->rowAttributes() ?>>
        <label for="x_rid_1" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_rid_1"><?= $Page->rid_1->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid_1" id="z_rid_1" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid_1->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_rid_1" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid_1"
        name="x_rid_1"
        class="form-control ew-select<?= $Page->rid_1->isInvalidClass() ?>"
        data-select2-id="fmaterial_out_oldsearch_x_rid_1"
        data-table="material_out_old"
        data-field="x_rid_1"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid_1->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid_1->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_1->getPlaceHolder()) ?>"
        <?= $Page->rid_1->editAttributes() ?>>
        <?= $Page->rid_1->selectOptionListHtml("x_rid_1") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid_1->getErrorMessage(false) ?></div>
<?= $Page->rid_1->Lookup->getParamTag($Page, "p_x_rid_1") ?>
<script>
loadjs.ready("fmaterial_out_oldsearch", function() {
    var options = { name: "x_rid_1", selectId: "fmaterial_out_oldsearch_x_rid_1" };
    if (fmaterial_out_oldsearch.lists.rid_1?.lookupOptions.length) {
        options.data = { id: "x_rid_1", form: "fmaterial_out_oldsearch" };
    } else {
        options.ajax = { id: "x_rid_1", form: "fmaterial_out_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.material_out_old.fields.rid_1.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_packets"><?= $Page->packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packets" id="z_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="material_out_old" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_oldsearch_x_packing_type"
        <?php } ?>
        data-table="material_out_old"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_oldsearch", function() {
    var options = { name: "x_packing_type", selectId: "fmaterial_out_oldsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_oldsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fmaterial_out_oldsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fmaterial_out_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_old.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity_sub->Visible) { // quantity_sub ?>
    <div id="r_quantity_sub" class="row"<?= $Page->quantity_sub->rowAttributes() ?>>
        <label for="x_quantity_sub" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_quantity_sub"><?= $Page->quantity_sub->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity_sub" id="z_quantity_sub" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity_sub->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_quantity_sub" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity_sub->getInputTextType() ?>" name="x_quantity_sub" id="x_quantity_sub" data-table="material_out_old" data-field="x_quantity_sub" value="<?= $Page->quantity_sub->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity_sub->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity_sub->formatPattern()) ?>"<?= $Page->quantity_sub->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity_sub->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="material_out_old" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process" id="z_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_oldsearch_x_process"
        <?php } ?>
        data-table="material_out_old"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_oldsearch", function() {
    var options = { name: "x_process", selectId: "fmaterial_out_oldsearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_oldsearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fmaterial_out_oldsearch" };
    } else {
        options.ajax = { id: "x_process", form: "fmaterial_out_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_old.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="material_out_old" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="material_out_old" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cart_amount->Visible) { // cart_amount ?>
    <div id="r_cart_amount" class="row"<?= $Page->cart_amount->rowAttributes() ?>>
        <label for="x_cart_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_cart_amount"><?= $Page->cart_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cart_amount" id="z_cart_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cart_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_cart_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cart_amount->getInputTextType() ?>" name="x_cart_amount" id="x_cart_amount" data-table="material_out_old" data-field="x_cart_amount" value="<?= $Page->cart_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cart_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_amount->formatPattern()) ?>"<?= $Page->cart_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cart_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other_amount->Visible) { // other_amount ?>
    <div id="r_other_amount" class="row"<?= $Page->other_amount->rowAttributes() ?>>
        <label for="x_other_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_other_amount"><?= $Page->other_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_other_amount" id="z_other_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_other_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other_amount->getInputTextType() ?>" name="x_other_amount" id="x_other_amount" data-table="material_out_old" data-field="x_other_amount" value="<?= $Page->other_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->other_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_amount->formatPattern()) ?>"<?= $Page->other_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="material_out_old" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tax_amount->Visible) { // tax_amount ?>
    <div id="r_tax_amount" class="row"<?= $Page->tax_amount->rowAttributes() ?>>
        <label for="x_tax_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_tax_amount"><?= $Page->tax_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_tax_amount" id="z_tax_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tax_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_tax_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tax_amount->getInputTextType() ?>" name="x_tax_amount" id="x_tax_amount" data-table="material_out_old" data-field="x_tax_amount" value="<?= $Page->tax_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->tax_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tax_amount->formatPattern()) ?>"<?= $Page->tax_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tax_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->total_amount->Visible) { // total_amount ?>
    <div id="r_total_amount" class="row"<?= $Page->total_amount->rowAttributes() ?>>
        <label for="x_total_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_total_amount"><?= $Page->total_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_total_amount" id="z_total_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->total_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_total_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->total_amount->getInputTextType() ?>" name="x_total_amount" id="x_total_amount" data-table="material_out_old" data-field="x_total_amount" value="<?= $Page->total_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->total_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->total_amount->formatPattern()) ?>"<?= $Page->total_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->total_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tax_percent->Visible) { // tax_percent ?>
    <div id="r_tax_percent" class="row"<?= $Page->tax_percent->rowAttributes() ?>>
        <label for="x_tax_percent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_tax_percent"><?= $Page->tax_percent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_tax_percent" id="z_tax_percent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tax_percent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_tax_percent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tax_percent->getInputTextType() ?>" name="x_tax_percent" id="x_tax_percent" data-table="material_out_old" data-field="x_tax_percent" value="<?= $Page->tax_percent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->tax_percent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tax_percent->formatPattern()) ?>"<?= $Page->tax_percent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tax_percent->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->hsn_code->Visible) { // hsn_code ?>
    <div id="r_hsn_code" class="row"<?= $Page->hsn_code->rowAttributes() ?>>
        <label for="x_hsn_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_hsn_code"><?= $Page->hsn_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_hsn_code" id="z_hsn_code" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->hsn_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_hsn_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->hsn_code->getInputTextType() ?>" name="x_hsn_code" id="x_hsn_code" data-table="material_out_old" data-field="x_hsn_code" value="<?= $Page->hsn_code->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->hsn_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->hsn_code->formatPattern()) ?>"<?= $Page->hsn_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->hsn_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_oldsearch_x_operator"
        <?php } ?>
        data-table="material_out_old"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_oldsearch", function() {
    var options = { name: "x_operator", selectId: "fmaterial_out_oldsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_oldsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fmaterial_out_oldsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fmaterial_out_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_old.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="material_out_old" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_godown" class="ew-search-field ew-search-field-single">
<template id="tp_x_godown">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="material_out_old" data-field="x_godown" name="x_godown" id="x_godown"<?= $Page->godown->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_godown" class="ew-item-list"></div>
<selection-list hidden
    id="x_godown"
    name="x_godown"
    value="<?= HtmlEncode($Page->godown->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_godown"
    data-target="dsl_x_godown"
    data-repeatcolumn="5"
    class="form-control<?= $Page->godown->isInvalidClass() ?>"
    data-table="material_out_old"
    data-field="x_godown"
    data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
    data-ew-action="update-options"
    <?= $Page->godown->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown_po->Visible) { // godown_po ?>
    <div id="r_godown_po" class="row"<?= $Page->godown_po->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_godown_po"><?= $Page->godown_po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown_po" id="z_godown_po" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown_po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_godown_po" class="ew-search-field ew-search-field-single">
<template id="tp_x_godown_po">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="material_out_old" data-field="x_godown_po" name="x_godown_po" id="x_godown_po"<?= $Page->godown_po->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_godown_po" class="ew-item-list"></div>
<selection-list hidden
    id="x_godown_po"
    name="x_godown_po"
    value="<?= HtmlEncode($Page->godown_po->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_godown_po"
    data-target="dsl_x_godown_po"
    data-repeatcolumn="3"
    class="form-control<?= $Page->godown_po->isInvalidClass() ?>"
    data-table="material_out_old"
    data-field="x_godown_po"
    data-value-separator="<?= $Page->godown_po->displayValueSeparatorAttribute() ?>"
    <?= $Page->godown_po->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->godown_po->getErrorMessage(false) ?></div>
<?= $Page->godown_po->Lookup->getParamTag($Page, "p_x_godown_po") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
    <div id="r_issue_to" class="row"<?= $Page->issue_to->rowAttributes() ?>>
        <label for="x_issue_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_issue_to"><?= $Page->issue_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_to" id="z_issue_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_issue_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_issue_to"
        name="x_issue_to"
        class="form-select ew-select<?= $Page->issue_to->isInvalidClass() ?>"
        <?php if (!$Page->issue_to->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_oldsearch_x_issue_to"
        <?php } ?>
        data-table="material_out_old"
        data-field="x_issue_to"
        data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>"
        <?= $Page->issue_to->editAttributes() ?>>
        <?= $Page->issue_to->selectOptionListHtml("x_issue_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage(false) ?></div>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
<?php if (!$Page->issue_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_oldsearch", function() {
    var options = { name: "x_issue_to", selectId: "fmaterial_out_oldsearch_x_issue_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_oldsearch.lists.issue_to?.lookupOptions.length) {
        options.data = { id: "x_issue_to", form: "fmaterial_out_oldsearch" };
    } else {
        options.ajax = { id: "x_issue_to", form: "fmaterial_out_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_old.fields.issue_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_to_unit->Visible) { // issue_to_unit ?>
    <div id="r_issue_to_unit" class="row"<?= $Page->issue_to_unit->rowAttributes() ?>>
        <label for="x_issue_to_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_issue_to_unit"><?= $Page->issue_to_unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_to_unit" id="z_issue_to_unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_to_unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_issue_to_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_issue_to_unit"
        name="x_issue_to_unit"
        class="form-select ew-select<?= $Page->issue_to_unit->isInvalidClass() ?>"
        <?php if (!$Page->issue_to_unit->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_oldsearch_x_issue_to_unit"
        <?php } ?>
        data-table="material_out_old"
        data-field="x_issue_to_unit"
        data-value-separator="<?= $Page->issue_to_unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to_unit->getPlaceHolder()) ?>"
        <?= $Page->issue_to_unit->editAttributes() ?>>
        <?= $Page->issue_to_unit->selectOptionListHtml("x_issue_to_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_to_unit->getErrorMessage(false) ?></div>
<?= $Page->issue_to_unit->Lookup->getParamTag($Page, "p_x_issue_to_unit") ?>
<?php if (!$Page->issue_to_unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_oldsearch", function() {
    var options = { name: "x_issue_to_unit", selectId: "fmaterial_out_oldsearch_x_issue_to_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_oldsearch.lists.issue_to_unit?.lookupOptions.length) {
        options.data = { id: "x_issue_to_unit", form: "fmaterial_out_oldsearch" };
    } else {
        options.ajax = { id: "x_issue_to_unit", form: "fmaterial_out_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_old.fields.issue_to_unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_dated"><?= $Page->dated->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_dated" id="z_dated" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->dated->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->dated->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_material_out_old_dated" class="ew-search-field">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="material_out_old" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_out_oldsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_out_oldsearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_material_out_old_dated" class="ew-search-field2 d-none">
<input type="<?= $Page->dated->getInputTextType() ?>" name="y_dated" id="y_dated" data-table="material_out_old" data-field="x_dated" value="<?= $Page->dated->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_out_oldsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_out_oldsearch", "y_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="material_out_old" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_oldsearch_x_status"
        <?php } ?>
        data-table="material_out_old"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_oldsearch", function() {
    var options = { name: "x_status", selectId: "fmaterial_out_oldsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_oldsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fmaterial_out_oldsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fmaterial_out_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_old.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads" class="row"<?= $Page->uploads->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_uploads"><?= $Page->uploads->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_uploads" id="z_uploads" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->uploads->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_uploads" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->uploads->getInputTextType() ?>" name="x_uploads" id="x_uploads" data-table="material_out_old" data-field="x_uploads" value="<?= $Page->uploads->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->uploads->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uploads->formatPattern()) ?>"<?= $Page->uploads->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uploads->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cart_ref->Visible) { // cart_ref ?>
    <div id="r_cart_ref" class="row"<?= $Page->cart_ref->rowAttributes() ?>>
        <label for="x_cart_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_material_out_old_cart_ref"><?= $Page->cart_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cart_ref" id="z_cart_ref" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cart_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_material_out_old_cart_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cart_ref->getInputTextType() ?>" name="x_cart_ref" id="x_cart_ref" data-table="material_out_old" data-field="x_cart_ref" value="<?= $Page->cart_ref->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cart_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_ref->formatPattern()) ?>"<?= $Page->cart_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cart_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmaterial_out_oldsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmaterial_out_oldsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmaterial_out_oldsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_out_old");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
