<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialOutBcAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_out_bc: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fmaterial_out_bcadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmaterial_out_bcadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["process", [fields.process.visible && fields.process.required ? ew.Validators.required(fields.process.caption) : null], fields.process.isInvalid],
            ["issue_to", [fields.issue_to.visible && fields.issue_to.required ? ew.Validators.required(fields.issue_to.caption) : null], fields.issue_to.isInvalid],
            ["godown", [fields.godown.visible && fields.godown.required ? ew.Validators.required(fields.godown.caption) : null], fields.godown.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null, ew.Validators.integer], fields._barcode.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "process": <?= $Page->process->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmaterial_out_bcadd" id="fmaterial_out_bcadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_out_bc">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process"<?= $Page->process->rowAttributes() ?>>
        <label id="elh_material_out_bc_process" for="x_process" class="<?= $Page->LeftColumnClass ?>"><?= $Page->process->caption() ?><?= $Page->process->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->process->cellAttributes() ?>>
<span id="el_material_out_bc_process">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fmaterial_out_bcadd_x_process"
        <?php } ?>
        data-table="material_out_bc"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <?= $Page->process->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage() ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_out_bcadd", function() {
    var options = { name: "x_process", selectId: "fmaterial_out_bcadd_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_out_bcadd.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fmaterial_out_bcadd" };
    } else {
        options.ajax = { id: "x_process", form: "fmaterial_out_bcadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out_bc.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
    <div id="r_issue_to"<?= $Page->issue_to->rowAttributes() ?>>
        <label id="elh_material_out_bc_issue_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_to->caption() ?><?= $Page->issue_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_to->cellAttributes() ?>>
<span id="el_material_out_bc_issue_to">
<?php
if (IsRTL()) {
    $Page->issue_to->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_issue_to" class="ew-auto-suggest">
    <div class="input-group">
        <input type="<?= $Page->issue_to->getInputTextType() ?>" class="form-control" name="sv_x_issue_to" id="sv_x_issue_to" value="<?= RemoveHtml($Page->issue_to->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_to->formatPattern()) ?>"<?= $Page->issue_to->editAttributes() ?> aria-describedby="x_issue_to_help">
        <?php if (AllowAdd(CurrentProjectID() . "buyer") && !$Page->issue_to->ReadOnly) { ?>
        <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_issue_to" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->issue_to->caption() ?>" data-title="<?= $Page->issue_to->caption() ?>" data-ew-action="add-option" data-el="x_issue_to" data-url="<?= GetUrl("buyeraddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
        <?php } ?>
    </div>
</span>
<selection-list hidden class="form-control" data-table="material_out_bc" data-field="x_issue_to" data-input="sv_x_issue_to" data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>" name="x_issue_to" id="x_issue_to" value="<?= HtmlEncode($Page->issue_to->CurrentValue) ?>"></selection-list>
<?= $Page->issue_to->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage() ?></div>
<script>
loadjs.ready("fmaterial_out_bcadd", function() {
    fmaterial_out_bcadd.createAutoSuggest(Object.assign({"id":"x_issue_to","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->issue_to->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.material_out_bc.fields.issue_to.autoSuggestOptions));
});
</script>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown"<?= $Page->godown->rowAttributes() ?>>
        <label id="elh_material_out_bc_godown" class="<?= $Page->LeftColumnClass ?>"><?= $Page->godown->caption() ?><?= $Page->godown->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->godown->cellAttributes() ?>>
<span id="el_material_out_bc_godown">
<template id="tp_x_godown">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="material_out_bc" data-field="x_godown" name="x_godown" id="x_godown"<?= $Page->godown->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_godown" class="ew-item-list"></div>
<selection-list hidden
    id="x_godown[]"
    name="x_godown[]"
    value="<?= HtmlEncode($Page->godown->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_godown"
    data-target="dsl_x_godown"
    data-repeatcolumn="5"
    class="form-control<?= $Page->godown->isInvalidClass() ?>"
    data-table="material_out_bc"
    data-field="x_godown"
    data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
    <?= $Page->godown->editAttributes() ?>></selection-list>
<?= $Page->godown->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->godown->getErrorMessage() ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_material_out_bc_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_material_out_bc_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="material_out_bc" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_out_bcadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_out_bcadd", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_material_out_bc_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_material_out_bc_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="material_out_bc" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode"<?= $Page->_barcode->rowAttributes() ?>>
        <label id="elh_material_out_bc__barcode" for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_barcode->caption() ?><?= $Page->_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_barcode->cellAttributes() ?>>
<span id="el_material_out_bc__barcode">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="material_out_bc" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?> aria-describedby="x__barcode_help">
<?= $Page->_barcode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmaterial_out_bcadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmaterial_out_bcadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_out_bc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
