<?php

namespace PHPMaker2024\fibre;

// Page object
$MaterialOutAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { material_out: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fmaterial_outadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmaterial_outadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["process", [fields.process.visible && fields.process.required ? ew.Validators.required(fields.process.caption) : null], fields.process.isInvalid],
            ["process_type", [fields.process_type.visible && fields.process_type.required ? ew.Validators.required(fields.process_type.caption) : null], fields.process_type.isInvalid],
            ["issue_to_unit", [fields.issue_to_unit.visible && fields.issue_to_unit.required ? ew.Validators.required(fields.issue_to_unit.caption) : null], fields.issue_to_unit.isInvalid],
            ["issue_to", [fields.issue_to.visible && fields.issue_to.required ? ew.Validators.required(fields.issue_to.caption) : null], fields.issue_to.isInvalid],
            ["godown", [fields.godown.visible && fields.godown.required ? ew.Validators.required(fields.godown.caption) : null], fields.godown.isInvalid],
            ["godown_po", [fields.godown_po.visible && fields.godown_po.required ? ew.Validators.required(fields.godown_po.caption) : null], fields.godown_po.isInvalid],
            ["jc_no", [fields.jc_no.visible && fields.jc_no.required ? ew.Validators.required(fields.jc_no.caption) : null], fields.jc_no.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["rid_1", [fields.rid_1.visible && fields.rid_1.required ? ew.Validators.required(fields.rid_1.caption) : null], fields.rid_1.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["rid_2", [fields.rid_2.visible && fields.rid_2.required ? ew.Validators.required(fields.rid_2.caption) : null], fields.rid_2.isInvalid],
            ["rid_3", [fields.rid_3.visible && fields.rid_3.required ? ew.Validators.required(fields.rid_3.caption) : null], fields.rid_3.isInvalid],
            ["rid_po", [fields.rid_po.visible && fields.rid_po.required ? ew.Validators.required(fields.rid_po.caption) : null], fields.rid_po.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["lot_no", [fields.lot_no.visible && fields.lot_no.required ? ew.Validators.required(fields.lot_no.caption) : null], fields.lot_no.isInvalid],
            ["avg_quantity", [fields.avg_quantity.visible && fields.avg_quantity.required ? ew.Validators.required(fields.avg_quantity.caption) : null, ew.Validators.float], fields.avg_quantity.isInvalid],
            ["max_qty", [fields.max_qty.visible && fields.max_qty.required ? ew.Validators.required(fields.max_qty.caption) : null, ew.Validators.float], fields.max_qty.isInvalid],
            ["quantity_sub", [fields.quantity_sub.visible && fields.quantity_sub.required ? ew.Validators.required(fields.quantity_sub.caption) : null, ew.Validators.float], fields.quantity_sub.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["packets", [fields.packets.visible && fields.packets.required ? ew.Validators.required(fields.packets.caption) : null], fields.packets.isInvalid],
            ["price", [fields.price.visible && fields.price.required ? ew.Validators.required(fields.price.caption) : null, ew.Validators.float], fields.price.isInvalid],
            ["cart_amount", [fields.cart_amount.visible && fields.cart_amount.required ? ew.Validators.required(fields.cart_amount.caption) : null, ew.Validators.float], fields.cart_amount.isInvalid],
            ["other_amount", [fields.other_amount.visible && fields.other_amount.required ? ew.Validators.required(fields.other_amount.caption) : null, ew.Validators.float], fields.other_amount.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "process": <?= $Page->process->toClientList($Page) ?>,
            "process_type": <?= $Page->process_type->toClientList($Page) ?>,
            "issue_to_unit": <?= $Page->issue_to_unit->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "godown_po": <?= $Page->godown_po->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid_1": <?= $Page->rid_1->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "rid_2": <?= $Page->rid_2->toClientList($Page) ?>,
            "rid_3": <?= $Page->rid_3->toClientList($Page) ?>,
            "rid_po": <?= $Page->rid_po->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmaterial_outadd" id="fmaterial_outadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="material_out">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process"<?= $Page->process->rowAttributes() ?>>
        <label id="elh_material_out_process" for="x_process" class="<?= $Page->LeftColumnClass ?>"><?= $Page->process->caption() ?><?= $Page->process->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->process->cellAttributes() ?>>
<span id="el_material_out_process">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fmaterial_outadd_x_process"
        <?php } ?>
        data-table="material_out"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <?= $Page->process->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage() ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_outadd", function() {
    var options = { name: "x_process", selectId: "fmaterial_outadd_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_outadd.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fmaterial_outadd" };
    } else {
        options.ajax = { id: "x_process", form: "fmaterial_outadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->process_type->Visible) { // process_type ?>
    <div id="r_process_type"<?= $Page->process_type->rowAttributes() ?>>
        <label id="elh_material_out_process_type" for="x_process_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->process_type->caption() ?><?= $Page->process_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->process_type->cellAttributes() ?>>
<span id="el_material_out_process_type">
    <select
        id="x_process_type"
        name="x_process_type"
        class="form-select ew-select<?= $Page->process_type->isInvalidClass() ?>"
        <?php if (!$Page->process_type->IsNativeSelect) { ?>
        data-select2-id="fmaterial_outadd_x_process_type"
        <?php } ?>
        data-table="material_out"
        data-field="x_process_type"
        data-value-separator="<?= $Page->process_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->process_type->editAttributes() ?>>
        <?= $Page->process_type->selectOptionListHtml("x_process_type") ?>
    </select>
    <?= $Page->process_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->process_type->getErrorMessage() ?></div>
<?= $Page->process_type->Lookup->getParamTag($Page, "p_x_process_type") ?>
<?php if (!$Page->process_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_outadd", function() {
    var options = { name: "x_process_type", selectId: "fmaterial_outadd_x_process_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_outadd.lists.process_type?.lookupOptions.length) {
        options.data = { id: "x_process_type", form: "fmaterial_outadd" };
    } else {
        options.ajax = { id: "x_process_type", form: "fmaterial_outadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out.fields.process_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_to_unit->Visible) { // issue_to_unit ?>
    <div id="r_issue_to_unit"<?= $Page->issue_to_unit->rowAttributes() ?>>
        <label id="elh_material_out_issue_to_unit" for="x_issue_to_unit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_to_unit->caption() ?><?= $Page->issue_to_unit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_to_unit->cellAttributes() ?>>
<span id="el_material_out_issue_to_unit">
    <select
        id="x_issue_to_unit"
        name="x_issue_to_unit"
        class="form-select ew-select<?= $Page->issue_to_unit->isInvalidClass() ?>"
        <?php if (!$Page->issue_to_unit->IsNativeSelect) { ?>
        data-select2-id="fmaterial_outadd_x_issue_to_unit"
        <?php } ?>
        data-table="material_out"
        data-field="x_issue_to_unit"
        data-value-separator="<?= $Page->issue_to_unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to_unit->getPlaceHolder()) ?>"
        <?= $Page->issue_to_unit->editAttributes() ?>>
        <?= $Page->issue_to_unit->selectOptionListHtml("x_issue_to_unit") ?>
    </select>
    <?= $Page->issue_to_unit->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->issue_to_unit->getErrorMessage() ?></div>
<?= $Page->issue_to_unit->Lookup->getParamTag($Page, "p_x_issue_to_unit") ?>
<?php if (!$Page->issue_to_unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_outadd", function() {
    var options = { name: "x_issue_to_unit", selectId: "fmaterial_outadd_x_issue_to_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_outadd.lists.issue_to_unit?.lookupOptions.length) {
        options.data = { id: "x_issue_to_unit", form: "fmaterial_outadd" };
    } else {
        options.ajax = { id: "x_issue_to_unit", form: "fmaterial_outadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out.fields.issue_to_unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
    <div id="r_issue_to"<?= $Page->issue_to->rowAttributes() ?>>
        <label id="elh_material_out_issue_to" for="x_issue_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_to->caption() ?><?= $Page->issue_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_to->cellAttributes() ?>>
<span id="el_material_out_issue_to">
    <select
        id="x_issue_to"
        name="x_issue_to"
        class="form-select ew-select<?= $Page->issue_to->isInvalidClass() ?>"
        <?php if (!$Page->issue_to->IsNativeSelect) { ?>
        data-select2-id="fmaterial_outadd_x_issue_to"
        <?php } ?>
        data-table="material_out"
        data-field="x_issue_to"
        data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>"
        <?= $Page->issue_to->editAttributes() ?>>
        <?= $Page->issue_to->selectOptionListHtml("x_issue_to") ?>
    </select>
    <?= $Page->issue_to->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage() ?></div>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
<?php if (!$Page->issue_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_outadd", function() {
    var options = { name: "x_issue_to", selectId: "fmaterial_outadd_x_issue_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_outadd.lists.issue_to?.lookupOptions.length) {
        options.data = { id: "x_issue_to", form: "fmaterial_outadd" };
    } else {
        options.ajax = { id: "x_issue_to", form: "fmaterial_outadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out.fields.issue_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown"<?= $Page->godown->rowAttributes() ?>>
        <label id="elh_material_out_godown" class="<?= $Page->LeftColumnClass ?>"><?= $Page->godown->caption() ?><?= $Page->godown->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->godown->cellAttributes() ?>>
<span id="el_material_out_godown">
<template id="tp_x_godown">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="material_out" data-field="x_godown" name="x_godown" id="x_godown"<?= $Page->godown->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_godown" class="ew-item-list"></div>
<selection-list hidden
    id="x_godown"
    name="x_godown"
    value="<?= HtmlEncode($Page->godown->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_godown"
    data-target="dsl_x_godown"
    data-repeatcolumn="5"
    class="form-control<?= $Page->godown->isInvalidClass() ?>"
    data-table="material_out"
    data-field="x_godown"
    data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
    data-ew-action="update-options"
    <?= $Page->godown->editAttributes() ?>></selection-list>
<?= $Page->godown->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->godown->getErrorMessage() ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->godown_po->Visible) { // godown_po ?>
    <div id="r_godown_po"<?= $Page->godown_po->rowAttributes() ?>>
        <label id="elh_material_out_godown_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->godown_po->caption() ?><?= $Page->godown_po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->godown_po->cellAttributes() ?>>
<span id="el_material_out_godown_po">
<template id="tp_x_godown_po">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="material_out" data-field="x_godown_po" name="x_godown_po" id="x_godown_po"<?= $Page->godown_po->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_godown_po" class="ew-item-list"></div>
<selection-list hidden
    id="x_godown_po"
    name="x_godown_po"
    value="<?= HtmlEncode($Page->godown_po->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_godown_po"
    data-target="dsl_x_godown_po"
    data-repeatcolumn="3"
    class="form-control<?= $Page->godown_po->isInvalidClass() ?>"
    data-table="material_out"
    data-field="x_godown_po"
    data-value-separator="<?= $Page->godown_po->displayValueSeparatorAttribute() ?>"
    data-ew-action="update-options"
    <?= $Page->godown_po->editAttributes() ?>></selection-list>
<?= $Page->godown_po->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->godown_po->getErrorMessage() ?></div>
<?= $Page->godown_po->Lookup->getParamTag($Page, "p_x_godown_po") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no"<?= $Page->jc_no->rowAttributes() ?>>
        <label id="elh_material_out_jc_no" for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->jc_no->caption() ?><?= $Page->jc_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->jc_no->cellAttributes() ?>>
<span id="el_material_out_jc_no">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="material_out" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?> aria-describedby="x_jc_no_help">
<?= $Page->jc_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_material_out_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_material_out_grp">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_outadd_x_grp"
        <?php } ?>
        data-table="material_out"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_outadd", function() {
    var options = { name: "x_grp", selectId: "fmaterial_outadd_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_outadd.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fmaterial_outadd" };
    } else {
        options.ajax = { id: "x_grp", form: "fmaterial_outadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_material_out_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_material_out_s_grp">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fmaterial_outadd_x_s_grp"
        <?php } ?>
        data-table="material_out"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <?= $Page->s_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_outadd", function() {
    var options = { name: "x_s_grp", selectId: "fmaterial_outadd_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_outadd.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fmaterial_outadd" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fmaterial_outadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_material_out_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_material_out_product">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fmaterial_outadd_x_product"
        <?php } ?>
        data-table="material_out"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <?= $Page->product->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_outadd", function() {
    var options = { name: "x_product", selectId: "fmaterial_outadd_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_outadd.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fmaterial_outadd" };
    } else {
        options.ajax = { id: "x_product", form: "fmaterial_outadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid_1->Visible) { // rid_1 ?>
    <div id="r_rid_1"<?= $Page->rid_1->rowAttributes() ?>>
        <label id="elh_material_out_rid_1" for="x_rid_1" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid_1->caption() ?><?= $Page->rid_1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid_1->cellAttributes() ?>>
<span id="el_material_out_rid_1">
    <select
        id="x_rid_1"
        name="x_rid_1"
        class="form-control ew-select<?= $Page->rid_1->isInvalidClass() ?>"
        data-select2-id="fmaterial_outadd_x_rid_1"
        data-table="material_out"
        data-field="x_rid_1"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid_1->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid_1->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_1->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->rid_1->editAttributes() ?>>
        <?= $Page->rid_1->selectOptionListHtml("x_rid_1") ?>
    </select>
    <?= $Page->rid_1->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid_1->getErrorMessage() ?></div>
<?= $Page->rid_1->Lookup->getParamTag($Page, "p_x_rid_1") ?>
<script>
loadjs.ready("fmaterial_outadd", function() {
    var options = { name: "x_rid_1", selectId: "fmaterial_outadd_x_rid_1" };
    if (fmaterial_outadd.lists.rid_1?.lookupOptions.length) {
        options.data = { id: "x_rid_1", form: "fmaterial_outadd" };
    } else {
        options.ajax = { id: "x_rid_1", form: "fmaterial_outadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.material_out.fields.rid_1.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type"<?= $Page->packing_type->rowAttributes() ?>>
        <label id="elh_material_out_packing_type" for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing_type->caption() ?><?= $Page->packing_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing_type->cellAttributes() ?>>
<span id="el_material_out_packing_type">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fmaterial_outadd_x_packing_type"
        <?php } ?>
        data-table="material_out"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <?= $Page->packing_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage() ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_outadd", function() {
    var options = { name: "x_packing_type", selectId: "fmaterial_outadd_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_outadd.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fmaterial_outadd" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fmaterial_outadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid_2->Visible) { // rid_2 ?>
    <div id="r_rid_2"<?= $Page->rid_2->rowAttributes() ?>>
        <label id="elh_material_out_rid_2" for="x_rid_2" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid_2->caption() ?><?= $Page->rid_2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid_2->cellAttributes() ?>>
<span id="el_material_out_rid_2">
    <select
        id="x_rid_2"
        name="x_rid_2"
        class="form-control ew-select<?= $Page->rid_2->isInvalidClass() ?>"
        data-select2-id="fmaterial_outadd_x_rid_2"
        data-table="material_out"
        data-field="x_rid_2"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid_2->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid_2->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_2->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->rid_2->editAttributes() ?>>
        <?= $Page->rid_2->selectOptionListHtml("x_rid_2") ?>
    </select>
    <?= $Page->rid_2->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid_2->getErrorMessage() ?></div>
<?= $Page->rid_2->Lookup->getParamTag($Page, "p_x_rid_2") ?>
<script>
loadjs.ready("fmaterial_outadd", function() {
    var options = { name: "x_rid_2", selectId: "fmaterial_outadd_x_rid_2" };
    if (fmaterial_outadd.lists.rid_2?.lookupOptions.length) {
        options.data = { id: "x_rid_2", form: "fmaterial_outadd" };
    } else {
        options.ajax = { id: "x_rid_2", form: "fmaterial_outadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.material_out.fields.rid_2.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid_3->Visible) { // rid_3 ?>
    <div id="r_rid_3"<?= $Page->rid_3->rowAttributes() ?>>
        <label id="elh_material_out_rid_3" for="x_rid_3" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid_3->caption() ?><?= $Page->rid_3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid_3->cellAttributes() ?>>
<span id="el_material_out_rid_3">
    <select
        id="x_rid_3"
        name="x_rid_3"
        class="form-control ew-select<?= $Page->rid_3->isInvalidClass() ?>"
        data-select2-id="fmaterial_outadd_x_rid_3"
        data-table="material_out"
        data-field="x_rid_3"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid_3->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid_3->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_3->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->rid_3->editAttributes() ?>>
        <?= $Page->rid_3->selectOptionListHtml("x_rid_3") ?>
    </select>
    <?= $Page->rid_3->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid_3->getErrorMessage() ?></div>
<?= $Page->rid_3->Lookup->getParamTag($Page, "p_x_rid_3") ?>
<script>
loadjs.ready("fmaterial_outadd", function() {
    var options = { name: "x_rid_3", selectId: "fmaterial_outadd_x_rid_3" };
    if (fmaterial_outadd.lists.rid_3?.lookupOptions.length) {
        options.data = { id: "x_rid_3", form: "fmaterial_outadd" };
    } else {
        options.ajax = { id: "x_rid_3", form: "fmaterial_outadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.material_out.fields.rid_3.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid_po->Visible) { // rid_po ?>
    <div id="r_rid_po"<?= $Page->rid_po->rowAttributes() ?>>
        <label id="elh_material_out_rid_po" for="x_rid_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid_po->caption() ?><?= $Page->rid_po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid_po->cellAttributes() ?>>
<span id="el_material_out_rid_po">
    <select
        id="x_rid_po"
        name="x_rid_po"
        class="form-select ew-select<?= $Page->rid_po->isInvalidClass() ?>"
        <?php if (!$Page->rid_po->IsNativeSelect) { ?>
        data-select2-id="fmaterial_outadd_x_rid_po"
        <?php } ?>
        data-table="material_out"
        data-field="x_rid_po"
        data-value-separator="<?= $Page->rid_po->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_po->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->rid_po->editAttributes() ?>>
        <?= $Page->rid_po->selectOptionListHtml("x_rid_po") ?>
    </select>
    <?= $Page->rid_po->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid_po->getErrorMessage() ?></div>
<?= $Page->rid_po->Lookup->getParamTag($Page, "p_x_rid_po") ?>
<?php if (!$Page->rid_po->IsNativeSelect) { ?>
<script>
loadjs.ready("fmaterial_outadd", function() {
    var options = { name: "x_rid_po", selectId: "fmaterial_outadd_x_rid_po" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmaterial_outadd.lists.rid_po?.lookupOptions.length) {
        options.data = { id: "x_rid_po", form: "fmaterial_outadd" };
    } else {
        options.ajax = { id: "x_rid_po", form: "fmaterial_outadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.material_out.fields.rid_po.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_material_out_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_material_out_rid">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="40" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?> aria-describedby="x_rid_help">
</span>
<selection-list hidden class="form-control" data-table="material_out" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->CurrentValue) ?>"></selection-list>
<?= $Page->rid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<script>
loadjs.ready("fmaterial_outadd", function() {
    fmaterial_outadd.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.material_out.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no"<?= $Page->lot_no->rowAttributes() ?>>
        <label id="elh_material_out_lot_no" for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lot_no->caption() ?><?= $Page->lot_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lot_no->cellAttributes() ?>>
<span id="el_material_out_lot_no">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="material_out" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?> aria-describedby="x_lot_no_help">
<?= $Page->lot_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->avg_quantity->Visible) { // avg_quantity ?>
    <div id="r_avg_quantity"<?= $Page->avg_quantity->rowAttributes() ?>>
        <label id="elh_material_out_avg_quantity" for="x_avg_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->avg_quantity->caption() ?><?= $Page->avg_quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->avg_quantity->cellAttributes() ?>>
<span id="el_material_out_avg_quantity">
<input type="<?= $Page->avg_quantity->getInputTextType() ?>" name="x_avg_quantity" id="x_avg_quantity" data-table="material_out" data-field="x_avg_quantity" value="<?= $Page->avg_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->avg_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->avg_quantity->formatPattern()) ?>"<?= $Page->avg_quantity->editAttributes() ?> aria-describedby="x_avg_quantity_help">
<?= $Page->avg_quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->avg_quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->max_qty->Visible) { // max_qty ?>
    <div id="r_max_qty"<?= $Page->max_qty->rowAttributes() ?>>
        <label id="elh_material_out_max_qty" for="x_max_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->max_qty->caption() ?><?= $Page->max_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->max_qty->cellAttributes() ?>>
<span id="el_material_out_max_qty">
<input type="<?= $Page->max_qty->getInputTextType() ?>" name="x_max_qty" id="x_max_qty" data-table="material_out" data-field="x_max_qty" value="<?= $Page->max_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->max_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->max_qty->formatPattern()) ?>"<?= $Page->max_qty->editAttributes() ?> aria-describedby="x_max_qty_help">
<?= $Page->max_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->max_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity_sub->Visible) { // quantity_sub ?>
    <div id="r_quantity_sub"<?= $Page->quantity_sub->rowAttributes() ?>>
        <label id="elh_material_out_quantity_sub" for="x_quantity_sub" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity_sub->caption() ?><?= $Page->quantity_sub->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity_sub->cellAttributes() ?>>
<span id="el_material_out_quantity_sub">
<input type="<?= $Page->quantity_sub->getInputTextType() ?>" name="x_quantity_sub" id="x_quantity_sub" data-table="material_out" data-field="x_quantity_sub" value="<?= $Page->quantity_sub->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity_sub->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity_sub->formatPattern()) ?>"<?= $Page->quantity_sub->editAttributes() ?> aria-describedby="x_quantity_sub_help">
<?= $Page->quantity_sub->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity_sub->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_material_out_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_material_out_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="material_out" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets"<?= $Page->packets->rowAttributes() ?>>
        <label id="elh_material_out_packets" for="x_packets" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packets->caption() ?><?= $Page->packets->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packets->cellAttributes() ?>>
<span id="el_material_out_packets">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="material_out" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?> aria-describedby="x_packets_help">
<?= $Page->packets->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price"<?= $Page->price->rowAttributes() ?>>
        <label id="elh_material_out_price" for="x_price" class="<?= $Page->LeftColumnClass ?>"><?= $Page->price->caption() ?><?= $Page->price->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->price->cellAttributes() ?>>
<span id="el_material_out_price">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="material_out" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?> aria-describedby="x_price_help">
<?= $Page->price->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cart_amount->Visible) { // cart_amount ?>
    <div id="r_cart_amount"<?= $Page->cart_amount->rowAttributes() ?>>
        <label id="elh_material_out_cart_amount" for="x_cart_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cart_amount->caption() ?><?= $Page->cart_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cart_amount->cellAttributes() ?>>
<span id="el_material_out_cart_amount">
<input type="<?= $Page->cart_amount->getInputTextType() ?>" name="x_cart_amount" id="x_cart_amount" data-table="material_out" data-field="x_cart_amount" value="<?= $Page->cart_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cart_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_amount->formatPattern()) ?>"<?= $Page->cart_amount->editAttributes() ?> aria-describedby="x_cart_amount_help">
<?= $Page->cart_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cart_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other_amount->Visible) { // other_amount ?>
    <div id="r_other_amount"<?= $Page->other_amount->rowAttributes() ?>>
        <label id="elh_material_out_other_amount" for="x_other_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other_amount->caption() ?><?= $Page->other_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other_amount->cellAttributes() ?>>
<span id="el_material_out_other_amount">
<input type="<?= $Page->other_amount->getInputTextType() ?>" name="x_other_amount" id="x_other_amount" data-table="material_out" data-field="x_other_amount" value="<?= $Page->other_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->other_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_amount->formatPattern()) ?>"<?= $Page->other_amount->editAttributes() ?> aria-describedby="x_other_amount_help">
<?= $Page->other_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_material_out_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_material_out_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="material_out" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmaterial_outadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmaterial_outadd", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_material_out_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_material_out_remarks">
<textarea data-table="material_out" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_material_out_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_material_out_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="material_out"
        data-field="x_uploads"
        data-size="250"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmaterial_outadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmaterial_outadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("material_out");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    $("#r_godown_po").hide();
    $("#r_rid_po").hide();
    $("#r_rid_2").hide();
    	     var process= $('#x_process').val();
    	     if (process == 101)
    	     {
    	     $("#r_process_type").hide();
    	     $("#r_issue_to").show();
    	     $("#r_jc_no").show();
    	     $("#r_tmp_lot").hide();
    	     $("#r_price").show();
    	     $("#r_other_amount").show();
    	     $("#r_cart_amount").show();	     
    	     $("#r_rid_1").show();
    	     $("#r_rid_3").show();	     	     
    	     $("#r_rid_2").hide();
       	     $("#r_issue_to_loom").hide();	     
    	     $("#x_issue_to_loom").val('');
    	     }
    	     else if (process == 102)
    	     {
    	     $("#r_jc_no").hide();
    	     $("#r_process_type").hide();
    	     $("#r_issue_to").show();	     
    	     $("#x_issue_to").val('');
    	     $("#r_tmp_lot").hide();
       	     $("#r_price").show();
    	     $("#r_other_amount").hide();
    	     $("#r_cart_amount").show();
    	     $("#r_rid_1").show();
    	     $("#r_rid_3").show();	     	     
    	     $("#r_rid_2").hide();	     
       	     $("#r_issue_to_loom").hide();	     
    	     $("#x_issue_to_loom").val('');
    	     }
    	     else if (process == 103)
    	     {
    	     $("#r_process_type").show();
    	     $("#r_jc_no").show();
    	     $("#r_issue_to").show();	     
    	     $("#x_issue_to").val('');
    	     $("#r_tmp_lot").hide();
    	     $("#r_price").hide();
    	     $("#r_other_amount").hide();
    	     $("#r_cart_amount").hide();
    	     $("#r_rid_1").show();		 		 
    	     $("#r_rid_3").show();
    	     $("#r_rid_2").hide();	     
       	     $("#r_issue_to_loom").hide();	     
    	     $("#x_issue_to_loom").val('');
    	     }
    	     else if (process == 104)
    	     {
    	     $("#r_process_type").hide();
    	     $("#r_jc_no").show();
    	     $("#r_issue_to").hide();	     
    	     $("#r_tmp_lot").hide();
    	     $("#r_price").hide();
    	     $("#r_other_amount").hide();
    	     $("#r_cart_amount").hide();
    	     $("#r_rid_1").show();
    	     $("#r_rid_3").show();	     
    	     $("#r_rid_2").hide();	     
       	     $("#r_issue_to_loom").hide();	     
    	     $("#x_issue_to_loom").val('');
    	     }
    		 else if (process == 105)
    	     {
    	     $("#r_process_type").show();
    	     $("#r_jc_no").show();
    	     $("#r_issue_to").hide();
    	     $("#x_issue_to").val('');
    	     $("#r_issue_to_loom").show();	     
    	     $("#x_issue_to_loom").val('');
    	     $("#r_tmp_lot").hide();
    	     $("#r_price").hide();
    	     $("#r_other_amount").hide();
    	     $("#r_cart_amount").hide();
    	     $("#r_rid_1").show();		 		 
    	     $("#r_rid_3").show();
    	     $("#r_rid_2").hide();
    	     }
    	     else if (process == 109)
    	     {
    	     $("#r_process_type").hide();
    	     $("#r_jc_no").show();
    	     $("#r_issue_to").hide();	     
    	     $("#r_tmp_lot").hide();
    	     $("#r_price").hide();
    	     $("#r_other_amount").hide();
    	     $("#r_cart_amount").hide();
    	     $("#r_rid_1").hide();
    	     $("#r_rid_3").hide();
    	     $("#r_rid_2").show();
       	     $("#r_issue_to_loom").hide();	     
    	     $("#x_issue_to_loom").val('');
    	     }
});
</script>
