<?php

namespace PHPMaker2024\fibre;

// Page object
$MarginListMonthlySearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { margin_list_monthly: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmargin_list_monthlysearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmargin_list_monthlysearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [ew.Validators.integer], fields.rid.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["margin_monthly", [ew.Validators.float], fields.margin_monthly.isInvalid],
            ["margin_", [ew.Validators.float], fields.margin_.isInvalid],
            ["packets_p", [ew.Validators.float], fields.packets_p.isInvalid],
            ["quantity_p", [ew.Validators.float], fields.quantity_p.isInvalid],
            ["_p", [ew.Validators.float], fields._p.isInvalid],
            ["amount_p", [ew.Validators.float], fields.amount_p.isInvalid],
            ["packets_s", [ew.Validators.float], fields.packets_s.isInvalid],
            ["quantity_s", [ew.Validators.float], fields.quantity_s.isInvalid],
            ["_s", [ew.Validators.float], fields._s.isInvalid],
            ["amount_s", [ew.Validators.float], fields.amount_s.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["ref", [], fields.ref.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmargin_list_monthlysearch" id="fmargin_list_monthlysearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="margin_list_monthly">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fmargin_list_monthlysearch_x_grp"
        <?php } ?>
        data-table="margin_list_monthly"
        data-field="x_grp"
        data-page="0"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmargin_list_monthlysearch", function() {
    var options = { name: "x_grp", selectId: "fmargin_list_monthlysearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmargin_list_monthlysearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fmargin_list_monthlysearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fmargin_list_monthlysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.margin_list_monthly.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fmargin_list_monthlysearch_x_s_grp"
        <?php } ?>
        data-table="margin_list_monthly"
        data-field="x_s_grp"
        data-page="0"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmargin_list_monthlysearch", function() {
    var options = { name: "x_s_grp", selectId: "fmargin_list_monthlysearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmargin_list_monthlysearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fmargin_list_monthlysearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fmargin_list_monthlysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.margin_list_monthly.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fmargin_list_monthlysearch_x_product"
        <?php } ?>
        data-table="margin_list_monthly"
        data-field="x_product"
        data-page="0"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmargin_list_monthlysearch", function() {
    var options = { name: "x_product", selectId: "fmargin_list_monthlysearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmargin_list_monthlysearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fmargin_list_monthlysearch" };
    } else {
        options.ajax = { id: "x_product", form: "fmargin_list_monthlysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.margin_list_monthly.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_MarginListMonthlySearch"><!-- multi-page accordion -->
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_margin_list_monthly1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_margin_list_monthly1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_rid" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="margin_list_monthly" data-field="x_rid" data-input="sv_x_rid" data-page="1" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fmargin_list_monthlysearch", function() {
    fmargin_list_monthlysearch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.margin_list_monthly.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="margin_list_monthly" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" data-page="1" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->margin_monthly->Visible) { // margin_monthly ?>
    <div id="r_margin_monthly" class="row"<?= $Page->margin_monthly->rowAttributes() ?>>
        <label for="x_margin_monthly" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_margin_monthly"><?= $Page->margin_monthly->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_margin_monthly" id="z_margin_monthly" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->margin_monthly->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_margin_monthly" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->margin_monthly->getInputTextType() ?>" name="x_margin_monthly" id="x_margin_monthly" data-table="margin_list_monthly" data-field="x_margin_monthly" value="<?= $Page->margin_monthly->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->margin_monthly->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->margin_monthly->formatPattern()) ?>"<?= $Page->margin_monthly->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->margin_monthly->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->margin_->Visible) { // margin_% ?>
    <div id="r_margin_" class="row"<?= $Page->margin_->rowAttributes() ?>>
        <label for="x_margin_" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_margin_"><?= $Page->margin_->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_margin_" id="z_margin_" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->margin_->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_margin_" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->margin_->getInputTextType() ?>" name="x_margin_" id="x_margin_" data-table="margin_list_monthly" data-field="x_margin_" value="<?= $Page->margin_->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->margin_->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->margin_->formatPattern()) ?>"<?= $Page->margin_->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->margin_->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets_p->Visible) { // packets_p ?>
    <div id="r_packets_p" class="row"<?= $Page->packets_p->rowAttributes() ?>>
        <label for="x_packets_p" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_packets_p"><?= $Page->packets_p->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packets_p" id="z_packets_p" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets_p->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_packets_p" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets_p->getInputTextType() ?>" name="x_packets_p" id="x_packets_p" data-table="margin_list_monthly" data-field="x_packets_p" value="<?= $Page->packets_p->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->packets_p->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets_p->formatPattern()) ?>"<?= $Page->packets_p->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets_p->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity_p->Visible) { // quantity_p ?>
    <div id="r_quantity_p" class="row"<?= $Page->quantity_p->rowAttributes() ?>>
        <label for="x_quantity_p" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_quantity_p"><?= $Page->quantity_p->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity_p" id="z_quantity_p" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity_p->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_quantity_p" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity_p->getInputTextType() ?>" name="x_quantity_p" id="x_quantity_p" data-table="margin_list_monthly" data-field="x_quantity_p" value="<?= $Page->quantity_p->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->quantity_p->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity_p->formatPattern()) ?>"<?= $Page->quantity_p->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity_p->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_p->Visible) { // @_p ?>
    <div id="r__p" class="row"<?= $Page->_p->rowAttributes() ?>>
        <label for="x__p" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly__p"><?= $Page->_p->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__p" id="z__p" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_p->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly__p" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_p->getInputTextType() ?>" name="x__p" id="x__p" data-table="margin_list_monthly" data-field="x__p" value="<?= $Page->_p->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->_p->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_p->formatPattern()) ?>"<?= $Page->_p->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_p->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount_p->Visible) { // amount_p ?>
    <div id="r_amount_p" class="row"<?= $Page->amount_p->rowAttributes() ?>>
        <label for="x_amount_p" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_amount_p"><?= $Page->amount_p->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount_p" id="z_amount_p" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount_p->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_amount_p" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount_p->getInputTextType() ?>" name="x_amount_p" id="x_amount_p" data-table="margin_list_monthly" data-field="x_amount_p" value="<?= $Page->amount_p->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->amount_p->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount_p->formatPattern()) ?>"<?= $Page->amount_p->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount_p->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets_s->Visible) { // packets_s ?>
    <div id="r_packets_s" class="row"<?= $Page->packets_s->rowAttributes() ?>>
        <label for="x_packets_s" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_packets_s"><?= $Page->packets_s->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packets_s" id="z_packets_s" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets_s->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_packets_s" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets_s->getInputTextType() ?>" name="x_packets_s" id="x_packets_s" data-table="margin_list_monthly" data-field="x_packets_s" value="<?= $Page->packets_s->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->packets_s->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets_s->formatPattern()) ?>"<?= $Page->packets_s->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets_s->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity_s->Visible) { // quantity_s ?>
    <div id="r_quantity_s" class="row"<?= $Page->quantity_s->rowAttributes() ?>>
        <label for="x_quantity_s" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_quantity_s"><?= $Page->quantity_s->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity_s" id="z_quantity_s" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity_s->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_quantity_s" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity_s->getInputTextType() ?>" name="x_quantity_s" id="x_quantity_s" data-table="margin_list_monthly" data-field="x_quantity_s" value="<?= $Page->quantity_s->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->quantity_s->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity_s->formatPattern()) ?>"<?= $Page->quantity_s->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity_s->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_s->Visible) { // @_s ?>
    <div id="r__s" class="row"<?= $Page->_s->rowAttributes() ?>>
        <label for="x__s" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly__s"><?= $Page->_s->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__s" id="z__s" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_s->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly__s" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_s->getInputTextType() ?>" name="x__s" id="x__s" data-table="margin_list_monthly" data-field="x__s" value="<?= $Page->_s->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->_s->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_s->formatPattern()) ?>"<?= $Page->_s->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_s->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount_s->Visible) { // amount_s ?>
    <div id="r_amount_s" class="row"<?= $Page->amount_s->rowAttributes() ?>>
        <label for="x_amount_s" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_amount_s"><?= $Page->amount_s->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount_s" id="z_amount_s" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount_s->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_amount_s" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount_s->getInputTextType() ?>" name="x_amount_s" id="x_amount_s" data-table="margin_list_monthly" data-field="x_amount_s" value="<?= $Page->amount_s->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->amount_s->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount_s->formatPattern()) ?>"<?= $Page->amount_s->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount_s->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label for="x_godown" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fmargin_list_monthlysearch_x_godown"
        <?php } ?>
        data-table="margin_list_monthly"
        data-field="x_godown"
        data-page="1"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fmargin_list_monthlysearch", function() {
    var options = { name: "x_godown", selectId: "fmargin_list_monthlysearch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmargin_list_monthlysearch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fmargin_list_monthlysearch" };
    } else {
        options.ajax = { id: "x_godown", form: "fmargin_list_monthlysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.margin_list_monthly.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label for="x_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_margin_list_monthly_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ref" id="z_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_margin_list_monthly_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="margin_list_monthly" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" data-page="1" size="30" maxlength="68" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmargin_list_monthlysearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmargin_list_monthlysearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmargin_list_monthlysearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("margin_list_monthly");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
