<?php

namespace PHPMaker2024\fibre;

// Page object
$MarginListMonthlyList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { margin_list_monthly: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fmargin_list_monthlysrch" id="fmargin_list_monthlysrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fmargin_list_monthlysrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { margin_list_monthly: currentTable } });
var currentForm;
var fmargin_list_monthlysrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmargin_list_monthlysrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->grp->Visible) { // grp ?>
<?php
if (!$Page->grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->grp->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_grp" class="ew-search-caption ew-label"><?= $Page->grp->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</div>
        </div>
        <div id="el_margin_list_monthly_grp" class="ew-search-field">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fmargin_list_monthlysrch_x_grp"
        <?php } ?>
        data-table="margin_list_monthly"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmargin_list_monthlysrch", function() {
    var options = { name: "x_grp", selectId: "fmargin_list_monthlysrch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmargin_list_monthlysrch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fmargin_list_monthlysrch" };
    } else {
        options.ajax = { id: "x_grp", form: "fmargin_list_monthlysrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.margin_list_monthly.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
<?php
if (!$Page->s_grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_s_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->s_grp->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_s_grp" class="ew-search-caption ew-label"><?= $Page->s_grp->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</div>
        </div>
        <div id="el_margin_list_monthly_s_grp" class="ew-search-field">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fmargin_list_monthlysrch_x_s_grp"
        <?php } ?>
        data-table="margin_list_monthly"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fmargin_list_monthlysrch", function() {
    var options = { name: "x_s_grp", selectId: "fmargin_list_monthlysrch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmargin_list_monthlysrch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fmargin_list_monthlysrch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fmargin_list_monthlysrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.margin_list_monthly.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
<?php
if (!$Page->product->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_product" class="ew-search-caption ew-label"><?= $Page->product->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</div>
        </div>
        <div id="el_margin_list_monthly_product" class="ew-search-field">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fmargin_list_monthlysrch_x_product"
        <?php } ?>
        data-table="margin_list_monthly"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fmargin_list_monthlysrch", function() {
    var options = { name: "x_product", selectId: "fmargin_list_monthlysrch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmargin_list_monthlysrch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fmargin_list_monthlysrch" };
    } else {
        options.ajax = { id: "x_product", form: "fmargin_list_monthlysrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.margin_list_monthly.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fmargin_list_monthlysrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fmargin_list_monthlysrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fmargin_list_monthlysrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fmargin_list_monthlysrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fmargin_list_monthlysrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fmargin_list_monthlysrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fmargin_list_monthlysrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="margin_list_monthly">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_margin_list_monthly" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_margin_list_monthlylist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_margin_list_monthly_grp" class="margin_list_monthly_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>"><div id="elh_margin_list_monthly_s_grp" class="margin_list_monthly_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_margin_list_monthly_product" class="margin_list_monthly_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>"><div id="elh_margin_list_monthly_rid" class="margin_list_monthly_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
        <th data-name="lot_no" class="<?= $Page->lot_no->headerCellClass() ?>"><div id="elh_margin_list_monthly_lot_no" class="margin_list_monthly_lot_no"><?= $Page->renderFieldHeader($Page->lot_no) ?></div></th>
<?php } ?>
<?php if ($Page->margin_monthly->Visible) { // margin_monthly ?>
        <th data-name="margin_monthly" class="<?= $Page->margin_monthly->headerCellClass() ?>"><div id="elh_margin_list_monthly_margin_monthly" class="margin_list_monthly_margin_monthly"><?= $Page->renderFieldHeader($Page->margin_monthly) ?></div></th>
<?php } ?>
<?php if ($Page->margin_->Visible) { // margin_% ?>
        <th data-name="margin_" class="<?= $Page->margin_->headerCellClass() ?>"><div id="elh_margin_list_monthly_margin_" class="margin_list_monthly_margin_"><?= $Page->renderFieldHeader($Page->margin_) ?></div></th>
<?php } ?>
<?php if ($Page->packets_p->Visible) { // packets_p ?>
        <th data-name="packets_p" class="<?= $Page->packets_p->headerCellClass() ?>"><div id="elh_margin_list_monthly_packets_p" class="margin_list_monthly_packets_p"><?= $Page->renderFieldHeader($Page->packets_p) ?></div></th>
<?php } ?>
<?php if ($Page->quantity_p->Visible) { // quantity_p ?>
        <th data-name="quantity_p" class="<?= $Page->quantity_p->headerCellClass() ?>"><div id="elh_margin_list_monthly_quantity_p" class="margin_list_monthly_quantity_p"><?= $Page->renderFieldHeader($Page->quantity_p) ?></div></th>
<?php } ?>
<?php if ($Page->_p->Visible) { // @_p ?>
        <th data-name="_p" class="<?= $Page->_p->headerCellClass() ?>"><div id="elh_margin_list_monthly__p" class="margin_list_monthly__p"><?= $Page->renderFieldHeader($Page->_p) ?></div></th>
<?php } ?>
<?php if ($Page->amount_p->Visible) { // amount_p ?>
        <th data-name="amount_p" class="<?= $Page->amount_p->headerCellClass() ?>"><div id="elh_margin_list_monthly_amount_p" class="margin_list_monthly_amount_p"><?= $Page->renderFieldHeader($Page->amount_p) ?></div></th>
<?php } ?>
<?php if ($Page->packets_s->Visible) { // packets_s ?>
        <th data-name="packets_s" class="<?= $Page->packets_s->headerCellClass() ?>"><div id="elh_margin_list_monthly_packets_s" class="margin_list_monthly_packets_s"><?= $Page->renderFieldHeader($Page->packets_s) ?></div></th>
<?php } ?>
<?php if ($Page->quantity_s->Visible) { // quantity_s ?>
        <th data-name="quantity_s" class="<?= $Page->quantity_s->headerCellClass() ?>"><div id="elh_margin_list_monthly_quantity_s" class="margin_list_monthly_quantity_s"><?= $Page->renderFieldHeader($Page->quantity_s) ?></div></th>
<?php } ?>
<?php if ($Page->_s->Visible) { // @_s ?>
        <th data-name="_s" class="<?= $Page->_s->headerCellClass() ?>"><div id="elh_margin_list_monthly__s" class="margin_list_monthly__s"><?= $Page->renderFieldHeader($Page->_s) ?></div></th>
<?php } ?>
<?php if ($Page->amount_s->Visible) { // amount_s ?>
        <th data-name="amount_s" class="<?= $Page->amount_s->headerCellClass() ?>"><div id="elh_margin_list_monthly_amount_s" class="margin_list_monthly_amount_s"><?= $Page->renderFieldHeader($Page->amount_s) ?></div></th>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
        <th data-name="godown" class="<?= $Page->godown->headerCellClass() ?>"><div id="elh_margin_list_monthly_godown" class="margin_list_monthly_godown"><?= $Page->renderFieldHeader($Page->godown) ?></div></th>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Page->ref->headerCellClass() ?>"><div id="elh_margin_list_monthly_ref" class="margin_list_monthly_ref"><?= $Page->renderFieldHeader($Page->ref) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_grp" class="el_margin_list_monthly_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_s_grp" class="el_margin_list_monthly_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?= $Page->s_grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_product" class="el_margin_list_monthly_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_rid" class="el_margin_list_monthly_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?= $Page->rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no"<?= $Page->lot_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_lot_no" class="el_margin_list_monthly_lot_no">
<span<?= $Page->lot_no->viewAttributes() ?>>
<?= $Page->lot_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->margin_monthly->Visible) { // margin_monthly ?>
        <td data-name="margin_monthly"<?= $Page->margin_monthly->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_margin_monthly" class="el_margin_list_monthly_margin_monthly">
<span<?= $Page->margin_monthly->viewAttributes() ?>>
<?= $Page->margin_monthly->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->margin_->Visible) { // margin_% ?>
        <td data-name="margin_"<?= $Page->margin_->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_margin_" class="el_margin_list_monthly_margin_">
<span<?= $Page->margin_->viewAttributes() ?>>
<?= $Page->margin_->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packets_p->Visible) { // packets_p ?>
        <td data-name="packets_p"<?= $Page->packets_p->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_packets_p" class="el_margin_list_monthly_packets_p">
<span<?= $Page->packets_p->viewAttributes() ?>>
<?= $Page->packets_p->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity_p->Visible) { // quantity_p ?>
        <td data-name="quantity_p"<?= $Page->quantity_p->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_quantity_p" class="el_margin_list_monthly_quantity_p">
<span<?= $Page->quantity_p->viewAttributes() ?>>
<?= $Page->quantity_p->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_p->Visible) { // @_p ?>
        <td data-name="_p"<?= $Page->_p->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly__p" class="el_margin_list_monthly__p">
<span<?= $Page->_p->viewAttributes() ?>>
<?= $Page->_p->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount_p->Visible) { // amount_p ?>
        <td data-name="amount_p"<?= $Page->amount_p->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_amount_p" class="el_margin_list_monthly_amount_p">
<span<?= $Page->amount_p->viewAttributes() ?>>
<?= $Page->amount_p->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packets_s->Visible) { // packets_s ?>
        <td data-name="packets_s"<?= $Page->packets_s->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_packets_s" class="el_margin_list_monthly_packets_s">
<span<?= $Page->packets_s->viewAttributes() ?>>
<?= $Page->packets_s->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity_s->Visible) { // quantity_s ?>
        <td data-name="quantity_s"<?= $Page->quantity_s->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_quantity_s" class="el_margin_list_monthly_quantity_s">
<span<?= $Page->quantity_s->viewAttributes() ?>>
<?= $Page->quantity_s->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_s->Visible) { // @_s ?>
        <td data-name="_s"<?= $Page->_s->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly__s" class="el_margin_list_monthly__s">
<span<?= $Page->_s->viewAttributes() ?>>
<?= $Page->_s->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount_s->Visible) { // amount_s ?>
        <td data-name="amount_s"<?= $Page->amount_s->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_amount_s" class="el_margin_list_monthly_amount_s">
<span<?= $Page->amount_s->viewAttributes() ?>>
<?= $Page->amount_s->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown"<?= $Page->godown->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_godown" class="el_margin_list_monthly_godown">
<span<?= $Page->godown->viewAttributes() ?>>
<?= $Page->godown->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Page->ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_monthly_ref" class="el_margin_list_monthly_ref">
<span<?= $Page->ref->viewAttributes() ?>>
<?= $Page->ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp" class="<?= $Page->grp->footerCellClass() ?>"><span id="elf_margin_list_monthly_grp" class="margin_list_monthly_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp" class="<?= $Page->s_grp->footerCellClass() ?>"><span id="elf_margin_list_monthly_s_grp" class="margin_list_monthly_s_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product" class="<?= $Page->product->footerCellClass() ?>"><span id="elf_margin_list_monthly_product" class="margin_list_monthly_product">
        </span></td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid" class="<?= $Page->rid->footerCellClass() ?>"><span id="elf_margin_list_monthly_rid" class="margin_list_monthly_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no" class="<?= $Page->lot_no->footerCellClass() ?>"><span id="elf_margin_list_monthly_lot_no" class="margin_list_monthly_lot_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->margin_monthly->Visible) { // margin_monthly ?>
        <td data-name="margin_monthly" class="<?= $Page->margin_monthly->footerCellClass() ?>"><span id="elf_margin_list_monthly_margin_monthly" class="margin_list_monthly_margin_monthly">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->margin_monthly->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->margin_->Visible) { // margin_% ?>
        <td data-name="margin_" class="<?= $Page->margin_->footerCellClass() ?>"><span id="elf_margin_list_monthly_margin_" class="margin_list_monthly_margin_">
        <span class="ew-aggregate"><?= $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
        <?= $Page->margin_->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->packets_p->Visible) { // packets_p ?>
        <td data-name="packets_p" class="<?= $Page->packets_p->footerCellClass() ?>"><span id="elf_margin_list_monthly_packets_p" class="margin_list_monthly_packets_p">
        </span></td>
    <?php } ?>
    <?php if ($Page->quantity_p->Visible) { // quantity_p ?>
        <td data-name="quantity_p" class="<?= $Page->quantity_p->footerCellClass() ?>"><span id="elf_margin_list_monthly_quantity_p" class="margin_list_monthly_quantity_p">
        </span></td>
    <?php } ?>
    <?php if ($Page->_p->Visible) { // @_p ?>
        <td data-name="_p" class="<?= $Page->_p->footerCellClass() ?>"><span id="elf_margin_list_monthly__p" class="margin_list_monthly__p">
        </span></td>
    <?php } ?>
    <?php if ($Page->amount_p->Visible) { // amount_p ?>
        <td data-name="amount_p" class="<?= $Page->amount_p->footerCellClass() ?>"><span id="elf_margin_list_monthly_amount_p" class="margin_list_monthly_amount_p">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->amount_p->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->packets_s->Visible) { // packets_s ?>
        <td data-name="packets_s" class="<?= $Page->packets_s->footerCellClass() ?>"><span id="elf_margin_list_monthly_packets_s" class="margin_list_monthly_packets_s">
        </span></td>
    <?php } ?>
    <?php if ($Page->quantity_s->Visible) { // quantity_s ?>
        <td data-name="quantity_s" class="<?= $Page->quantity_s->footerCellClass() ?>"><span id="elf_margin_list_monthly_quantity_s" class="margin_list_monthly_quantity_s">
        </span></td>
    <?php } ?>
    <?php if ($Page->_s->Visible) { // @_s ?>
        <td data-name="_s" class="<?= $Page->_s->footerCellClass() ?>"><span id="elf_margin_list_monthly__s" class="margin_list_monthly__s">
        </span></td>
    <?php } ?>
    <?php if ($Page->amount_s->Visible) { // amount_s ?>
        <td data-name="amount_s" class="<?= $Page->amount_s->footerCellClass() ?>"><span id="elf_margin_list_monthly_amount_s" class="margin_list_monthly_amount_s">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->amount_s->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown" class="<?= $Page->godown->footerCellClass() ?>"><span id="elf_margin_list_monthly_godown" class="margin_list_monthly_godown">
        </span></td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref" class="<?= $Page->ref->footerCellClass() ?>"><span id="elf_margin_list_monthly_ref" class="margin_list_monthly_ref">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("margin_list_monthly");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
