<?php

namespace PHPMaker2024\fibre;

// Page object
$MarginListList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { margin_list: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="margin_list">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_margin_list" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_margin_listlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_margin_list_grp" class="margin_list_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>"><div id="elh_margin_list_s_grp" class="margin_list_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_margin_list_product" class="margin_list_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>"><div id="elh_margin_list_rid" class="margin_list_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
        <th data-name="godown" class="<?= $Page->godown->headerCellClass() ?>"><div id="elh_margin_list_godown" class="margin_list_godown"><?= $Page->renderFieldHeader($Page->godown) ?></div></th>
<?php } ?>
<?php if ($Page->margin_monthly->Visible) { // margin_monthly ?>
        <th data-name="margin_monthly" class="<?= $Page->margin_monthly->headerCellClass() ?>"><div id="elh_margin_list_margin_monthly" class="margin_list_margin_monthly"><?= $Page->renderFieldHeader($Page->margin_monthly) ?></div></th>
<?php } ?>
<?php if ($Page->margin_->Visible) { // margin_% ?>
        <th data-name="margin_" class="<?= $Page->margin_->headerCellClass() ?>"><div id="elh_margin_list_margin_" class="margin_list_margin_"><?= $Page->renderFieldHeader($Page->margin_) ?></div></th>
<?php } ?>
<?php if ($Page->packets_s->Visible) { // packets_s ?>
        <th data-name="packets_s" class="<?= $Page->packets_s->headerCellClass() ?>"><div id="elh_margin_list_packets_s" class="margin_list_packets_s"><?= $Page->renderFieldHeader($Page->packets_s) ?></div></th>
<?php } ?>
<?php if ($Page->quantity_s->Visible) { // quantity_s ?>
        <th data-name="quantity_s" class="<?= $Page->quantity_s->headerCellClass() ?>"><div id="elh_margin_list_quantity_s" class="margin_list_quantity_s"><?= $Page->renderFieldHeader($Page->quantity_s) ?></div></th>
<?php } ?>
<?php if ($Page->_s->Visible) { // @_s ?>
        <th data-name="_s" class="<?= $Page->_s->headerCellClass() ?>"><div id="elh_margin_list__s" class="margin_list__s"><?= $Page->renderFieldHeader($Page->_s) ?></div></th>
<?php } ?>
<?php if ($Page->amount_s->Visible) { // amount_s ?>
        <th data-name="amount_s" class="<?= $Page->amount_s->headerCellClass() ?>"><div id="elh_margin_list_amount_s" class="margin_list_amount_s"><?= $Page->renderFieldHeader($Page->amount_s) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_grp" class="el_margin_list_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->grp->getViewValue()) && $Page->grp->linkAttributes() != "") { ?>
<a<?= $Page->grp->linkAttributes() ?>><?= $Page->grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_s_grp" class="el_margin_list_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->s_grp->getViewValue()) && $Page->s_grp->linkAttributes() != "") { ?>
<a<?= $Page->s_grp->linkAttributes() ?>><?= $Page->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_product" class="el_margin_list_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_rid" class="el_margin_list_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?= $Page->rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown"<?= $Page->godown->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_godown" class="el_margin_list_godown">
<span<?= $Page->godown->viewAttributes() ?>>
<?php if (!EmptyString($Page->godown->getViewValue()) && $Page->godown->linkAttributes() != "") { ?>
<a<?= $Page->godown->linkAttributes() ?>><?= $Page->godown->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->margin_monthly->Visible) { // margin_monthly ?>
        <td data-name="margin_monthly"<?= $Page->margin_monthly->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_margin_monthly" class="el_margin_list_margin_monthly">
<span<?= $Page->margin_monthly->viewAttributes() ?>>
<?= $Page->margin_monthly->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->margin_->Visible) { // margin_% ?>
        <td data-name="margin_"<?= $Page->margin_->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_margin_" class="el_margin_list_margin_">
<span<?= $Page->margin_->viewAttributes() ?>>
<?= $Page->margin_->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packets_s->Visible) { // packets_s ?>
        <td data-name="packets_s"<?= $Page->packets_s->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_packets_s" class="el_margin_list_packets_s">
<span<?= $Page->packets_s->viewAttributes() ?>>
<?= $Page->packets_s->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity_s->Visible) { // quantity_s ?>
        <td data-name="quantity_s"<?= $Page->quantity_s->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_quantity_s" class="el_margin_list_quantity_s">
<span<?= $Page->quantity_s->viewAttributes() ?>>
<?= $Page->quantity_s->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_s->Visible) { // @_s ?>
        <td data-name="_s"<?= $Page->_s->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list__s" class="el_margin_list__s">
<span<?= $Page->_s->viewAttributes() ?>>
<?= $Page->_s->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount_s->Visible) { // amount_s ?>
        <td data-name="amount_s"<?= $Page->amount_s->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_margin_list_amount_s" class="el_margin_list_amount_s">
<span<?= $Page->amount_s->viewAttributes() ?>>
<?= $Page->amount_s->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp" class="<?= $Page->grp->footerCellClass() ?>"><span id="elf_margin_list_grp" class="margin_list_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp" class="<?= $Page->s_grp->footerCellClass() ?>"><span id="elf_margin_list_s_grp" class="margin_list_s_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product" class="<?= $Page->product->footerCellClass() ?>"><span id="elf_margin_list_product" class="margin_list_product">
        </span></td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid" class="<?= $Page->rid->footerCellClass() ?>"><span id="elf_margin_list_rid" class="margin_list_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown" class="<?= $Page->godown->footerCellClass() ?>"><span id="elf_margin_list_godown" class="margin_list_godown">
        </span></td>
    <?php } ?>
    <?php if ($Page->margin_monthly->Visible) { // margin_monthly ?>
        <td data-name="margin_monthly" class="<?= $Page->margin_monthly->footerCellClass() ?>"><span id="elf_margin_list_margin_monthly" class="margin_list_margin_monthly">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->margin_monthly->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->margin_->Visible) { // margin_% ?>
        <td data-name="margin_" class="<?= $Page->margin_->footerCellClass() ?>"><span id="elf_margin_list_margin_" class="margin_list_margin_">
        <span class="ew-aggregate"><?= $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
        <?= $Page->margin_->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->packets_s->Visible) { // packets_s ?>
        <td data-name="packets_s" class="<?= $Page->packets_s->footerCellClass() ?>"><span id="elf_margin_list_packets_s" class="margin_list_packets_s">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->packets_s->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->quantity_s->Visible) { // quantity_s ?>
        <td data-name="quantity_s" class="<?= $Page->quantity_s->footerCellClass() ?>"><span id="elf_margin_list_quantity_s" class="margin_list_quantity_s">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->quantity_s->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->_s->Visible) { // @_s ?>
        <td data-name="_s" class="<?= $Page->_s->footerCellClass() ?>"><span id="elf_margin_list__s" class="margin_list__s">
        </span></td>
    <?php } ?>
    <?php if ($Page->amount_s->Visible) { // amount_s ?>
        <td data-name="amount_s" class="<?= $Page->amount_s->footerCellClass() ?>"><span id="elf_margin_list_amount_s" class="margin_list_amount_s">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->amount_s->ViewValue ?></span>
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("margin_list");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
