<?php

namespace PHPMaker2024\fibre;

// Page object
$LotNoDetailsList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { lot_no_details: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="flot_no_detailssrch" id="flot_no_detailssrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="flot_no_detailssrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { lot_no_details: currentTable } });
var currentForm;
var flot_no_detailssrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("flot_no_detailssrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->grp->Visible) { // grp ?>
<?php
if (!$Page->grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->grp->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_grp" class="ew-search-caption ew-label"><?= $Page->grp->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</div>
        </div>
        <div id="el_lot_no_details_grp" class="ew-search-field">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="flot_no_detailssrch_x_grp"
        <?php } ?>
        data-table="lot_no_details"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("flot_no_detailssrch", function() {
    var options = { name: "x_grp", selectId: "flot_no_detailssrch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (flot_no_detailssrch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "flot_no_detailssrch" };
    } else {
        options.ajax = { id: "x_grp", form: "flot_no_detailssrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.lot_no_details.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
<?php
if (!$Page->s_grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_s_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->s_grp->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_s_grp" class="ew-search-caption ew-label"><?= $Page->s_grp->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</div>
        </div>
        <div id="el_lot_no_details_s_grp" class="ew-search-field">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="flot_no_detailssrch_x_s_grp"
        <?php } ?>
        data-table="lot_no_details"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("flot_no_detailssrch", function() {
    var options = { name: "x_s_grp", selectId: "flot_no_detailssrch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (flot_no_detailssrch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "flot_no_detailssrch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "flot_no_detailssrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.lot_no_details.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="flot_no_detailssrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="flot_no_detailssrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="flot_no_detailssrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="flot_no_detailssrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="flot_no_detailssrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="flot_no_detailssrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="flot_no_detailssrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="lot_no_details">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_lot_no_details" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_lot_no_detailslist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_lot_no_details_id" class="lot_no_details_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_lot_no_details_grp" class="lot_no_details_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_lot_no_details_s_grp" class="lot_no_details_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Page->ref->headerCellClass() ?>"><div id="elh_lot_no_details_ref" class="lot_no_details_ref"><?= $Page->renderFieldHeader($Page->ref) ?></div></th>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
        <th data-name="lot_no" class="<?= $Page->lot_no->headerCellClass() ?>"><div id="elh_lot_no_details_lot_no" class="lot_no_details_lot_no"><?= $Page->renderFieldHeader($Page->lot_no) ?></div></th>
<?php } ?>
<?php if ($Page->processed_at->Visible) { // processed_at ?>
        <th data-name="processed_at" class="<?= $Page->processed_at->headerCellClass() ?>"><div id="elh_lot_no_details_processed_at" class="lot_no_details_processed_at"><?= $Page->renderFieldHeader($Page->processed_at) ?></div></th>
<?php } ?>
<?php if ($Page->micron->Visible) { // micron ?>
        <th data-name="micron" class="<?= $Page->micron->headerCellClass() ?>"><div id="elh_lot_no_details_micron" class="lot_no_details_micron"><?= $Page->renderFieldHeader($Page->micron) ?></div></th>
<?php } ?>
<?php if ($Page->length->Visible) { // length ?>
        <th data-name="length" class="<?= $Page->length->headerCellClass() ?>"><div id="elh_lot_no_details_length" class="lot_no_details_length"><?= $Page->renderFieldHeader($Page->length) ?></div></th>
<?php } ?>
<?php if ($Page->balance_quantity->Visible) { // balance_quantity ?>
        <th data-name="balance_quantity" class="<?= $Page->balance_quantity->headerCellClass() ?>"><div id="elh_lot_no_details_balance_quantity" class="lot_no_details_balance_quantity"><?= $Page->renderFieldHeader($Page->balance_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->balance_packets->Visible) { // balance_packets ?>
        <th data-name="balance_packets" class="<?= $Page->balance_packets->headerCellClass() ?>"><div id="elh_lot_no_details_balance_packets" class="lot_no_details_balance_packets"><?= $Page->renderFieldHeader($Page->balance_packets) ?></div></th>
<?php } ?>
<?php if ($Page->base_product->Visible) { // base_product ?>
        <th data-name="base_product" class="<?= $Page->base_product->headerCellClass() ?>"><div id="elh_lot_no_details_base_product" class="lot_no_details_base_product"><?= $Page->renderFieldHeader($Page->base_product) ?></div></th>
<?php } ?>
<?php if ($Page->byproduct_1->Visible) { // byproduct_1 ?>
        <th data-name="byproduct_1" class="<?= $Page->byproduct_1->headerCellClass() ?>"><div id="elh_lot_no_details_byproduct_1" class="lot_no_details_byproduct_1"><?= $Page->renderFieldHeader($Page->byproduct_1) ?></div></th>
<?php } ?>
<?php if ($Page->byproduct_2->Visible) { // byproduct_2 ?>
        <th data-name="byproduct_2" class="<?= $Page->byproduct_2->headerCellClass() ?>"><div id="elh_lot_no_details_byproduct_2" class="lot_no_details_byproduct_2"><?= $Page->renderFieldHeader($Page->byproduct_2) ?></div></th>
<?php } ?>
<?php if ($Page->byproduct_3->Visible) { // byproduct_3 ?>
        <th data-name="byproduct_3" class="<?= $Page->byproduct_3->headerCellClass() ?>"><div id="elh_lot_no_details_byproduct_3" class="lot_no_details_byproduct_3"><?= $Page->renderFieldHeader($Page->byproduct_3) ?></div></th>
<?php } ?>
<?php if ($Page->byproduct_4->Visible) { // byproduct_4 ?>
        <th data-name="byproduct_4" class="<?= $Page->byproduct_4->headerCellClass() ?>"><div id="elh_lot_no_details_byproduct_4" class="lot_no_details_byproduct_4"><?= $Page->renderFieldHeader($Page->byproduct_4) ?></div></th>
<?php } ?>
<?php if ($Page->in_quantity->Visible) { // in_quantity ?>
        <th data-name="in_quantity" class="<?= $Page->in_quantity->headerCellClass() ?>"><div id="elh_lot_no_details_in_quantity" class="lot_no_details_in_quantity"><?= $Page->renderFieldHeader($Page->in_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->out_quantity->Visible) { // out_quantity ?>
        <th data-name="out_quantity" class="<?= $Page->out_quantity->headerCellClass() ?>"><div id="elh_lot_no_details_out_quantity" class="lot_no_details_out_quantity"><?= $Page->renderFieldHeader($Page->out_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->in_packets->Visible) { // in_packets ?>
        <th data-name="in_packets" class="<?= $Page->in_packets->headerCellClass() ?>"><div id="elh_lot_no_details_in_packets" class="lot_no_details_in_packets"><?= $Page->renderFieldHeader($Page->in_packets) ?></div></th>
<?php } ?>
<?php if ($Page->out_packets->Visible) { // out_packets ?>
        <th data-name="out_packets" class="<?= $Page->out_packets->headerCellClass() ?>"><div id="elh_lot_no_details_out_packets" class="lot_no_details_out_packets"><?= $Page->renderFieldHeader($Page->out_packets) ?></div></th>
<?php } ?>
<?php if ($Page->age->Visible) { // age ?>
        <th data-name="age" class="<?= $Page->age->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_lot_no_details_age" class="lot_no_details_age"><?= $Page->renderFieldHeader($Page->age) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_lot_no_details_remarks" class="lot_no_details_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Page->dated->headerCellClass() ?>"><div id="elh_lot_no_details_dated" class="lot_no_details_dated"><?= $Page->renderFieldHeader($Page->dated) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_id" class="el_lot_no_details_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_grp" class="el_lot_no_details_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_s_grp" class="el_lot_no_details_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->s_grp->getViewValue()) && $Page->s_grp->linkAttributes() != "") { ?>
<a<?= $Page->s_grp->linkAttributes() ?>><?= $Page->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Page->ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_ref" class="el_lot_no_details_ref">
<span<?= $Page->ref->viewAttributes() ?>>
<?= $Page->ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no"<?= $Page->lot_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_lot_no" class="el_lot_no_details_lot_no">
<span<?= $Page->lot_no->viewAttributes() ?>>
<?= $Page->lot_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->processed_at->Visible) { // processed_at ?>
        <td data-name="processed_at"<?= $Page->processed_at->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_processed_at" class="el_lot_no_details_processed_at">
<span<?= $Page->processed_at->viewAttributes() ?>>
<?= $Page->processed_at->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->micron->Visible) { // micron ?>
        <td data-name="micron"<?= $Page->micron->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_micron" class="el_lot_no_details_micron">
<span<?= $Page->micron->viewAttributes() ?>>
<?= $Page->micron->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->length->Visible) { // length ?>
        <td data-name="length"<?= $Page->length->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_length" class="el_lot_no_details_length">
<span<?= $Page->length->viewAttributes() ?>>
<?= $Page->length->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->balance_quantity->Visible) { // balance_quantity ?>
        <td data-name="balance_quantity"<?= $Page->balance_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_balance_quantity" class="el_lot_no_details_balance_quantity">
<span<?= $Page->balance_quantity->viewAttributes() ?>>
<?= $Page->balance_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->balance_packets->Visible) { // balance_packets ?>
        <td data-name="balance_packets"<?= $Page->balance_packets->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_balance_packets" class="el_lot_no_details_balance_packets">
<span<?= $Page->balance_packets->viewAttributes() ?>>
<?= $Page->balance_packets->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->base_product->Visible) { // base_product ?>
        <td data-name="base_product"<?= $Page->base_product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_base_product" class="el_lot_no_details_base_product">
<span<?= $Page->base_product->viewAttributes() ?>>
<?= $Page->base_product->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->byproduct_1->Visible) { // byproduct_1 ?>
        <td data-name="byproduct_1"<?= $Page->byproduct_1->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_byproduct_1" class="el_lot_no_details_byproduct_1">
<span<?= $Page->byproduct_1->viewAttributes() ?>>
<?= $Page->byproduct_1->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->byproduct_2->Visible) { // byproduct_2 ?>
        <td data-name="byproduct_2"<?= $Page->byproduct_2->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_byproduct_2" class="el_lot_no_details_byproduct_2">
<span<?= $Page->byproduct_2->viewAttributes() ?>>
<?= $Page->byproduct_2->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->byproduct_3->Visible) { // byproduct_3 ?>
        <td data-name="byproduct_3"<?= $Page->byproduct_3->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_byproduct_3" class="el_lot_no_details_byproduct_3">
<span<?= $Page->byproduct_3->viewAttributes() ?>>
<?= $Page->byproduct_3->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->byproduct_4->Visible) { // byproduct_4 ?>
        <td data-name="byproduct_4"<?= $Page->byproduct_4->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_byproduct_4" class="el_lot_no_details_byproduct_4">
<span<?= $Page->byproduct_4->viewAttributes() ?>>
<?= $Page->byproduct_4->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->in_quantity->Visible) { // in_quantity ?>
        <td data-name="in_quantity"<?= $Page->in_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_in_quantity" class="el_lot_no_details_in_quantity">
<span<?= $Page->in_quantity->viewAttributes() ?>>
<?= $Page->in_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->out_quantity->Visible) { // out_quantity ?>
        <td data-name="out_quantity"<?= $Page->out_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_out_quantity" class="el_lot_no_details_out_quantity">
<span<?= $Page->out_quantity->viewAttributes() ?>>
<?= $Page->out_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->in_packets->Visible) { // in_packets ?>
        <td data-name="in_packets"<?= $Page->in_packets->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_in_packets" class="el_lot_no_details_in_packets">
<span<?= $Page->in_packets->viewAttributes() ?>>
<?= $Page->in_packets->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->out_packets->Visible) { // out_packets ?>
        <td data-name="out_packets"<?= $Page->out_packets->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_out_packets" class="el_lot_no_details_out_packets">
<span<?= $Page->out_packets->viewAttributes() ?>>
<?= $Page->out_packets->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->age->Visible) { // age ?>
        <td data-name="age"<?= $Page->age->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_age" class="el_lot_no_details_age">
<span<?= $Page->age->viewAttributes() ?>>
<?= $Page->age->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_remarks" class="el_lot_no_details_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Page->dated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_lot_no_details_dated" class="el_lot_no_details_dated">
<span<?= $Page->dated->viewAttributes() ?>>
<?= $Page->dated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("lot_no_details");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
