<?php

namespace PHPMaker2024\fibre;

// Page object
$LocationsView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="flocationsview" id="flocationsview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { locations: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var flocationsview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("flocationsview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="locations">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_locations_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_locations_id">
<span<?= $Page->id->viewAttributes() ?>>
<?php if (!EmptyString($Page->id->getViewValue()) && $Page->id->linkAttributes() != "") { ?>
<a<?= $Page->id->linkAttributes() ?>><?= $Page->id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->latitude->Visible) { // latitude ?>
    <tr id="r_latitude"<?= $Page->latitude->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_locations_latitude"><?= $Page->latitude->caption() ?></span></td>
        <td data-name="latitude"<?= $Page->latitude->cellAttributes() ?>>
<span id="el_locations_latitude">
<span<?= $Page->latitude->viewAttributes() ?>>
<?= $Page->latitude->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->longitude->Visible) { // longitude ?>
    <tr id="r_longitude"<?= $Page->longitude->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_locations_longitude"><?= $Page->longitude->caption() ?></span></td>
        <td data-name="longitude"<?= $Page->longitude->cellAttributes() ?>>
<span id="el_locations_longitude">
<span<?= $Page->longitude->viewAttributes() ?>>
<?= $Page->longitude->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->tid->Visible) { // tid ?>
    <tr id="r_tid"<?= $Page->tid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_locations_tid"><?= $Page->tid->caption() ?></span></td>
        <td data-name="tid"<?= $Page->tid->cellAttributes() ?>>
<span id="el_locations_tid">
<span<?= $Page->tid->viewAttributes() ?>>
<?= $Page->tid->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <tr id="r_code"<?= $Page->code->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_locations_code"><?= $Page->code->caption() ?></span></td>
        <td data-name="code"<?= $Page->code->cellAttributes() ?>>
<span id="el_locations_code">
<span<?= $Page->code->viewAttributes() ?>>
<div id="mp_locations_code"
    class="ew-map"
    style="width: 256px; height: 256px;"
    data-ext="leaflet"
    data-service="openstreetmap"
    data-use-single-map="false"
    data-use-marker-clusterer="false"
    data-single-map-width="1000"
    data-single-map-height="500"
    data-geocoding-delay="250"
    data-show-map-on-top="true"
    data-show-all-markers="true"
    data-latitude="<?= HtmlEncode($Page->latitude->CurrentValue) ?>"
    data-longitude="<?= HtmlEncode($Page->longitude->CurrentValue) ?>"
    data-coordinate="<?= HtmlEncode($Page->coordinate->CurrentValue) ?>"
    data-zoom="16"
    data-title="<?= HtmlEncode($Page->id->CurrentValue) ?>"
    data-description="<?= HtmlEncode($Page->code->CurrentValue) ?>"
></div>
<span class="ew-map-value"><?= $Page->code->ViewValue ?></span>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <tr id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_locations_remarks"><?= $Page->remarks->caption() ?></span></td>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el_locations_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <tr id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_locations_operator"><?= $Page->operator->caption() ?></span></td>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el_locations_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <tr id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_locations_datetime"><?= $Page->datetime->caption() ?></span></td>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el_locations_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <tr id="r_url"<?= $Page->url->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_locations_url"><?= $Page->url->caption() ?></span></td>
        <td data-name="url"<?= $Page->url->cellAttributes() ?>>
<span id="el_locations_url">
<span<?= $Page->url->viewAttributes() ?>>
<?= $Page->url->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->e_operator->Visible) { // e_operator ?>
    <tr id="r_e_operator"<?= $Page->e_operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_locations_e_operator"><?= $Page->e_operator->caption() ?></span></td>
        <td data-name="e_operator"<?= $Page->e_operator->cellAttributes() ?>>
<span id="el_locations_e_operator">
<span<?= $Page->e_operator->viewAttributes() ?>>
<?= $Page->e_operator->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->e_datetime->Visible) { // e_datetime ?>
    <tr id="r_e_datetime"<?= $Page->e_datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_locations_e_datetime"><?= $Page->e_datetime->caption() ?></span></td>
        <td data-name="e_datetime"<?= $Page->e_datetime->cellAttributes() ?>>
<span id="el_locations_e_datetime">
<span<?= $Page->e_datetime->viewAttributes() ?>>
<?= $Page->e_datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
