<?php

namespace PHPMaker2024\fibre;

// Page object
$LocationsSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { locations: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var flocationssearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("flocationssearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["y_id", [ew.Validators.between], false],
            ["latitude", [ew.Validators.float], fields.latitude.isInvalid],
            ["longitude", [ew.Validators.float], fields.longitude.isInvalid],
            ["tid", [ew.Validators.integer], fields.tid.isInvalid],
            ["code", [], fields.code.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["e_operator", [ew.Validators.integer], fields.e_operator.isInvalid],
            ["e_datetime", [ew.Validators.datetime(fields.e_datetime.clientFormatPattern)], fields.e_datetime.isInvalid],
            ["y_e_datetime", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="flocationssearch" id="flocationssearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("locationslist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="locations">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_locations_id" class="locationssearch"><span id="el_locations_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="locations" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_locations_latitude" class="locationssearch"><span id="el_locations_latitude" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->latitude->getInputTextType() ?>" name="x_latitude" id="x_latitude" data-table="locations" data-field="x_latitude" value="<?= $Page->latitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->latitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->latitude->formatPattern()) ?>"<?= $Page->latitude->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->latitude->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_locations_longitude" class="locationssearch"><span id="el_locations_longitude" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->longitude->getInputTextType() ?>" name="x_longitude" id="x_longitude" data-table="locations" data-field="x_longitude" value="<?= $Page->longitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->longitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->longitude->formatPattern()) ?>"<?= $Page->longitude->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->longitude->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_locations_tid" class="locationssearch"><span id="el_locations_tid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tid->getInputTextType() ?>" name="x_tid" id="x_tid" data-table="locations" data-field="x_tid" value="<?= $Page->tid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->tid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tid->formatPattern()) ?>"<?= $Page->tid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tid->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_locations_code" class="locationssearch"><span id="el_locations_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="locations" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_locations_remarks" class="locationssearch"><span id="el_locations_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="locations" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="300" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_locations_operator" class="locationssearch"><span id="el_locations_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="locations" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_locations_datetime" class="locationssearch"><span id="el_locations_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="locations" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["flocationssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("flocationssearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_locations_e_operator" class="locationssearch"><span id="el_locations_e_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->e_operator->getInputTextType() ?>" name="x_e_operator" id="x_e_operator" data-table="locations" data-field="x_e_operator" value="<?= $Page->e_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->e_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->e_operator->formatPattern()) ?>"<?= $Page->e_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->e_operator->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_locations_e_datetime" class="locationssearch"><span id="el_locations_e_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->e_datetime->getInputTextType() ?>" name="x_e_datetime" id="x_e_datetime" data-table="locations" data-field="x_e_datetime" value="<?= $Page->e_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->e_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->e_datetime->formatPattern()) ?>"<?= $Page->e_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->e_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->e_datetime->ReadOnly && !$Page->e_datetime->Disabled && !isset($Page->e_datetime->EditAttrs["readonly"]) && !isset($Page->e_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["flocationssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("flocationssearch", "x_e_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<div id="locations_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(flocationssearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "latitude",
                type: "double",
                label: currentTable.fields.latitude.caption,
                operators: currentTable.fields.latitude.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(flocationssearch.fields.latitude.validators),
                data: {
                    format: currentTable.fields.latitude.clientFormatPattern
                }
            },
            {
                id: "longitude",
                type: "double",
                label: currentTable.fields.longitude.caption,
                operators: currentTable.fields.longitude.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(flocationssearch.fields.longitude.validators),
                data: {
                    format: currentTable.fields.longitude.clientFormatPattern
                }
            },
            {
                id: "tid",
                type: "integer",
                label: currentTable.fields.tid.caption,
                operators: currentTable.fields.tid.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(flocationssearch.fields.tid.validators),
                data: {
                    format: currentTable.fields.tid.clientFormatPattern
                }
            },
            {
                id: "code",
                type: "string",
                label: currentTable.fields.code.caption,
                operators: currentTable.fields.code.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(flocationssearch.fields.code.validators),
                data: {
                    format: currentTable.fields.code.clientFormatPattern
                }
            },
            {
                id: "remarks",
                type: "string",
                label: currentTable.fields.remarks.caption,
                operators: currentTable.fields.remarks.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(flocationssearch.fields.remarks.validators),
                data: {
                    format: currentTable.fields.remarks.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(flocationssearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(flocationssearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
            {
                id: "e_operator",
                type: "integer",
                label: currentTable.fields.e_operator.caption,
                operators: currentTable.fields.e_operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(flocationssearch.fields.e_operator.validators),
                data: {
                    format: currentTable.fields.e_operator.clientFormatPattern
                }
            },
            {
                id: "e_datetime",
                type: "datetime",
                label: currentTable.fields.e_datetime.caption,
                operators: currentTable.fields.e_datetime.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(flocationssearch.fields.e_datetime.validators),
                data: {
                    format: currentTable.fields.e_datetime.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#locations_query_builder"),
        args = {},
        rules = ew.parseJson($("#flocationssearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#flocationssearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="flocationssearch" formaction="<?= HtmlEncode(GetUrl("locationslist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="flocationssearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="flocationssearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("locations");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
