<?php

namespace PHPMaker2024\fibre;

// Page object
$LedgerView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fledgerview" id="fledgerview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { ledger: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fledgerview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fledgerview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="ledger">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->uid->Visible) { // uid ?>
    <tr id="r_uid"<?= $Page->uid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ledger_uid"><?= $Page->uid->caption() ?></span></td>
        <td data-name="uid"<?= $Page->uid->cellAttributes() ?>>
<span id="el_ledger_uid">
<span>
<?= GetImageViewTag($Page->uid, $Page->uid->getViewValue()) ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <tr id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ledger_dated"><?= $Page->dated->caption() ?></span></td>
        <td data-name="dated"<?= $Page->dated->cellAttributes() ?>>
<span id="el_ledger_dated">
<span<?= $Page->dated->viewAttributes() ?>>
<?php if (!EmptyString($Page->dated->getViewValue()) && $Page->dated->linkAttributes() != "") { ?>
<a<?= $Page->dated->linkAttributes() ?>><?= $Page->dated->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->ref_account->Visible) { // ref_account ?>
    <tr id="r_ref_account"<?= $Page->ref_account->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ledger_ref_account"><?= $Page->ref_account->caption() ?></span></td>
        <td data-name="ref_account"<?= $Page->ref_account->cellAttributes() ?>>
<span id="el_ledger_ref_account">
<span<?= $Page->ref_account->viewAttributes() ?>>
<?php if (!EmptyString($Page->ref_account->getViewValue()) && $Page->ref_account->linkAttributes() != "") { ?>
<a<?= $Page->ref_account->linkAttributes() ?>><?= $Page->ref_account->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->ref_account->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
    <tr id="r_Balance"<?= $Page->Balance->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ledger_Balance"><?= $Page->Balance->caption() ?></span></td>
        <td data-name="Balance"<?= $Page->Balance->cellAttributes() ?>>
<span id="el_ledger_Balance">
<span<?= $Page->Balance->viewAttributes() ?>>
<?= $Page->Balance->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->cumulative_sum->Visible) { // cumulative_sum ?>
    <tr id="r_cumulative_sum"<?= $Page->cumulative_sum->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ledger_cumulative_sum"><?= $Page->cumulative_sum->caption() ?></span></td>
        <td data-name="cumulative_sum"<?= $Page->cumulative_sum->cellAttributes() ?>>
<span id="el_ledger_cumulative_sum">
<span<?= $Page->cumulative_sum->viewAttributes() ?>>
<?= $Page->cumulative_sum->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <tr id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ledger_remarks"><?= $Page->remarks->caption() ?></span></td>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el_ledger_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <tr id="r_name"<?= $Page->name->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ledger_name"><?= $Page->name->caption() ?></span></td>
        <td data-name="name"<?= $Page->name->cellAttributes() ?>>
<span id="el_ledger_name">
<span<?= $Page->name->viewAttributes() ?>>
<?php if (!EmptyString($Page->name->getViewValue()) && $Page->name->linkAttributes() != "") { ?>
<a<?= $Page->name->linkAttributes() ?>><?= $Page->name->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <tr id="r_ref"<?= $Page->ref->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ledger_ref"><?= $Page->ref->caption() ?></span></td>
        <td data-name="ref"<?= $Page->ref->cellAttributes() ?>>
<span id="el_ledger_ref">
<span<?= $Page->ref->viewAttributes() ?>>
<?php if (!EmptyString($Page->ref->getViewValue()) && $Page->ref->linkAttributes() != "") { ?>
<a<?= $Page->ref->linkAttributes() ?>><?= $Page->ref->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <tr id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ledger_uploads"><?= $Page->uploads->caption() ?></span></td>
        <td data-name="uploads"<?= $Page->uploads->cellAttributes() ?>>
<span id="el_ledger_uploads">
<span>
<?= GetFileViewTag($Page->uploads, $Page->uploads->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ledger_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_ledger_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
