<?php

namespace PHPMaker2024\fibre;

// Page object
$LReceiptView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fl_receiptview" id="fl_receiptview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { l_receipt: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fl_receiptview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fl_receiptview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="l_receipt">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_l_receipt_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_l_receipt_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->r_from->Visible) { // r_from ?>
    <tr id="r_r_from"<?= $Page->r_from->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_l_receipt_r_from"><?= $Page->r_from->caption() ?></span></td>
        <td data-name="r_from"<?= $Page->r_from->cellAttributes() ?>>
<span id="el_l_receipt_r_from">
<span<?= $Page->r_from->viewAttributes() ?>>
<?= $Page->r_from->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->r_to->Visible) { // r_to ?>
    <tr id="r_r_to"<?= $Page->r_to->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_l_receipt_r_to"><?= $Page->r_to->caption() ?></span></td>
        <td data-name="r_to"<?= $Page->r_to->cellAttributes() ?>>
<span id="el_l_receipt_r_to">
<span<?= $Page->r_to->viewAttributes() ?>>
<?= $Page->r_to->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->d_id->Visible) { // d_id ?>
    <tr id="r_d_id"<?= $Page->d_id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_l_receipt_d_id"><?= $Page->d_id->caption() ?></span></td>
        <td data-name="d_id"<?= $Page->d_id->cellAttributes() ?>>
<span id="el_l_receipt_d_id">
<span<?= $Page->d_id->viewAttributes() ?>>
<?= $Page->d_id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->total_amount->Visible) { // total_amount ?>
    <tr id="r_total_amount"<?= $Page->total_amount->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_l_receipt_total_amount"><?= $Page->total_amount->caption() ?></span></td>
        <td data-name="total_amount"<?= $Page->total_amount->cellAttributes() ?>>
<span id="el_l_receipt_total_amount">
<span<?= $Page->total_amount->viewAttributes() ?>>
<?= $Page->total_amount->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->discount_amount->Visible) { // discount_amount ?>
    <tr id="r_discount_amount"<?= $Page->discount_amount->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_l_receipt_discount_amount"><?= $Page->discount_amount->caption() ?></span></td>
        <td data-name="discount_amount"<?= $Page->discount_amount->cellAttributes() ?>>
<span id="el_l_receipt_discount_amount">
<span<?= $Page->discount_amount->viewAttributes() ?>>
<?= $Page->discount_amount->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->receipt_amount->Visible) { // receipt_amount ?>
    <tr id="r_receipt_amount"<?= $Page->receipt_amount->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_l_receipt_receipt_amount"><?= $Page->receipt_amount->caption() ?></span></td>
        <td data-name="receipt_amount"<?= $Page->receipt_amount->cellAttributes() ?>>
<span id="el_l_receipt_receipt_amount">
<span<?= $Page->receipt_amount->viewAttributes() ?>>
<?= $Page->receipt_amount->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <tr id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_l_receipt_dated"><?= $Page->dated->caption() ?></span></td>
        <td data-name="dated"<?= $Page->dated->cellAttributes() ?>>
<span id="el_l_receipt_dated">
<span<?= $Page->dated->viewAttributes() ?>>
<?= $Page->dated->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <tr id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_l_receipt_remarks"><?= $Page->remarks->caption() ?></span></td>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el_l_receipt_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <tr id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_l_receipt_uploads"><?= $Page->uploads->caption() ?></span></td>
        <td data-name="uploads"<?= $Page->uploads->cellAttributes() ?>>
<span id="el_l_receipt_uploads">
<span>
<?= GetFileViewTag($Page->uploads, $Page->uploads->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <tr id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_l_receipt_operator"><?= $Page->operator->caption() ?></span></td>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el_l_receipt_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <tr id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_l_receipt_datetime"><?= $Page->datetime->caption() ?></span></td>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el_l_receipt_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
