<?php

namespace PHPMaker2024\fibre;

// Page object
$LReceiptSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { l_receipt: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fl_receiptsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fl_receiptsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["r_from", [], fields.r_from.isInvalid],
            ["d_id", [], fields.d_id.isInvalid],
            ["total_amount", [ew.Validators.float], fields.total_amount.isInvalid],
            ["discount_amount", [ew.Validators.float], fields.discount_amount.isInvalid],
            ["receipt_amount", [ew.Validators.float], fields.receipt_amount.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["uploads", [], fields.uploads.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "r_from": <?= $Page->r_from->toClientList($Page) ?>,
            "d_id": <?= $Page->d_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fl_receiptsearch" id="fl_receiptsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="l_receipt">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_receipt_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_receipt_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="l_receipt" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->r_from->Visible) { // r_from ?>
    <div id="r_r_from" class="row"<?= $Page->r_from->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_receipt_r_from"><?= $Page->r_from->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_r_from" id="z_r_from" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->r_from->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_receipt_r_from" class="ew-search-field ew-search-field-single">
    <select
        id="x_r_from"
        name="x_r_from"
        class="form-control ew-select<?= $Page->r_from->isInvalidClass() ?>"
        data-select2-id="fl_receiptsearch_x_r_from"
        data-table="l_receipt"
        data-field="x_r_from"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->r_from->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->r_from->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->r_from->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->r_from->editAttributes() ?>>
        <?= $Page->r_from->selectOptionListHtml("x_r_from") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->r_from->getErrorMessage(false) ?></div>
<?= $Page->r_from->Lookup->getParamTag($Page, "p_x_r_from") ?>
<script>
loadjs.ready("fl_receiptsearch", function() {
    var options = { name: "x_r_from", selectId: "fl_receiptsearch_x_r_from" };
    if (fl_receiptsearch.lists.r_from?.lookupOptions.length) {
        options.data = { id: "x_r_from", form: "fl_receiptsearch" };
    } else {
        options.ajax = { id: "x_r_from", form: "fl_receiptsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.l_receipt.fields.r_from.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_id->Visible) { // d_id ?>
    <div id="r_d_id" class="row"<?= $Page->d_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_receipt_d_id"><?= $Page->d_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_id" id="z_d_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_receipt_d_id" class="ew-search-field ew-search-field-single">
<template id="tp_x_d_id">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="l_receipt" data-field="x_d_id" name="x_d_id" id="x_d_id"<?= $Page->d_id->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_d_id" class="ew-item-list"></div>
<selection-list hidden
    id="x_d_id"
    name="x_d_id"
    value="<?= HtmlEncode($Page->d_id->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_d_id"
    data-target="dsl_x_d_id"
    data-repeatcolumn="1"
    class="form-control<?= $Page->d_id->isInvalidClass() ?>"
    data-table="l_receipt"
    data-field="x_d_id"
    data-value-separator="<?= $Page->d_id->displayValueSeparatorAttribute() ?>"
    <?= $Page->d_id->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->d_id->getErrorMessage(false) ?></div>
<?= $Page->d_id->Lookup->getParamTag($Page, "p_x_d_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->total_amount->Visible) { // total_amount ?>
    <div id="r_total_amount" class="row"<?= $Page->total_amount->rowAttributes() ?>>
        <label for="x_total_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_receipt_total_amount"><?= $Page->total_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_total_amount" id="z_total_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->total_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_receipt_total_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->total_amount->getInputTextType() ?>" name="x_total_amount" id="x_total_amount" data-table="l_receipt" data-field="x_total_amount" value="<?= $Page->total_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->total_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->total_amount->formatPattern()) ?>"<?= $Page->total_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->total_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->discount_amount->Visible) { // discount_amount ?>
    <div id="r_discount_amount" class="row"<?= $Page->discount_amount->rowAttributes() ?>>
        <label for="x_discount_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_receipt_discount_amount"><?= $Page->discount_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_discount_amount" id="z_discount_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->discount_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_receipt_discount_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->discount_amount->getInputTextType() ?>" name="x_discount_amount" id="x_discount_amount" data-table="l_receipt" data-field="x_discount_amount" value="<?= $Page->discount_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->discount_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->discount_amount->formatPattern()) ?>"<?= $Page->discount_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->discount_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->receipt_amount->Visible) { // receipt_amount ?>
    <div id="r_receipt_amount" class="row"<?= $Page->receipt_amount->rowAttributes() ?>>
        <label for="x_receipt_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_receipt_receipt_amount"><?= $Page->receipt_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_receipt_amount" id="z_receipt_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->receipt_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_receipt_receipt_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->receipt_amount->getInputTextType() ?>" name="x_receipt_amount" id="x_receipt_amount" data-table="l_receipt" data-field="x_receipt_amount" value="<?= $Page->receipt_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->receipt_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->receipt_amount->formatPattern()) ?>"<?= $Page->receipt_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->receipt_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_receipt_dated"><?= $Page->dated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dated" id="z_dated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_receipt_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="l_receipt" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fl_receiptsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fl_receiptsearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_receipt_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_receipt_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="l_receipt" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads" class="row"<?= $Page->uploads->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_receipt_uploads"><?= $Page->uploads->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_uploads" id="z_uploads" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->uploads->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_receipt_uploads" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->uploads->getInputTextType() ?>" name="x_uploads" id="x_uploads" data-table="l_receipt" data-field="x_uploads" value="<?= $Page->uploads->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->uploads->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uploads->formatPattern()) ?>"<?= $Page->uploads->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uploads->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_receipt_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_receipt_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="l_receipt" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_receipt_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_receipt_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="l_receipt" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fl_receiptsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fl_receiptsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fl_receiptsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fl_receiptsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fl_receiptsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("l_receipt");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
