<?php

namespace PHPMaker2024\fibre;

// Page object
$LReceiptEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fl_receiptedit" id="fl_receiptedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { l_receipt: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fl_receiptedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fl_receiptedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null, ew.Validators.integer], fields.id.isInvalid],
            ["r_from", [fields.r_from.visible && fields.r_from.required ? ew.Validators.required(fields.r_from.caption) : null], fields.r_from.isInvalid],
            ["r_to", [fields.r_to.visible && fields.r_to.required ? ew.Validators.required(fields.r_to.caption) : null], fields.r_to.isInvalid],
            ["d_id", [fields.d_id.visible && fields.d_id.required ? ew.Validators.required(fields.d_id.caption) : null], fields.d_id.isInvalid],
            ["total_amount", [fields.total_amount.visible && fields.total_amount.required ? ew.Validators.required(fields.total_amount.caption) : null, ew.Validators.float], fields.total_amount.isInvalid],
            ["discount_amount", [fields.discount_amount.visible && fields.discount_amount.required ? ew.Validators.required(fields.discount_amount.caption) : null, ew.Validators.float], fields.discount_amount.isInvalid],
            ["receipt_amount", [fields.receipt_amount.visible && fields.receipt_amount.required ? ew.Validators.required(fields.receipt_amount.caption) : null, ew.Validators.float], fields.receipt_amount.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "r_from": <?= $Page->r_from->toClientList($Page) ?>,
            "r_to": <?= $Page->r_to->toClientList($Page) ?>,
            "d_id": <?= $Page->d_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="l_receipt">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_l_receipt_id" for="x_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_l_receipt_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="l_receipt" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->r_from->Visible) { // r_from ?>
    <div id="r_r_from"<?= $Page->r_from->rowAttributes() ?>>
        <label id="elh_l_receipt_r_from" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_from->caption() ?><?= $Page->r_from->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_from->cellAttributes() ?>>
<span id="el_l_receipt_r_from">
    <select
        id="x_r_from"
        name="x_r_from"
        class="form-control ew-select<?= $Page->r_from->isInvalidClass() ?>"
        data-select2-id="fl_receiptedit_x_r_from"
        data-table="l_receipt"
        data-field="x_r_from"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->r_from->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->r_from->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->r_from->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->r_from->editAttributes() ?>>
        <?= $Page->r_from->selectOptionListHtml("x_r_from") ?>
    </select>
    <?= $Page->r_from->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->r_from->getErrorMessage() ?></div>
<?= $Page->r_from->Lookup->getParamTag($Page, "p_x_r_from") ?>
<script>
loadjs.ready("fl_receiptedit", function() {
    var options = { name: "x_r_from", selectId: "fl_receiptedit_x_r_from" };
    if (fl_receiptedit.lists.r_from?.lookupOptions.length) {
        options.data = { id: "x_r_from", form: "fl_receiptedit" };
    } else {
        options.ajax = { id: "x_r_from", form: "fl_receiptedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.l_receipt.fields.r_from.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->r_to->Visible) { // r_to ?>
    <div id="r_r_to"<?= $Page->r_to->rowAttributes() ?>>
        <label id="elh_l_receipt_r_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_to->caption() ?><?= $Page->r_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_to->cellAttributes() ?>>
<span id="el_l_receipt_r_to">
<template id="tp_x_r_to">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="l_receipt" data-field="x_r_to" name="x_r_to" id="x_r_to"<?= $Page->r_to->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_r_to" class="ew-item-list"></div>
<selection-list hidden
    id="x_r_to"
    name="x_r_to"
    value="<?= HtmlEncode($Page->r_to->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_r_to"
    data-target="dsl_x_r_to"
    data-repeatcolumn="2"
    class="form-control<?= $Page->r_to->isInvalidClass() ?>"
    data-table="l_receipt"
    data-field="x_r_to"
    data-value-separator="<?= $Page->r_to->displayValueSeparatorAttribute() ?>"
    <?= $Page->r_to->editAttributes() ?>></selection-list>
<?= $Page->r_to->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->r_to->getErrorMessage() ?></div>
<?= $Page->r_to->Lookup->getParamTag($Page, "p_x_r_to") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->d_id->Visible) { // d_id ?>
    <div id="r_d_id"<?= $Page->d_id->rowAttributes() ?>>
        <label id="elh_l_receipt_d_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->d_id->caption() ?><?= $Page->d_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->d_id->cellAttributes() ?>>
<span id="el_l_receipt_d_id">
<template id="tp_x_d_id">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="l_receipt" data-field="x_d_id" name="x_d_id" id="x_d_id"<?= $Page->d_id->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_d_id" class="ew-item-list"></div>
<selection-list hidden
    id="x_d_id"
    name="x_d_id"
    value="<?= HtmlEncode($Page->d_id->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_d_id"
    data-target="dsl_x_d_id"
    data-repeatcolumn="1"
    class="form-control<?= $Page->d_id->isInvalidClass() ?>"
    data-table="l_receipt"
    data-field="x_d_id"
    data-value-separator="<?= $Page->d_id->displayValueSeparatorAttribute() ?>"
    <?= $Page->d_id->editAttributes() ?>></selection-list>
<?= $Page->d_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->d_id->getErrorMessage() ?></div>
<?= $Page->d_id->Lookup->getParamTag($Page, "p_x_d_id") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->total_amount->Visible) { // total_amount ?>
    <div id="r_total_amount"<?= $Page->total_amount->rowAttributes() ?>>
        <label id="elh_l_receipt_total_amount" for="x_total_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->total_amount->caption() ?><?= $Page->total_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->total_amount->cellAttributes() ?>>
<span id="el_l_receipt_total_amount">
<input type="<?= $Page->total_amount->getInputTextType() ?>" name="x_total_amount" id="x_total_amount" data-table="l_receipt" data-field="x_total_amount" value="<?= $Page->total_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->total_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->total_amount->formatPattern()) ?>"<?= $Page->total_amount->editAttributes() ?> aria-describedby="x_total_amount_help">
<?= $Page->total_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->total_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->discount_amount->Visible) { // discount_amount ?>
    <div id="r_discount_amount"<?= $Page->discount_amount->rowAttributes() ?>>
        <label id="elh_l_receipt_discount_amount" for="x_discount_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->discount_amount->caption() ?><?= $Page->discount_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->discount_amount->cellAttributes() ?>>
<span id="el_l_receipt_discount_amount">
<input type="<?= $Page->discount_amount->getInputTextType() ?>" name="x_discount_amount" id="x_discount_amount" data-table="l_receipt" data-field="x_discount_amount" value="<?= $Page->discount_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->discount_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->discount_amount->formatPattern()) ?>"<?= $Page->discount_amount->editAttributes() ?> aria-describedby="x_discount_amount_help">
<?= $Page->discount_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->discount_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->receipt_amount->Visible) { // receipt_amount ?>
    <div id="r_receipt_amount"<?= $Page->receipt_amount->rowAttributes() ?>>
        <label id="elh_l_receipt_receipt_amount" for="x_receipt_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->receipt_amount->caption() ?><?= $Page->receipt_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->receipt_amount->cellAttributes() ?>>
<span id="el_l_receipt_receipt_amount">
<input type="<?= $Page->receipt_amount->getInputTextType() ?>" name="x_receipt_amount" id="x_receipt_amount" data-table="l_receipt" data-field="x_receipt_amount" value="<?= $Page->receipt_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->receipt_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->receipt_amount->formatPattern()) ?>"<?= $Page->receipt_amount->editAttributes() ?> aria-describedby="x_receipt_amount_help">
<?= $Page->receipt_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->receipt_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_l_receipt_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_l_receipt_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="l_receipt" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fl_receiptedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fl_receiptedit", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_l_receipt_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_l_receipt_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="l_receipt" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_l_receipt_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_l_receipt_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="l_receipt"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="<?= (Post("fa_x_uploads") == "0") ? "0" : "1" ?>">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fl_receiptedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fl_receiptedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("l_receipt");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
