<?php

namespace PHPMaker2024\fibre;

// Page object
$LExaminationTypeSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { l_examination_type: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fl_examination_typesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fl_examination_typesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["report_grp", [], fields.report_grp.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["ex_grp", [], fields.ex_grp.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["max_discount", [ew.Validators.float], fields.max_discount.isInvalid],
            ["code", [], fields.code.isInvalid],
            ["standard_min", [], fields.standard_min.isInvalid],
            ["standard_max", [ew.Validators.float], fields.standard_max.isInvalid],
            ["standard_unit", [], fields.standard_unit.isInvalid],
            ["header", [], fields.header.isInvalid],
            ["footer", [], fields.footer.isInvalid],
            ["process_time_hours", [ew.Validators.integer], fields.process_time_hours.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["diagnosis_code", [], fields.diagnosis_code.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "report_grp": <?= $Page->report_grp->toClientList($Page) ?>,
            "ex_grp": <?= $Page->ex_grp->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fl_examination_typesearch" id="fl_examination_typesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="l_examination_type">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="l_examination_type" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fl_examination_typesearch_x_grp"
        <?php } ?>
        data-table="l_examination_type"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fl_examination_typesearch", function() {
    var options = { name: "x_grp", selectId: "fl_examination_typesearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fl_examination_typesearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fl_examination_typesearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fl_examination_typesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.l_examination_type.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->report_grp->Visible) { // report_grp ?>
    <div id="r_report_grp" class="row"<?= $Page->report_grp->rowAttributes() ?>>
        <label for="x_report_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_report_grp"><?= $Page->report_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_report_grp" id="z_report_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->report_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_report_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_report_grp"
        name="x_report_grp"
        class="form-select ew-select<?= $Page->report_grp->isInvalidClass() ?>"
        <?php if (!$Page->report_grp->IsNativeSelect) { ?>
        data-select2-id="fl_examination_typesearch_x_report_grp"
        <?php } ?>
        data-table="l_examination_type"
        data-field="x_report_grp"
        data-value-separator="<?= $Page->report_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->report_grp->getPlaceHolder()) ?>"
        <?= $Page->report_grp->editAttributes() ?>>
        <?= $Page->report_grp->selectOptionListHtml("x_report_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->report_grp->getErrorMessage(false) ?></div>
<?= $Page->report_grp->Lookup->getParamTag($Page, "p_x_report_grp") ?>
<?php if (!$Page->report_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fl_examination_typesearch", function() {
    var options = { name: "x_report_grp", selectId: "fl_examination_typesearch_x_report_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fl_examination_typesearch.lists.report_grp?.lookupOptions.length) {
        options.data = { id: "x_report_grp", form: "fl_examination_typesearch" };
    } else {
        options.ajax = { id: "x_report_grp", form: "fl_examination_typesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.l_examination_type.fields.report_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="l_examination_type" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ex_grp->Visible) { // ex_grp ?>
    <div id="r_ex_grp" class="row"<?= $Page->ex_grp->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_ex_grp"><?= $Page->ex_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ex_grp" id="z_ex_grp" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ex_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_ex_grp" class="ew-search-field ew-search-field-single">
<template id="tp_x_ex_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="l_examination_type" data-field="x_ex_grp" name="x_ex_grp" id="x_ex_grp"<?= $Page->ex_grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_ex_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_ex_grp[]"
    name="x_ex_grp[]"
    value="<?= HtmlEncode($Page->ex_grp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_ex_grp"
    data-target="dsl_x_ex_grp"
    data-repeatcolumn="3"
    class="form-control<?= $Page->ex_grp->isInvalidClass() ?>"
    data-table="l_examination_type"
    data-field="x_ex_grp"
    data-value-separator="<?= $Page->ex_grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->ex_grp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->ex_grp->getErrorMessage(false) ?></div>
<?= $Page->ex_grp->Lookup->getParamTag($Page, "p_x_ex_grp") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="l_examination_type" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->max_discount->Visible) { // max_discount ?>
    <div id="r_max_discount" class="row"<?= $Page->max_discount->rowAttributes() ?>>
        <label for="x_max_discount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_max_discount"><?= $Page->max_discount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_max_discount" id="z_max_discount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->max_discount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_max_discount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->max_discount->getInputTextType() ?>" name="x_max_discount" id="x_max_discount" data-table="l_examination_type" data-field="x_max_discount" value="<?= $Page->max_discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->max_discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->max_discount->formatPattern()) ?>"<?= $Page->max_discount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->max_discount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_code"><?= $Page->code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_code" id="z_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="l_examination_type" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->standard_min->Visible) { // standard_min ?>
    <div id="r_standard_min" class="row"<?= $Page->standard_min->rowAttributes() ?>>
        <label for="x_standard_min" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_standard_min"><?= $Page->standard_min->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_standard_min" id="z_standard_min" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->standard_min->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_standard_min" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->standard_min->getInputTextType() ?>" name="x_standard_min" id="x_standard_min" data-table="l_examination_type" data-field="x_standard_min" value="<?= $Page->standard_min->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->standard_min->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->standard_min->formatPattern()) ?>"<?= $Page->standard_min->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->standard_min->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->standard_max->Visible) { // standard_max ?>
    <div id="r_standard_max" class="row"<?= $Page->standard_max->rowAttributes() ?>>
        <label for="x_standard_max" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_standard_max"><?= $Page->standard_max->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_standard_max" id="z_standard_max" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->standard_max->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_standard_max" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->standard_max->getInputTextType() ?>" name="x_standard_max" id="x_standard_max" data-table="l_examination_type" data-field="x_standard_max" value="<?= $Page->standard_max->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->standard_max->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->standard_max->formatPattern()) ?>"<?= $Page->standard_max->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->standard_max->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->standard_unit->Visible) { // standard_unit ?>
    <div id="r_standard_unit" class="row"<?= $Page->standard_unit->rowAttributes() ?>>
        <label for="x_standard_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_standard_unit"><?= $Page->standard_unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_standard_unit" id="z_standard_unit" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->standard_unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_standard_unit" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->standard_unit->getInputTextType() ?>" name="x_standard_unit" id="x_standard_unit" data-table="l_examination_type" data-field="x_standard_unit" value="<?= $Page->standard_unit->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->standard_unit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->standard_unit->formatPattern()) ?>"<?= $Page->standard_unit->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->standard_unit->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->header->Visible) { // header ?>
    <div id="r_header" class="row"<?= $Page->header->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_header"><?= $Page->header->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_header" id="z_header" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->header->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_header" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->header->getInputTextType() ?>" name="x_header" id="x_header" data-table="l_examination_type" data-field="x_header" value="<?= $Page->header->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->header->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->header->formatPattern()) ?>"<?= $Page->header->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->header->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->footer->Visible) { // footer ?>
    <div id="r_footer" class="row"<?= $Page->footer->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_footer"><?= $Page->footer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_footer" id="z_footer" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->footer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_footer" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->footer->getInputTextType() ?>" name="x_footer" id="x_footer" data-table="l_examination_type" data-field="x_footer" value="<?= $Page->footer->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->footer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->footer->formatPattern()) ?>"<?= $Page->footer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->footer->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_time_hours->Visible) { // process_time_hours ?>
    <div id="r_process_time_hours" class="row"<?= $Page->process_time_hours->rowAttributes() ?>>
        <label for="x_process_time_hours" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_process_time_hours"><?= $Page->process_time_hours->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process_time_hours" id="z_process_time_hours" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_time_hours->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_process_time_hours" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->process_time_hours->getInputTextType() ?>" name="x_process_time_hours" id="x_process_time_hours" data-table="l_examination_type" data-field="x_process_time_hours" value="<?= $Page->process_time_hours->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->process_time_hours->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process_time_hours->formatPattern()) ?>"<?= $Page->process_time_hours->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->process_time_hours->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fl_examination_typesearch_x_status"
        <?php } ?>
        data-table="l_examination_type"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fl_examination_typesearch", function() {
    var options = { name: "x_status", selectId: "fl_examination_typesearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fl_examination_typesearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fl_examination_typesearch" };
    } else {
        options.ajax = { id: "x_status", form: "fl_examination_typesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.l_examination_type.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->diagnosis_code->Visible) { // diagnosis_code ?>
    <div id="r_diagnosis_code" class="row"<?= $Page->diagnosis_code->rowAttributes() ?>>
        <label for="x_diagnosis_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_diagnosis_code"><?= $Page->diagnosis_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_diagnosis_code" id="z_diagnosis_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->diagnosis_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_diagnosis_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->diagnosis_code->getInputTextType() ?>" name="x_diagnosis_code" id="x_diagnosis_code" data-table="l_examination_type" data-field="x_diagnosis_code" value="<?= $Page->diagnosis_code->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->diagnosis_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diagnosis_code->formatPattern()) ?>"<?= $Page->diagnosis_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diagnosis_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="l_examination_type" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_type_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_type_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="l_examination_type" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fl_examination_typesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fl_examination_typesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fl_examination_typesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fl_examination_typesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fl_examination_typesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("l_examination_type");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
