<?php

namespace PHPMaker2024\fibre;

// Page object
$LExaminationSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { l_examination: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fl_examinationsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fl_examinationsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.datetime(fields.id.clientFormatPattern)], fields.id.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["user", [ew.Validators.integer], fields.user.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["age", [ew.Validators.integer], fields.age.isInvalid],
            ["sex", [], fields.sex.isInvalid],
            ["referral", [ew.Validators.integer], fields.referral.isInvalid],
            ["examination_grp", [], fields.examination_grp.isInvalid],
            ["examination_type", [], fields.examination_type.isInvalid],
            ["total_amount", [ew.Validators.float], fields.total_amount.isInvalid],
            ["discount_percent", [ew.Validators.float], fields.discount_percent.isInvalid],
            ["discount_amount", [ew.Validators.float], fields.discount_amount.isInvalid],
            ["final_amount", [ew.Validators.float], fields.final_amount.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["receipt", [ew.Validators.float], fields.receipt.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "mobile": <?= $Page->mobile->toClientList($Page) ?>,
            "user": <?= $Page->user->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "name": <?= $Page->name->toClientList($Page) ?>,
            "sex": <?= $Page->sex->toClientList($Page) ?>,
            "referral": <?= $Page->referral->toClientList($Page) ?>,
            "examination_grp": <?= $Page->examination_grp->toClientList($Page) ?>,
            "examination_type": <?= $Page->examination_type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fl_examinationsearch" id="fl_examinationsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="l_examination">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="l_examination" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_mobile" class="ew-search-field ew-search-field-single">
    <select
        id="x_mobile"
        name="x_mobile"
        class="form-control ew-select<?= $Page->mobile->isInvalidClass() ?>"
        data-select2-id="fl_examinationsearch_x_mobile"
        data-table="l_examination"
        data-field="x_mobile"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->mobile->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->mobile->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->mobile->editAttributes() ?>>
        <?= $Page->mobile->selectOptionListHtml("x_mobile") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
<?= $Page->mobile->Lookup->getParamTag($Page, "p_x_mobile") ?>
<script>
loadjs.ready("fl_examinationsearch", function() {
    var options = { name: "x_mobile", selectId: "fl_examinationsearch_x_mobile" };
    if (fl_examinationsearch.lists.mobile?.lookupOptions.length) {
        options.data = { id: "x_mobile", form: "fl_examinationsearch" };
    } else {
        options.ajax = { id: "x_mobile", form: "fl_examinationsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.l_examination.fields.mobile.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->user->Visible) { // user ?>
    <div id="r_user" class="row"<?= $Page->user->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_user"><?= $Page->user->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_user" id="z_user" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->user->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_user" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->user->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_user" class="ew-auto-suggest">
    <input type="<?= $Page->user->getInputTextType() ?>" class="form-control" name="sv_x_user" id="sv_x_user" value="<?= RemoveHtml($Page->user->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->user->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->user->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user->formatPattern()) ?>"<?= $Page->user->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="l_examination" data-field="x_user" data-input="sv_x_user" data-value-separator="<?= $Page->user->displayValueSeparatorAttribute() ?>" name="x_user" id="x_user" value="<?= HtmlEncode($Page->user->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->user->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fl_examinationsearch", function() {
    fl_examinationsearch.createAutoSuggest(Object.assign({"id":"x_user","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->user->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.l_examination.fields.user.autoSuggestOptions));
});
</script>
<?= $Page->user->Lookup->getParamTag($Page, "p_x_user") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fl_examinationsearch_x_category"
        <?php } ?>
        data-table="l_examination"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fl_examinationsearch", function() {
    var options = { name: "x_category", selectId: "fl_examinationsearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fl_examinationsearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fl_examinationsearch" };
    } else {
        options.ajax = { id: "x_category", form: "fl_examinationsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.l_examination.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_name" class="ew-search-field ew-search-field-single">
    <select
        id="x_name"
        name="x_name"
        class="form-control ew-select<?= $Page->name->isInvalidClass() ?>"
        data-select2-id="fl_examinationsearch_x_name"
        data-table="l_examination"
        data-field="x_name"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->name->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->name->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>"
        <?= $Page->name->editAttributes() ?>>
        <?= $Page->name->selectOptionListHtml("x_name") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
<?= $Page->name->Lookup->getParamTag($Page, "p_x_name") ?>
<script>
loadjs.ready("fl_examinationsearch", function() {
    var options = { name: "x_name", selectId: "fl_examinationsearch_x_name" };
    if (fl_examinationsearch.lists.name?.lookupOptions.length) {
        options.data = { id: "x_name", form: "fl_examinationsearch" };
    } else {
        options.ajax = { id: "x_name", form: "fl_examinationsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.l_examination.fields.name.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->age->Visible) { // age ?>
    <div id="r_age" class="row"<?= $Page->age->rowAttributes() ?>>
        <label for="x_age" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_age"><?= $Page->age->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_age" id="z_age" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->age->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_age" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->age->getInputTextType() ?>" name="x_age" id="x_age" data-table="l_examination" data-field="x_age" value="<?= $Page->age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->age->formatPattern()) ?>"<?= $Page->age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->age->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sex->Visible) { // sex ?>
    <div id="r_sex" class="row"<?= $Page->sex->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_sex"><?= $Page->sex->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sex" id="z_sex" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sex->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_sex" class="ew-search-field ew-search-field-single">
<template id="tp_x_sex">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="l_examination" data-field="x_sex" name="x_sex" id="x_sex"<?= $Page->sex->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_sex" class="ew-item-list"></div>
<selection-list hidden
    id="x_sex"
    name="x_sex"
    value="<?= HtmlEncode($Page->sex->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_sex"
    data-target="dsl_x_sex"
    data-repeatcolumn="5"
    class="form-control<?= $Page->sex->isInvalidClass() ?>"
    data-table="l_examination"
    data-field="x_sex"
    data-value-separator="<?= $Page->sex->displayValueSeparatorAttribute() ?>"
    <?= $Page->sex->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->sex->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->referral->Visible) { // referral ?>
    <div id="r_referral" class="row"<?= $Page->referral->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_referral"><?= $Page->referral->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_referral" id="z_referral" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->referral->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_referral" class="ew-search-field ew-search-field-single">
    <select
        id="x_referral"
        name="x_referral"
        class="form-control ew-select<?= $Page->referral->isInvalidClass() ?>"
        data-select2-id="fl_examinationsearch_x_referral"
        data-table="l_examination"
        data-field="x_referral"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->referral->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->referral->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->referral->getPlaceHolder()) ?>"
        <?= $Page->referral->editAttributes() ?>>
        <?= $Page->referral->selectOptionListHtml("x_referral") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->referral->getErrorMessage(false) ?></div>
<?= $Page->referral->Lookup->getParamTag($Page, "p_x_referral") ?>
<script>
loadjs.ready("fl_examinationsearch", function() {
    var options = { name: "x_referral", selectId: "fl_examinationsearch_x_referral" };
    if (fl_examinationsearch.lists.referral?.lookupOptions.length) {
        options.data = { id: "x_referral", form: "fl_examinationsearch" };
    } else {
        options.ajax = { id: "x_referral", form: "fl_examinationsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.l_examination.fields.referral.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->examination_grp->Visible) { // examination_grp ?>
    <div id="r_examination_grp" class="row"<?= $Page->examination_grp->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_examination_grp"><?= $Page->examination_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_examination_grp" id="z_examination_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->examination_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_examination_grp" class="ew-search-field ew-search-field-single">
<template id="tp_x_examination_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="l_examination" data-field="x_examination_grp" name="x_examination_grp" id="x_examination_grp"<?= $Page->examination_grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_examination_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_examination_grp[]"
    name="x_examination_grp[]"
    value="<?= HtmlEncode($Page->examination_grp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_examination_grp"
    data-target="dsl_x_examination_grp"
    data-repeatcolumn="3"
    class="form-control<?= $Page->examination_grp->isInvalidClass() ?>"
    data-table="l_examination"
    data-field="x_examination_grp"
    data-ew-action="update-options"
    data-value-separator="<?= $Page->examination_grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->examination_grp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->examination_grp->getErrorMessage(false) ?></div>
<?= $Page->examination_grp->Lookup->getParamTag($Page, "p_x_examination_grp") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->examination_type->Visible) { // examination_type ?>
    <div id="r_examination_type" class="row"<?= $Page->examination_type->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_examination_type"><?= $Page->examination_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_examination_type" id="z_examination_type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->examination_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_examination_type" class="ew-search-field ew-search-field-single">
<template id="tp_x_examination_type">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="l_examination" data-field="x_examination_type" name="x_examination_type" id="x_examination_type"<?= $Page->examination_type->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_examination_type" class="ew-item-list"></div>
<selection-list hidden
    id="x_examination_type[]"
    name="x_examination_type[]"
    value="<?= HtmlEncode($Page->examination_type->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_examination_type"
    data-target="dsl_x_examination_type"
    data-repeatcolumn="3"
    class="form-control<?= $Page->examination_type->isInvalidClass() ?>"
    data-table="l_examination"
    data-field="x_examination_type"
    data-value-separator="<?= $Page->examination_type->displayValueSeparatorAttribute() ?>"
    <?= $Page->examination_type->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->examination_type->getErrorMessage(false) ?></div>
<?= $Page->examination_type->Lookup->getParamTag($Page, "p_x_examination_type") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->total_amount->Visible) { // total_amount ?>
    <div id="r_total_amount" class="row"<?= $Page->total_amount->rowAttributes() ?>>
        <label for="x_total_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_total_amount"><?= $Page->total_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_total_amount" id="z_total_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->total_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_total_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->total_amount->getInputTextType() ?>" name="x_total_amount" id="x_total_amount" data-table="l_examination" data-field="x_total_amount" value="<?= $Page->total_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->total_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->total_amount->formatPattern()) ?>"<?= $Page->total_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->total_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->discount_percent->Visible) { // discount_percent ?>
    <div id="r_discount_percent" class="row"<?= $Page->discount_percent->rowAttributes() ?>>
        <label for="x_discount_percent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_discount_percent"><?= $Page->discount_percent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_discount_percent" id="z_discount_percent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->discount_percent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_discount_percent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->discount_percent->getInputTextType() ?>" name="x_discount_percent" id="x_discount_percent" data-table="l_examination" data-field="x_discount_percent" value="<?= $Page->discount_percent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->discount_percent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->discount_percent->formatPattern()) ?>"<?= $Page->discount_percent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->discount_percent->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->discount_amount->Visible) { // discount_amount ?>
    <div id="r_discount_amount" class="row"<?= $Page->discount_amount->rowAttributes() ?>>
        <label for="x_discount_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_discount_amount"><?= $Page->discount_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_discount_amount" id="z_discount_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->discount_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_discount_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->discount_amount->getInputTextType() ?>" name="x_discount_amount" id="x_discount_amount" data-table="l_examination" data-field="x_discount_amount" value="<?= $Page->discount_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->discount_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->discount_amount->formatPattern()) ?>"<?= $Page->discount_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->discount_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->final_amount->Visible) { // final_amount ?>
    <div id="r_final_amount" class="row"<?= $Page->final_amount->rowAttributes() ?>>
        <label for="x_final_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_final_amount"><?= $Page->final_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_final_amount" id="z_final_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->final_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_final_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->final_amount->getInputTextType() ?>" name="x_final_amount" id="x_final_amount" data-table="l_examination" data-field="x_final_amount" value="<?= $Page->final_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->final_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->final_amount->formatPattern()) ?>"<?= $Page->final_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->final_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="l_examination" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="l_examination" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="l_examination" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fl_examinationsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fl_examinationsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->receipt->Visible) { // receipt ?>
    <div id="r_receipt" class="row"<?= $Page->receipt->rowAttributes() ?>>
        <label for="x_receipt" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_receipt"><?= $Page->receipt->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_receipt" id="z_receipt" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->receipt->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_receipt" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->receipt->getInputTextType() ?>" name="x_receipt" id="x_receipt" data-table="l_examination" data-field="x_receipt" value="<?= $Page->receipt->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->receipt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->receipt->formatPattern()) ?>"<?= $Page->receipt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->receipt->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fl_examinationsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fl_examinationsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fl_examinationsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("l_examination");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
