<?php

namespace PHPMaker2024\fibre;

// Page object
$LExaminationReportSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { l_examination_report: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fl_examination_reportsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fl_examination_reportsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["d_id", [ew.Validators.integer], fields.d_id.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["examination_code", [], fields.examination_code.isInvalid],
            ["diagnosis_value", [], fields.diagnosis_value.isInvalid],
            ["diagnosis_st_min", [], fields.diagnosis_st_min.isInvalid],
            ["diagnosis_st_max", [ew.Validators.float], fields.diagnosis_st_max.isInvalid],
            ["diagnosis_unit", [], fields.diagnosis_unit.isInvalid],
            ["balance_amount", [ew.Validators.integer], fields.balance_amount.isInvalid],
            ["age", [ew.Validators.integer], fields.age.isInvalid],
            ["sex", [], fields.sex.isInvalid],
            ["referral", [ew.Validators.integer], fields.referral.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["examination_grp", [], fields.examination_grp.isInvalid],
            ["diagnosis_datetime", [ew.Validators.datetime(fields.diagnosis_datetime.clientFormatPattern)], fields.diagnosis_datetime.isInvalid],
            ["import_value", [], fields.import_value.isInvalid],
            ["total_amount", [ew.Validators.integer], fields.total_amount.isInvalid],
            ["discount_amount", [ew.Validators.float], fields.discount_amount.isInvalid],
            ["received_amount", [ew.Validators.integer], fields.received_amount.isInvalid],
            ["examination_id", [ew.Validators.integer], fields.examination_id.isInvalid],
            ["examination_name", [], fields.examination_name.isInvalid],
            ["uid", [], fields.uid.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["user", [ew.Validators.integer], fields.user.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "mobile": <?= $Page->mobile->toClientList($Page) ?>,
            "name": <?= $Page->name->toClientList($Page) ?>,
            "sex": <?= $Page->sex->toClientList($Page) ?>,
            "referral": <?= $Page->referral->toClientList($Page) ?>,
            "examination_grp": <?= $Page->examination_grp->toClientList($Page) ?>,
            "user": <?= $Page->user->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fl_examination_reportsearch" id="fl_examination_reportsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="l_examination_report">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->d_id->Visible) { // d_id ?>
    <div id="r_d_id" class="row"<?= $Page->d_id->rowAttributes() ?>>
        <label for="x_d_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_d_id"><?= $Page->d_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_id" id="z_d_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_d_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_id->getInputTextType() ?>" name="x_d_id" id="x_d_id" data-table="l_examination_report" data-field="x_d_id" value="<?= $Page->d_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->d_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_id->formatPattern()) ?>"<?= $Page->d_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_mobile" class="ew-search-field ew-search-field-single">
    <select
        id="x_mobile"
        name="x_mobile"
        class="form-control ew-select<?= $Page->mobile->isInvalidClass() ?>"
        data-select2-id="fl_examination_reportsearch_x_mobile"
        data-table="l_examination_report"
        data-field="x_mobile"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->mobile->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->mobile->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->mobile->editAttributes() ?>>
        <?= $Page->mobile->selectOptionListHtml("x_mobile") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
<?= $Page->mobile->Lookup->getParamTag($Page, "p_x_mobile") ?>
<script>
loadjs.ready("fl_examination_reportsearch", function() {
    var options = { name: "x_mobile", selectId: "fl_examination_reportsearch_x_mobile" };
    if (fl_examination_reportsearch.lists.mobile?.lookupOptions.length) {
        options.data = { id: "x_mobile", form: "fl_examination_reportsearch" };
    } else {
        options.ajax = { id: "x_mobile", form: "fl_examination_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.l_examination_report.fields.mobile.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_name" class="ew-search-field ew-search-field-single">
    <select
        id="x_name"
        name="x_name"
        class="form-control ew-select<?= $Page->name->isInvalidClass() ?>"
        data-select2-id="fl_examination_reportsearch_x_name"
        data-table="l_examination_report"
        data-field="x_name"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->name->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->name->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>"
        <?= $Page->name->editAttributes() ?>>
        <?= $Page->name->selectOptionListHtml("x_name") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
<?= $Page->name->Lookup->getParamTag($Page, "p_x_name") ?>
<script>
loadjs.ready("fl_examination_reportsearch", function() {
    var options = { name: "x_name", selectId: "fl_examination_reportsearch_x_name" };
    if (fl_examination_reportsearch.lists.name?.lookupOptions.length) {
        options.data = { id: "x_name", form: "fl_examination_reportsearch" };
    } else {
        options.ajax = { id: "x_name", form: "fl_examination_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.l_examination_report.fields.name.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->examination_code->Visible) { // examination_code ?>
    <div id="r_examination_code" class="row"<?= $Page->examination_code->rowAttributes() ?>>
        <label for="x_examination_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_examination_code"><?= $Page->examination_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_examination_code" id="z_examination_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->examination_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_examination_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->examination_code->getInputTextType() ?>" name="x_examination_code" id="x_examination_code" data-table="l_examination_report" data-field="x_examination_code" value="<?= $Page->examination_code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->examination_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->examination_code->formatPattern()) ?>"<?= $Page->examination_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->examination_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->diagnosis_value->Visible) { // diagnosis_value ?>
    <div id="r_diagnosis_value" class="row"<?= $Page->diagnosis_value->rowAttributes() ?>>
        <label for="x_diagnosis_value" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_diagnosis_value"><?= $Page->diagnosis_value->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_diagnosis_value" id="z_diagnosis_value" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->diagnosis_value->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_diagnosis_value" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->diagnosis_value->getInputTextType() ?>" name="x_diagnosis_value" id="x_diagnosis_value" data-table="l_examination_report" data-field="x_diagnosis_value" value="<?= $Page->diagnosis_value->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->diagnosis_value->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diagnosis_value->formatPattern()) ?>"<?= $Page->diagnosis_value->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diagnosis_value->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->diagnosis_st_min->Visible) { // diagnosis_st_min ?>
    <div id="r_diagnosis_st_min" class="row"<?= $Page->diagnosis_st_min->rowAttributes() ?>>
        <label for="x_diagnosis_st_min" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_diagnosis_st_min"><?= $Page->diagnosis_st_min->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_diagnosis_st_min" id="z_diagnosis_st_min" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->diagnosis_st_min->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_diagnosis_st_min" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->diagnosis_st_min->getInputTextType() ?>" name="x_diagnosis_st_min" id="x_diagnosis_st_min" data-table="l_examination_report" data-field="x_diagnosis_st_min" value="<?= $Page->diagnosis_st_min->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->diagnosis_st_min->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diagnosis_st_min->formatPattern()) ?>"<?= $Page->diagnosis_st_min->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diagnosis_st_min->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->diagnosis_st_max->Visible) { // diagnosis_st_max ?>
    <div id="r_diagnosis_st_max" class="row"<?= $Page->diagnosis_st_max->rowAttributes() ?>>
        <label for="x_diagnosis_st_max" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_diagnosis_st_max"><?= $Page->diagnosis_st_max->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_diagnosis_st_max" id="z_diagnosis_st_max" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->diagnosis_st_max->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_diagnosis_st_max" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->diagnosis_st_max->getInputTextType() ?>" name="x_diagnosis_st_max" id="x_diagnosis_st_max" data-table="l_examination_report" data-field="x_diagnosis_st_max" value="<?= $Page->diagnosis_st_max->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->diagnosis_st_max->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diagnosis_st_max->formatPattern()) ?>"<?= $Page->diagnosis_st_max->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diagnosis_st_max->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->diagnosis_unit->Visible) { // diagnosis_unit ?>
    <div id="r_diagnosis_unit" class="row"<?= $Page->diagnosis_unit->rowAttributes() ?>>
        <label for="x_diagnosis_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_diagnosis_unit"><?= $Page->diagnosis_unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_diagnosis_unit" id="z_diagnosis_unit" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->diagnosis_unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_diagnosis_unit" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->diagnosis_unit->getInputTextType() ?>" name="x_diagnosis_unit" id="x_diagnosis_unit" data-table="l_examination_report" data-field="x_diagnosis_unit" value="<?= $Page->diagnosis_unit->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->diagnosis_unit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diagnosis_unit->formatPattern()) ?>"<?= $Page->diagnosis_unit->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diagnosis_unit->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->balance_amount->Visible) { // balance_amount ?>
    <div id="r_balance_amount" class="row"<?= $Page->balance_amount->rowAttributes() ?>>
        <label for="x_balance_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_balance_amount"><?= $Page->balance_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_balance_amount" id="z_balance_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->balance_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_balance_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->balance_amount->getInputTextType() ?>" name="x_balance_amount" id="x_balance_amount" data-table="l_examination_report" data-field="x_balance_amount" value="<?= $Page->balance_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->balance_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance_amount->formatPattern()) ?>"<?= $Page->balance_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->balance_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->age->Visible) { // age ?>
    <div id="r_age" class="row"<?= $Page->age->rowAttributes() ?>>
        <label for="x_age" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_age"><?= $Page->age->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_age" id="z_age" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->age->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_age" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->age->getInputTextType() ?>" name="x_age" id="x_age" data-table="l_examination_report" data-field="x_age" value="<?= $Page->age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->age->formatPattern()) ?>"<?= $Page->age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->age->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sex->Visible) { // sex ?>
    <div id="r_sex" class="row"<?= $Page->sex->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_sex"><?= $Page->sex->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sex" id="z_sex" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sex->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_sex" class="ew-search-field ew-search-field-single">
<template id="tp_x_sex">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="l_examination_report" data-field="x_sex" name="x_sex" id="x_sex"<?= $Page->sex->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_sex" class="ew-item-list"></div>
<selection-list hidden
    id="x_sex"
    name="x_sex"
    value="<?= HtmlEncode($Page->sex->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_sex"
    data-target="dsl_x_sex"
    data-repeatcolumn="5"
    class="form-control<?= $Page->sex->isInvalidClass() ?>"
    data-table="l_examination_report"
    data-field="x_sex"
    data-value-separator="<?= $Page->sex->displayValueSeparatorAttribute() ?>"
    <?= $Page->sex->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->sex->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->referral->Visible) { // referral ?>
    <div id="r_referral" class="row"<?= $Page->referral->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_referral"><?= $Page->referral->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_referral" id="z_referral" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->referral->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_referral" class="ew-search-field ew-search-field-single">
    <select
        id="x_referral"
        name="x_referral"
        class="form-control ew-select<?= $Page->referral->isInvalidClass() ?>"
        data-select2-id="fl_examination_reportsearch_x_referral"
        data-table="l_examination_report"
        data-field="x_referral"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->referral->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->referral->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->referral->getPlaceHolder()) ?>"
        <?= $Page->referral->editAttributes() ?>>
        <?= $Page->referral->selectOptionListHtml("x_referral") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->referral->getErrorMessage(false) ?></div>
<?= $Page->referral->Lookup->getParamTag($Page, "p_x_referral") ?>
<script>
loadjs.ready("fl_examination_reportsearch", function() {
    var options = { name: "x_referral", selectId: "fl_examination_reportsearch_x_referral" };
    if (fl_examination_reportsearch.lists.referral?.lookupOptions.length) {
        options.data = { id: "x_referral", form: "fl_examination_reportsearch" };
    } else {
        options.ajax = { id: "x_referral", form: "fl_examination_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.l_examination_report.fields.referral.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="l_examination_report" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->examination_grp->Visible) { // examination_grp ?>
    <div id="r_examination_grp" class="row"<?= $Page->examination_grp->rowAttributes() ?>>
        <label for="x_examination_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_examination_grp"><?= $Page->examination_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_examination_grp" id="z_examination_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->examination_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_examination_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_examination_grp"
        name="x_examination_grp"
        class="form-select ew-select<?= $Page->examination_grp->isInvalidClass() ?>"
        <?php if (!$Page->examination_grp->IsNativeSelect) { ?>
        data-select2-id="fl_examination_reportsearch_x_examination_grp"
        <?php } ?>
        data-table="l_examination_report"
        data-field="x_examination_grp"
        data-value-separator="<?= $Page->examination_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->examination_grp->getPlaceHolder()) ?>"
        <?= $Page->examination_grp->editAttributes() ?>>
        <?= $Page->examination_grp->selectOptionListHtml("x_examination_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->examination_grp->getErrorMessage(false) ?></div>
<?= $Page->examination_grp->Lookup->getParamTag($Page, "p_x_examination_grp") ?>
<?php if (!$Page->examination_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fl_examination_reportsearch", function() {
    var options = { name: "x_examination_grp", selectId: "fl_examination_reportsearch_x_examination_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fl_examination_reportsearch.lists.examination_grp?.lookupOptions.length) {
        options.data = { id: "x_examination_grp", form: "fl_examination_reportsearch" };
    } else {
        options.ajax = { id: "x_examination_grp", form: "fl_examination_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.l_examination_report.fields.examination_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->diagnosis_datetime->Visible) { // diagnosis_datetime ?>
    <div id="r_diagnosis_datetime" class="row"<?= $Page->diagnosis_datetime->rowAttributes() ?>>
        <label for="x_diagnosis_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_diagnosis_datetime"><?= $Page->diagnosis_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_diagnosis_datetime" id="z_diagnosis_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->diagnosis_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_diagnosis_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->diagnosis_datetime->getInputTextType() ?>" name="x_diagnosis_datetime" id="x_diagnosis_datetime" data-table="l_examination_report" data-field="x_diagnosis_datetime" value="<?= $Page->diagnosis_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->diagnosis_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->diagnosis_datetime->formatPattern()) ?>"<?= $Page->diagnosis_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->diagnosis_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->diagnosis_datetime->ReadOnly && !$Page->diagnosis_datetime->Disabled && !isset($Page->diagnosis_datetime->EditAttrs["readonly"]) && !isset($Page->diagnosis_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fl_examination_reportsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fl_examination_reportsearch", "x_diagnosis_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->import_value->Visible) { // import_value ?>
    <div id="r_import_value" class="row"<?= $Page->import_value->rowAttributes() ?>>
        <label for="x_import_value" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_import_value"><?= $Page->import_value->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_import_value" id="z_import_value" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->import_value->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_import_value" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->import_value->getInputTextType() ?>" name="x_import_value" id="x_import_value" data-table="l_examination_report" data-field="x_import_value" value="<?= $Page->import_value->EditValue ?>" size="35" maxlength="1000" placeholder="<?= HtmlEncode($Page->import_value->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->import_value->formatPattern()) ?>"<?= $Page->import_value->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->import_value->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->total_amount->Visible) { // total_amount ?>
    <div id="r_total_amount" class="row"<?= $Page->total_amount->rowAttributes() ?>>
        <label for="x_total_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_total_amount"><?= $Page->total_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_total_amount" id="z_total_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->total_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_total_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->total_amount->getInputTextType() ?>" name="x_total_amount" id="x_total_amount" data-table="l_examination_report" data-field="x_total_amount" value="<?= $Page->total_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->total_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->total_amount->formatPattern()) ?>"<?= $Page->total_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->total_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->discount_amount->Visible) { // discount_amount ?>
    <div id="r_discount_amount" class="row"<?= $Page->discount_amount->rowAttributes() ?>>
        <label for="x_discount_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_discount_amount"><?= $Page->discount_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_discount_amount" id="z_discount_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->discount_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_discount_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->discount_amount->getInputTextType() ?>" name="x_discount_amount" id="x_discount_amount" data-table="l_examination_report" data-field="x_discount_amount" value="<?= $Page->discount_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->discount_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->discount_amount->formatPattern()) ?>"<?= $Page->discount_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->discount_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->received_amount->Visible) { // received_amount ?>
    <div id="r_received_amount" class="row"<?= $Page->received_amount->rowAttributes() ?>>
        <label for="x_received_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_received_amount"><?= $Page->received_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_received_amount" id="z_received_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->received_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_received_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->received_amount->getInputTextType() ?>" name="x_received_amount" id="x_received_amount" data-table="l_examination_report" data-field="x_received_amount" value="<?= $Page->received_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->received_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->received_amount->formatPattern()) ?>"<?= $Page->received_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->received_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->examination_id->Visible) { // examination_id ?>
    <div id="r_examination_id" class="row"<?= $Page->examination_id->rowAttributes() ?>>
        <label for="x_examination_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_examination_id"><?= $Page->examination_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_examination_id" id="z_examination_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->examination_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_examination_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->examination_id->getInputTextType() ?>" name="x_examination_id" id="x_examination_id" data-table="l_examination_report" data-field="x_examination_id" value="<?= $Page->examination_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->examination_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->examination_id->formatPattern()) ?>"<?= $Page->examination_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->examination_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->examination_name->Visible) { // examination_name ?>
    <div id="r_examination_name" class="row"<?= $Page->examination_name->rowAttributes() ?>>
        <label for="x_examination_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_examination_name"><?= $Page->examination_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_examination_name" id="z_examination_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->examination_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_examination_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->examination_name->getInputTextType() ?>" name="x_examination_name" id="x_examination_name" data-table="l_examination_report" data-field="x_examination_name" value="<?= $Page->examination_name->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->examination_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->examination_name->formatPattern()) ?>"<?= $Page->examination_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->examination_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->uid->Visible) { // uid ?>
    <div id="r_uid" class="row"<?= $Page->uid->rowAttributes() ?>>
        <label for="x_uid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_uid"><?= $Page->uid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_uid" id="z_uid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->uid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_uid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->uid->getInputTextType() ?>" name="x_uid" id="x_uid" data-table="l_examination_report" data-field="x_uid" value="<?= $Page->uid->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uid->formatPattern()) ?>"<?= $Page->uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="l_examination_report" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="l_examination_report" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fl_examination_reportsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fl_examination_reportsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->user->Visible) { // user ?>
    <div id="r_user" class="row"<?= $Page->user->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_l_examination_report_user"><?= $Page->user->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_user" id="z_user" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->user->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_l_examination_report_user" class="ew-search-field ew-search-field-single">
    <select
        id="x_user"
        name="x_user"
        class="form-control ew-select<?= $Page->user->isInvalidClass() ?>"
        data-select2-id="fl_examination_reportsearch_x_user"
        data-table="l_examination_report"
        data-field="x_user"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->user->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->user->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->user->getPlaceHolder()) ?>"
        <?= $Page->user->editAttributes() ?>>
        <?= $Page->user->selectOptionListHtml("x_user") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->user->getErrorMessage(false) ?></div>
<?= $Page->user->Lookup->getParamTag($Page, "p_x_user") ?>
<script>
loadjs.ready("fl_examination_reportsearch", function() {
    var options = { name: "x_user", selectId: "fl_examination_reportsearch_x_user" };
    if (fl_examination_reportsearch.lists.user?.lookupOptions.length) {
        options.data = { id: "x_user", form: "fl_examination_reportsearch" };
    } else {
        options.ajax = { id: "x_user", form: "fl_examination_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.l_examination_report.fields.user.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fl_examination_reportsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fl_examination_reportsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fl_examination_reportsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("l_examination_report");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
