<?php

namespace PHPMaker2024\fibre;

// Page object
$JobCardSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { job_card: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fjob_cardsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fjob_cardsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["jc_no", [ew.Validators.integer], fields.jc_no.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["buyer_id", [], fields.buyer_id.isInvalid],
            ["works", [], fields.works.isInvalid],
            ["issue_to_internal", [], fields.issue_to_internal.isInvalid],
            ["issue_to_external", [], fields.issue_to_external.isInvalid],
            ["issue_to", [ew.Validators.integer], fields.issue_to.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["item", [], fields.item.isInvalid],
            ["poid", [], fields.poid.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["pro_unit", [], fields.pro_unit.isInvalid],
            ["employee_id", [], fields.employee_id.isInvalid],
            ["_1", [], fields._1.isInvalid],
            ["_2", [], fields._2.isInvalid],
            ["_3", [], fields._3.isInvalid],
            ["_4", [], fields._4.isInvalid],
            ["_5", [], fields._5.isInvalid],
            ["_6", [], fields._6.isInvalid],
            ["_7", [], fields._7.isInvalid],
            ["_8", [], fields._8.isInvalid],
            ["other1", [], fields.other1.isInvalid],
            ["other2", [], fields.other2.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "works": <?= $Page->works->toClientList($Page) ?>,
            "issue_to_internal": <?= $Page->issue_to_internal->toClientList($Page) ?>,
            "issue_to_external": <?= $Page->issue_to_external->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "product_code": <?= $Page->product_code->toClientList($Page) ?>,
            "item": <?= $Page->item->toClientList($Page) ?>,
            "poid": <?= $Page->poid->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "pro_unit": <?= $Page->pro_unit->toClientList($Page) ?>,
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fjob_cardsearch" id="fjob_cardsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="job_card">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="job_card" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no" class="row"<?= $Page->jc_no->rowAttributes() ?>>
        <label for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_jc_no"><?= $Page->jc_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_no" id="z_jc_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_jc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="job_card" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fjob_cardsearch_x_company_id"
        <?php } ?>
        data-table="job_card"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardsearch", function() {
    var options = { name: "x_company_id", selectId: "fjob_cardsearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fjob_cardsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fjob_cardsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id" class="row"<?= $Page->buyer_id->rowAttributes() ?>>
        <label for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_buyer_id"><?= $Page->buyer_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_buyer_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-control ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        data-select2-id="fjob_cardsearch_x_buyer_id"
        data-table="job_card"
        data-field="x_buyer_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<script>
loadjs.ready("fjob_cardsearch", function() {
    var options = { name: "x_buyer_id", selectId: "fjob_cardsearch_x_buyer_id" };
    if (fjob_cardsearch.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fjob_cardsearch" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fjob_cardsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.job_card.fields.buyer_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_to_internal->Visible) { // issue_to_internal ?>
    <div id="r_issue_to_internal" class="row"<?= $Page->issue_to_internal->rowAttributes() ?>>
        <label for="x_issue_to_internal" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_issue_to_internal"><?= $Page->issue_to_internal->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_to_internal" id="z_issue_to_internal" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_to_internal->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_issue_to_internal" class="ew-search-field ew-search-field-single">
    <select
        id="x_issue_to_internal"
        name="x_issue_to_internal"
        class="form-select ew-select<?= $Page->issue_to_internal->isInvalidClass() ?>"
        <?php if (!$Page->issue_to_internal->IsNativeSelect) { ?>
        data-select2-id="fjob_cardsearch_x_issue_to_internal"
        <?php } ?>
        data-table="job_card"
        data-field="x_issue_to_internal"
        data-value-separator="<?= $Page->issue_to_internal->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to_internal->getPlaceHolder()) ?>"
        <?= $Page->issue_to_internal->editAttributes() ?>>
        <?= $Page->issue_to_internal->selectOptionListHtml("x_issue_to_internal") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_to_internal->getErrorMessage(false) ?></div>
<?= $Page->issue_to_internal->Lookup->getParamTag($Page, "p_x_issue_to_internal") ?>
<?php if (!$Page->issue_to_internal->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardsearch", function() {
    var options = { name: "x_issue_to_internal", selectId: "fjob_cardsearch_x_issue_to_internal" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardsearch.lists.issue_to_internal?.lookupOptions.length) {
        options.data = { id: "x_issue_to_internal", form: "fjob_cardsearch" };
    } else {
        options.ajax = { id: "x_issue_to_internal", form: "fjob_cardsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.issue_to_internal.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_to_external->Visible) { // issue_to_external ?>
    <div id="r_issue_to_external" class="row"<?= $Page->issue_to_external->rowAttributes() ?>>
        <label for="x_issue_to_external" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_issue_to_external"><?= $Page->issue_to_external->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_to_external" id="z_issue_to_external" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_to_external->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_issue_to_external" class="ew-search-field ew-search-field-single">
    <select
        id="x_issue_to_external"
        name="x_issue_to_external"
        class="form-select ew-select<?= $Page->issue_to_external->isInvalidClass() ?>"
        <?php if (!$Page->issue_to_external->IsNativeSelect) { ?>
        data-select2-id="fjob_cardsearch_x_issue_to_external"
        <?php } ?>
        data-table="job_card"
        data-field="x_issue_to_external"
        data-value-separator="<?= $Page->issue_to_external->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to_external->getPlaceHolder()) ?>"
        <?= $Page->issue_to_external->editAttributes() ?>>
        <?= $Page->issue_to_external->selectOptionListHtml("x_issue_to_external") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_to_external->getErrorMessage(false) ?></div>
<?= $Page->issue_to_external->Lookup->getParamTag($Page, "p_x_issue_to_external") ?>
<?php if (!$Page->issue_to_external->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardsearch", function() {
    var options = { name: "x_issue_to_external", selectId: "fjob_cardsearch_x_issue_to_external" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardsearch.lists.issue_to_external?.lookupOptions.length) {
        options.data = { id: "x_issue_to_external", form: "fjob_cardsearch" };
    } else {
        options.ajax = { id: "x_issue_to_external", form: "fjob_cardsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.issue_to_external.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
    <div id="r_issue_to" class="row"<?= $Page->issue_to->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_issue_to"><?= $Page->issue_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_issue_to" id="z_issue_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->issue_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_issue_to" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->issue_to->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_issue_to" class="ew-auto-suggest">
    <input type="<?= $Page->issue_to->getInputTextType() ?>" class="form-control" name="sv_x_issue_to" id="sv_x_issue_to" value="<?= RemoveHtml($Page->issue_to->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_to->formatPattern()) ?>"<?= $Page->issue_to->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="job_card" data-field="x_issue_to" data-input="sv_x_issue_to" data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>" name="x_issue_to" id="x_issue_to" value="<?= HtmlEncode($Page->issue_to->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fjob_cardsearch", function() {
    fjob_cardsearch.createAutoSuggest(Object.assign({"id":"x_issue_to","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->issue_to->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.job_card.fields.issue_to.autoSuggestOptions));
});
</script>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fjob_cardsearch_x_grp"
        <?php } ?>
        data-table="job_card"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardsearch", function() {
    var options = { name: "x_grp", selectId: "fjob_cardsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fjob_cardsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fjob_cardsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fjob_cardsearch_x_s_grp"
        <?php } ?>
        data-table="job_card"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardsearch", function() {
    var options = { name: "x_s_grp", selectId: "fjob_cardsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fjob_cardsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fjob_cardsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fjob_cardsearch_x_packing_type"
        <?php } ?>
        data-table="job_card"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardsearch", function() {
    var options = { name: "x_packing_type", selectId: "fjob_cardsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fjob_cardsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fjob_cardsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_product_code" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_code"
        name="x_product_code"
        class="form-control ew-select<?= $Page->product_code->isInvalidClass() ?>"
        data-select2-id="fjob_cardsearch_x_product_code"
        data-table="job_card"
        data-field="x_product_code"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->product_code->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->product_code->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>"
        <?= $Page->product_code->editAttributes() ?>>
        <?= $Page->product_code->selectOptionListHtml("x_product_code") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
<?= $Page->product_code->Lookup->getParamTag($Page, "p_x_product_code") ?>
<script>
loadjs.ready("fjob_cardsearch", function() {
    var options = { name: "x_product_code", selectId: "fjob_cardsearch_x_product_code" };
    if (fjob_cardsearch.lists.product_code?.lookupOptions.length) {
        options.data = { id: "x_product_code", form: "fjob_cardsearch" };
    } else {
        options.ajax = { id: "x_product_code", form: "fjob_cardsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.job_card.fields.product_code.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
    <div id="r_item" class="row"<?= $Page->item->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_item"><?= $Page->item->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_item" id="z_item" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->item->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_item" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->item->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_item" class="ew-auto-suggest">
    <input type="<?= $Page->item->getInputTextType() ?>" class="form-control" name="sv_x_item" id="sv_x_item" value="<?= RemoveHtml($Page->item->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->item->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->item->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->item->formatPattern()) ?>"<?= $Page->item->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="job_card" data-field="x_item" data-input="sv_x_item" data-value-separator="<?= $Page->item->displayValueSeparatorAttribute() ?>" name="x_item" id="x_item" value="<?= HtmlEncode($Page->item->AdvancedSearch->SearchValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Page->item->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fjob_cardsearch", function() {
    fjob_cardsearch.createAutoSuggest(Object.assign({"id":"x_item","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->item->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.job_card.fields.item.autoSuggestOptions));
});
</script>
<?= $Page->item->Lookup->getParamTag($Page, "p_x_item") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->poid->Visible) { // poid ?>
    <div id="r_poid" class="row"<?= $Page->poid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_poid"><?= $Page->poid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_poid" id="z_poid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->poid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_poid" class="ew-search-field ew-search-field-single">
<template id="tp_x_poid">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="job_card" data-field="x_poid" name="x_poid" id="x_poid"<?= $Page->poid->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_poid" class="ew-item-list"></div>
<selection-list hidden
    id="x_poid[]"
    name="x_poid[]"
    value="<?= HtmlEncode($Page->poid->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_poid"
    data-target="dsl_x_poid"
    data-repeatcolumn="1"
    class="form-control<?= $Page->poid->isInvalidClass() ?>"
    data-table="job_card"
    data-field="x_poid"
    data-value-separator="<?= $Page->poid->displayValueSeparatorAttribute() ?>"
    <?= $Page->poid->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->poid->getErrorMessage(false) ?></div>
<?= $Page->poid->Lookup->getParamTag($Page, "p_x_poid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_batch_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-control ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        data-select2-id="fjob_cardsearch_x_batch_no"
        data-table="job_card"
        data-field="x_batch_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->batch_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<script>
loadjs.ready("fjob_cardsearch", function() {
    var options = { name: "x_batch_no", selectId: "fjob_cardsearch_x_batch_no" };
    if (fjob_cardsearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fjob_cardsearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fjob_cardsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.job_card.fields.batch_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="job_card" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pro_unit->Visible) { // pro_unit ?>
    <div id="r_pro_unit" class="row"<?= $Page->pro_unit->rowAttributes() ?>>
        <label for="x_pro_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pro_unit"><?= $Page->pro_unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pro_unit" id="z_pro_unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pro_unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pro_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_pro_unit"
        name="x_pro_unit"
        class="form-select ew-select<?= $Page->pro_unit->isInvalidClass() ?>"
        <?php if (!$Page->pro_unit->IsNativeSelect) { ?>
        data-select2-id="fjob_cardsearch_x_pro_unit"
        <?php } ?>
        data-table="job_card"
        data-field="x_pro_unit"
        data-value-separator="<?= $Page->pro_unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pro_unit->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->pro_unit->editAttributes() ?>>
        <?= $Page->pro_unit->selectOptionListHtml("x_pro_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pro_unit->getErrorMessage(false) ?></div>
<?= $Page->pro_unit->Lookup->getParamTag($Page, "p_x_pro_unit") ?>
<?php if (!$Page->pro_unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardsearch", function() {
    var options = { name: "x_pro_unit", selectId: "fjob_cardsearch_x_pro_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardsearch.lists.pro_unit?.lookupOptions.length) {
        options.data = { id: "x_pro_unit", form: "fjob_cardsearch" };
    } else {
        options.ajax = { id: "x_pro_unit", form: "fjob_cardsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.pro_unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id" class="row"<?= $Page->employee_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_employee_id"><?= $Page->employee_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->employee_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_employee_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_employee_id[]"
        name="x_employee_id[]"
        class="form-control ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        data-select2-id="fjob_cardsearch_x_employee_id[]"
        data-table="job_card"
        data-field="x_employee_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->employee_id->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("x_employee_id[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
<script>
loadjs.ready("fjob_cardsearch", function() {
    var options = { name: "x_employee_id[]", selectId: "fjob_cardsearch_x_employee_id[]" };
    options.multiple = true;
    if (fjob_cardsearch.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "x_employee_id[]", form: "fjob_cardsearch" };
    } else {
        options.ajax = { id: "x_employee_id[]", form: "fjob_cardsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.job_card.fields.employee_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_1->Visible) { // 1 ?>
    <div id="r__1" class="row"<?= $Page->_1->rowAttributes() ?>>
        <label for="x__1" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card__1"><?= $Page->_1->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__1" id="z__1" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_1->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card__1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_1->getInputTextType() ?>" name="x__1" id="x__1" data-table="job_card" data-field="x__1" value="<?= $Page->_1->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_1->formatPattern()) ?>"<?= $Page->_1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_1->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_2->Visible) { // 2 ?>
    <div id="r__2" class="row"<?= $Page->_2->rowAttributes() ?>>
        <label for="x__2" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card__2"><?= $Page->_2->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__2" id="z__2" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_2->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card__2" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_2->getInputTextType() ?>" name="x__2" id="x__2" data-table="job_card" data-field="x__2" value="<?= $Page->_2->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_2->formatPattern()) ?>"<?= $Page->_2->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_2->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_3->Visible) { // 3 ?>
    <div id="r__3" class="row"<?= $Page->_3->rowAttributes() ?>>
        <label for="x__3" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card__3"><?= $Page->_3->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__3" id="z__3" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_3->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card__3" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_3->getInputTextType() ?>" name="x__3" id="x__3" data-table="job_card" data-field="x__3" value="<?= $Page->_3->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_3->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_3->formatPattern()) ?>"<?= $Page->_3->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_3->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_4->Visible) { // 4 ?>
    <div id="r__4" class="row"<?= $Page->_4->rowAttributes() ?>>
        <label for="x__4" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card__4"><?= $Page->_4->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__4" id="z__4" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_4->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card__4" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_4->getInputTextType() ?>" name="x__4" id="x__4" data-table="job_card" data-field="x__4" value="<?= $Page->_4->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_4->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_4->formatPattern()) ?>"<?= $Page->_4->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_4->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_5->Visible) { // 5 ?>
    <div id="r__5" class="row"<?= $Page->_5->rowAttributes() ?>>
        <label for="x__5" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card__5"><?= $Page->_5->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__5" id="z__5" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_5->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card__5" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_5->getInputTextType() ?>" name="x__5" id="x__5" data-table="job_card" data-field="x__5" value="<?= $Page->_5->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_5->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_5->formatPattern()) ?>"<?= $Page->_5->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_5->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_6->Visible) { // 6 ?>
    <div id="r__6" class="row"<?= $Page->_6->rowAttributes() ?>>
        <label for="x__6" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card__6"><?= $Page->_6->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__6" id="z__6" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_6->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card__6" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_6->getInputTextType() ?>" name="x__6" id="x__6" data-table="job_card" data-field="x__6" value="<?= $Page->_6->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_6->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_6->formatPattern()) ?>"<?= $Page->_6->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_6->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_7->Visible) { // 7 ?>
    <div id="r__7" class="row"<?= $Page->_7->rowAttributes() ?>>
        <label for="x__7" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card__7"><?= $Page->_7->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__7" id="z__7" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_7->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card__7" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_7->getInputTextType() ?>" name="x__7" id="x__7" data-table="job_card" data-field="x__7" value="<?= $Page->_7->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_7->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_7->formatPattern()) ?>"<?= $Page->_7->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_7->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_8->Visible) { // 8 ?>
    <div id="r__8" class="row"<?= $Page->_8->rowAttributes() ?>>
        <label for="x__8" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card__8"><?= $Page->_8->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__8" id="z__8" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_8->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card__8" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_8->getInputTextType() ?>" name="x__8" id="x__8" data-table="job_card" data-field="x__8" value="<?= $Page->_8->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_8->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_8->formatPattern()) ?>"<?= $Page->_8->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_8->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other1->Visible) { // other1 ?>
    <div id="r_other1" class="row"<?= $Page->other1->rowAttributes() ?>>
        <label for="x_other1" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_other1"><?= $Page->other1->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_other1" id="z_other1" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other1->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_other1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other1->getInputTextType() ?>" name="x_other1" id="x_other1" data-table="job_card" data-field="x_other1" value="<?= $Page->other1->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->other1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other1->formatPattern()) ?>"<?= $Page->other1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other1->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other2->Visible) { // other2 ?>
    <div id="r_other2" class="row"<?= $Page->other2->rowAttributes() ?>>
        <label for="x_other2" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_other2"><?= $Page->other2->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_other2" id="z_other2" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other2->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_other2" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other2->getInputTextType() ?>" name="x_other2" id="x_other2" data-table="job_card" data-field="x_other2" value="<?= $Page->other2->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->other2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other2->formatPattern()) ?>"<?= $Page->other2->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other2->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fjob_cardsearch_x_operator"
        <?php } ?>
        data-table="job_card"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardsearch", function() {
    var options = { name: "x_operator", selectId: "fjob_cardsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fjob_cardsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fjob_cardsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="job_card" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fjob_cardsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fjob_cardsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fjob_cardsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fjob_cardsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fjob_cardsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("job_card");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
