<?php

namespace PHPMaker2024\fibre;

// Page object
$JobCardPendingQuerySearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { job_card_pending_query: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fjob_card_pending_querysearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fjob_card_pending_querysearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["works", [], fields.works.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["jc_no", [ew.Validators.integer], fields.jc_no.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["emp_name", [], fields.emp_name.isInvalid],
            ["tqty", [ew.Validators.integer], fields.tqty.isInvalid],
            ["count", [ew.Validators.integer], fields.count.isInvalid],
            ["tsqm", [ew.Validators.float], fields.tsqm.isInvalid],
            ["psqm", [ew.Validators.float], fields.psqm.isInvalid],
            ["pending_days", [ew.Validators.integer], fields.pending_days.isInvalid],
            ["design_size", [], fields.design_size.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["plan_week", [ew.Validators.integer], fields.plan_week.isInvalid],
            ["dispatch_date", [], fields.dispatch_date.isInvalid],
            ["loom_no", [], fields.loom_no.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["completed", [], fields.completed.isInvalid],
            ["status", [], fields.status.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "works": <?= $Page->works->toClientList($Page) ?>,
            "emp_name": <?= $Page->emp_name->toClientList($Page) ?>,
            "_barcode": <?= $Page->_barcode->toClientList($Page) ?>,
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "dispatch_date": <?= $Page->dispatch_date->toClientList($Page) ?>,
            "loom_no": <?= $Page->loom_no->toClientList($Page) ?>,
            "completed": <?= $Page->completed->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fjob_card_pending_querysearch" id="fjob_card_pending_querysearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="job_card_pending_query">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->works->Visible) { // works ?>
    <div id="r_works" class="row"<?= $Page->works->rowAttributes() ?>>
        <label for="x_works" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_works"><?= $Page->works->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_works" id="z_works" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->works->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_works"
        name="x_works"
        class="form-select ew-select<?= $Page->works->isInvalidClass() ?>"
        <?php if (!$Page->works->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_works"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_works"
        data-value-separator="<?= $Page->works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->works->getPlaceHolder()) ?>"
        <?= $Page->works->editAttributes() ?>>
        <?= $Page->works->selectOptionListHtml("x_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->works->getErrorMessage(false) ?></div>
<?= $Page->works->Lookup->getParamTag($Page, "p_x_works") ?>
<?php if (!$Page->works->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_works", selectId: "fjob_card_pending_querysearch_x_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.works?.lookupOptions.length) {
        options.data = { id: "x_works", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_works", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_po"><?= $Page->po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="job_card_pending_query" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no" class="row"<?= $Page->jc_no->rowAttributes() ?>>
        <label for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_jc_no"><?= $Page->jc_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_no" id="z_jc_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_jc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="job_card_pending_query" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="job_card_pending_query" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fjob_card_pending_querysearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fjob_card_pending_querysearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emp_name->Visible) { // emp_name ?>
    <div id="r_emp_name" class="row"<?= $Page->emp_name->rowAttributes() ?>>
        <label for="x_emp_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_emp_name"><?= $Page->emp_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_emp_name" id="z_emp_name" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emp_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_emp_name" class="ew-search-field ew-search-field-single">
    <select
        id="x_emp_name[]"
        name="x_emp_name[]"
        class="form-select ew-select<?= $Page->emp_name->isInvalidClass() ?>"
        <?php if (!$Page->emp_name->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_emp_name[]"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_emp_name"
        multiple
        size="1"
        data-value-separator="<?= $Page->emp_name->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->emp_name->getPlaceHolder()) ?>"
        <?= $Page->emp_name->editAttributes() ?>>
        <?= $Page->emp_name->selectOptionListHtml("x_emp_name[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->emp_name->getErrorMessage(false) ?></div>
<?= $Page->emp_name->Lookup->getParamTag($Page, "p_x_emp_name") ?>
<?php if (!$Page->emp_name->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_emp_name[]", selectId: "fjob_card_pending_querysearch_x_emp_name[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.emp_name?.lookupOptions.length) {
        options.data = { id: "x_emp_name[]", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_emp_name[]", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.emp_name.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tqty->Visible) { // tqty ?>
    <div id="r_tqty" class="row"<?= $Page->tqty->rowAttributes() ?>>
        <label for="x_tqty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_tqty"><?= $Page->tqty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_tqty" id="z_tqty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tqty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_tqty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tqty->getInputTextType() ?>" name="x_tqty" id="x_tqty" data-table="job_card_pending_query" data-field="x_tqty" value="<?= $Page->tqty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->tqty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tqty->formatPattern()) ?>"<?= $Page->tqty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tqty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->count->Visible) { // count ?>
    <div id="r_count" class="row"<?= $Page->count->rowAttributes() ?>>
        <label for="x_count" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_count"><?= $Page->count->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_count" id="z_count" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->count->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_count" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->count->getInputTextType() ?>" name="x_count" id="x_count" data-table="job_card_pending_query" data-field="x_count" value="<?= $Page->count->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->count->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->count->formatPattern()) ?>"<?= $Page->count->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->count->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tsqm->Visible) { // tsqm ?>
    <div id="r_tsqm" class="row"<?= $Page->tsqm->rowAttributes() ?>>
        <label for="x_tsqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_tsqm"><?= $Page->tsqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_tsqm" id="z_tsqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tsqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_tsqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tsqm->getInputTextType() ?>" name="x_tsqm" id="x_tsqm" data-table="job_card_pending_query" data-field="x_tsqm" value="<?= $Page->tsqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->tsqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tsqm->formatPattern()) ?>"<?= $Page->tsqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tsqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->psqm->Visible) { // psqm ?>
    <div id="r_psqm" class="row"<?= $Page->psqm->rowAttributes() ?>>
        <label for="x_psqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_psqm"><?= $Page->psqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_psqm" id="z_psqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->psqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_psqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->psqm->getInputTextType() ?>" name="x_psqm" id="x_psqm" data-table="job_card_pending_query" data-field="x_psqm" value="<?= $Page->psqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->psqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->psqm->formatPattern()) ?>"<?= $Page->psqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->psqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pending_days->Visible) { // pending_days ?>
    <div id="r_pending_days" class="row"<?= $Page->pending_days->rowAttributes() ?>>
        <label for="x_pending_days" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_pending_days"><?= $Page->pending_days->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pending_days" id="z_pending_days" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pending_days->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_pending_days" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pending_days->getInputTextType() ?>" name="x_pending_days" id="x_pending_days" data-table="job_card_pending_query" data-field="x_pending_days" value="<?= $Page->pending_days->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_days->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_days->formatPattern()) ?>"<?= $Page->pending_days->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_days->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_size->Visible) { // design_size ?>
    <div id="r_design_size" class="row"<?= $Page->design_size->rowAttributes() ?>>
        <label for="x_design_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_design_size"><?= $Page->design_size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design_size" id="z_design_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_design_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design_size->getInputTextType() ?>" name="x_design_size" id="x_design_size" data-table="job_card_pending_query" data-field="x_design_size" value="<?= $Page->design_size->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->design_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design_size->formatPattern()) ?>"<?= $Page->design_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design_size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query__barcode"><?= $Page->_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query__barcode" class="ew-search-field ew-search-field-single">
    <select
        id="x__barcode[]"
        name="x__barcode[]"
        class="form-select ew-select<?= $Page->_barcode->isInvalidClass() ?>"
        <?php if (!$Page->_barcode->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x__barcode[]"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x__barcode"
        multiple
        size="1"
        data-value-separator="<?= $Page->_barcode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>"
        <?= $Page->_barcode->editAttributes() ?>>
        <?= $Page->_barcode->selectOptionListHtml("x__barcode[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
<?= $Page->_barcode->Lookup->getParamTag($Page, "p_x__barcode") ?>
<?php if (!$Page->_barcode->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x__barcode[]", selectId: "fjob_card_pending_querysearch_x__barcode[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists._barcode?.lookupOptions.length) {
        options.data = { id: "x__barcode[]", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x__barcode[]", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields._barcode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id" class="row"<?= $Page->buyers_id->rowAttributes() ?>>
        <label for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_buyers_id"><?= $Page->buyers_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyers_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_buyers_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_buyers_id"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_buyers_id", selectId: "fjob_card_pending_querysearch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->plan_week->Visible) { // plan_week ?>
    <div id="r_plan_week" class="row"<?= $Page->plan_week->rowAttributes() ?>>
        <label for="x_plan_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_plan_week"><?= $Page->plan_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_plan_week" id="z_plan_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->plan_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_plan_week" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->plan_week->getInputTextType() ?>" name="x_plan_week" id="x_plan_week" data-table="job_card_pending_query" data-field="x_plan_week" value="<?= $Page->plan_week->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->plan_week->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->plan_week->formatPattern()) ?>"<?= $Page->plan_week->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->plan_week->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dispatch_date->Visible) { // dispatch_date ?>
    <div id="r_dispatch_date" class="row"<?= $Page->dispatch_date->rowAttributes() ?>>
        <label for="x_dispatch_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_dispatch_date"><?= $Page->dispatch_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dispatch_date" id="z_dispatch_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dispatch_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_dispatch_date" class="ew-search-field ew-search-field-single">
    <select
        id="x_dispatch_date"
        name="x_dispatch_date"
        class="form-select ew-select<?= $Page->dispatch_date->isInvalidClass() ?>"
        <?php if (!$Page->dispatch_date->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_dispatch_date"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_dispatch_date"
        data-value-separator="<?= $Page->dispatch_date->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->dispatch_date->getPlaceHolder()) ?>"
        <?= $Page->dispatch_date->editAttributes() ?>>
        <?= $Page->dispatch_date->selectOptionListHtml("x_dispatch_date") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->dispatch_date->getErrorMessage(false) ?></div>
<?= $Page->dispatch_date->Lookup->getParamTag($Page, "p_x_dispatch_date") ?>
<?php if (!$Page->dispatch_date->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_dispatch_date", selectId: "fjob_card_pending_querysearch_x_dispatch_date" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.dispatch_date?.lookupOptions.length) {
        options.data = { id: "x_dispatch_date", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_dispatch_date", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.dispatch_date.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->loom_no->Visible) { // loom_no ?>
    <div id="r_loom_no" class="row"<?= $Page->loom_no->rowAttributes() ?>>
        <label for="x_loom_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_loom_no"><?= $Page->loom_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_loom_no" id="z_loom_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->loom_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_loom_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_loom_no"
        name="x_loom_no"
        class="form-select ew-select<?= $Page->loom_no->isInvalidClass() ?>"
        <?php if (!$Page->loom_no->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_loom_no"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_loom_no"
        data-value-separator="<?= $Page->loom_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->loom_no->getPlaceHolder()) ?>"
        <?= $Page->loom_no->editAttributes() ?>>
        <?= $Page->loom_no->selectOptionListHtml("x_loom_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->loom_no->getErrorMessage(false) ?></div>
<?= $Page->loom_no->Lookup->getParamTag($Page, "p_x_loom_no") ?>
<?php if (!$Page->loom_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_loom_no", selectId: "fjob_card_pending_querysearch_x_loom_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.loom_no?.lookupOptions.length) {
        options.data = { id: "x_loom_no", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_loom_no", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.loom_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="job_card_pending_query" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->completed->Visible) { // completed ?>
    <div id="r_completed" class="row"<?= $Page->completed->rowAttributes() ?>>
        <label for="x_completed" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_completed"><?= $Page->completed->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_completed" id="z_completed" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->completed->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_completed" class="ew-search-field ew-search-field-single">
    <select
        id="x_completed"
        name="x_completed"
        class="form-select ew-select<?= $Page->completed->isInvalidClass() ?>"
        <?php if (!$Page->completed->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_completed"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_completed"
        data-value-separator="<?= $Page->completed->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->completed->getPlaceHolder()) ?>"
        <?= $Page->completed->editAttributes() ?>>
        <?= $Page->completed->selectOptionListHtml("x_completed") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->completed->getErrorMessage(false) ?></div>
<?php if (!$Page->completed->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_completed", selectId: "fjob_card_pending_querysearch_x_completed" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.completed?.lookupOptions.length) {
        options.data = { id: "x_completed", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_completed", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.completed.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_job_card_pending_query_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_status" id="z_status" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_job_card_pending_query_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status[]"
        name="x_status[]"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_status[]"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_status"
        multiple
        size="1"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_status[]", selectId: "fjob_card_pending_querysearch_x_status[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status[]", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_status[]", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fjob_card_pending_querysearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fjob_card_pending_querysearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fjob_card_pending_querysearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("job_card_pending_query");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
