<?php

namespace PHPMaker2024\fibre;

// Page object
$JobCardPendingQuerySearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { job_card_pending_query: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fjob_card_pending_querysearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fjob_card_pending_querysearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["works", [], fields.works.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["jc_no", [ew.Validators.integer], fields.jc_no.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["emp_name", [], fields.emp_name.isInvalid],
            ["tqty", [ew.Validators.integer], fields.tqty.isInvalid],
            ["count", [ew.Validators.integer], fields.count.isInvalid],
            ["tsqm", [ew.Validators.float], fields.tsqm.isInvalid],
            ["psqm", [ew.Validators.float], fields.psqm.isInvalid],
            ["pending_days", [ew.Validators.integer], fields.pending_days.isInvalid],
            ["design_size", [], fields.design_size.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["plan_week", [ew.Validators.integer], fields.plan_week.isInvalid],
            ["dispatch_date", [], fields.dispatch_date.isInvalid],
            ["loom_no", [], fields.loom_no.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["completed", [], fields.completed.isInvalid],
            ["status", [], fields.status.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "works": <?= $Page->works->toClientList($Page) ?>,
            "emp_name": <?= $Page->emp_name->toClientList($Page) ?>,
            "_barcode": <?= $Page->_barcode->toClientList($Page) ?>,
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "dispatch_date": <?= $Page->dispatch_date->toClientList($Page) ?>,
            "loom_no": <?= $Page->loom_no->toClientList($Page) ?>,
            "completed": <?= $Page->completed->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fjob_card_pending_querysearch" id="fjob_card_pending_querysearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("jobcardpendingquerylist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="job_card_pending_query">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_job_card_pending_query_works" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_works"
        name="x_works"
        class="form-select ew-select<?= $Page->works->isInvalidClass() ?>"
        <?php if (!$Page->works->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_works"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_works"
        data-value-separator="<?= $Page->works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->works->getPlaceHolder()) ?>"
        <?= $Page->works->editAttributes() ?>>
        <?= $Page->works->selectOptionListHtml("x_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->works->getErrorMessage(false) ?></div>
<?= $Page->works->Lookup->getParamTag($Page, "p_x_works") ?>
<?php if (!$Page->works->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_works", selectId: "fjob_card_pending_querysearch_x_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.works?.lookupOptions.length) {
        options.data = { id: "x_works", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_works", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_pending_query_po" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="job_card_pending_query" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_pending_query_jc_no" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_jc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="job_card_pending_query" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_pending_query_datetime" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="job_card_pending_query" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fjob_card_pending_querysearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fjob_card_pending_querysearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_pending_query_emp_name" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_emp_name" class="ew-search-field ew-search-field-single">
    <select
        id="x_emp_name[]"
        name="x_emp_name[]"
        class="form-select ew-select<?= $Page->emp_name->isInvalidClass() ?>"
        <?php if (!$Page->emp_name->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_emp_name[]"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_emp_name"
        multiple
        size="1"
        data-value-separator="<?= $Page->emp_name->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->emp_name->getPlaceHolder()) ?>"
        <?= $Page->emp_name->editAttributes() ?>>
        <?= $Page->emp_name->selectOptionListHtml("x_emp_name[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->emp_name->getErrorMessage(false) ?></div>
<?= $Page->emp_name->Lookup->getParamTag($Page, "p_x_emp_name") ?>
<?php if (!$Page->emp_name->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_emp_name[]", selectId: "fjob_card_pending_querysearch_x_emp_name[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.emp_name?.lookupOptions.length) {
        options.data = { id: "x_emp_name[]", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_emp_name[]", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.emp_name.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_pending_query_tqty" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_tqty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tqty->getInputTextType() ?>" name="x_tqty" id="x_tqty" data-table="job_card_pending_query" data-field="x_tqty" value="<?= $Page->tqty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->tqty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tqty->formatPattern()) ?>"<?= $Page->tqty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tqty->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_pending_query_count" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_count" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->count->getInputTextType() ?>" name="x_count" id="x_count" data-table="job_card_pending_query" data-field="x_count" value="<?= $Page->count->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->count->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->count->formatPattern()) ?>"<?= $Page->count->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->count->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_pending_query_tsqm" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_tsqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tsqm->getInputTextType() ?>" name="x_tsqm" id="x_tsqm" data-table="job_card_pending_query" data-field="x_tsqm" value="<?= $Page->tsqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->tsqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tsqm->formatPattern()) ?>"<?= $Page->tsqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tsqm->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_pending_query_psqm" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_psqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->psqm->getInputTextType() ?>" name="x_psqm" id="x_psqm" data-table="job_card_pending_query" data-field="x_psqm" value="<?= $Page->psqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->psqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->psqm->formatPattern()) ?>"<?= $Page->psqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->psqm->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_pending_query_pending_days" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_pending_days" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pending_days->getInputTextType() ?>" name="x_pending_days" id="x_pending_days" data-table="job_card_pending_query" data-field="x_pending_days" value="<?= $Page->pending_days->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_days->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_days->formatPattern()) ?>"<?= $Page->pending_days->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_days->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_pending_query_design_size" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_design_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design_size->getInputTextType() ?>" name="x_design_size" id="x_design_size" data-table="job_card_pending_query" data-field="x_design_size" value="<?= $Page->design_size->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->design_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design_size->formatPattern()) ?>"<?= $Page->design_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design_size->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_pending_query__barcode" class="job_card_pending_querysearch"><span id="el_job_card_pending_query__barcode" class="ew-search-field ew-search-field-single">
    <select
        id="x__barcode[]"
        name="x__barcode[]"
        class="form-select ew-select<?= $Page->_barcode->isInvalidClass() ?>"
        <?php if (!$Page->_barcode->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x__barcode[]"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x__barcode"
        multiple
        size="1"
        data-value-separator="<?= $Page->_barcode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>"
        <?= $Page->_barcode->editAttributes() ?>>
        <?= $Page->_barcode->selectOptionListHtml("x__barcode[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
<?= $Page->_barcode->Lookup->getParamTag($Page, "p_x__barcode") ?>
<?php if (!$Page->_barcode->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x__barcode[]", selectId: "fjob_card_pending_querysearch_x__barcode[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists._barcode?.lookupOptions.length) {
        options.data = { id: "x__barcode[]", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x__barcode[]", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields._barcode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_pending_query_buyers_id" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_buyers_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_buyers_id"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_buyers_id", selectId: "fjob_card_pending_querysearch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_pending_query_plan_week" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_plan_week" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->plan_week->getInputTextType() ?>" name="x_plan_week" id="x_plan_week" data-table="job_card_pending_query" data-field="x_plan_week" value="<?= $Page->plan_week->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->plan_week->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->plan_week->formatPattern()) ?>"<?= $Page->plan_week->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->plan_week->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_pending_query_dispatch_date" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_dispatch_date" class="ew-search-field ew-search-field-single">
    <select
        id="x_dispatch_date"
        name="x_dispatch_date"
        class="form-select ew-select<?= $Page->dispatch_date->isInvalidClass() ?>"
        <?php if (!$Page->dispatch_date->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_dispatch_date"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_dispatch_date"
        data-value-separator="<?= $Page->dispatch_date->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->dispatch_date->getPlaceHolder()) ?>"
        <?= $Page->dispatch_date->editAttributes() ?>>
        <?= $Page->dispatch_date->selectOptionListHtml("x_dispatch_date") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->dispatch_date->getErrorMessage(false) ?></div>
<?= $Page->dispatch_date->Lookup->getParamTag($Page, "p_x_dispatch_date") ?>
<?php if (!$Page->dispatch_date->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_dispatch_date", selectId: "fjob_card_pending_querysearch_x_dispatch_date" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.dispatch_date?.lookupOptions.length) {
        options.data = { id: "x_dispatch_date", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_dispatch_date", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.dispatch_date.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_pending_query_loom_no" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_loom_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_loom_no"
        name="x_loom_no"
        class="form-select ew-select<?= $Page->loom_no->isInvalidClass() ?>"
        <?php if (!$Page->loom_no->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_loom_no"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_loom_no"
        data-value-separator="<?= $Page->loom_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->loom_no->getPlaceHolder()) ?>"
        <?= $Page->loom_no->editAttributes() ?>>
        <?= $Page->loom_no->selectOptionListHtml("x_loom_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->loom_no->getErrorMessage(false) ?></div>
<?= $Page->loom_no->Lookup->getParamTag($Page, "p_x_loom_no") ?>
<?php if (!$Page->loom_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_loom_no", selectId: "fjob_card_pending_querysearch_x_loom_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.loom_no?.lookupOptions.length) {
        options.data = { id: "x_loom_no", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_loom_no", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.loom_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_pending_query_operator" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="job_card_pending_query" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_pending_query_completed" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_completed" class="ew-search-field ew-search-field-single">
    <select
        id="x_completed"
        name="x_completed"
        class="form-select ew-select<?= $Page->completed->isInvalidClass() ?>"
        <?php if (!$Page->completed->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_completed"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_completed"
        data-value-separator="<?= $Page->completed->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->completed->getPlaceHolder()) ?>"
        <?= $Page->completed->editAttributes() ?>>
        <?= $Page->completed->selectOptionListHtml("x_completed") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->completed->getErrorMessage(false) ?></div>
<?php if (!$Page->completed->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_completed", selectId: "fjob_card_pending_querysearch_x_completed" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.completed?.lookupOptions.length) {
        options.data = { id: "x_completed", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_completed", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.completed.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_pending_query_status" class="job_card_pending_querysearch"><span id="el_job_card_pending_query_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status[]"
        name="x_status[]"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysearch_x_status[]"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_status"
        multiple
        size="1"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysearch", function() {
    var options = { name: "x_status[]", selectId: "fjob_card_pending_querysearch_x_status[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status[]", form: "fjob_card_pending_querysearch" };
    } else {
        options.ajax = { id: "x_status[]", form: "fjob_card_pending_querysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<div id="job_card_pending_query_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "works",
                type: "integer",
                label: currentTable.fields.works.caption,
                operators: currentTable.fields.works.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.works.validators),
                data: {
                    format: currentTable.fields.works.clientFormatPattern
                }
            },
            {
                id: "po",
                type: "integer",
                label: currentTable.fields.po.caption,
                operators: currentTable.fields.po.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.po.validators),
                data: {
                    format: currentTable.fields.po.clientFormatPattern
                }
            },
            {
                id: "jc_no",
                type: "integer",
                label: currentTable.fields.jc_no.caption,
                operators: currentTable.fields.jc_no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.jc_no.validators),
                data: {
                    format: currentTable.fields.jc_no.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
            {
                id: "emp_name",
                type: "string",
                label: currentTable.fields.emp_name.caption,
                operators: currentTable.fields.emp_name.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.emp_name.validators),
                data: {
                    format: currentTable.fields.emp_name.clientFormatPattern
                }
            },
            {
                id: "tqty",
                type: "integer",
                label: currentTable.fields.tqty.caption,
                operators: currentTable.fields.tqty.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.tqty.validators),
                data: {
                    format: currentTable.fields.tqty.clientFormatPattern
                }
            },
            {
                id: "count",
                type: "integer",
                label: currentTable.fields.count.caption,
                operators: currentTable.fields.count.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.count.validators),
                data: {
                    format: currentTable.fields.count.clientFormatPattern
                }
            },
            {
                id: "tsqm",
                type: "double",
                label: currentTable.fields.tsqm.caption,
                operators: currentTable.fields.tsqm.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.tsqm.validators),
                data: {
                    format: currentTable.fields.tsqm.clientFormatPattern
                }
            },
            {
                id: "psqm",
                type: "double",
                label: currentTable.fields.psqm.caption,
                operators: currentTable.fields.psqm.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.psqm.validators),
                data: {
                    format: currentTable.fields.psqm.clientFormatPattern
                }
            },
            {
                id: "pending_days",
                type: "integer",
                label: currentTable.fields.pending_days.caption,
                operators: currentTable.fields.pending_days.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.pending_days.validators),
                data: {
                    format: currentTable.fields.pending_days.clientFormatPattern
                }
            },
            {
                id: "design_size",
                type: "string",
                label: currentTable.fields.design_size.caption,
                operators: currentTable.fields.design_size.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.design_size.validators),
                data: {
                    format: currentTable.fields.design_size.clientFormatPattern
                }
            },
            {
                id: "_barcode",
                type: "string",
                label: currentTable.fields._barcode.caption,
                operators: currentTable.fields._barcode.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields._barcode.validators),
                data: {
                    format: currentTable.fields._barcode.clientFormatPattern
                }
            },
            {
                id: "buyers_id",
                type: "integer",
                label: currentTable.fields.buyers_id.caption,
                operators: currentTable.fields.buyers_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.buyers_id.validators),
                data: {
                    format: currentTable.fields.buyers_id.clientFormatPattern
                }
            },
            {
                id: "plan_week",
                type: "integer",
                label: currentTable.fields.plan_week.caption,
                operators: currentTable.fields.plan_week.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.plan_week.validators),
                data: {
                    format: currentTable.fields.plan_week.clientFormatPattern
                }
            },
            {
                id: "dispatch_date",
                type: "integer",
                label: currentTable.fields.dispatch_date.caption,
                operators: currentTable.fields.dispatch_date.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.dispatch_date.validators),
                data: {
                    format: currentTable.fields.dispatch_date.clientFormatPattern
                }
            },
            {
                id: "loom_no",
                type: "integer",
                label: currentTable.fields.loom_no.caption,
                operators: currentTable.fields.loom_no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.loom_no.validators),
                data: {
                    format: currentTable.fields.loom_no.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "completed",
                type: "string",
                label: currentTable.fields.completed.caption,
                operators: currentTable.fields.completed.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.completed.validators),
                data: {
                    format: currentTable.fields.completed.clientFormatPattern
                }
            },
            {
                id: "status",
                type: "string",
                label: currentTable.fields.status.caption,
                operators: currentTable.fields.status.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_pending_querysearch.fields.status.validators),
                data: {
                    format: currentTable.fields.status.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#job_card_pending_query_query_builder"),
        args = {},
        rules = ew.parseJson($("#fjob_card_pending_querysearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fjob_card_pending_querysearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fjob_card_pending_querysearch" formaction="<?= HtmlEncode(GetUrl("jobcardpendingquerylist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fjob_card_pending_querysearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fjob_card_pending_querysearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("job_card_pending_query");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
