<?php

namespace PHPMaker2024\fibre;

// Page object
$JobCardPendingQueryList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { job_card_pending_query: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fjob_card_pending_querysrch" id="fjob_card_pending_querysrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fjob_card_pending_querysrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { job_card_pending_query: currentTable } });
var currentForm;
var fjob_card_pending_querysrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fjob_card_pending_querysrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["works", [], fields.works.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["buyers_id", [], fields.buyers_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "works": <?= $Page->works->toClientList($Page) ?>,
            "_barcode": <?= $Page->_barcode->toClientList($Page) ?>,
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->works->Visible) { // works ?>
<?php
if (!$Page->works->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_works" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->works->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_works" class="ew-search-caption ew-label"><?= $Page->works->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_works" id="z_works" value="=">
</div>
        </div>
        <div id="el_job_card_pending_query_works" class="ew-search-field">
    <select
        id="x_works"
        name="x_works"
        class="form-select ew-select<?= $Page->works->isInvalidClass() ?>"
        <?php if (!$Page->works->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysrch_x_works"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_works"
        data-value-separator="<?= $Page->works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->works->getPlaceHolder()) ?>"
        <?= $Page->works->editAttributes() ?>>
        <?= $Page->works->selectOptionListHtml("x_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->works->getErrorMessage(false) ?></div>
<?= $Page->works->Lookup->getParamTag($Page, "p_x_works") ?>
<?php if (!$Page->works->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysrch", function() {
    var options = { name: "x_works", selectId: "fjob_card_pending_querysrch_x_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysrch.lists.works?.lookupOptions.length) {
        options.data = { id: "x_works", form: "fjob_card_pending_querysrch" };
    } else {
        options.ajax = { id: "x_works", form: "fjob_card_pending_querysrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_po" class="ew-search-caption ew-label"><?= $Page->po->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</div>
        </div>
        <div id="el_job_card_pending_query_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="job_card_pending_query" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
<?php
if (!$Page->_barcode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__barcode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_barcode->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x__barcode" class="ew-search-caption ew-label"><?= $Page->_barcode->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="LIKE">
</div>
        </div>
        <div id="el_job_card_pending_query__barcode" class="ew-search-field">
    <select
        id="x__barcode[]"
        name="x__barcode[]"
        class="form-select ew-select<?= $Page->_barcode->isInvalidClass() ?>"
        <?php if (!$Page->_barcode->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysrch_x__barcode[]"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x__barcode"
        multiple
        size="1"
        data-value-separator="<?= $Page->_barcode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>"
        <?= $Page->_barcode->editAttributes() ?>>
        <?= $Page->_barcode->selectOptionListHtml("x__barcode[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
<?= $Page->_barcode->Lookup->getParamTag($Page, "p_x__barcode") ?>
<?php if (!$Page->_barcode->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysrch", function() {
    var options = { name: "x__barcode[]", selectId: "fjob_card_pending_querysrch_x__barcode[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysrch.lists._barcode?.lookupOptions.length) {
        options.data = { id: "x__barcode[]", form: "fjob_card_pending_querysrch" };
    } else {
        options.ajax = { id: "x__barcode[]", form: "fjob_card_pending_querysrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields._barcode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
<?php
if (!$Page->buyers_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyers_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyers_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_buyers_id" class="ew-search-caption ew-label"><?= $Page->buyers_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</div>
        </div>
        <div id="el_job_card_pending_query_buyers_id" class="ew-search-field">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fjob_card_pending_querysrch_x_buyers_id"
        <?php } ?>
        data-table="job_card_pending_query"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_pending_querysrch", function() {
    var options = { name: "x_buyers_id", selectId: "fjob_card_pending_querysrch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_pending_querysrch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fjob_card_pending_querysrch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fjob_card_pending_querysrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_pending_query.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fjob_card_pending_querysrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fjob_card_pending_querysrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fjob_card_pending_querysrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fjob_card_pending_querysrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fjob_card_pending_querysrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fjob_card_pending_querysrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fjob_card_pending_querysrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="job_card_pending_query">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_job_card_pending_query" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_job_card_pending_querylist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->works->Visible) { // works ?>
        <th data-name="works" class="<?= $Page->works->headerCellClass() ?>"><div id="elh_job_card_pending_query_works" class="job_card_pending_query_works"><?= $Page->renderFieldHeader($Page->works) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_job_card_pending_query_po" class="job_card_pending_query_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
        <th data-name="jc_no" class="<?= $Page->jc_no->headerCellClass() ?>"><div id="elh_job_card_pending_query_jc_no" class="job_card_pending_query_jc_no"><?= $Page->renderFieldHeader($Page->jc_no) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_job_card_pending_query_datetime" class="job_card_pending_query_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->emp_name->Visible) { // emp_name ?>
        <th data-name="emp_name" class="<?= $Page->emp_name->headerCellClass() ?>"><div id="elh_job_card_pending_query_emp_name" class="job_card_pending_query_emp_name"><?= $Page->renderFieldHeader($Page->emp_name) ?></div></th>
<?php } ?>
<?php if ($Page->tqty->Visible) { // tqty ?>
        <th data-name="tqty" class="<?= $Page->tqty->headerCellClass() ?>"><div id="elh_job_card_pending_query_tqty" class="job_card_pending_query_tqty"><?= $Page->renderFieldHeader($Page->tqty) ?></div></th>
<?php } ?>
<?php if ($Page->count->Visible) { // count ?>
        <th data-name="count" class="<?= $Page->count->headerCellClass() ?>"><div id="elh_job_card_pending_query_count" class="job_card_pending_query_count"><?= $Page->renderFieldHeader($Page->count) ?></div></th>
<?php } ?>
<?php if ($Page->tsqm->Visible) { // tsqm ?>
        <th data-name="tsqm" class="<?= $Page->tsqm->headerCellClass() ?>"><div id="elh_job_card_pending_query_tsqm" class="job_card_pending_query_tsqm"><?= $Page->renderFieldHeader($Page->tsqm) ?></div></th>
<?php } ?>
<?php if ($Page->psqm->Visible) { // psqm ?>
        <th data-name="psqm" class="<?= $Page->psqm->headerCellClass() ?>"><div id="elh_job_card_pending_query_psqm" class="job_card_pending_query_psqm"><?= $Page->renderFieldHeader($Page->psqm) ?></div></th>
<?php } ?>
<?php if ($Page->pending_days->Visible) { // pending_days ?>
        <th data-name="pending_days" class="<?= $Page->pending_days->headerCellClass() ?>"><div id="elh_job_card_pending_query_pending_days" class="job_card_pending_query_pending_days"><?= $Page->renderFieldHeader($Page->pending_days) ?></div></th>
<?php } ?>
<?php if ($Page->design_size->Visible) { // design_size ?>
        <th data-name="design_size" class="<?= $Page->design_size->headerCellClass() ?>"><div id="elh_job_card_pending_query_design_size" class="job_card_pending_query_design_size"><?= $Page->renderFieldHeader($Page->design_size) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>"><div id="elh_job_card_pending_query__barcode" class="job_card_pending_query__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <th data-name="buyers_id" class="<?= $Page->buyers_id->headerCellClass() ?>"><div id="elh_job_card_pending_query_buyers_id" class="job_card_pending_query_buyers_id"><?= $Page->renderFieldHeader($Page->buyers_id) ?></div></th>
<?php } ?>
<?php if ($Page->plan_week->Visible) { // plan_week ?>
        <th data-name="plan_week" class="<?= $Page->plan_week->headerCellClass() ?>"><div id="elh_job_card_pending_query_plan_week" class="job_card_pending_query_plan_week"><?= $Page->renderFieldHeader($Page->plan_week) ?></div></th>
<?php } ?>
<?php if ($Page->dispatch_date->Visible) { // dispatch_date ?>
        <th data-name="dispatch_date" class="<?= $Page->dispatch_date->headerCellClass() ?>"><div id="elh_job_card_pending_query_dispatch_date" class="job_card_pending_query_dispatch_date"><?= $Page->renderFieldHeader($Page->dispatch_date) ?></div></th>
<?php } ?>
<?php if ($Page->loom_no->Visible) { // loom_no ?>
        <th data-name="loom_no" class="<?= $Page->loom_no->headerCellClass() ?>"><div id="elh_job_card_pending_query_loom_no" class="job_card_pending_query_loom_no"><?= $Page->renderFieldHeader($Page->loom_no) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_job_card_pending_query_operator" class="job_card_pending_query_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->works->Visible) { // works ?>
        <td data-name="works"<?= $Page->works->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_works" class="el_job_card_pending_query_works">
<span<?= $Page->works->viewAttributes() ?>>
<?= $Page->works->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_po" class="el_job_card_pending_query_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_no->Visible) { // jc_no ?>
        <td data-name="jc_no"<?= $Page->jc_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_jc_no" class="el_job_card_pending_query_jc_no">
<span<?= $Page->jc_no->viewAttributes() ?>>
<?php if (!EmptyString($Page->jc_no->getViewValue()) && $Page->jc_no->linkAttributes() != "") { ?>
<a<?= $Page->jc_no->linkAttributes() ?>><?= $Page->jc_no->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->jc_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_datetime" class="el_job_card_pending_query_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->emp_name->Visible) { // emp_name ?>
        <td data-name="emp_name"<?= $Page->emp_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_emp_name" class="el_job_card_pending_query_emp_name">
<span<?= $Page->emp_name->viewAttributes() ?>>
<?= $Page->emp_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->tqty->Visible) { // tqty ?>
        <td data-name="tqty"<?= $Page->tqty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_tqty" class="el_job_card_pending_query_tqty">
<span<?= $Page->tqty->viewAttributes() ?>>
<?= $Page->tqty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->count->Visible) { // count ?>
        <td data-name="count"<?= $Page->count->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_count" class="el_job_card_pending_query_count">
<span<?= $Page->count->viewAttributes() ?>>
<?= $Page->count->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->tsqm->Visible) { // tsqm ?>
        <td data-name="tsqm"<?= $Page->tsqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_tsqm" class="el_job_card_pending_query_tsqm">
<span<?= $Page->tsqm->viewAttributes() ?>>
<?= $Page->tsqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->psqm->Visible) { // psqm ?>
        <td data-name="psqm"<?= $Page->psqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_psqm" class="el_job_card_pending_query_psqm">
<span<?= $Page->psqm->viewAttributes() ?>>
<?= $Page->psqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending_days->Visible) { // pending_days ?>
        <td data-name="pending_days"<?= $Page->pending_days->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_pending_days" class="el_job_card_pending_query_pending_days">
<span<?= $Page->pending_days->viewAttributes() ?>>
<?= $Page->pending_days->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design_size->Visible) { // design_size ?>
        <td data-name="design_size"<?= $Page->design_size->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_design_size" class="el_job_card_pending_query_design_size">
<span<?= $Page->design_size->viewAttributes() ?>>
<?= $Page->design_size->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query__barcode" class="el_job_card_pending_query__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id"<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_buyers_id" class="el_job_card_pending_query_buyers_id">
<span<?= $Page->buyers_id->viewAttributes() ?>>
<?= $Page->buyers_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->plan_week->Visible) { // plan_week ?>
        <td data-name="plan_week"<?= $Page->plan_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_plan_week" class="el_job_card_pending_query_plan_week">
<span<?= $Page->plan_week->viewAttributes() ?>>
<?= $Page->plan_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dispatch_date->Visible) { // dispatch_date ?>
        <td data-name="dispatch_date"<?= $Page->dispatch_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_dispatch_date" class="el_job_card_pending_query_dispatch_date">
<span<?= $Page->dispatch_date->viewAttributes() ?>>
<?= $Page->dispatch_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->loom_no->Visible) { // loom_no ?>
        <td data-name="loom_no"<?= $Page->loom_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_loom_no" class="el_job_card_pending_query_loom_no">
<span<?= $Page->loom_no->viewAttributes() ?>>
<?= $Page->loom_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_pending_query_operator" class="el_job_card_pending_query_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->works->Visible) { // works ?>
        <td data-name="works" class="<?= $Page->works->footerCellClass() ?>"><span id="elf_job_card_pending_query_works" class="job_card_pending_query_works">
        </span></td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po" class="<?= $Page->po->footerCellClass() ?>"><span id="elf_job_card_pending_query_po" class="job_card_pending_query_po">
        </span></td>
    <?php } ?>
    <?php if ($Page->jc_no->Visible) { // jc_no ?>
        <td data-name="jc_no" class="<?= $Page->jc_no->footerCellClass() ?>"><span id="elf_job_card_pending_query_jc_no" class="job_card_pending_query_jc_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Page->datetime->footerCellClass() ?>"><span id="elf_job_card_pending_query_datetime" class="job_card_pending_query_datetime">
        </span></td>
    <?php } ?>
    <?php if ($Page->emp_name->Visible) { // emp_name ?>
        <td data-name="emp_name" class="<?= $Page->emp_name->footerCellClass() ?>"><span id="elf_job_card_pending_query_emp_name" class="job_card_pending_query_emp_name">
        </span></td>
    <?php } ?>
    <?php if ($Page->tqty->Visible) { // tqty ?>
        <td data-name="tqty" class="<?= $Page->tqty->footerCellClass() ?>"><span id="elf_job_card_pending_query_tqty" class="job_card_pending_query_tqty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->tqty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->count->Visible) { // count ?>
        <td data-name="count" class="<?= $Page->count->footerCellClass() ?>"><span id="elf_job_card_pending_query_count" class="job_card_pending_query_count">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->count->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->tsqm->Visible) { // tsqm ?>
        <td data-name="tsqm" class="<?= $Page->tsqm->footerCellClass() ?>"><span id="elf_job_card_pending_query_tsqm" class="job_card_pending_query_tsqm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->tsqm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->psqm->Visible) { // psqm ?>
        <td data-name="psqm" class="<?= $Page->psqm->footerCellClass() ?>"><span id="elf_job_card_pending_query_psqm" class="job_card_pending_query_psqm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->psqm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->pending_days->Visible) { // pending_days ?>
        <td data-name="pending_days" class="<?= $Page->pending_days->footerCellClass() ?>"><span id="elf_job_card_pending_query_pending_days" class="job_card_pending_query_pending_days">
        <span class="ew-aggregate"><?= $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
        <?= $Page->pending_days->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->design_size->Visible) { // design_size ?>
        <td data-name="design_size" class="<?= $Page->design_size->footerCellClass() ?>"><span id="elf_job_card_pending_query_design_size" class="job_card_pending_query_design_size">
        </span></td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode" class="<?= $Page->_barcode->footerCellClass() ?>"><span id="elf_job_card_pending_query__barcode" class="job_card_pending_query__barcode">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id" class="<?= $Page->buyers_id->footerCellClass() ?>"><span id="elf_job_card_pending_query_buyers_id" class="job_card_pending_query_buyers_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->plan_week->Visible) { // plan_week ?>
        <td data-name="plan_week" class="<?= $Page->plan_week->footerCellClass() ?>"><span id="elf_job_card_pending_query_plan_week" class="job_card_pending_query_plan_week">
        </span></td>
    <?php } ?>
    <?php if ($Page->dispatch_date->Visible) { // dispatch_date ?>
        <td data-name="dispatch_date" class="<?= $Page->dispatch_date->footerCellClass() ?>"><span id="elf_job_card_pending_query_dispatch_date" class="job_card_pending_query_dispatch_date">
        </span></td>
    <?php } ?>
    <?php if ($Page->loom_no->Visible) { // loom_no ?>
        <td data-name="loom_no" class="<?= $Page->loom_no->footerCellClass() ?>"><span id="elf_job_card_pending_query_loom_no" class="job_card_pending_query_loom_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator" class="<?= $Page->operator->footerCellClass() ?>"><span id="elf_job_card_pending_query_operator" class="job_card_pending_query_operator">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("job_card_pending_query");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
