<?php

namespace PHPMaker2024\fibre;

// Page object
$JobCardHsAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { job_card_hs: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fjob_card_hsadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fjob_card_hsadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["works", [fields.works.visible && fields.works.required ? ew.Validators.required(fields.works.caption) : null], fields.works.isInvalid],
            ["jc_no_fp", [fields.jc_no_fp.visible && fields.jc_no_fp.required ? ew.Validators.required(fields.jc_no_fp.caption) : null, ew.Validators.integer], fields.jc_no_fp.isInvalid],
            ["item", [fields.item.visible && fields.item.required ? ew.Validators.required(fields.item.caption) : null], fields.item.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null], fields.po.isInvalid],
            ["employee_id", [fields.employee_id.visible && fields.employee_id.required ? ew.Validators.required(fields.employee_id.caption) : null], fields.employee_id.isInvalid],
            ["avl_qty", [fields.avl_qty.visible && fields.avl_qty.required ? ew.Validators.required(fields.avl_qty.caption) : null, ew.Validators.float], fields.avl_qty.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["_1", [fields._1.visible && fields._1.required ? ew.Validators.required(fields._1.caption) : null], fields._1.isInvalid],
            ["_2", [fields._2.visible && fields._2.required ? ew.Validators.required(fields._2.caption) : null], fields._2.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "works": <?= $Page->works->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fjob_card_hsadd" id="fjob_card_hsadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="job_card_hs">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->works->Visible) { // works ?>
    <div id="r_works"<?= $Page->works->rowAttributes() ?>>
        <label id="elh_job_card_hs_works" for="x_works" class="<?= $Page->LeftColumnClass ?>"><?= $Page->works->caption() ?><?= $Page->works->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->works->cellAttributes() ?>>
<span id="el_job_card_hs_works">
    <select
        id="x_works"
        name="x_works"
        class="form-select ew-select<?= $Page->works->isInvalidClass() ?>"
        <?php if (!$Page->works->IsNativeSelect) { ?>
        data-select2-id="fjob_card_hsadd_x_works"
        <?php } ?>
        data-table="job_card_hs"
        data-field="x_works"
        data-value-separator="<?= $Page->works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->works->getPlaceHolder()) ?>"
        <?= $Page->works->editAttributes() ?>>
        <?= $Page->works->selectOptionListHtml("x_works") ?>
    </select>
    <?= $Page->works->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->works->getErrorMessage() ?></div>
<?= $Page->works->Lookup->getParamTag($Page, "p_x_works") ?>
<?php if (!$Page->works->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_hsadd", function() {
    var options = { name: "x_works", selectId: "fjob_card_hsadd_x_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_hsadd.lists.works?.lookupOptions.length) {
        options.data = { id: "x_works", form: "fjob_card_hsadd" };
    } else {
        options.ajax = { id: "x_works", form: "fjob_card_hsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_hs.fields.works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->jc_no_fp->Visible) { // jc_no_fp ?>
    <div id="r_jc_no_fp"<?= $Page->jc_no_fp->rowAttributes() ?>>
        <label id="elh_job_card_hs_jc_no_fp" for="x_jc_no_fp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->jc_no_fp->caption() ?><?= $Page->jc_no_fp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->jc_no_fp->cellAttributes() ?>>
<span id="el_job_card_hs_jc_no_fp">
<input type="<?= $Page->jc_no_fp->getInputTextType() ?>" name="x_jc_no_fp" id="x_jc_no_fp" data-table="job_card_hs" data-field="x_jc_no_fp" value="<?= $Page->jc_no_fp->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no_fp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no_fp->formatPattern()) ?>"<?= $Page->jc_no_fp->editAttributes() ?> aria-describedby="x_jc_no_fp_help">
<?= $Page->jc_no_fp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->jc_no_fp->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
    <div id="r_item"<?= $Page->item->rowAttributes() ?>>
        <label id="elh_job_card_hs_item" for="x_item" class="<?= $Page->LeftColumnClass ?>"><?= $Page->item->caption() ?><?= $Page->item->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->item->cellAttributes() ?>>
<span id="el_job_card_hs_item">
<input type="<?= $Page->item->getInputTextType() ?>" name="x_item" id="x_item" data-table="job_card_hs" data-field="x_item" value="<?= $Page->item->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->item->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->item->formatPattern()) ?>"<?= $Page->item->editAttributes() ?> aria-describedby="x_item_help">
<?= $Page->item->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->item->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no"<?= $Page->batch_no->rowAttributes() ?>>
        <label id="elh_job_card_hs_batch_no" for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->batch_no->caption() ?><?= $Page->batch_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->batch_no->cellAttributes() ?>>
<span id="el_job_card_hs_batch_no">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="fjob_card_hsadd_x_batch_no"
        <?php } ?>
        data-table="job_card_hs"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <?= $Page->batch_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage() ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_hsadd", function() {
    var options = { name: "x_batch_no", selectId: "fjob_card_hsadd_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_hsadd.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fjob_card_hsadd" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fjob_card_hsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_hs.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po"<?= $Page->po->rowAttributes() ?>>
        <label id="elh_job_card_hs_po" for="x_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po->caption() ?><?= $Page->po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po->cellAttributes() ?>>
<span id="el_job_card_hs_po">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="job_card_hs" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?> aria-describedby="x_po_help">
<?= $Page->po->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id"<?= $Page->employee_id->rowAttributes() ?>>
        <label id="elh_job_card_hs_employee_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_id->caption() ?><?= $Page->employee_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_id->cellAttributes() ?>>
<span id="el_job_card_hs_employee_id">
<div class="input-group flex-nowrap">
    <select
        id="x_employee_id"
        name="x_employee_id"
        class="form-control ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        data-select2-id="fjob_card_hsadd_x_employee_id"
        data-table="job_card_hs"
        data-field="x_employee_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->employee_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("x_employee_id") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "production_employee_hs") && !$Page->employee_id->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_employee_id" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->employee_id->caption() ?>" data-title="<?= $Page->employee_id->caption() ?>" data-ew-action="add-option" data-el="x_employee_id" data-url="<?= GetUrl("productionemployeehsaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->employee_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage() ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
<script>
loadjs.ready("fjob_card_hsadd", function() {
    var options = { name: "x_employee_id", selectId: "fjob_card_hsadd_x_employee_id" };
    if (fjob_card_hsadd.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "x_employee_id", form: "fjob_card_hsadd" };
    } else {
        options.ajax = { id: "x_employee_id", form: "fjob_card_hsadd", limit: 3 };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.job_card_hs.fields.employee_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->avl_qty->Visible) { // avl_qty ?>
    <div id="r_avl_qty"<?= $Page->avl_qty->rowAttributes() ?>>
        <label id="elh_job_card_hs_avl_qty" for="x_avl_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->avl_qty->caption() ?><?= $Page->avl_qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->avl_qty->cellAttributes() ?>>
<span id="el_job_card_hs_avl_qty">
<input type="<?= $Page->avl_qty->getInputTextType() ?>" name="x_avl_qty" id="x_avl_qty" data-table="job_card_hs" data-field="x_avl_qty" value="<?= $Page->avl_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->avl_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->avl_qty->formatPattern()) ?>"<?= $Page->avl_qty->editAttributes() ?> aria-describedby="x_avl_qty_help">
<?= $Page->avl_qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->avl_qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_job_card_hs_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_job_card_hs_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="job_card_hs" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_1->Visible) { // 1 ?>
    <div id="r__1"<?= $Page->_1->rowAttributes() ?>>
        <label id="elh_job_card_hs__1" for="x__1" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_1->caption() ?><?= $Page->_1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_1->cellAttributes() ?>>
<span id="el_job_card_hs__1">
<input type="<?= $Page->_1->getInputTextType() ?>" name="x__1" id="x__1" data-table="job_card_hs" data-field="x__1" value="<?= $Page->_1->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_1->formatPattern()) ?>"<?= $Page->_1->editAttributes() ?> aria-describedby="x__1_help">
<?= $Page->_1->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_1->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_2->Visible) { // 2 ?>
    <div id="r__2"<?= $Page->_2->rowAttributes() ?>>
        <label id="elh_job_card_hs__2" for="x__2" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_2->caption() ?><?= $Page->_2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_2->cellAttributes() ?>>
<span id="el_job_card_hs__2">
<input type="<?= $Page->_2->getInputTextType() ?>" name="x__2" id="x__2" data-table="job_card_hs" data-field="x__2" value="<?= $Page->_2->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_2->formatPattern()) ?>"<?= $Page->_2->editAttributes() ?> aria-describedby="x__2_help">
<?= $Page->_2->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_2->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fjob_card_hsadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fjob_card_hsadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("job_card_hs");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
