<?php

namespace PHPMaker2024\fibre;

// Page object
$JobCardFList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { job_card_f: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fjob_card_fsrch" id="fjob_card_fsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fjob_card_fsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { job_card_f: currentTable } });
var currentForm;
var fjob_card_fsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fjob_card_fsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["employee_id", [], fields.employee_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
<?php
if (!$Page->employee_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_employee_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->employee_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_employee_id" class="ew-search-caption ew-label"><?= $Page->employee_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE">
</div>
        </div>
        <div id="el_job_card_f_employee_id" class="ew-search-field">
<input type="<?= $Page->employee_id->getInputTextType() ?>" name="x_employee_id" id="x_employee_id" data-table="job_card_f" data-field="x_employee_id" value="<?= $Page->employee_id->EditValue ?>" size="30" maxlength="25" placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_id->formatPattern()) ?>"<?= $Page->employee_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fjob_card_fsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fjob_card_fsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fjob_card_fsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fjob_card_fsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fjob_card_fsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fjob_card_fsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fjob_card_fsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="job_card_f">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_job_card_f" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_job_card_flist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_job_card_f_id" class="job_card_f_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_job_card_f_grp" class="job_card_f_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
        <th data-name="employee_id" class="<?= $Page->employee_id->headerCellClass() ?>"><div id="elh_job_card_f_employee_id" class="job_card_f_employee_id"><?= $Page->renderFieldHeader($Page->employee_id) ?></div></th>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
        <th data-name="lot_no" class="<?= $Page->lot_no->headerCellClass() ?>"><div id="elh_job_card_f_lot_no" class="job_card_f_lot_no"><?= $Page->renderFieldHeader($Page->lot_no) ?></div></th>
<?php } ?>
<?php if ($Page->_1->Visible) { // 1 ?>
        <th data-name="_1" class="<?= $Page->_1->headerCellClass() ?>"><div id="elh_job_card_f__1" class="job_card_f__1"><?= $Page->renderFieldHeader($Page->_1) ?></div></th>
<?php } ?>
<?php if ($Page->_2->Visible) { // 2 ?>
        <th data-name="_2" class="<?= $Page->_2->headerCellClass() ?>"><div id="elh_job_card_f__2" class="job_card_f__2"><?= $Page->renderFieldHeader($Page->_2) ?></div></th>
<?php } ?>
<?php if ($Page->_3->Visible) { // 3 ?>
        <th data-name="_3" class="<?= $Page->_3->headerCellClass() ?>"><div id="elh_job_card_f__3" class="job_card_f__3"><?= $Page->renderFieldHeader($Page->_3) ?></div></th>
<?php } ?>
<?php if ($Page->_4->Visible) { // 4 ?>
        <th data-name="_4" class="<?= $Page->_4->headerCellClass() ?>"><div id="elh_job_card_f__4" class="job_card_f__4"><?= $Page->renderFieldHeader($Page->_4) ?></div></th>
<?php } ?>
<?php if ($Page->_5->Visible) { // 5 ?>
        <th data-name="_5" class="<?= $Page->_5->headerCellClass() ?>"><div id="elh_job_card_f__5" class="job_card_f__5"><?= $Page->renderFieldHeader($Page->_5) ?></div></th>
<?php } ?>
<?php if ($Page->_6->Visible) { // 6 ?>
        <th data-name="_6" class="<?= $Page->_6->headerCellClass() ?>"><div id="elh_job_card_f__6" class="job_card_f__6"><?= $Page->renderFieldHeader($Page->_6) ?></div></th>
<?php } ?>
<?php if ($Page->_7->Visible) { // 7 ?>
        <th data-name="_7" class="<?= $Page->_7->headerCellClass() ?>"><div id="elh_job_card_f__7" class="job_card_f__7"><?= $Page->renderFieldHeader($Page->_7) ?></div></th>
<?php } ?>
<?php if ($Page->_8->Visible) { // 8 ?>
        <th data-name="_8" class="<?= $Page->_8->headerCellClass() ?>"><div id="elh_job_card_f__8" class="job_card_f__8"><?= $Page->renderFieldHeader($Page->_8) ?></div></th>
<?php } ?>
<?php if ($Page->other1->Visible) { // other1 ?>
        <th data-name="other1" class="<?= $Page->other1->headerCellClass() ?>"><div id="elh_job_card_f_other1" class="job_card_f_other1"><?= $Page->renderFieldHeader($Page->other1) ?></div></th>
<?php } ?>
<?php if ($Page->other2->Visible) { // other2 ?>
        <th data-name="other2" class="<?= $Page->other2->headerCellClass() ?>"><div id="elh_job_card_f_other2" class="job_card_f_other2"><?= $Page->renderFieldHeader($Page->other2) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_job_card_f_operator" class="job_card_f_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->updated->Visible) { // updated ?>
        <th data-name="updated" class="<?= $Page->updated->headerCellClass() ?>"><div id="elh_job_card_f_updated" class="job_card_f_updated"><?= $Page->renderFieldHeader($Page->updated) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_job_card_f_datetime" class="job_card_f_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
        <th data-name="jc_no" class="<?= $Page->jc_no->headerCellClass() ?>"><div id="elh_job_card_f_jc_no" class="job_card_f_jc_no"><?= $Page->renderFieldHeader($Page->jc_no) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>"><div id="elh_job_card_f_s_grp" class="job_card_f_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
        <th data-name="item" class="<?= $Page->item->headerCellClass() ?>"><div id="elh_job_card_f_item" class="job_card_f_item"><?= $Page->renderFieldHeader($Page->item) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_job_card_f_batch_no" class="job_card_f_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->poid->Visible) { // poid ?>
        <th data-name="poid" class="<?= $Page->poid->headerCellClass() ?>"><div id="elh_job_card_f_poid" class="job_card_f_poid"><?= $Page->renderFieldHeader($Page->poid) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_job_card_f_quantity" class="job_card_f_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->pro_unit->Visible) { // pro_unit ?>
        <th data-name="pro_unit" class="<?= $Page->pro_unit->headerCellClass() ?>"><div id="elh_job_card_f_pro_unit" class="job_card_f_pro_unit"><?= $Page->renderFieldHeader($Page->pro_unit) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_id" class="el_job_card_f_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_grp" class="el_job_card_f_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->employee_id->Visible) { // employee_id ?>
        <td data-name="employee_id"<?= $Page->employee_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_employee_id" class="el_job_card_f_employee_id">
<span<?= $Page->employee_id->viewAttributes() ?>>
<?= $Page->employee_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no"<?= $Page->lot_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_lot_no" class="el_job_card_f_lot_no">
<span<?= $Page->lot_no->viewAttributes() ?>>
<?= $Page->lot_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_1->Visible) { // 1 ?>
        <td data-name="_1"<?= $Page->_1->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f__1" class="el_job_card_f__1">
<span<?= $Page->_1->viewAttributes() ?>>
<?= $Page->_1->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_2->Visible) { // 2 ?>
        <td data-name="_2"<?= $Page->_2->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f__2" class="el_job_card_f__2">
<span<?= $Page->_2->viewAttributes() ?>>
<?= $Page->_2->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_3->Visible) { // 3 ?>
        <td data-name="_3"<?= $Page->_3->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f__3" class="el_job_card_f__3">
<span<?= $Page->_3->viewAttributes() ?>>
<?= $Page->_3->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_4->Visible) { // 4 ?>
        <td data-name="_4"<?= $Page->_4->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f__4" class="el_job_card_f__4">
<span<?= $Page->_4->viewAttributes() ?>>
<?= $Page->_4->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_5->Visible) { // 5 ?>
        <td data-name="_5"<?= $Page->_5->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f__5" class="el_job_card_f__5">
<span<?= $Page->_5->viewAttributes() ?>>
<?= $Page->_5->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_6->Visible) { // 6 ?>
        <td data-name="_6"<?= $Page->_6->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f__6" class="el_job_card_f__6">
<span<?= $Page->_6->viewAttributes() ?>>
<?= $Page->_6->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_7->Visible) { // 7 ?>
        <td data-name="_7"<?= $Page->_7->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f__7" class="el_job_card_f__7">
<span<?= $Page->_7->viewAttributes() ?>>
<?= $Page->_7->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_8->Visible) { // 8 ?>
        <td data-name="_8"<?= $Page->_8->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f__8" class="el_job_card_f__8">
<span<?= $Page->_8->viewAttributes() ?>>
<?= $Page->_8->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->other1->Visible) { // other1 ?>
        <td data-name="other1"<?= $Page->other1->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_other1" class="el_job_card_f_other1">
<span<?= $Page->other1->viewAttributes() ?>>
<?= $Page->other1->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->other2->Visible) { // other2 ?>
        <td data-name="other2"<?= $Page->other2->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_other2" class="el_job_card_f_other2">
<span<?= $Page->other2->viewAttributes() ?>>
<?= $Page->other2->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_operator" class="el_job_card_f_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->updated->Visible) { // updated ?>
        <td data-name="updated"<?= $Page->updated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_updated" class="el_job_card_f_updated">
<span<?= $Page->updated->viewAttributes() ?>>
<?= $Page->updated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_datetime" class="el_job_card_f_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_no->Visible) { // jc_no ?>
        <td data-name="jc_no"<?= $Page->jc_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_jc_no" class="el_job_card_f_jc_no">
<span<?= $Page->jc_no->viewAttributes() ?>>
<?= $Page->jc_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_s_grp" class="el_job_card_f_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?= $Page->s_grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->item->Visible) { // item ?>
        <td data-name="item"<?= $Page->item->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_item" class="el_job_card_f_item">
<span<?= $Page->item->viewAttributes() ?>>
<?= $Page->item->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_batch_no" class="el_job_card_f_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?= $Page->batch_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->poid->Visible) { // poid ?>
        <td data-name="poid"<?= $Page->poid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_poid" class="el_job_card_f_poid">
<span<?= $Page->poid->viewAttributes() ?>>
<?= $Page->poid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_quantity" class="el_job_card_f_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pro_unit->Visible) { // pro_unit ?>
        <td data-name="pro_unit"<?= $Page->pro_unit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_job_card_f_pro_unit" class="el_job_card_f_pro_unit">
<span<?= $Page->pro_unit->viewAttributes() ?>>
<?= $Page->pro_unit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("job_card_f");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    $("#elh_job_card_f__1").html("<?php echo PageDesc(1,'d_01_head')['d_01_head'] ?>");
    $("#elh_job_card_f__2").html("<?php echo PageDesc(1,'d_02_head')['d_02_head'] ?>");
    $("#elh_job_card_f__3").html("<?php echo PageDesc(1,'d_03_head')['d_03_head'] ?>");
    $("#elh_job_card_f__4").html("<?php echo PageDesc(1,'d_04_head')['d_04_head'] ?>");
    $("#elh_job_card_f__5").html("<?php echo PageDesc(1,'d_05_head')['d_05_head'] ?>");
    $("#elh_job_card_f__6").html("<?php echo PageDesc(1,'d_06_head')['d_06_head'] ?>");
    $("#elh_job_card_f__7").html("<?php echo PageDesc(1,'d_07_head')['d_07_head'] ?>");
    $("#elh_job_card_f__8").html("<?php echo PageDesc(1,'d_08_head')['d_08_head'] ?>");
});
</script>
<?php } ?>
