<?php

namespace PHPMaker2024\fibre;

// Page object
$JobCardEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fjob_cardedit" id="fjob_cardedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { job_card: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fjob_cardedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fjob_cardedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null], fields.company_id.isInvalid],
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null], fields.buyer_id.isInvalid],
            ["works", [fields.works.visible && fields.works.required ? ew.Validators.required(fields.works.caption) : null], fields.works.isInvalid],
            ["issue_to_internal", [fields.issue_to_internal.visible && fields.issue_to_internal.required ? ew.Validators.required(fields.issue_to_internal.caption) : null], fields.issue_to_internal.isInvalid],
            ["issue_to_external", [fields.issue_to_external.visible && fields.issue_to_external.required ? ew.Validators.required(fields.issue_to_external.caption) : null], fields.issue_to_external.isInvalid],
            ["issue_to", [fields.issue_to.visible && fields.issue_to.required ? ew.Validators.required(fields.issue_to.caption) : null, ew.Validators.integer], fields.issue_to.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["product_code", [fields.product_code.visible && fields.product_code.required ? ew.Validators.required(fields.product_code.caption) : null], fields.product_code.isInvalid],
            ["item", [fields.item.visible && fields.item.required ? ew.Validators.required(fields.item.caption) : null], fields.item.isInvalid],
            ["poid", [fields.poid.visible && fields.poid.required ? ew.Validators.required(fields.poid.caption) : null], fields.poid.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["pro_unit", [fields.pro_unit.visible && fields.pro_unit.required ? ew.Validators.required(fields.pro_unit.caption) : null], fields.pro_unit.isInvalid],
            ["employee_id", [fields.employee_id.visible && fields.employee_id.required ? ew.Validators.required(fields.employee_id.caption) : null], fields.employee_id.isInvalid],
            ["_1", [fields._1.visible && fields._1.required ? ew.Validators.required(fields._1.caption) : null], fields._1.isInvalid],
            ["_2", [fields._2.visible && fields._2.required ? ew.Validators.required(fields._2.caption) : null], fields._2.isInvalid],
            ["_3", [fields._3.visible && fields._3.required ? ew.Validators.required(fields._3.caption) : null], fields._3.isInvalid],
            ["_4", [fields._4.visible && fields._4.required ? ew.Validators.required(fields._4.caption) : null], fields._4.isInvalid],
            ["_5", [fields._5.visible && fields._5.required ? ew.Validators.required(fields._5.caption) : null], fields._5.isInvalid],
            ["_6", [fields._6.visible && fields._6.required ? ew.Validators.required(fields._6.caption) : null], fields._6.isInvalid],
            ["_7", [fields._7.visible && fields._7.required ? ew.Validators.required(fields._7.caption) : null], fields._7.isInvalid],
            ["_8", [fields._8.visible && fields._8.required ? ew.Validators.required(fields._8.caption) : null], fields._8.isInvalid],
            ["other1", [fields.other1.visible && fields.other1.required ? ew.Validators.required(fields.other1.caption) : null], fields.other1.isInvalid],
            ["other2", [fields.other2.visible && fields.other2.required ? ew.Validators.required(fields.other2.caption) : null], fields.other2.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "works": <?= $Page->works->toClientList($Page) ?>,
            "issue_to_internal": <?= $Page->issue_to_internal->toClientList($Page) ?>,
            "issue_to_external": <?= $Page->issue_to_external->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "product_code": <?= $Page->product_code->toClientList($Page) ?>,
            "item": <?= $Page->item->toClientList($Page) ?>,
            "poid": <?= $Page->poid->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "pro_unit": <?= $Page->pro_unit->toClientList($Page) ?>,
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="job_card">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_job_card_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_job_card_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="job_card" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label id="elh_job_card_company_id" for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->company_id->caption() ?><?= $Page->company_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->company_id->cellAttributes() ?>>
<span id="el_job_card_company_id">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fjob_cardedit_x_company_id"
        <?php } ?>
        data-table="job_card"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <?= $Page->company_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage() ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardedit", function() {
    var options = { name: "x_company_id", selectId: "fjob_cardedit_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardedit.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fjob_cardedit" };
    } else {
        options.ajax = { id: "x_company_id", form: "fjob_cardedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id"<?= $Page->buyer_id->rowAttributes() ?>>
        <label id="elh_job_card_buyer_id" for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_id->caption() ?><?= $Page->buyer_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el_job_card_buyer_id">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-control ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        data-select2-id="fjob_cardedit_x_buyer_id"
        data-table="job_card"
        data-field="x_buyer_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <?= $Page->buyer_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage() ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<script>
loadjs.ready("fjob_cardedit", function() {
    var options = { name: "x_buyer_id", selectId: "fjob_cardedit_x_buyer_id" };
    if (fjob_cardedit.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fjob_cardedit" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fjob_cardedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.job_card.fields.buyer_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->works->Visible) { // works ?>
    <div id="r_works"<?= $Page->works->rowAttributes() ?>>
        <label id="elh_job_card_works" for="x_works" class="<?= $Page->LeftColumnClass ?>"><?= $Page->works->caption() ?><?= $Page->works->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->works->cellAttributes() ?>>
<span id="el_job_card_works">
    <select
        id="x_works"
        name="x_works"
        class="form-select ew-select<?= $Page->works->isInvalidClass() ?>"
        <?php if (!$Page->works->IsNativeSelect) { ?>
        data-select2-id="fjob_cardedit_x_works"
        <?php } ?>
        data-table="job_card"
        data-field="x_works"
        data-value-separator="<?= $Page->works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->works->getPlaceHolder()) ?>"
        <?= $Page->works->editAttributes() ?>>
        <?= $Page->works->selectOptionListHtml("x_works") ?>
    </select>
    <?= $Page->works->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->works->getErrorMessage() ?></div>
<?php if (!$Page->works->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardedit", function() {
    var options = { name: "x_works", selectId: "fjob_cardedit_x_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardedit.lists.works?.lookupOptions.length) {
        options.data = { id: "x_works", form: "fjob_cardedit" };
    } else {
        options.ajax = { id: "x_works", form: "fjob_cardedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_to_internal->Visible) { // issue_to_internal ?>
    <div id="r_issue_to_internal"<?= $Page->issue_to_internal->rowAttributes() ?>>
        <label id="elh_job_card_issue_to_internal" for="x_issue_to_internal" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_to_internal->caption() ?><?= $Page->issue_to_internal->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_to_internal->cellAttributes() ?>>
<span id="el_job_card_issue_to_internal">
    <select
        id="x_issue_to_internal"
        name="x_issue_to_internal"
        class="form-select ew-select<?= $Page->issue_to_internal->isInvalidClass() ?>"
        <?php if (!$Page->issue_to_internal->IsNativeSelect) { ?>
        data-select2-id="fjob_cardedit_x_issue_to_internal"
        <?php } ?>
        data-table="job_card"
        data-field="x_issue_to_internal"
        data-value-separator="<?= $Page->issue_to_internal->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to_internal->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->issue_to_internal->editAttributes() ?>>
        <?= $Page->issue_to_internal->selectOptionListHtml("x_issue_to_internal") ?>
    </select>
    <?= $Page->issue_to_internal->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->issue_to_internal->getErrorMessage() ?></div>
<?= $Page->issue_to_internal->Lookup->getParamTag($Page, "p_x_issue_to_internal") ?>
<?php if (!$Page->issue_to_internal->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardedit", function() {
    var options = { name: "x_issue_to_internal", selectId: "fjob_cardedit_x_issue_to_internal" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardedit.lists.issue_to_internal?.lookupOptions.length) {
        options.data = { id: "x_issue_to_internal", form: "fjob_cardedit" };
    } else {
        options.ajax = { id: "x_issue_to_internal", form: "fjob_cardedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.issue_to_internal.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_to_external->Visible) { // issue_to_external ?>
    <div id="r_issue_to_external"<?= $Page->issue_to_external->rowAttributes() ?>>
        <label id="elh_job_card_issue_to_external" for="x_issue_to_external" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_to_external->caption() ?><?= $Page->issue_to_external->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_to_external->cellAttributes() ?>>
<span id="el_job_card_issue_to_external">
    <select
        id="x_issue_to_external"
        name="x_issue_to_external"
        class="form-select ew-select<?= $Page->issue_to_external->isInvalidClass() ?>"
        <?php if (!$Page->issue_to_external->IsNativeSelect) { ?>
        data-select2-id="fjob_cardedit_x_issue_to_external"
        <?php } ?>
        data-table="job_card"
        data-field="x_issue_to_external"
        data-value-separator="<?= $Page->issue_to_external->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to_external->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->issue_to_external->editAttributes() ?>>
        <?= $Page->issue_to_external->selectOptionListHtml("x_issue_to_external") ?>
    </select>
    <?= $Page->issue_to_external->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->issue_to_external->getErrorMessage() ?></div>
<?= $Page->issue_to_external->Lookup->getParamTag($Page, "p_x_issue_to_external") ?>
<?php if (!$Page->issue_to_external->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardedit", function() {
    var options = { name: "x_issue_to_external", selectId: "fjob_cardedit_x_issue_to_external" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardedit.lists.issue_to_external?.lookupOptions.length) {
        options.data = { id: "x_issue_to_external", form: "fjob_cardedit" };
    } else {
        options.ajax = { id: "x_issue_to_external", form: "fjob_cardedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.issue_to_external.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
    <div id="r_issue_to"<?= $Page->issue_to->rowAttributes() ?>>
        <label id="elh_job_card_issue_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_to->caption() ?><?= $Page->issue_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_to->cellAttributes() ?>>
<span id="el_job_card_issue_to">
<?php
if (IsRTL()) {
    $Page->issue_to->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_issue_to" class="ew-auto-suggest">
    <input type="<?= $Page->issue_to->getInputTextType() ?>" class="form-control" name="sv_x_issue_to" id="sv_x_issue_to" value="<?= RemoveHtml($Page->issue_to->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->issue_to->formatPattern()) ?>"<?= $Page->issue_to->editAttributes() ?> aria-describedby="x_issue_to_help">
</span>
<selection-list hidden class="form-control" data-table="job_card" data-field="x_issue_to" data-input="sv_x_issue_to" data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>" name="x_issue_to" id="x_issue_to" value="<?= HtmlEncode($Page->issue_to->CurrentValue) ?>"></selection-list>
<?= $Page->issue_to->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage() ?></div>
<script>
loadjs.ready("fjob_cardedit", function() {
    fjob_cardedit.createAutoSuggest(Object.assign({"id":"x_issue_to","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->issue_to->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.job_card.fields.issue_to.autoSuggestOptions));
});
</script>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_job_card_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_job_card_grp">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fjob_cardedit_x_grp"
        <?php } ?>
        data-table="job_card"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardedit", function() {
    var options = { name: "x_grp", selectId: "fjob_cardedit_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardedit.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fjob_cardedit" };
    } else {
        options.ajax = { id: "x_grp", form: "fjob_cardedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_job_card_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_job_card_s_grp">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fjob_cardedit_x_s_grp"
        <?php } ?>
        data-table="job_card"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <?= $Page->s_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardedit", function() {
    var options = { name: "x_s_grp", selectId: "fjob_cardedit_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardedit.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fjob_cardedit" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fjob_cardedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type"<?= $Page->packing_type->rowAttributes() ?>>
        <label id="elh_job_card_packing_type" for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing_type->caption() ?><?= $Page->packing_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing_type->cellAttributes() ?>>
<span id="el_job_card_packing_type">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fjob_cardedit_x_packing_type"
        <?php } ?>
        data-table="job_card"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <?= $Page->packing_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage() ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardedit", function() {
    var options = { name: "x_packing_type", selectId: "fjob_cardedit_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardedit.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fjob_cardedit" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fjob_cardedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code"<?= $Page->product_code->rowAttributes() ?>>
        <label id="elh_job_card_product_code" for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_code->caption() ?><?= $Page->product_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_code->cellAttributes() ?>>
<span id="el_job_card_product_code">
    <select
        id="x_product_code"
        name="x_product_code"
        class="form-control ew-select<?= $Page->product_code->isInvalidClass() ?>"
        data-select2-id="fjob_cardedit_x_product_code"
        data-table="job_card"
        data-field="x_product_code"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->product_code->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->product_code->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->product_code->editAttributes() ?>>
        <?= $Page->product_code->selectOptionListHtml("x_product_code") ?>
    </select>
    <?= $Page->product_code->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product_code->getErrorMessage() ?></div>
<?= $Page->product_code->Lookup->getParamTag($Page, "p_x_product_code") ?>
<script>
loadjs.ready("fjob_cardedit", function() {
    var options = { name: "x_product_code", selectId: "fjob_cardedit_x_product_code" };
    if (fjob_cardedit.lists.product_code?.lookupOptions.length) {
        options.data = { id: "x_product_code", form: "fjob_cardedit" };
    } else {
        options.ajax = { id: "x_product_code", form: "fjob_cardedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.job_card.fields.product_code.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
    <div id="r_item"<?= $Page->item->rowAttributes() ?>>
        <label id="elh_job_card_item" class="<?= $Page->LeftColumnClass ?>"><?= $Page->item->caption() ?><?= $Page->item->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->item->cellAttributes() ?>>
<span id="el_job_card_item">
<?php
if (IsRTL()) {
    $Page->item->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_item" class="ew-auto-suggest">
    <input type="<?= $Page->item->getInputTextType() ?>" class="form-control" name="sv_x_item" id="sv_x_item" value="<?= RemoveHtml($Page->item->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->item->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->item->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->item->formatPattern()) ?>"<?= $Page->item->editAttributes() ?> aria-describedby="x_item_help">
</span>
<selection-list hidden class="form-control" data-table="job_card" data-field="x_item" data-input="sv_x_item" data-value-separator="<?= $Page->item->displayValueSeparatorAttribute() ?>" name="x_item" id="x_item" value="<?= HtmlEncode($Page->item->CurrentValue) ?>" data-ew-action="update-options"></selection-list>
<?= $Page->item->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->item->getErrorMessage() ?></div>
<script>
loadjs.ready("fjob_cardedit", function() {
    fjob_cardedit.createAutoSuggest(Object.assign({"id":"x_item","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->item->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.job_card.fields.item.autoSuggestOptions));
});
</script>
<?= $Page->item->Lookup->getParamTag($Page, "p_x_item") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->poid->Visible) { // poid ?>
    <div id="r_poid"<?= $Page->poid->rowAttributes() ?>>
        <label id="elh_job_card_poid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->poid->caption() ?><?= $Page->poid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->poid->cellAttributes() ?>>
<span id="el_job_card_poid">
<template id="tp_x_poid">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="job_card" data-field="x_poid" name="x_poid" id="x_poid"<?= $Page->poid->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_poid" class="ew-item-list"></div>
<selection-list hidden
    id="x_poid[]"
    name="x_poid[]"
    value="<?= HtmlEncode($Page->poid->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_poid"
    data-target="dsl_x_poid"
    data-repeatcolumn="1"
    class="form-control<?= $Page->poid->isInvalidClass() ?>"
    data-table="job_card"
    data-field="x_poid"
    data-value-separator="<?= $Page->poid->displayValueSeparatorAttribute() ?>"
    <?= $Page->poid->editAttributes() ?>></selection-list>
<?= $Page->poid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->poid->getErrorMessage() ?></div>
<?= $Page->poid->Lookup->getParamTag($Page, "p_x_poid") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no"<?= $Page->batch_no->rowAttributes() ?>>
        <label id="elh_job_card_batch_no" for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->batch_no->caption() ?><?= $Page->batch_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->batch_no->cellAttributes() ?>>
<span id="el_job_card_batch_no">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-control ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        data-select2-id="fjob_cardedit_x_batch_no"
        data-table="job_card"
        data-field="x_batch_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->batch_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <?= $Page->batch_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage() ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<script>
loadjs.ready("fjob_cardedit", function() {
    var options = { name: "x_batch_no", selectId: "fjob_cardedit_x_batch_no" };
    if (fjob_cardedit.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fjob_cardedit" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fjob_cardedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.job_card.fields.batch_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_job_card_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_job_card_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="job_card" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pro_unit->Visible) { // pro_unit ?>
    <div id="r_pro_unit"<?= $Page->pro_unit->rowAttributes() ?>>
        <label id="elh_job_card_pro_unit" for="x_pro_unit" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pro_unit->caption() ?><?= $Page->pro_unit->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pro_unit->cellAttributes() ?>>
<span id="el_job_card_pro_unit">
    <select
        id="x_pro_unit"
        name="x_pro_unit"
        class="form-select ew-select<?= $Page->pro_unit->isInvalidClass() ?>"
        <?php if (!$Page->pro_unit->IsNativeSelect) { ?>
        data-select2-id="fjob_cardedit_x_pro_unit"
        <?php } ?>
        data-table="job_card"
        data-field="x_pro_unit"
        data-value-separator="<?= $Page->pro_unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pro_unit->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->pro_unit->editAttributes() ?>>
        <?= $Page->pro_unit->selectOptionListHtml("x_pro_unit") ?>
    </select>
    <?= $Page->pro_unit->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->pro_unit->getErrorMessage() ?></div>
<?= $Page->pro_unit->Lookup->getParamTag($Page, "p_x_pro_unit") ?>
<?php if (!$Page->pro_unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_cardedit", function() {
    var options = { name: "x_pro_unit", selectId: "fjob_cardedit_x_pro_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_cardedit.lists.pro_unit?.lookupOptions.length) {
        options.data = { id: "x_pro_unit", form: "fjob_cardedit" };
    } else {
        options.ajax = { id: "x_pro_unit", form: "fjob_cardedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card.fields.pro_unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id"<?= $Page->employee_id->rowAttributes() ?>>
        <label id="elh_job_card_employee_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_id->caption() ?><?= $Page->employee_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_id->cellAttributes() ?>>
<span id="el_job_card_employee_id">
    <select
        id="x_employee_id[]"
        name="x_employee_id[]"
        class="form-control ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        data-select2-id="fjob_cardedit_x_employee_id[]"
        data-table="job_card"
        data-field="x_employee_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->employee_id->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("x_employee_id[]") ?>
    </select>
    <?= $Page->employee_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage() ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
<script>
loadjs.ready("fjob_cardedit", function() {
    var options = { name: "x_employee_id[]", selectId: "fjob_cardedit_x_employee_id[]" };
    options.multiple = true;
    if (fjob_cardedit.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "x_employee_id[]", form: "fjob_cardedit" };
    } else {
        options.ajax = { id: "x_employee_id[]", form: "fjob_cardedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.job_card.fields.employee_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_1->Visible) { // 1 ?>
    <div id="r__1"<?= $Page->_1->rowAttributes() ?>>
        <label id="elh_job_card__1" for="x__1" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_1->caption() ?><?= $Page->_1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_1->cellAttributes() ?>>
<span id="el_job_card__1">
<input type="<?= $Page->_1->getInputTextType() ?>" name="x__1" id="x__1" data-table="job_card" data-field="x__1" value="<?= $Page->_1->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_1->formatPattern()) ?>"<?= $Page->_1->editAttributes() ?> aria-describedby="x__1_help">
<?= $Page->_1->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_1->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_2->Visible) { // 2 ?>
    <div id="r__2"<?= $Page->_2->rowAttributes() ?>>
        <label id="elh_job_card__2" for="x__2" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_2->caption() ?><?= $Page->_2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_2->cellAttributes() ?>>
<span id="el_job_card__2">
<input type="<?= $Page->_2->getInputTextType() ?>" name="x__2" id="x__2" data-table="job_card" data-field="x__2" value="<?= $Page->_2->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_2->formatPattern()) ?>"<?= $Page->_2->editAttributes() ?> aria-describedby="x__2_help">
<?= $Page->_2->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_2->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_3->Visible) { // 3 ?>
    <div id="r__3"<?= $Page->_3->rowAttributes() ?>>
        <label id="elh_job_card__3" for="x__3" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_3->caption() ?><?= $Page->_3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_3->cellAttributes() ?>>
<span id="el_job_card__3">
<input type="<?= $Page->_3->getInputTextType() ?>" name="x__3" id="x__3" data-table="job_card" data-field="x__3" value="<?= $Page->_3->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_3->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_3->formatPattern()) ?>"<?= $Page->_3->editAttributes() ?> aria-describedby="x__3_help">
<?= $Page->_3->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_3->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_4->Visible) { // 4 ?>
    <div id="r__4"<?= $Page->_4->rowAttributes() ?>>
        <label id="elh_job_card__4" for="x__4" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_4->caption() ?><?= $Page->_4->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_4->cellAttributes() ?>>
<span id="el_job_card__4">
<input type="<?= $Page->_4->getInputTextType() ?>" name="x__4" id="x__4" data-table="job_card" data-field="x__4" value="<?= $Page->_4->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_4->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_4->formatPattern()) ?>"<?= $Page->_4->editAttributes() ?> aria-describedby="x__4_help">
<?= $Page->_4->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_4->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_5->Visible) { // 5 ?>
    <div id="r__5"<?= $Page->_5->rowAttributes() ?>>
        <label id="elh_job_card__5" for="x__5" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_5->caption() ?><?= $Page->_5->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_5->cellAttributes() ?>>
<span id="el_job_card__5">
<input type="<?= $Page->_5->getInputTextType() ?>" name="x__5" id="x__5" data-table="job_card" data-field="x__5" value="<?= $Page->_5->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_5->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_5->formatPattern()) ?>"<?= $Page->_5->editAttributes() ?> aria-describedby="x__5_help">
<?= $Page->_5->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_5->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_6->Visible) { // 6 ?>
    <div id="r__6"<?= $Page->_6->rowAttributes() ?>>
        <label id="elh_job_card__6" for="x__6" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_6->caption() ?><?= $Page->_6->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_6->cellAttributes() ?>>
<span id="el_job_card__6">
<input type="<?= $Page->_6->getInputTextType() ?>" name="x__6" id="x__6" data-table="job_card" data-field="x__6" value="<?= $Page->_6->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_6->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_6->formatPattern()) ?>"<?= $Page->_6->editAttributes() ?> aria-describedby="x__6_help">
<?= $Page->_6->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_6->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_7->Visible) { // 7 ?>
    <div id="r__7"<?= $Page->_7->rowAttributes() ?>>
        <label id="elh_job_card__7" for="x__7" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_7->caption() ?><?= $Page->_7->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_7->cellAttributes() ?>>
<span id="el_job_card__7">
<input type="<?= $Page->_7->getInputTextType() ?>" name="x__7" id="x__7" data-table="job_card" data-field="x__7" value="<?= $Page->_7->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_7->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_7->formatPattern()) ?>"<?= $Page->_7->editAttributes() ?> aria-describedby="x__7_help">
<?= $Page->_7->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_7->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_8->Visible) { // 8 ?>
    <div id="r__8"<?= $Page->_8->rowAttributes() ?>>
        <label id="elh_job_card__8" for="x__8" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_8->caption() ?><?= $Page->_8->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_8->cellAttributes() ?>>
<span id="el_job_card__8">
<input type="<?= $Page->_8->getInputTextType() ?>" name="x__8" id="x__8" data-table="job_card" data-field="x__8" value="<?= $Page->_8->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_8->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_8->formatPattern()) ?>"<?= $Page->_8->editAttributes() ?> aria-describedby="x__8_help">
<?= $Page->_8->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_8->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other1->Visible) { // other1 ?>
    <div id="r_other1"<?= $Page->other1->rowAttributes() ?>>
        <label id="elh_job_card_other1" for="x_other1" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other1->caption() ?><?= $Page->other1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other1->cellAttributes() ?>>
<span id="el_job_card_other1">
<input type="<?= $Page->other1->getInputTextType() ?>" name="x_other1" id="x_other1" data-table="job_card" data-field="x_other1" value="<?= $Page->other1->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->other1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other1->formatPattern()) ?>"<?= $Page->other1->editAttributes() ?> aria-describedby="x_other1_help">
<?= $Page->other1->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other1->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other2->Visible) { // other2 ?>
    <div id="r_other2"<?= $Page->other2->rowAttributes() ?>>
        <label id="elh_job_card_other2" for="x_other2" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other2->caption() ?><?= $Page->other2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other2->cellAttributes() ?>>
<span id="el_job_card_other2">
<input type="<?= $Page->other2->getInputTextType() ?>" name="x_other2" id="x_other2" data-table="job_card" data-field="x_other2" value="<?= $Page->other2->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->other2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other2->formatPattern()) ?>"<?= $Page->other2->editAttributes() ?> aria-describedby="x_other2_help">
<?= $Page->other2->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other2->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fjob_cardedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fjob_cardedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("job_card");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    		var SGrp = $("#x_s_grp").val();
    		document.cookie = "s_grp="+SGrp+";path=/";
    		if (SGrp.length > 0)
    		{
    		$.getJSON(window.location.origin +"/apcajax?getHead="+SGrp,function(data){
    					if (data.jc_01_head == '--NA--') {
    					$("#r__1").hide(); } else {
    					$("#r__1").show();					
    					$("#elh_job_card__1").html(data.jc_01_head);}
    					if (data.jc_02_head == '--NA--') {
    					$("#r__2").hide(); } else {
    					$("#r__2").show();					
    					$("#elh_job_card__2").html(data.jc_02_head);}
    					if (data.jc_03_head == '--NA--') {
    					$("#r__3").hide(); } else {
    					$("#r__3").show();					
    					$("#elh_job_card__3").html(data.jc_03_head);}
    					if (data.jc_04_head == '--NA--') {
    					$("#r__4").hide(); } else {
    					$("#r__4").show();					
    					$("#elh_job_card__4").html(data.jc_04_head);}
    					if (data.jc_05_head == '--NA--') {
    					$("#r__5").hide(); } else {
    					$("#r__5").show();					
    					$("#elh_job_card__5").html(data.jc_05_head);}
    					if (data.jc_06_head == '--NA--') {
    					$("#r__6").hide(); } else {
    					$("#r__6").show();					
    					$("#elh_job_card__6").html(data.jc_06_head);}
    					if (data.jc_07_head == '--NA--') {
    					$("#r__7").hide(); } else {
    					$("#r__7").show();					
    					$("#elh_job_card__7").html(data.jc_07_head);}
    					if (data.jc_08_head == '--NA--') {
    					$("#r__8").hide(); } else {
    					$("#r__8").show();					
    					$("#elh_job_card__8").html(data.jc_08_head);}
    					if (data.jc_09_head == '--NA--') {
    					$("#r_other1").hide(); } else {
    					$("#r_other1").show();					
    					$("#elh_job_card_other1").html(data.jc_09_head);}
    					if (data.jc_10_head == '--NA--') {
    					$("#r_other2").hide(); } else {
    					$("#r_other2").show();					
    					$("#elh_job_card_other2").html(data.jc_10_head);}
    					});
    				}
    				else
    				{
    					$("#r__1").hide();
    					$("#r__2").hide();
    					$("#r__3").hide();
    					$("#r__4").hide();
    					$("#r__5").hide();
    					$("#r__6").hide();
    					$("#r__7").hide();
    					$("#r__8").hide();
    					$("#r_other1").hide();
    					$("#r_other2").hide();
    				}
    		var loc = $("#x_works").val();
    		if (loc == '1')
    		{
    			$("#r_issue_to_internal").hide();
    			$("#r_issue_to_external").show();
    			$("#x_issue_to").val($("#x_issue_to_external").val());
    		}
    		else
    		{
    			$("#r_issue_to_internal").show();
    			$("#r_issue_to_external").hide();
    			$("#x_issue_to").val($("#x_issue_to_internal").val());
    		}
});
</script>
