<?php

namespace PHPMaker2024\fibre;

// Page object
$JobCardBcSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { job_card_bc: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fjob_card_bcsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fjob_card_bcsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["no", [ew.Validators.integer], fields.no.isInvalid],
            ["works", [], fields.works.isInvalid],
            ["issue_to", [], fields.issue_to.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["po", [], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["design_size_1", [], fields.design_size_1.isInvalid],
            ["loom_no", [], fields.loom_no.isInvalid],
            ["employee_id", [], fields.employee_id.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["r_date", [ew.Validators.datetime(fields.r_date.clientFormatPattern)], fields.r_date.isInvalid],
            ["deduction", [ew.Validators.float], fields.deduction.isInvalid],
            ["ded_remarks", [], fields.ded_remarks.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["_1", [], fields._1.isInvalid],
            ["_2", [], fields._2.isInvalid],
            ["_3", [], fields._3.isInvalid],
            ["_4", [], fields._4.isInvalid],
            ["_5", [], fields._5.isInvalid],
            ["_6", [], fields._6.isInvalid],
            ["_7", [], fields._7.isInvalid],
            ["_8", [], fields._8.isInvalid],
            ["other1", [], fields.other1.isInvalid],
            ["other2", [], fields.other2.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "works": <?= $Page->works->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "po": <?= $Page->po->toClientList($Page) ?>,
            "loom_no": <?= $Page->loom_no->toClientList($Page) ?>,
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
            "_barcode": <?= $Page->_barcode->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fjob_card_bcsearch" id="fjob_card_bcsearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("jobcardbclist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="job_card_bc">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_job_card_bc_id" class="job_card_bcsearch"><span id="el_job_card_bc_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="job_card_bc" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc_no" class="job_card_bcsearch"><span id="el_job_card_bc_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->no->getInputTextType() ?>" name="x_no" id="x_no" data-table="job_card_bc" data-field="x_no" value="<?= $Page->no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no->formatPattern()) ?>"<?= $Page->no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc_works" class="job_card_bcsearch"><span id="el_job_card_bc_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_works"
        name="x_works"
        class="form-select ew-select<?= $Page->works->isInvalidClass() ?>"
        <?php if (!$Page->works->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcsearch_x_works"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_works"
        data-value-separator="<?= $Page->works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->works->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->works->editAttributes() ?>>
        <?= $Page->works->selectOptionListHtml("x_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->works->getErrorMessage(false) ?></div>
<?= $Page->works->Lookup->getParamTag($Page, "p_x_works") ?>
<?php if (!$Page->works->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcsearch", function() {
    var options = { name: "x_works", selectId: "fjob_card_bcsearch_x_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcsearch.lists.works?.lookupOptions.length) {
        options.data = { id: "x_works", form: "fjob_card_bcsearch" };
    } else {
        options.ajax = { id: "x_works", form: "fjob_card_bcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_bc_issue_to" class="job_card_bcsearch"><span id="el_job_card_bc_issue_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_issue_to"
        name="x_issue_to"
        class="form-select ew-select<?= $Page->issue_to->isInvalidClass() ?>"
        <?php if (!$Page->issue_to->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcsearch_x_issue_to"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_issue_to"
        data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>"
        <?= $Page->issue_to->editAttributes() ?>>
        <?= $Page->issue_to->selectOptionListHtml("x_issue_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage(false) ?></div>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
<?php if (!$Page->issue_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcsearch", function() {
    var options = { name: "x_issue_to", selectId: "fjob_card_bcsearch_x_issue_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcsearch.lists.issue_to?.lookupOptions.length) {
        options.data = { id: "x_issue_to", form: "fjob_card_bcsearch" };
    } else {
        options.ajax = { id: "x_issue_to", form: "fjob_card_bcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.issue_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_bc_grp" class="job_card_bcsearch"><span id="el_job_card_bc_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcsearch_x_grp"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcsearch", function() {
    var options = { name: "x_grp", selectId: "fjob_card_bcsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fjob_card_bcsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fjob_card_bcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_bc_po" class="job_card_bcsearch"><span id="el_job_card_bc_po" class="ew-search-field ew-search-field-single">
    <select
        id="x_po"
        name="x_po"
        class="form-select ew-select<?= $Page->po->isInvalidClass() ?>"
        <?php if (!$Page->po->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcsearch_x_po"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_po"
        data-value-separator="<?= $Page->po->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->po->editAttributes() ?>>
        <?= $Page->po->selectOptionListHtml("x_po") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
<?= $Page->po->Lookup->getParamTag($Page, "p_x_po") ?>
<?php if (!$Page->po->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcsearch", function() {
    var options = { name: "x_po", selectId: "fjob_card_bcsearch_x_po" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcsearch.lists.po?.lookupOptions.length) {
        options.data = { id: "x_po", form: "fjob_card_bcsearch" };
    } else {
        options.ajax = { id: "x_po", form: "fjob_card_bcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.po.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_bc_design_size_1" class="job_card_bcsearch"><span id="el_job_card_bc_design_size_1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design_size_1->getInputTextType() ?>" name="x_design_size_1" id="x_design_size_1" data-table="job_card_bc" data-field="x_design_size_1" value="<?= $Page->design_size_1->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->design_size_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design_size_1->formatPattern()) ?>"<?= $Page->design_size_1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design_size_1->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc_loom_no" class="job_card_bcsearch"><span id="el_job_card_bc_loom_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_loom_no"
        name="x_loom_no"
        class="form-select ew-select<?= $Page->loom_no->isInvalidClass() ?>"
        <?php if (!$Page->loom_no->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcsearch_x_loom_no"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_loom_no"
        data-value-separator="<?= $Page->loom_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->loom_no->getPlaceHolder()) ?>"
        <?= $Page->loom_no->editAttributes() ?>>
        <?= $Page->loom_no->selectOptionListHtml("x_loom_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->loom_no->getErrorMessage(false) ?></div>
<?= $Page->loom_no->Lookup->getParamTag($Page, "p_x_loom_no") ?>
<?php if (!$Page->loom_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcsearch", function() {
    var options = { name: "x_loom_no", selectId: "fjob_card_bcsearch_x_loom_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcsearch.lists.loom_no?.lookupOptions.length) {
        options.data = { id: "x_loom_no", form: "fjob_card_bcsearch" };
    } else {
        options.ajax = { id: "x_loom_no", form: "fjob_card_bcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.loom_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_bc_employee_id" class="job_card_bcsearch"><span id="el_job_card_bc_employee_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_employee_id[]"
        name="x_employee_id[]"
        class="form-control ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        data-select2-id="fjob_card_bcsearch_x_employee_id[]"
        data-table="job_card_bc"
        data-field="x_employee_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->employee_id->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("x_employee_id[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
<script>
loadjs.ready("fjob_card_bcsearch", function() {
    var options = { name: "x_employee_id[]", selectId: "fjob_card_bcsearch_x_employee_id[]" };
    options.multiple = true;
    if (fjob_card_bcsearch.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "x_employee_id[]", form: "fjob_card_bcsearch" };
    } else {
        options.ajax = { id: "x_employee_id[]", form: "fjob_card_bcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.job_card_bc.fields.employee_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_job_card_bc__barcode" class="job_card_bcsearch"><span id="el_job_card_bc__barcode" class="ew-search-field ew-search-field-single">
    <select
        id="x__barcode[]"
        name="x__barcode[]"
        class="form-select ew-select<?= $Page->_barcode->isInvalidClass() ?>"
        <?php if (!$Page->_barcode->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcsearch_x__barcode[]"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x__barcode"
        multiple
        size="1"
        data-value-separator="<?= $Page->_barcode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>"
        <?= $Page->_barcode->editAttributes() ?>>
        <?= $Page->_barcode->selectOptionListHtml("x__barcode[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
<?= $Page->_barcode->Lookup->getParamTag($Page, "p_x__barcode") ?>
<?php if (!$Page->_barcode->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcsearch", function() {
    var options = { name: "x__barcode[]", selectId: "fjob_card_bcsearch_x__barcode[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcsearch.lists._barcode?.lookupOptions.length) {
        options.data = { id: "x__barcode[]", form: "fjob_card_bcsearch" };
    } else {
        options.ajax = { id: "x__barcode[]", form: "fjob_card_bcsearch", limit: 10 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields._barcode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_bc_r_date" class="job_card_bcsearch"><span id="el_job_card_bc_r_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->r_date->getInputTextType() ?>" name="x_r_date" id="x_r_date" data-table="job_card_bc" data-field="x_r_date" value="<?= $Page->r_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->r_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_date->formatPattern()) ?>"<?= $Page->r_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->r_date->getErrorMessage(false) ?></div>
<?php if (!$Page->r_date->ReadOnly && !$Page->r_date->Disabled && !isset($Page->r_date->EditAttrs["readonly"]) && !isset($Page->r_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fjob_card_bcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fjob_card_bcsearch", "x_r_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_bc_deduction" class="job_card_bcsearch"><span id="el_job_card_bc_deduction" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->deduction->getInputTextType() ?>" name="x_deduction" id="x_deduction" data-table="job_card_bc" data-field="x_deduction" value="<?= $Page->deduction->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->deduction->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->deduction->formatPattern()) ?>"<?= $Page->deduction->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->deduction->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc_ded_remarks" class="job_card_bcsearch"><span id="el_job_card_bc_ded_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ded_remarks->getInputTextType() ?>" name="x_ded_remarks" id="x_ded_remarks" data-table="job_card_bc" data-field="x_ded_remarks" value="<?= $Page->ded_remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->ded_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ded_remarks->formatPattern()) ?>"<?= $Page->ded_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ded_remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc_operator" class="job_card_bcsearch"><span id="el_job_card_bc_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcsearch_x_operator"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcsearch", function() {
    var options = { name: "x_operator", selectId: "fjob_card_bcsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fjob_card_bcsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fjob_card_bcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_bc_datetime" class="job_card_bcsearch"><span id="el_job_card_bc_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="job_card_bc" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fjob_card_bcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fjob_card_bcsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_job_card_bc__1" class="job_card_bcsearch"><span id="el_job_card_bc__1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_1->getInputTextType() ?>" name="x__1" id="x__1" data-table="job_card_bc" data-field="x__1" value="<?= $Page->_1->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_1->formatPattern()) ?>"<?= $Page->_1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_1->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc__2" class="job_card_bcsearch"><span id="el_job_card_bc__2" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_2->getInputTextType() ?>" name="x__2" id="x__2" data-table="job_card_bc" data-field="x__2" value="<?= $Page->_2->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_2->formatPattern()) ?>"<?= $Page->_2->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_2->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc__3" class="job_card_bcsearch"><span id="el_job_card_bc__3" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_3->getInputTextType() ?>" name="x__3" id="x__3" data-table="job_card_bc" data-field="x__3" value="<?= $Page->_3->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_3->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_3->formatPattern()) ?>"<?= $Page->_3->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_3->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc__4" class="job_card_bcsearch"><span id="el_job_card_bc__4" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_4->getInputTextType() ?>" name="x__4" id="x__4" data-table="job_card_bc" data-field="x__4" value="<?= $Page->_4->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_4->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_4->formatPattern()) ?>"<?= $Page->_4->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_4->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc__5" class="job_card_bcsearch"><span id="el_job_card_bc__5" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_5->getInputTextType() ?>" name="x__5" id="x__5" data-table="job_card_bc" data-field="x__5" value="<?= $Page->_5->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_5->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_5->formatPattern()) ?>"<?= $Page->_5->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_5->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc__6" class="job_card_bcsearch"><span id="el_job_card_bc__6" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_6->getInputTextType() ?>" name="x__6" id="x__6" data-table="job_card_bc" data-field="x__6" value="<?= $Page->_6->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_6->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_6->formatPattern()) ?>"<?= $Page->_6->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_6->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc__7" class="job_card_bcsearch"><span id="el_job_card_bc__7" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_7->getInputTextType() ?>" name="x__7" id="x__7" data-table="job_card_bc" data-field="x__7" value="<?= $Page->_7->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_7->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_7->formatPattern()) ?>"<?= $Page->_7->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_7->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc__8" class="job_card_bcsearch"><span id="el_job_card_bc__8" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_8->getInputTextType() ?>" name="x__8" id="x__8" data-table="job_card_bc" data-field="x__8" value="<?= $Page->_8->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_8->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_8->formatPattern()) ?>"<?= $Page->_8->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_8->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc_other1" class="job_card_bcsearch"><span id="el_job_card_bc_other1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other1->getInputTextType() ?>" name="x_other1" id="x_other1" data-table="job_card_bc" data-field="x_other1" value="<?= $Page->other1->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->other1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other1->formatPattern()) ?>"<?= $Page->other1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other1->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_job_card_bc_other2" class="job_card_bcsearch"><span id="el_job_card_bc_other2" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other2->getInputTextType() ?>" name="x_other2" id="x_other2" data-table="job_card_bc" data-field="x_other2" value="<?= $Page->other2->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->other2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other2->formatPattern()) ?>"<?= $Page->other2->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other2->getErrorMessage(false) ?></div>
</span></template>
<div id="job_card_bc_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "no",
                type: "integer",
                label: currentTable.fields.no.caption,
                operators: currentTable.fields.no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.no.validators),
                data: {
                    format: currentTable.fields.no.clientFormatPattern
                }
            },
            {
                id: "works",
                type: "integer",
                label: currentTable.fields.works.caption,
                operators: currentTable.fields.works.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.works.validators),
                data: {
                    format: currentTable.fields.works.clientFormatPattern
                }
            },
            {
                id: "issue_to",
                type: "integer",
                label: currentTable.fields.issue_to.caption,
                operators: currentTable.fields.issue_to.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.issue_to.validators),
                data: {
                    format: currentTable.fields.issue_to.clientFormatPattern
                }
            },
            {
                id: "grp",
                type: "integer",
                label: currentTable.fields.grp.caption,
                operators: currentTable.fields.grp.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.grp.validators),
                data: {
                    format: currentTable.fields.grp.clientFormatPattern
                }
            },
            {
                id: "po",
                type: "string",
                label: currentTable.fields.po.caption,
                operators: currentTable.fields.po.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.po.validators),
                data: {
                    format: currentTable.fields.po.clientFormatPattern
                }
            },
            {
                id: "design_size_1",
                type: "string",
                label: currentTable.fields.design_size_1.caption,
                operators: currentTable.fields.design_size_1.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.design_size_1.validators),
                data: {
                    format: currentTable.fields.design_size_1.clientFormatPattern
                }
            },
            {
                id: "loom_no",
                type: "integer",
                label: currentTable.fields.loom_no.caption,
                operators: currentTable.fields.loom_no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.loom_no.validators),
                data: {
                    format: currentTable.fields.loom_no.clientFormatPattern
                }
            },
            {
                id: "employee_id",
                type: "string",
                label: currentTable.fields.employee_id.caption,
                operators: currentTable.fields.employee_id.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.employee_id.validators),
                data: {
                    format: currentTable.fields.employee_id.clientFormatPattern
                }
            },
            {
                id: "_barcode",
                type: "string",
                label: currentTable.fields._barcode.caption,
                operators: currentTable.fields._barcode.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields._barcode.validators),
                data: {
                    format: currentTable.fields._barcode.clientFormatPattern
                }
            },
            {
                id: "r_date",
                type: "datetime",
                label: currentTable.fields.r_date.caption,
                operators: currentTable.fields.r_date.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.r_date.validators),
                data: {
                    format: currentTable.fields.r_date.clientFormatPattern
                }
            },
            {
                id: "deduction",
                type: "double",
                label: currentTable.fields.deduction.caption,
                operators: currentTable.fields.deduction.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.deduction.validators),
                data: {
                    format: currentTable.fields.deduction.clientFormatPattern
                }
            },
            {
                id: "ded_remarks",
                type: "string",
                label: currentTable.fields.ded_remarks.caption,
                operators: currentTable.fields.ded_remarks.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.ded_remarks.validators),
                data: {
                    format: currentTable.fields.ded_remarks.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
            {
                id: "_1",
                type: "string",
                label: currentTable.fields._1.caption,
                operators: currentTable.fields._1.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields._1.validators),
                data: {
                    format: currentTable.fields._1.clientFormatPattern
                }
            },
            {
                id: "_2",
                type: "string",
                label: currentTable.fields._2.caption,
                operators: currentTable.fields._2.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields._2.validators),
                data: {
                    format: currentTable.fields._2.clientFormatPattern
                }
            },
            {
                id: "_3",
                type: "string",
                label: currentTable.fields._3.caption,
                operators: currentTable.fields._3.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields._3.validators),
                data: {
                    format: currentTable.fields._3.clientFormatPattern
                }
            },
            {
                id: "_4",
                type: "string",
                label: currentTable.fields._4.caption,
                operators: currentTable.fields._4.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields._4.validators),
                data: {
                    format: currentTable.fields._4.clientFormatPattern
                }
            },
            {
                id: "_5",
                type: "string",
                label: currentTable.fields._5.caption,
                operators: currentTable.fields._5.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields._5.validators),
                data: {
                    format: currentTable.fields._5.clientFormatPattern
                }
            },
            {
                id: "_6",
                type: "string",
                label: currentTable.fields._6.caption,
                operators: currentTable.fields._6.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields._6.validators),
                data: {
                    format: currentTable.fields._6.clientFormatPattern
                }
            },
            {
                id: "_7",
                type: "string",
                label: currentTable.fields._7.caption,
                operators: currentTable.fields._7.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields._7.validators),
                data: {
                    format: currentTable.fields._7.clientFormatPattern
                }
            },
            {
                id: "_8",
                type: "string",
                label: currentTable.fields._8.caption,
                operators: currentTable.fields._8.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields._8.validators),
                data: {
                    format: currentTable.fields._8.clientFormatPattern
                }
            },
            {
                id: "other1",
                type: "string",
                label: currentTable.fields.other1.caption,
                operators: currentTable.fields.other1.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.other1.validators),
                data: {
                    format: currentTable.fields.other1.clientFormatPattern
                }
            },
            {
                id: "other2",
                type: "string",
                label: currentTable.fields.other2.caption,
                operators: currentTable.fields.other2.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fjob_card_bcsearch.fields.other2.validators),
                data: {
                    format: currentTable.fields.other2.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#job_card_bc_query_builder"),
        args = {},
        rules = ew.parseJson($("#fjob_card_bcsearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fjob_card_bcsearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fjob_card_bcsearch" formaction="<?= HtmlEncode(GetUrl("jobcardbclist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fjob_card_bcsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fjob_card_bcsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("job_card_bc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
