<?php

namespace PHPMaker2024\fibre;

// Page object
$JobCardBcAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { job_card_bc: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fjob_card_bcadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fjob_card_bcadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["no", [fields.no.visible && fields.no.required ? ew.Validators.required(fields.no.caption) : null, ew.Validators.integer], fields.no.isInvalid],
            ["works", [fields.works.visible && fields.works.required ? ew.Validators.required(fields.works.caption) : null], fields.works.isInvalid],
            ["issue_to", [fields.issue_to.visible && fields.issue_to.required ? ew.Validators.required(fields.issue_to.caption) : null], fields.issue_to.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null], fields.po.isInvalid],
            ["design_size", [fields.design_size.visible && fields.design_size.required ? ew.Validators.required(fields.design_size.caption) : null], fields.design_size.isInvalid],
            ["size_wl", [fields.size_wl.visible && fields.size_wl.required ? ew.Validators.required(fields.size_wl.caption) : null], fields.size_wl.isInvalid],
            ["loom_no", [fields.loom_no.visible && fields.loom_no.required ? ew.Validators.required(fields.loom_no.caption) : null], fields.loom_no.isInvalid],
            ["employee_1", [fields.employee_1.visible && fields.employee_1.required ? ew.Validators.required(fields.employee_1.caption) : null, ew.Validators.integer], fields.employee_1.isInvalid],
            ["employee_2", [fields.employee_2.visible && fields.employee_2.required ? ew.Validators.required(fields.employee_2.caption) : null, ew.Validators.integer], fields.employee_2.isInvalid],
            ["employee_3", [fields.employee_3.visible && fields.employee_3.required ? ew.Validators.required(fields.employee_3.caption) : null, ew.Validators.integer], fields.employee_3.isInvalid],
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null], fields._barcode.isInvalid],
            ["r_date", [fields.r_date.visible && fields.r_date.required ? ew.Validators.required(fields.r_date.caption) : null, ew.Validators.datetime(fields.r_date.clientFormatPattern)], fields.r_date.isInvalid],
            ["lot_no", [fields.lot_no.visible && fields.lot_no.required ? ew.Validators.required(fields.lot_no.caption) : null], fields.lot_no.isInvalid],
            ["deduction", [fields.deduction.visible && fields.deduction.required ? ew.Validators.required(fields.deduction.caption) : null, ew.Validators.float], fields.deduction.isInvalid],
            ["ded_remarks", [fields.ded_remarks.visible && fields.ded_remarks.required ? ew.Validators.required(fields.ded_remarks.caption) : null], fields.ded_remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["_1", [fields._1.visible && fields._1.required ? ew.Validators.required(fields._1.caption) : null], fields._1.isInvalid],
            ["_2", [fields._2.visible && fields._2.required ? ew.Validators.required(fields._2.caption) : null], fields._2.isInvalid],
            ["_3", [fields._3.visible && fields._3.required ? ew.Validators.required(fields._3.caption) : null], fields._3.isInvalid],
            ["_4", [fields._4.visible && fields._4.required ? ew.Validators.required(fields._4.caption) : null], fields._4.isInvalid],
            ["_5", [fields._5.visible && fields._5.required ? ew.Validators.required(fields._5.caption) : null], fields._5.isInvalid],
            ["_6", [fields._6.visible && fields._6.required ? ew.Validators.required(fields._6.caption) : null], fields._6.isInvalid],
            ["_7", [fields._7.visible && fields._7.required ? ew.Validators.required(fields._7.caption) : null], fields._7.isInvalid],
            ["_8", [fields._8.visible && fields._8.required ? ew.Validators.required(fields._8.caption) : null], fields._8.isInvalid],
            ["other1", [fields.other1.visible && fields.other1.required ? ew.Validators.required(fields.other1.caption) : null], fields.other1.isInvalid],
            ["other2", [fields.other2.visible && fields.other2.required ? ew.Validators.required(fields.other2.caption) : null], fields.other2.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "works": <?= $Page->works->toClientList($Page) ?>,
            "issue_to": <?= $Page->issue_to->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "po": <?= $Page->po->toClientList($Page) ?>,
            "design_size": <?= $Page->design_size->toClientList($Page) ?>,
            "loom_no": <?= $Page->loom_no->toClientList($Page) ?>,
            "employee_1": <?= $Page->employee_1->toClientList($Page) ?>,
            "employee_2": <?= $Page->employee_2->toClientList($Page) ?>,
            "employee_3": <?= $Page->employee_3->toClientList($Page) ?>,
            "_barcode": <?= $Page->_barcode->toClientList($Page) ?>,
            "lot_no": <?= $Page->lot_no->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fjob_card_bcadd" id="fjob_card_bcadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="job_card_bc">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->no->Visible) { // no ?>
    <div id="r_no"<?= $Page->no->rowAttributes() ?>>
        <label id="elh_job_card_bc_no" for="x_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->no->caption() ?><?= $Page->no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->no->cellAttributes() ?>>
<span id="el_job_card_bc_no">
<input type="<?= $Page->no->getInputTextType() ?>" name="x_no" id="x_no" data-table="job_card_bc" data-field="x_no" value="<?= $Page->no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->no->formatPattern()) ?>"<?= $Page->no->editAttributes() ?> aria-describedby="x_no_help">
<?= $Page->no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->works->Visible) { // works ?>
    <div id="r_works"<?= $Page->works->rowAttributes() ?>>
        <label id="elh_job_card_bc_works" for="x_works" class="<?= $Page->LeftColumnClass ?>"><?= $Page->works->caption() ?><?= $Page->works->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->works->cellAttributes() ?>>
<span id="el_job_card_bc_works">
    <select
        id="x_works"
        name="x_works"
        class="form-select ew-select<?= $Page->works->isInvalidClass() ?>"
        <?php if (!$Page->works->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcadd_x_works"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_works"
        data-value-separator="<?= $Page->works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->works->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->works->editAttributes() ?>>
        <?= $Page->works->selectOptionListHtml("x_works") ?>
    </select>
    <?= $Page->works->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->works->getErrorMessage() ?></div>
<?= $Page->works->Lookup->getParamTag($Page, "p_x_works") ?>
<?php if (!$Page->works->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcadd", function() {
    var options = { name: "x_works", selectId: "fjob_card_bcadd_x_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcadd.lists.works?.lookupOptions.length) {
        options.data = { id: "x_works", form: "fjob_card_bcadd" };
    } else {
        options.ajax = { id: "x_works", form: "fjob_card_bcadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->issue_to->Visible) { // issue_to ?>
    <div id="r_issue_to"<?= $Page->issue_to->rowAttributes() ?>>
        <label id="elh_job_card_bc_issue_to" for="x_issue_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->issue_to->caption() ?><?= $Page->issue_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->issue_to->cellAttributes() ?>>
<span id="el_job_card_bc_issue_to">
    <select
        id="x_issue_to"
        name="x_issue_to"
        class="form-select ew-select<?= $Page->issue_to->isInvalidClass() ?>"
        <?php if (!$Page->issue_to->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcadd_x_issue_to"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_issue_to"
        data-value-separator="<?= $Page->issue_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->issue_to->getPlaceHolder()) ?>"
        <?= $Page->issue_to->editAttributes() ?>>
        <?= $Page->issue_to->selectOptionListHtml("x_issue_to") ?>
    </select>
    <?= $Page->issue_to->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->issue_to->getErrorMessage() ?></div>
<?= $Page->issue_to->Lookup->getParamTag($Page, "p_x_issue_to") ?>
<?php if (!$Page->issue_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcadd", function() {
    var options = { name: "x_issue_to", selectId: "fjob_card_bcadd_x_issue_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcadd.lists.issue_to?.lookupOptions.length) {
        options.data = { id: "x_issue_to", form: "fjob_card_bcadd" };
    } else {
        options.ajax = { id: "x_issue_to", form: "fjob_card_bcadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.issue_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_job_card_bc_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_job_card_bc_grp">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcadd_x_grp"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcadd", function() {
    var options = { name: "x_grp", selectId: "fjob_card_bcadd_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcadd.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fjob_card_bcadd" };
    } else {
        options.ajax = { id: "x_grp", form: "fjob_card_bcadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_job_card_bc_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_job_card_bc_s_grp">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcadd_x_s_grp"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <?= $Page->s_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcadd", function() {
    var options = { name: "x_s_grp", selectId: "fjob_card_bcadd_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcadd.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fjob_card_bcadd" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fjob_card_bcadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po"<?= $Page->po->rowAttributes() ?>>
        <label id="elh_job_card_bc_po" for="x_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po->caption() ?><?= $Page->po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po->cellAttributes() ?>>
<span id="el_job_card_bc_po">
    <select
        id="x_po"
        name="x_po"
        class="form-select ew-select<?= $Page->po->isInvalidClass() ?>"
        <?php if (!$Page->po->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcadd_x_po"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_po"
        data-value-separator="<?= $Page->po->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->po->editAttributes() ?>>
        <?= $Page->po->selectOptionListHtml("x_po") ?>
    </select>
    <?= $Page->po->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->po->getErrorMessage() ?></div>
<?= $Page->po->Lookup->getParamTag($Page, "p_x_po") ?>
<?php if (!$Page->po->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcadd", function() {
    var options = { name: "x_po", selectId: "fjob_card_bcadd_x_po" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcadd.lists.po?.lookupOptions.length) {
        options.data = { id: "x_po", form: "fjob_card_bcadd" };
    } else {
        options.ajax = { id: "x_po", form: "fjob_card_bcadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.po.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->design_size->Visible) { // design_size ?>
    <div id="r_design_size"<?= $Page->design_size->rowAttributes() ?>>
        <label id="elh_job_card_bc_design_size" for="x_design_size" class="<?= $Page->LeftColumnClass ?>"><?= $Page->design_size->caption() ?><?= $Page->design_size->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->design_size->cellAttributes() ?>>
<span id="el_job_card_bc_design_size">
    <select
        id="x_design_size"
        name="x_design_size"
        class="form-select ew-select<?= $Page->design_size->isInvalidClass() ?>"
        <?php if (!$Page->design_size->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcadd_x_design_size"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_design_size"
        data-value-separator="<?= $Page->design_size->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_size->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->design_size->editAttributes() ?>>
        <?= $Page->design_size->selectOptionListHtml("x_design_size") ?>
    </select>
    <?= $Page->design_size->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->design_size->getErrorMessage() ?></div>
<?= $Page->design_size->Lookup->getParamTag($Page, "p_x_design_size") ?>
<?php if (!$Page->design_size->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcadd", function() {
    var options = { name: "x_design_size", selectId: "fjob_card_bcadd_x_design_size" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcadd.lists.design_size?.lookupOptions.length) {
        options.data = { id: "x_design_size", form: "fjob_card_bcadd" };
    } else {
        options.ajax = { id: "x_design_size", form: "fjob_card_bcadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.design_size.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size_wl->Visible) { // size_wl ?>
    <div id="r_size_wl"<?= $Page->size_wl->rowAttributes() ?>>
        <label id="elh_job_card_bc_size_wl" for="x_size_wl" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size_wl->caption() ?><?= $Page->size_wl->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size_wl->cellAttributes() ?>>
<span id="el_job_card_bc_size_wl">
<input type="<?= $Page->size_wl->getInputTextType() ?>" name="x_size_wl" id="x_size_wl" data-table="job_card_bc" data-field="x_size_wl" value="<?= $Page->size_wl->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->size_wl->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_wl->formatPattern()) ?>"<?= $Page->size_wl->editAttributes() ?> aria-describedby="x_size_wl_help">
<?= $Page->size_wl->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->size_wl->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->loom_no->Visible) { // loom_no ?>
    <div id="r_loom_no"<?= $Page->loom_no->rowAttributes() ?>>
        <label id="elh_job_card_bc_loom_no" for="x_loom_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->loom_no->caption() ?><?= $Page->loom_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->loom_no->cellAttributes() ?>>
<span id="el_job_card_bc_loom_no">
    <select
        id="x_loom_no"
        name="x_loom_no"
        class="form-select ew-select<?= $Page->loom_no->isInvalidClass() ?>"
        <?php if (!$Page->loom_no->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcadd_x_loom_no"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_loom_no"
        data-value-separator="<?= $Page->loom_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->loom_no->getPlaceHolder()) ?>"
        <?= $Page->loom_no->editAttributes() ?>>
        <?= $Page->loom_no->selectOptionListHtml("x_loom_no") ?>
    </select>
    <?= $Page->loom_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->loom_no->getErrorMessage() ?></div>
<?= $Page->loom_no->Lookup->getParamTag($Page, "p_x_loom_no") ?>
<?php if (!$Page->loom_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcadd", function() {
    var options = { name: "x_loom_no", selectId: "fjob_card_bcadd_x_loom_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcadd.lists.loom_no?.lookupOptions.length) {
        options.data = { id: "x_loom_no", form: "fjob_card_bcadd" };
    } else {
        options.ajax = { id: "x_loom_no", form: "fjob_card_bcadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.loom_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->employee_1->Visible) { // employee_1 ?>
    <div id="r_employee_1"<?= $Page->employee_1->rowAttributes() ?>>
        <label id="elh_job_card_bc_employee_1" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_1->caption() ?><?= $Page->employee_1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_1->cellAttributes() ?>>
<span id="el_job_card_bc_employee_1">
<?php
if (IsRTL()) {
    $Page->employee_1->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_employee_1" class="ew-auto-suggest">
    <input type="<?= $Page->employee_1->getInputTextType() ?>" class="form-control" name="sv_x_employee_1" id="sv_x_employee_1" value="<?= RemoveHtml($Page->employee_1->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->employee_1->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->employee_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_1->formatPattern()) ?>"<?= $Page->employee_1->editAttributes() ?> aria-describedby="x_employee_1_help">
</span>
<selection-list hidden class="form-control" data-table="job_card_bc" data-field="x_employee_1" data-input="sv_x_employee_1" data-value-separator="<?= $Page->employee_1->displayValueSeparatorAttribute() ?>" name="x_employee_1" id="x_employee_1" value="<?= HtmlEncode($Page->employee_1->CurrentValue) ?>"></selection-list>
<?= $Page->employee_1->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->employee_1->getErrorMessage() ?></div>
<script>
loadjs.ready("fjob_card_bcadd", function() {
    fjob_card_bcadd.createAutoSuggest(Object.assign({"id":"x_employee_1","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->employee_1->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.job_card_bc.fields.employee_1.autoSuggestOptions));
});
</script>
<?= $Page->employee_1->Lookup->getParamTag($Page, "p_x_employee_1") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->employee_2->Visible) { // employee_2 ?>
    <div id="r_employee_2"<?= $Page->employee_2->rowAttributes() ?>>
        <label id="elh_job_card_bc_employee_2" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_2->caption() ?><?= $Page->employee_2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_2->cellAttributes() ?>>
<span id="el_job_card_bc_employee_2">
<?php
if (IsRTL()) {
    $Page->employee_2->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_employee_2" class="ew-auto-suggest">
    <input type="<?= $Page->employee_2->getInputTextType() ?>" class="form-control" name="sv_x_employee_2" id="sv_x_employee_2" value="<?= RemoveHtml($Page->employee_2->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->employee_2->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->employee_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_2->formatPattern()) ?>"<?= $Page->employee_2->editAttributes() ?> aria-describedby="x_employee_2_help">
</span>
<selection-list hidden class="form-control" data-table="job_card_bc" data-field="x_employee_2" data-input="sv_x_employee_2" data-value-separator="<?= $Page->employee_2->displayValueSeparatorAttribute() ?>" name="x_employee_2" id="x_employee_2" value="<?= HtmlEncode($Page->employee_2->CurrentValue) ?>"></selection-list>
<?= $Page->employee_2->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->employee_2->getErrorMessage() ?></div>
<script>
loadjs.ready("fjob_card_bcadd", function() {
    fjob_card_bcadd.createAutoSuggest(Object.assign({"id":"x_employee_2","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->employee_2->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.job_card_bc.fields.employee_2.autoSuggestOptions));
});
</script>
<?= $Page->employee_2->Lookup->getParamTag($Page, "p_x_employee_2") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->employee_3->Visible) { // employee_3 ?>
    <div id="r_employee_3"<?= $Page->employee_3->rowAttributes() ?>>
        <label id="elh_job_card_bc_employee_3" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_3->caption() ?><?= $Page->employee_3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_3->cellAttributes() ?>>
<span id="el_job_card_bc_employee_3">
<?php
if (IsRTL()) {
    $Page->employee_3->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_employee_3" class="ew-auto-suggest">
    <input type="<?= $Page->employee_3->getInputTextType() ?>" class="form-control" name="sv_x_employee_3" id="sv_x_employee_3" value="<?= RemoveHtml($Page->employee_3->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->employee_3->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->employee_3->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_3->formatPattern()) ?>"<?= $Page->employee_3->editAttributes() ?> aria-describedby="x_employee_3_help">
</span>
<selection-list hidden class="form-control" data-table="job_card_bc" data-field="x_employee_3" data-input="sv_x_employee_3" data-value-separator="<?= $Page->employee_3->displayValueSeparatorAttribute() ?>" name="x_employee_3" id="x_employee_3" value="<?= HtmlEncode($Page->employee_3->CurrentValue) ?>"></selection-list>
<?= $Page->employee_3->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->employee_3->getErrorMessage() ?></div>
<script>
loadjs.ready("fjob_card_bcadd", function() {
    fjob_card_bcadd.createAutoSuggest(Object.assign({"id":"x_employee_3","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->employee_3->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.job_card_bc.fields.employee_3.autoSuggestOptions));
});
</script>
<?= $Page->employee_3->Lookup->getParamTag($Page, "p_x_employee_3") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode"<?= $Page->_barcode->rowAttributes() ?>>
        <label id="elh_job_card_bc__barcode" for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_barcode->caption() ?><?= $Page->_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_barcode->cellAttributes() ?>>
<span id="el_job_card_bc__barcode">
    <select
        id="x__barcode[]"
        name="x__barcode[]"
        class="form-select ew-select<?= $Page->_barcode->isInvalidClass() ?>"
        <?php if (!$Page->_barcode->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcadd_x__barcode[]"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x__barcode"
        multiple
        size="1"
        data-value-separator="<?= $Page->_barcode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>"
        <?= $Page->_barcode->editAttributes() ?>>
        <?= $Page->_barcode->selectOptionListHtml("x__barcode[]") ?>
    </select>
    <?= $Page->_barcode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage() ?></div>
<?= $Page->_barcode->Lookup->getParamTag($Page, "p_x__barcode") ?>
<?php if (!$Page->_barcode->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcadd", function() {
    var options = { name: "x__barcode[]", selectId: "fjob_card_bcadd_x__barcode[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcadd.lists._barcode?.lookupOptions.length) {
        options.data = { id: "x__barcode[]", form: "fjob_card_bcadd" };
    } else {
        options.ajax = { id: "x__barcode[]", form: "fjob_card_bcadd", limit: 10 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields._barcode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->r_date->Visible) { // r_date ?>
    <div id="r_r_date"<?= $Page->r_date->rowAttributes() ?>>
        <label id="elh_job_card_bc_r_date" for="x_r_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_date->caption() ?><?= $Page->r_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_date->cellAttributes() ?>>
<span id="el_job_card_bc_r_date">
<input type="<?= $Page->r_date->getInputTextType() ?>" name="x_r_date" id="x_r_date" data-table="job_card_bc" data-field="x_r_date" value="<?= $Page->r_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->r_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_date->formatPattern()) ?>"<?= $Page->r_date->editAttributes() ?> aria-describedby="x_r_date_help">
<?= $Page->r_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->r_date->getErrorMessage() ?></div>
<?php if (!$Page->r_date->ReadOnly && !$Page->r_date->Disabled && !isset($Page->r_date->EditAttrs["readonly"]) && !isset($Page->r_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fjob_card_bcadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fjob_card_bcadd", "x_r_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no"<?= $Page->lot_no->rowAttributes() ?>>
        <label id="elh_job_card_bc_lot_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lot_no->caption() ?><?= $Page->lot_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lot_no->cellAttributes() ?>>
<span id="el_job_card_bc_lot_no">
    <select
        id="x_lot_no[]"
        name="x_lot_no[]"
        class="form-select ew-select<?= $Page->lot_no->isInvalidClass() ?>"
        <?php if (!$Page->lot_no->IsNativeSelect) { ?>
        data-select2-id="fjob_card_bcadd_x_lot_no[]"
        <?php } ?>
        data-table="job_card_bc"
        data-field="x_lot_no"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->lot_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>"
        <?= $Page->lot_no->editAttributes() ?>>
        <?= $Page->lot_no->selectOptionListHtml("x_lot_no[]") ?>
    </select>
    <?= $Page->lot_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage() ?></div>
<?= $Page->lot_no->Lookup->getParamTag($Page, "p_x_lot_no") ?>
<?php if (!$Page->lot_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fjob_card_bcadd", function() {
    var options = { name: "x_lot_no[]", selectId: "fjob_card_bcadd_x_lot_no[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 1;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown job_card_bc-x_lot_no-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fjob_card_bcadd.lists.lot_no?.lookupOptions.length) {
        options.data = { id: "x_lot_no[]", form: "fjob_card_bcadd" };
    } else {
        options.ajax = { id: "x_lot_no[]", form: "fjob_card_bcadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.job_card_bc.fields.lot_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->deduction->Visible) { // deduction ?>
    <div id="r_deduction"<?= $Page->deduction->rowAttributes() ?>>
        <label id="elh_job_card_bc_deduction" for="x_deduction" class="<?= $Page->LeftColumnClass ?>"><?= $Page->deduction->caption() ?><?= $Page->deduction->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->deduction->cellAttributes() ?>>
<span id="el_job_card_bc_deduction">
<input type="<?= $Page->deduction->getInputTextType() ?>" name="x_deduction" id="x_deduction" data-table="job_card_bc" data-field="x_deduction" value="<?= $Page->deduction->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->deduction->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->deduction->formatPattern()) ?>"<?= $Page->deduction->editAttributes() ?> aria-describedby="x_deduction_help">
<?= $Page->deduction->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->deduction->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ded_remarks->Visible) { // ded_remarks ?>
    <div id="r_ded_remarks"<?= $Page->ded_remarks->rowAttributes() ?>>
        <label id="elh_job_card_bc_ded_remarks" for="x_ded_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ded_remarks->caption() ?><?= $Page->ded_remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ded_remarks->cellAttributes() ?>>
<span id="el_job_card_bc_ded_remarks">
<input type="<?= $Page->ded_remarks->getInputTextType() ?>" name="x_ded_remarks" id="x_ded_remarks" data-table="job_card_bc" data-field="x_ded_remarks" value="<?= $Page->ded_remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->ded_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ded_remarks->formatPattern()) ?>"<?= $Page->ded_remarks->editAttributes() ?> aria-describedby="x_ded_remarks_help">
<?= $Page->ded_remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ded_remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_1->Visible) { // 1 ?>
    <div id="r__1"<?= $Page->_1->rowAttributes() ?>>
        <label id="elh_job_card_bc__1" for="x__1" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_1->caption() ?><?= $Page->_1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_1->cellAttributes() ?>>
<span id="el_job_card_bc__1">
<input type="<?= $Page->_1->getInputTextType() ?>" name="x__1" id="x__1" data-table="job_card_bc" data-field="x__1" value="<?= $Page->_1->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_1->formatPattern()) ?>"<?= $Page->_1->editAttributes() ?> aria-describedby="x__1_help">
<?= $Page->_1->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_1->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_2->Visible) { // 2 ?>
    <div id="r__2"<?= $Page->_2->rowAttributes() ?>>
        <label id="elh_job_card_bc__2" for="x__2" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_2->caption() ?><?= $Page->_2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_2->cellAttributes() ?>>
<span id="el_job_card_bc__2">
<input type="<?= $Page->_2->getInputTextType() ?>" name="x__2" id="x__2" data-table="job_card_bc" data-field="x__2" value="<?= $Page->_2->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_2->formatPattern()) ?>"<?= $Page->_2->editAttributes() ?> aria-describedby="x__2_help">
<?= $Page->_2->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_2->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_3->Visible) { // 3 ?>
    <div id="r__3"<?= $Page->_3->rowAttributes() ?>>
        <label id="elh_job_card_bc__3" for="x__3" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_3->caption() ?><?= $Page->_3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_3->cellAttributes() ?>>
<span id="el_job_card_bc__3">
<input type="<?= $Page->_3->getInputTextType() ?>" name="x__3" id="x__3" data-table="job_card_bc" data-field="x__3" value="<?= $Page->_3->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_3->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_3->formatPattern()) ?>"<?= $Page->_3->editAttributes() ?> aria-describedby="x__3_help">
<?= $Page->_3->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_3->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_4->Visible) { // 4 ?>
    <div id="r__4"<?= $Page->_4->rowAttributes() ?>>
        <label id="elh_job_card_bc__4" for="x__4" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_4->caption() ?><?= $Page->_4->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_4->cellAttributes() ?>>
<span id="el_job_card_bc__4">
<input type="<?= $Page->_4->getInputTextType() ?>" name="x__4" id="x__4" data-table="job_card_bc" data-field="x__4" value="<?= $Page->_4->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_4->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_4->formatPattern()) ?>"<?= $Page->_4->editAttributes() ?> aria-describedby="x__4_help">
<?= $Page->_4->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_4->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_5->Visible) { // 5 ?>
    <div id="r__5"<?= $Page->_5->rowAttributes() ?>>
        <label id="elh_job_card_bc__5" for="x__5" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_5->caption() ?><?= $Page->_5->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_5->cellAttributes() ?>>
<span id="el_job_card_bc__5">
<input type="<?= $Page->_5->getInputTextType() ?>" name="x__5" id="x__5" data-table="job_card_bc" data-field="x__5" value="<?= $Page->_5->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_5->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_5->formatPattern()) ?>"<?= $Page->_5->editAttributes() ?> aria-describedby="x__5_help">
<?= $Page->_5->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_5->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_6->Visible) { // 6 ?>
    <div id="r__6"<?= $Page->_6->rowAttributes() ?>>
        <label id="elh_job_card_bc__6" for="x__6" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_6->caption() ?><?= $Page->_6->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_6->cellAttributes() ?>>
<span id="el_job_card_bc__6">
<input type="<?= $Page->_6->getInputTextType() ?>" name="x__6" id="x__6" data-table="job_card_bc" data-field="x__6" value="<?= $Page->_6->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_6->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_6->formatPattern()) ?>"<?= $Page->_6->editAttributes() ?> aria-describedby="x__6_help">
<?= $Page->_6->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_6->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_7->Visible) { // 7 ?>
    <div id="r__7"<?= $Page->_7->rowAttributes() ?>>
        <label id="elh_job_card_bc__7" for="x__7" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_7->caption() ?><?= $Page->_7->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_7->cellAttributes() ?>>
<span id="el_job_card_bc__7">
<input type="<?= $Page->_7->getInputTextType() ?>" name="x__7" id="x__7" data-table="job_card_bc" data-field="x__7" value="<?= $Page->_7->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_7->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_7->formatPattern()) ?>"<?= $Page->_7->editAttributes() ?> aria-describedby="x__7_help">
<?= $Page->_7->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_7->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_8->Visible) { // 8 ?>
    <div id="r__8"<?= $Page->_8->rowAttributes() ?>>
        <label id="elh_job_card_bc__8" for="x__8" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_8->caption() ?><?= $Page->_8->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_8->cellAttributes() ?>>
<span id="el_job_card_bc__8">
<input type="<?= $Page->_8->getInputTextType() ?>" name="x__8" id="x__8" data-table="job_card_bc" data-field="x__8" value="<?= $Page->_8->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_8->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_8->formatPattern()) ?>"<?= $Page->_8->editAttributes() ?> aria-describedby="x__8_help">
<?= $Page->_8->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_8->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other1->Visible) { // other1 ?>
    <div id="r_other1"<?= $Page->other1->rowAttributes() ?>>
        <label id="elh_job_card_bc_other1" for="x_other1" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other1->caption() ?><?= $Page->other1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other1->cellAttributes() ?>>
<span id="el_job_card_bc_other1">
<input type="<?= $Page->other1->getInputTextType() ?>" name="x_other1" id="x_other1" data-table="job_card_bc" data-field="x_other1" value="<?= $Page->other1->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->other1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other1->formatPattern()) ?>"<?= $Page->other1->editAttributes() ?> aria-describedby="x_other1_help">
<?= $Page->other1->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other1->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other2->Visible) { // other2 ?>
    <div id="r_other2"<?= $Page->other2->rowAttributes() ?>>
        <label id="elh_job_card_bc_other2" for="x_other2" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other2->caption() ?><?= $Page->other2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other2->cellAttributes() ?>>
<span id="el_job_card_bc_other2">
<input type="<?= $Page->other2->getInputTextType() ?>" name="x_other2" id="x_other2" data-table="job_card_bc" data-field="x_other2" value="<?= $Page->other2->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->other2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other2->formatPattern()) ?>"<?= $Page->other2->editAttributes() ?> aria-describedby="x_other2_help">
<?= $Page->other2->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other2->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fjob_card_bcadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fjob_card_bcadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("job_card_bc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    		var jloc = getCookie('location')
    		if (jloc == 1)
    		{
    		$('#r_issue_to').show()
    		}
    		else
    		{
    		$('#r_issue_to').val(0)		
    		$('#r_issue_to').hide()
    		}
    		var SGrp = $("#x_s_grp").val();
    		if (SGrp.length > 0)
    		{
    		$.getJSON(window.location.origin +"/apcajax?getHead="+SGrp,function(data){
    					if (data.jc_01_head == '--NA--') {
    					$("#r__1").hide(); } else {
    					$("#r__1").show();					
    					$("#elh_job_card_bc__1").html(data.jc_01_head);}
    					if (data.jc_02_head == '--NA--') {
    					$("#r__2").hide(); } else {
    					$("#r__2").show();					
    					$("#elh_job_card_bc__2").html(data.jc_02_head);}
    					if (data.jc_03_head == '--NA--') {
    					$("#r__3").hide(); } else {
    					$("#r__3").show();					
    					$("#elh_job_card_bc__3").html(data.jc_03_head);}
    					if (data.jc_04_head == '--NA--') {
    					$("#r__4").hide(); } else {
    					$("#r__4").show();					
    					$("#elh_job_card_bc__4").html(data.jc_04_head);}
    					if (data.jc_05_head == '--NA--') {
    					$("#r__5").hide(); } else {
    					$("#r__5").show();					
    					$("#elh_job_card_bc__5").html(data.jc_05_head);}
    					if (data.jc_06_head == '--NA--') {
    					$("#r__6").hide(); } else {
    					$("#r__6").show();					
    					$("#elh_job_card_bc__6").html(data.jc_06_head);}
    					if (data.jc_07_head == '--NA--') {
    					$("#r__7").hide(); } else {
    					$("#r__7").show();					
    					$("#elh_job_card_bc__7").html(data.jc_07_head);}
    					if (data.jc_08_head == '--NA--') {
    					$("#r__8").hide(); } else {
    					$("#r__8").show();					
    					$("#elh_job_card_bc__8").html(data.jc_08_head);}
    					if (data.jc_09_head == '--NA--') {
    					$("#r_other1").hide(); } else {
    					$("#r_other1").show();					
    					$("#elh_job_card_bc_other1").html(data.jc_09_head);}
    					if (data.jc_10_head == '--NA--') {
    					$("#r_other2").hide(); } else {
    					$("#r_other2").show();					
    					$("#elh_job_card_bc_other2").html(data.jc_10_head);}					
    					});
    				}
            $("#btn-action").hide();
            $('#elh_job_card_bc__barcode').append('<button class="btn btn-warning sm" onclick="checkbarcode()">Validate Barcode(s)</button>');
    window.checkbarcode = function(){
        const width = getCookie("width");
        const checkmat = <?= isset($_COOKIE["fibre_checkmat"]) ? $_COOKIE["fibre_checkmat"] : $_COOKIE["checkmat"] ?>;    
        const loc = $("#x_works").val();
        const BC = $('#el_job_card_bc__barcode select[name="x__barcode[]"]').val();
        if (BC.length > 0) {
            $("#error1").remove();
            $.getJSON(`${window.location.origin}/apcajax?loc=${loc}&width=${width}&getwep=${BC}`, function(data) {    
                if (typeof data.message === 'undefined') {
                    let inc_text = '';    
                    if (data.weaving_in != 0) {
                        inc_text = `<br>Weaving Inc./SQM: ${data.weaving_in}<br>CS Inc./SQM: ${data.csweaving_in}`;
                    }
                    $("#error_ref").remove();
                    $('#elh_job_card_bc_deduction').html(`Deduction @/SQM<br><span id="error1" style="color:red;">Weaving/SQM: ${data.weaving}<br>CS/SQM: ${data.csweaving}${inc_text}</span>`);
                    $('#r__barcode').append(`<span id="error_ref" style="color:red;">Remarks: ${data.remarks}</span>`);
                } else {
                    $('#el_job_card_bc__barcode select[name="x__barcode[]"]').val('');
                    alert(data.message);
                }    
            });
            if (checkmat > 0) 
            {
                $.getJSON(`${window.location.origin}/apcajax2?getshort=${BC}&loc=${loc}`, function(data) {
                    if (data.msg == 'OK') {
                        $("#btn-action").show();
                    } 
                    else if (checkmat == 1) 
                    {
                        $("#btn-action").show();
                        $("#errorshort").remove();
                        $('#r_employee_3').append(`<span id="errorshort" style="color:red;">${data}</span>`);
                        alert('इस कार्यपत्र के लिए सामग्री अपर्याप्त है, कृपया कम बारकोड का चयन करें या इसे बाद में करें।');
                    } 
                    else if (checkmat == 2) 
                    {
                        $("#btn-action").hide();
                        $("#errorshort").remove();
                        $('#r_employee_3').append(`<span id="errorshort" style="color:red;"><br>${data}</span>`);
                        $('#el_job_card_bc__barcode select[name="x__barcode[]"]').val('');
                        alert('इस कार्यपत्र के लिए सामग्री अपर्याप्त है, कृपया कम बारकोड का चयन करें या इसे बाद में करें।');
                    }
                });
            } else {
                $("#btn-action").show();
            }
        }
    }        
});
</script>
