<?php

namespace PHPMaker2024\fibre;

// Page object
$InvoiceDetailsSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { invoice_details: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var finvoice_detailssearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("finvoice_detailssearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["exporter", [], fields.exporter.isInvalid],
            ["consignee", [], fields.consignee.isInvalid],
            ["consignee_other", [], fields.consignee_other.isInvalid],
            ["packing_list_no", [], fields.packing_list_no.isInvalid],
            ["d_11", [], fields.d_11.isInvalid],
            ["description_11", [], fields.description_11.isInvalid],
            ["in_template", [], fields.in_template.isInvalid],
            ["pl_template", [], fields.pl_template.isInvalid],
            ["invoice_no", [], fields.invoice_no.isInvalid],
            ["invoice_date", [ew.Validators.datetime(fields.invoice_date.clientFormatPattern)], fields.invoice_date.isInvalid],
            ["po_no", [], fields.po_no.isInvalid],
            ["other_reference", [], fields.other_reference.isInvalid],
            ["origin", [], fields.origin.isInvalid],
            ["final_destination", [], fields.final_destination.isInvalid],
            ["payment_terms", [], fields.payment_terms.isInvalid],
            ["pre_carriage_receipt", [], fields.pre_carriage_receipt.isInvalid],
            ["place_of_receipt", [], fields.place_of_receipt.isInvalid],
            ["loading_port", [], fields.loading_port.isInvalid],
            ["port_discharge", [], fields.port_discharge.isInvalid],
            ["d_01", [], fields.d_01.isInvalid],
            ["description_01", [], fields.description_01.isInvalid],
            ["d_02", [], fields.d_02.isInvalid],
            ["description_02", [], fields.description_02.isInvalid],
            ["gross_weight", [], fields.gross_weight.isInvalid],
            ["nett_weight", [], fields.nett_weight.isInvalid],
            ["cbm", [], fields.cbm.isInvalid],
            ["exporter_bank_details", [], fields.exporter_bank_details.isInvalid],
            ["intermediary_bank", [], fields.intermediary_bank.isInvalid],
            ["shipment_mode", [], fields.shipment_mode.isInvalid],
            ["ex_factory_date", [ew.Validators.datetime(fields.ex_factory_date.clientFormatPattern)], fields.ex_factory_date.isInvalid],
            ["sailing_date", [ew.Validators.datetime(fields.sailing_date.clientFormatPattern)], fields.sailing_date.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["cart_lines", [ew.Validators.regex(/^([0-9,]){5,5}$/)], fields.cart_lines.isInvalid],
            ["pl_lines", [ew.Validators.regex(/^([0-9,]){5,5}$/)], fields.pl_lines.isInvalid],
            ["freezed", [], fields.freezed.isInvalid],
            ["a_operator", [ew.Validators.integer], fields.a_operator.isInvalid],
            ["port_delivery", [], fields.port_delivery.isInvalid],
            ["dispatch_details", [], fields.dispatch_details.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "exporter": <?= $Page->exporter->toClientList($Page) ?>,
            "consignee": <?= $Page->consignee->toClientList($Page) ?>,
            "consignee_other": <?= $Page->consignee_other->toClientList($Page) ?>,
            "packing_list_no": <?= $Page->packing_list_no->toClientList($Page) ?>,
            "in_template": <?= $Page->in_template->toClientList($Page) ?>,
            "pl_template": <?= $Page->pl_template->toClientList($Page) ?>,
            "shipment_mode": <?= $Page->shipment_mode->toClientList($Page) ?>,
            "freezed": <?= $Page->freezed->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="finvoice_detailssearch" id="finvoice_detailssearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="invoice_details">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="invoice_details" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details__barcode"><?= $Page->_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details__barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="invoice_details" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->exporter->Visible) { // exporter ?>
    <div id="r_exporter" class="row"<?= $Page->exporter->rowAttributes() ?>>
        <label for="x_exporter" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_exporter"><?= $Page->exporter->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_exporter" id="z_exporter" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->exporter->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_exporter" class="ew-search-field ew-search-field-single">
    <select
        id="x_exporter"
        name="x_exporter"
        class="form-select ew-select<?= $Page->exporter->isInvalidClass() ?>"
        <?php if (!$Page->exporter->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailssearch_x_exporter"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_exporter"
        data-value-separator="<?= $Page->exporter->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->exporter->getPlaceHolder()) ?>"
        <?= $Page->exporter->editAttributes() ?>>
        <?= $Page->exporter->selectOptionListHtml("x_exporter") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->exporter->getErrorMessage(false) ?></div>
<?= $Page->exporter->Lookup->getParamTag($Page, "p_x_exporter") ?>
<?php if (!$Page->exporter->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailssearch", function() {
    var options = { name: "x_exporter", selectId: "finvoice_detailssearch_x_exporter" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailssearch.lists.exporter?.lookupOptions.length) {
        options.data = { id: "x_exporter", form: "finvoice_detailssearch" };
    } else {
        options.ajax = { id: "x_exporter", form: "finvoice_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.exporter.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->consignee->Visible) { // consignee ?>
    <div id="r_consignee" class="row"<?= $Page->consignee->rowAttributes() ?>>
        <label for="x_consignee" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_consignee"><?= $Page->consignee->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_consignee" id="z_consignee" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->consignee->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_consignee" class="ew-search-field ew-search-field-single">
    <select
        id="x_consignee"
        name="x_consignee"
        class="form-select ew-select<?= $Page->consignee->isInvalidClass() ?>"
        <?php if (!$Page->consignee->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailssearch_x_consignee"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_consignee"
        data-value-separator="<?= $Page->consignee->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->consignee->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->consignee->editAttributes() ?>>
        <?= $Page->consignee->selectOptionListHtml("x_consignee") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->consignee->getErrorMessage(false) ?></div>
<?= $Page->consignee->Lookup->getParamTag($Page, "p_x_consignee") ?>
<?php if (!$Page->consignee->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailssearch", function() {
    var options = { name: "x_consignee", selectId: "finvoice_detailssearch_x_consignee" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailssearch.lists.consignee?.lookupOptions.length) {
        options.data = { id: "x_consignee", form: "finvoice_detailssearch" };
    } else {
        options.ajax = { id: "x_consignee", form: "finvoice_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.consignee.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->consignee_other->Visible) { // consignee_other ?>
    <div id="r_consignee_other" class="row"<?= $Page->consignee_other->rowAttributes() ?>>
        <label for="x_consignee_other" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_consignee_other"><?= $Page->consignee_other->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_consignee_other" id="z_consignee_other" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->consignee_other->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_consignee_other" class="ew-search-field ew-search-field-single">
    <select
        id="x_consignee_other"
        name="x_consignee_other"
        class="form-select ew-select<?= $Page->consignee_other->isInvalidClass() ?>"
        <?php if (!$Page->consignee_other->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailssearch_x_consignee_other"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_consignee_other"
        data-value-separator="<?= $Page->consignee_other->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->consignee_other->getPlaceHolder()) ?>"
        <?= $Page->consignee_other->editAttributes() ?>>
        <?= $Page->consignee_other->selectOptionListHtml("x_consignee_other") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->consignee_other->getErrorMessage(false) ?></div>
<?= $Page->consignee_other->Lookup->getParamTag($Page, "p_x_consignee_other") ?>
<?php if (!$Page->consignee_other->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailssearch", function() {
    var options = { name: "x_consignee_other", selectId: "finvoice_detailssearch_x_consignee_other" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailssearch.lists.consignee_other?.lookupOptions.length) {
        options.data = { id: "x_consignee_other", form: "finvoice_detailssearch" };
    } else {
        options.ajax = { id: "x_consignee_other", form: "finvoice_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.consignee_other.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_list_no->Visible) { // packing_list_no ?>
    <div id="r_packing_list_no" class="row"<?= $Page->packing_list_no->rowAttributes() ?>>
        <label for="x_packing_list_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_packing_list_no"><?= $Page->packing_list_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_list_no" id="z_packing_list_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_list_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_packing_list_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_list_no"
        name="x_packing_list_no"
        class="form-select ew-select<?= $Page->packing_list_no->isInvalidClass() ?>"
        <?php if (!$Page->packing_list_no->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailssearch_x_packing_list_no"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_packing_list_no"
        data-value-separator="<?= $Page->packing_list_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_list_no->getPlaceHolder()) ?>"
        <?= $Page->packing_list_no->editAttributes() ?>>
        <?= $Page->packing_list_no->selectOptionListHtml("x_packing_list_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_list_no->getErrorMessage(false) ?></div>
<?= $Page->packing_list_no->Lookup->getParamTag($Page, "p_x_packing_list_no") ?>
<?php if (!$Page->packing_list_no->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailssearch", function() {
    var options = { name: "x_packing_list_no", selectId: "finvoice_detailssearch_x_packing_list_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailssearch.lists.packing_list_no?.lookupOptions.length) {
        options.data = { id: "x_packing_list_no", form: "finvoice_detailssearch" };
    } else {
        options.ajax = { id: "x_packing_list_no", form: "finvoice_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.packing_list_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_11->Visible) { // d_11 ?>
    <div id="r_d_11" class="row"<?= $Page->d_11->rowAttributes() ?>>
        <label for="x_d_11" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_d_11"><?= $Page->d_11->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_11" id="z_d_11" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_11->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_d_11" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_11->getInputTextType() ?>" name="x_d_11" id="x_d_11" data-table="invoice_details" data-field="x_d_11" value="<?= $Page->d_11->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_11->formatPattern()) ?>"<?= $Page->d_11->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_11->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_11->Visible) { // description_11 ?>
    <div id="r_description_11" class="row"<?= $Page->description_11->rowAttributes() ?>>
        <label for="x_description_11" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_description_11"><?= $Page->description_11->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_11" id="z_description_11" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_11->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_description_11" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_11->getInputTextType() ?>" name="x_description_11" id="x_description_11" data-table="invoice_details" data-field="x_description_11" value="<?= $Page->description_11->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->description_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_11->formatPattern()) ?>"<?= $Page->description_11->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_11->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->in_template->Visible) { // in_template ?>
    <div id="r_in_template" class="row"<?= $Page->in_template->rowAttributes() ?>>
        <label for="x_in_template" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_in_template"><?= $Page->in_template->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_in_template" id="z_in_template" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->in_template->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_in_template" class="ew-search-field ew-search-field-single">
    <select
        id="x_in_template"
        name="x_in_template"
        class="form-select ew-select<?= $Page->in_template->isInvalidClass() ?>"
        <?php if (!$Page->in_template->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailssearch_x_in_template"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_in_template"
        data-value-separator="<?= $Page->in_template->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->in_template->getPlaceHolder()) ?>"
        <?= $Page->in_template->editAttributes() ?>>
        <?= $Page->in_template->selectOptionListHtml("x_in_template") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->in_template->getErrorMessage(false) ?></div>
<?= $Page->in_template->Lookup->getParamTag($Page, "p_x_in_template") ?>
<?php if (!$Page->in_template->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailssearch", function() {
    var options = { name: "x_in_template", selectId: "finvoice_detailssearch_x_in_template" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailssearch.lists.in_template?.lookupOptions.length) {
        options.data = { id: "x_in_template", form: "finvoice_detailssearch" };
    } else {
        options.ajax = { id: "x_in_template", form: "finvoice_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.in_template.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pl_template->Visible) { // pl_template ?>
    <div id="r_pl_template" class="row"<?= $Page->pl_template->rowAttributes() ?>>
        <label for="x_pl_template" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_pl_template"><?= $Page->pl_template->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pl_template" id="z_pl_template" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_template->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_pl_template" class="ew-search-field ew-search-field-single">
    <select
        id="x_pl_template"
        name="x_pl_template"
        class="form-select ew-select<?= $Page->pl_template->isInvalidClass() ?>"
        <?php if (!$Page->pl_template->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailssearch_x_pl_template"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_pl_template"
        data-value-separator="<?= $Page->pl_template->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pl_template->getPlaceHolder()) ?>"
        <?= $Page->pl_template->editAttributes() ?>>
        <?= $Page->pl_template->selectOptionListHtml("x_pl_template") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pl_template->getErrorMessage(false) ?></div>
<?= $Page->pl_template->Lookup->getParamTag($Page, "p_x_pl_template") ?>
<?php if (!$Page->pl_template->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailssearch", function() {
    var options = { name: "x_pl_template", selectId: "finvoice_detailssearch_x_pl_template" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailssearch.lists.pl_template?.lookupOptions.length) {
        options.data = { id: "x_pl_template", form: "finvoice_detailssearch" };
    } else {
        options.ajax = { id: "x_pl_template", form: "finvoice_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.pl_template.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_no->Visible) { // invoice_no ?>
    <div id="r_invoice_no" class="row"<?= $Page->invoice_no->rowAttributes() ?>>
        <label for="x_invoice_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_invoice_no"><?= $Page->invoice_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_invoice_no" id="z_invoice_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_invoice_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_no->getInputTextType() ?>" name="x_invoice_no" id="x_invoice_no" data-table="invoice_details" data-field="x_invoice_no" value="<?= $Page->invoice_no->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->invoice_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_no->formatPattern()) ?>"<?= $Page->invoice_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
    <div id="r_invoice_date" class="row"<?= $Page->invoice_date->rowAttributes() ?>>
        <label for="x_invoice_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_invoice_date"><?= $Page->invoice_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_invoice_date" id="z_invoice_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_invoice_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="x_invoice_date" id="x_invoice_date" data-table="invoice_details" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage(false) ?></div>
<?php if (!$Page->invoice_date->ReadOnly && !$Page->invoice_date->Disabled && !isset($Page->invoice_date->EditAttrs["readonly"]) && !isset($Page->invoice_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvoice_detailssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvoice_detailssearch", "x_invoice_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_no->Visible) { // po_no ?>
    <div id="r_po_no" class="row"<?= $Page->po_no->rowAttributes() ?>>
        <label for="x_po_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_po_no"><?= $Page->po_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_po_no" id="z_po_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_po_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po_no->getInputTextType() ?>" name="x_po_no" id="x_po_no" data-table="invoice_details" data-field="x_po_no" value="<?= $Page->po_no->EditValue ?>" maxlength="1000" placeholder="<?= HtmlEncode($Page->po_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_no->formatPattern()) ?>"<?= $Page->po_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other_reference->Visible) { // other_reference ?>
    <div id="r_other_reference" class="row"<?= $Page->other_reference->rowAttributes() ?>>
        <label for="x_other_reference" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_other_reference"><?= $Page->other_reference->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_other_reference" id="z_other_reference" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other_reference->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_other_reference" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other_reference->getInputTextType() ?>" name="x_other_reference" id="x_other_reference" data-table="invoice_details" data-field="x_other_reference" value="<?= $Page->other_reference->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->other_reference->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_reference->formatPattern()) ?>"<?= $Page->other_reference->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other_reference->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->origin->Visible) { // origin ?>
    <div id="r_origin" class="row"<?= $Page->origin->rowAttributes() ?>>
        <label for="x_origin" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_origin"><?= $Page->origin->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_origin" id="z_origin" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->origin->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_origin" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->origin->getInputTextType() ?>" name="x_origin" id="x_origin" data-table="invoice_details" data-field="x_origin" value="<?= $Page->origin->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->origin->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->origin->formatPattern()) ?>"<?= $Page->origin->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->origin->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->final_destination->Visible) { // final_destination ?>
    <div id="r_final_destination" class="row"<?= $Page->final_destination->rowAttributes() ?>>
        <label for="x_final_destination" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_final_destination"><?= $Page->final_destination->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_final_destination" id="z_final_destination" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->final_destination->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_final_destination" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->final_destination->getInputTextType() ?>" name="x_final_destination" id="x_final_destination" data-table="invoice_details" data-field="x_final_destination" value="<?= $Page->final_destination->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->final_destination->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->final_destination->formatPattern()) ?>"<?= $Page->final_destination->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->final_destination->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
    <div id="r_payment_terms" class="row"<?= $Page->payment_terms->rowAttributes() ?>>
        <label for="x_payment_terms" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_payment_terms"><?= $Page->payment_terms->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_payment_terms" id="z_payment_terms" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_terms->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_payment_terms" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->payment_terms->getInputTextType() ?>" name="x_payment_terms" id="x_payment_terms" data-table="invoice_details" data-field="x_payment_terms" value="<?= $Page->payment_terms->EditValue ?>" maxlength="96" placeholder="<?= HtmlEncode($Page->payment_terms->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->payment_terms->formatPattern()) ?>"<?= $Page->payment_terms->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->payment_terms->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pre_carriage_receipt->Visible) { // pre_carriage_receipt ?>
    <div id="r_pre_carriage_receipt" class="row"<?= $Page->pre_carriage_receipt->rowAttributes() ?>>
        <label for="x_pre_carriage_receipt" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_pre_carriage_receipt"><?= $Page->pre_carriage_receipt->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pre_carriage_receipt" id="z_pre_carriage_receipt" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pre_carriage_receipt->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_pre_carriage_receipt" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pre_carriage_receipt->getInputTextType() ?>" name="x_pre_carriage_receipt" id="x_pre_carriage_receipt" data-table="invoice_details" data-field="x_pre_carriage_receipt" value="<?= $Page->pre_carriage_receipt->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->pre_carriage_receipt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pre_carriage_receipt->formatPattern()) ?>"<?= $Page->pre_carriage_receipt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pre_carriage_receipt->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->place_of_receipt->Visible) { // place_of_receipt ?>
    <div id="r_place_of_receipt" class="row"<?= $Page->place_of_receipt->rowAttributes() ?>>
        <label for="x_place_of_receipt" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_place_of_receipt"><?= $Page->place_of_receipt->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_place_of_receipt" id="z_place_of_receipt" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->place_of_receipt->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_place_of_receipt" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->place_of_receipt->getInputTextType() ?>" name="x_place_of_receipt" id="x_place_of_receipt" data-table="invoice_details" data-field="x_place_of_receipt" value="<?= $Page->place_of_receipt->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->place_of_receipt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->place_of_receipt->formatPattern()) ?>"<?= $Page->place_of_receipt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->place_of_receipt->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->loading_port->Visible) { // loading_port ?>
    <div id="r_loading_port" class="row"<?= $Page->loading_port->rowAttributes() ?>>
        <label for="x_loading_port" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_loading_port"><?= $Page->loading_port->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_loading_port" id="z_loading_port" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->loading_port->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_loading_port" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->loading_port->getInputTextType() ?>" name="x_loading_port" id="x_loading_port" data-table="invoice_details" data-field="x_loading_port" value="<?= $Page->loading_port->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->loading_port->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->loading_port->formatPattern()) ?>"<?= $Page->loading_port->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->loading_port->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->port_discharge->Visible) { // port_discharge ?>
    <div id="r_port_discharge" class="row"<?= $Page->port_discharge->rowAttributes() ?>>
        <label for="x_port_discharge" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_port_discharge"><?= $Page->port_discharge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_port_discharge" id="z_port_discharge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->port_discharge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_port_discharge" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->port_discharge->getInputTextType() ?>" name="x_port_discharge" id="x_port_discharge" data-table="invoice_details" data-field="x_port_discharge" value="<?= $Page->port_discharge->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->port_discharge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_discharge->formatPattern()) ?>"<?= $Page->port_discharge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->port_discharge->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_01->Visible) { // d_01 ?>
    <div id="r_d_01" class="row"<?= $Page->d_01->rowAttributes() ?>>
        <label for="x_d_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_d_01"><?= $Page->d_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_01" id="z_d_01" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_d_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_01->getInputTextType() ?>" name="x_d_01" id="x_d_01" data-table="invoice_details" data-field="x_d_01" value="<?= $Page->d_01->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_01->formatPattern()) ?>"<?= $Page->d_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_01->Visible) { // description_01 ?>
    <div id="r_description_01" class="row"<?= $Page->description_01->rowAttributes() ?>>
        <label for="x_description_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_description_01"><?= $Page->description_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_01" id="z_description_01" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_description_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_01->getInputTextType() ?>" name="x_description_01" id="x_description_01" data-table="invoice_details" data-field="x_description_01" value="<?= $Page->description_01->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_01->formatPattern()) ?>"<?= $Page->description_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_02->Visible) { // d_02 ?>
    <div id="r_d_02" class="row"<?= $Page->d_02->rowAttributes() ?>>
        <label for="x_d_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_d_02"><?= $Page->d_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_02" id="z_d_02" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_d_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_02->getInputTextType() ?>" name="x_d_02" id="x_d_02" data-table="invoice_details" data-field="x_d_02" value="<?= $Page->d_02->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_02->formatPattern()) ?>"<?= $Page->d_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_02->Visible) { // description_02 ?>
    <div id="r_description_02" class="row"<?= $Page->description_02->rowAttributes() ?>>
        <label for="x_description_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_description_02"><?= $Page->description_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description_02" id="z_description_02" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_description_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description_02->getInputTextType() ?>" name="x_description_02" id="x_description_02" data-table="invoice_details" data-field="x_description_02" value="<?= $Page->description_02->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_02->formatPattern()) ?>"<?= $Page->description_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gross_weight->Visible) { // gross_weight ?>
    <div id="r_gross_weight" class="row"<?= $Page->gross_weight->rowAttributes() ?>>
        <label for="x_gross_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_gross_weight"><?= $Page->gross_weight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_gross_weight" id="z_gross_weight" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gross_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_gross_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gross_weight->getInputTextType() ?>" name="x_gross_weight" id="x_gross_weight" data-table="invoice_details" data-field="x_gross_weight" value="<?= $Page->gross_weight->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->gross_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gross_weight->formatPattern()) ?>"<?= $Page->gross_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gross_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->nett_weight->Visible) { // nett_weight ?>
    <div id="r_nett_weight" class="row"<?= $Page->nett_weight->rowAttributes() ?>>
        <label for="x_nett_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_nett_weight"><?= $Page->nett_weight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_nett_weight" id="z_nett_weight" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->nett_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_nett_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->nett_weight->getInputTextType() ?>" name="x_nett_weight" id="x_nett_weight" data-table="invoice_details" data-field="x_nett_weight" value="<?= $Page->nett_weight->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->nett_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->nett_weight->formatPattern()) ?>"<?= $Page->nett_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->nett_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
    <div id="r_cbm" class="row"<?= $Page->cbm->rowAttributes() ?>>
        <label for="x_cbm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_cbm"><?= $Page->cbm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_cbm" id="z_cbm" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cbm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_cbm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cbm->getInputTextType() ?>" name="x_cbm" id="x_cbm" data-table="invoice_details" data-field="x_cbm" value="<?= $Page->cbm->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cbm->formatPattern()) ?>"<?= $Page->cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cbm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->exporter_bank_details->Visible) { // exporter_bank_details ?>
    <div id="r_exporter_bank_details" class="row"<?= $Page->exporter_bank_details->rowAttributes() ?>>
        <label for="x_exporter_bank_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_exporter_bank_details"><?= $Page->exporter_bank_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_exporter_bank_details" id="z_exporter_bank_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->exporter_bank_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_exporter_bank_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->exporter_bank_details->getInputTextType() ?>" name="x_exporter_bank_details" id="x_exporter_bank_details" data-table="invoice_details" data-field="x_exporter_bank_details" value="<?= $Page->exporter_bank_details->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->exporter_bank_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->exporter_bank_details->formatPattern()) ?>"<?= $Page->exporter_bank_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->exporter_bank_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->intermediary_bank->Visible) { // intermediary_bank ?>
    <div id="r_intermediary_bank" class="row"<?= $Page->intermediary_bank->rowAttributes() ?>>
        <label for="x_intermediary_bank" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_intermediary_bank"><?= $Page->intermediary_bank->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_intermediary_bank" id="z_intermediary_bank" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->intermediary_bank->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_intermediary_bank" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->intermediary_bank->getInputTextType() ?>" name="x_intermediary_bank" id="x_intermediary_bank" data-table="invoice_details" data-field="x_intermediary_bank" value="<?= $Page->intermediary_bank->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->intermediary_bank->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->intermediary_bank->formatPattern()) ?>"<?= $Page->intermediary_bank->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->intermediary_bank->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shipment_mode->Visible) { // shipment_mode ?>
    <div id="r_shipment_mode" class="row"<?= $Page->shipment_mode->rowAttributes() ?>>
        <label for="x_shipment_mode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_shipment_mode"><?= $Page->shipment_mode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_shipment_mode" id="z_shipment_mode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shipment_mode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_shipment_mode" class="ew-search-field ew-search-field-single">
    <select
        id="x_shipment_mode"
        name="x_shipment_mode"
        class="form-select ew-select<?= $Page->shipment_mode->isInvalidClass() ?>"
        <?php if (!$Page->shipment_mode->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailssearch_x_shipment_mode"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_shipment_mode"
        data-value-separator="<?= $Page->shipment_mode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shipment_mode->getPlaceHolder()) ?>"
        <?= $Page->shipment_mode->editAttributes() ?>>
        <?= $Page->shipment_mode->selectOptionListHtml("x_shipment_mode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->shipment_mode->getErrorMessage(false) ?></div>
<?php if (!$Page->shipment_mode->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailssearch", function() {
    var options = { name: "x_shipment_mode", selectId: "finvoice_detailssearch_x_shipment_mode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailssearch.lists.shipment_mode?.lookupOptions.length) {
        options.data = { id: "x_shipment_mode", form: "finvoice_detailssearch" };
    } else {
        options.ajax = { id: "x_shipment_mode", form: "finvoice_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.shipment_mode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ex_factory_date->Visible) { // ex_factory_date ?>
    <div id="r_ex_factory_date" class="row"<?= $Page->ex_factory_date->rowAttributes() ?>>
        <label for="x_ex_factory_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_ex_factory_date"><?= $Page->ex_factory_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ex_factory_date" id="z_ex_factory_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ex_factory_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_ex_factory_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ex_factory_date->getInputTextType() ?>" name="x_ex_factory_date" id="x_ex_factory_date" data-table="invoice_details" data-field="x_ex_factory_date" value="<?= $Page->ex_factory_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->ex_factory_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ex_factory_date->formatPattern()) ?>"<?= $Page->ex_factory_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ex_factory_date->getErrorMessage(false) ?></div>
<?php if (!$Page->ex_factory_date->ReadOnly && !$Page->ex_factory_date->Disabled && !isset($Page->ex_factory_date->EditAttrs["readonly"]) && !isset($Page->ex_factory_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvoice_detailssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvoice_detailssearch", "x_ex_factory_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sailing_date->Visible) { // sailing_date ?>
    <div id="r_sailing_date" class="row"<?= $Page->sailing_date->rowAttributes() ?>>
        <label for="x_sailing_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_sailing_date"><?= $Page->sailing_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sailing_date" id="z_sailing_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sailing_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_sailing_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sailing_date->getInputTextType() ?>" name="x_sailing_date" id="x_sailing_date" data-table="invoice_details" data-field="x_sailing_date" value="<?= $Page->sailing_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->sailing_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sailing_date->formatPattern()) ?>"<?= $Page->sailing_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sailing_date->getErrorMessage(false) ?></div>
<?php if (!$Page->sailing_date->ReadOnly && !$Page->sailing_date->Disabled && !isset($Page->sailing_date->EditAttrs["readonly"]) && !isset($Page->sailing_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvoice_detailssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvoice_detailssearch", "x_sailing_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="invoice_details" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="invoice_details" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvoice_detailssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvoice_detailssearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cart_lines->Visible) { // cart_lines ?>
    <div id="r_cart_lines" class="row"<?= $Page->cart_lines->rowAttributes() ?>>
        <label for="x_cart_lines" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_cart_lines"><?= $Page->cart_lines->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cart_lines" id="z_cart_lines" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cart_lines->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_cart_lines" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cart_lines->getInputTextType() ?>" name="x_cart_lines" id="x_cart_lines" data-table="invoice_details" data-field="x_cart_lines" value="<?= $Page->cart_lines->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->cart_lines->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_lines->formatPattern()) ?>"<?= $Page->cart_lines->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cart_lines->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pl_lines->Visible) { // pl_lines ?>
    <div id="r_pl_lines" class="row"<?= $Page->pl_lines->rowAttributes() ?>>
        <label for="x_pl_lines" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_pl_lines"><?= $Page->pl_lines->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pl_lines" id="z_pl_lines" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_lines->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_pl_lines" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pl_lines->getInputTextType() ?>" name="x_pl_lines" id="x_pl_lines" data-table="invoice_details" data-field="x_pl_lines" value="<?= $Page->pl_lines->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->pl_lines->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_lines->formatPattern()) ?>"<?= $Page->pl_lines->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_lines->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->freezed->Visible) { // freezed ?>
    <div id="r_freezed" class="row"<?= $Page->freezed->rowAttributes() ?>>
        <label for="x_freezed" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_freezed"><?= $Page->freezed->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_freezed" id="z_freezed" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->freezed->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_freezed" class="ew-search-field ew-search-field-single">
    <select
        id="x_freezed"
        name="x_freezed"
        class="form-select ew-select<?= $Page->freezed->isInvalidClass() ?>"
        <?php if (!$Page->freezed->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailssearch_x_freezed"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_freezed"
        data-value-separator="<?= $Page->freezed->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->freezed->getPlaceHolder()) ?>"
        <?= $Page->freezed->editAttributes() ?>>
        <?= $Page->freezed->selectOptionListHtml("x_freezed") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->freezed->getErrorMessage(false) ?></div>
<?php if (!$Page->freezed->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailssearch", function() {
    var options = { name: "x_freezed", selectId: "finvoice_detailssearch_x_freezed" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailssearch.lists.freezed?.lookupOptions.length) {
        options.data = { id: "x_freezed", form: "finvoice_detailssearch" };
    } else {
        options.ajax = { id: "x_freezed", form: "finvoice_detailssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.freezed.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
    <div id="r_a_operator" class="row"<?= $Page->a_operator->rowAttributes() ?>>
        <label for="x_a_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_a_operator"><?= $Page->a_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_operator" id="z_a_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_a_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->a_operator->getInputTextType() ?>" name="x_a_operator" id="x_a_operator" data-table="invoice_details" data-field="x_a_operator" value="<?= $Page->a_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_operator->formatPattern()) ?>"<?= $Page->a_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->port_delivery->Visible) { // port_delivery ?>
    <div id="r_port_delivery" class="row"<?= $Page->port_delivery->rowAttributes() ?>>
        <label for="x_port_delivery" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_port_delivery"><?= $Page->port_delivery->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_port_delivery" id="z_port_delivery" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->port_delivery->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_port_delivery" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->port_delivery->getInputTextType() ?>" name="x_port_delivery" id="x_port_delivery" data-table="invoice_details" data-field="x_port_delivery" value="<?= $Page->port_delivery->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->port_delivery->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_delivery->formatPattern()) ?>"<?= $Page->port_delivery->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->port_delivery->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dispatch_details->Visible) { // dispatch_details ?>
    <div id="r_dispatch_details" class="row"<?= $Page->dispatch_details->rowAttributes() ?>>
        <label for="x_dispatch_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_invoice_details_dispatch_details"><?= $Page->dispatch_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_dispatch_details" id="z_dispatch_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dispatch_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_invoice_details_dispatch_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dispatch_details->getInputTextType() ?>" name="x_dispatch_details" id="x_dispatch_details" data-table="invoice_details" data-field="x_dispatch_details" value="<?= $Page->dispatch_details->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->dispatch_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dispatch_details->formatPattern()) ?>"<?= $Page->dispatch_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dispatch_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="finvoice_detailssearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="finvoice_detailssearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="finvoice_detailssearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("invoice_details");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
