<?php

namespace PHPMaker2024\fibre;

// Page object
$InvoiceDetailsList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { invoice_details: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="finvoice_detailssrch" id="finvoice_detailssrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="finvoice_detailssrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { invoice_details: currentTable } });
var currentForm;
var finvoice_detailssrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("finvoice_detailssrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="finvoice_detailssrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="finvoice_detailssrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="finvoice_detailssrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="finvoice_detailssrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="finvoice_detailssrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="finvoice_detailssrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="finvoice_detailssrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="invoice_details">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_invoice_details" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_invoice_detailslist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_invoice_details_id" class="invoice_details_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->exporter->Visible) { // exporter ?>
        <th data-name="exporter" class="<?= $Page->exporter->headerCellClass() ?>"><div id="elh_invoice_details_exporter" class="invoice_details_exporter"><?= $Page->renderFieldHeader($Page->exporter) ?></div></th>
<?php } ?>
<?php if ($Page->consignee->Visible) { // consignee ?>
        <th data-name="consignee" class="<?= $Page->consignee->headerCellClass() ?>"><div id="elh_invoice_details_consignee" class="invoice_details_consignee"><?= $Page->renderFieldHeader($Page->consignee) ?></div></th>
<?php } ?>
<?php if ($Page->consignee_other->Visible) { // consignee_other ?>
        <th data-name="consignee_other" class="<?= $Page->consignee_other->headerCellClass() ?>"><div id="elh_invoice_details_consignee_other" class="invoice_details_consignee_other"><?= $Page->renderFieldHeader($Page->consignee_other) ?></div></th>
<?php } ?>
<?php if ($Page->packing_list_no->Visible) { // packing_list_no ?>
        <th data-name="packing_list_no" class="<?= $Page->packing_list_no->headerCellClass() ?>"><div id="elh_invoice_details_packing_list_no" class="invoice_details_packing_list_no"><?= $Page->renderFieldHeader($Page->packing_list_no) ?></div></th>
<?php } ?>
<?php if ($Page->d_11->Visible) { // d_11 ?>
        <th data-name="d_11" class="<?= $Page->d_11->headerCellClass() ?>"><div id="elh_invoice_details_d_11" class="invoice_details_d_11"><?= $Page->renderFieldHeader($Page->d_11) ?></div></th>
<?php } ?>
<?php if ($Page->in_template->Visible) { // in_template ?>
        <th data-name="in_template" class="<?= $Page->in_template->headerCellClass() ?>"><div id="elh_invoice_details_in_template" class="invoice_details_in_template"><?= $Page->renderFieldHeader($Page->in_template) ?></div></th>
<?php } ?>
<?php if ($Page->pl_template->Visible) { // pl_template ?>
        <th data-name="pl_template" class="<?= $Page->pl_template->headerCellClass() ?>"><div id="elh_invoice_details_pl_template" class="invoice_details_pl_template"><?= $Page->renderFieldHeader($Page->pl_template) ?></div></th>
<?php } ?>
<?php if ($Page->invoice_no->Visible) { // invoice_no ?>
        <th data-name="invoice_no" class="<?= $Page->invoice_no->headerCellClass() ?>"><div id="elh_invoice_details_invoice_no" class="invoice_details_invoice_no"><?= $Page->renderFieldHeader($Page->invoice_no) ?></div></th>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
        <th data-name="invoice_date" class="<?= $Page->invoice_date->headerCellClass() ?>"><div id="elh_invoice_details_invoice_date" class="invoice_details_invoice_date"><?= $Page->renderFieldHeader($Page->invoice_date) ?></div></th>
<?php } ?>
<?php if ($Page->po_no->Visible) { // po_no ?>
        <th data-name="po_no" class="<?= $Page->po_no->headerCellClass() ?>"><div id="elh_invoice_details_po_no" class="invoice_details_po_no"><?= $Page->renderFieldHeader($Page->po_no) ?></div></th>
<?php } ?>
<?php if ($Page->other_reference->Visible) { // other_reference ?>
        <th data-name="other_reference" class="<?= $Page->other_reference->headerCellClass() ?>"><div id="elh_invoice_details_other_reference" class="invoice_details_other_reference"><?= $Page->renderFieldHeader($Page->other_reference) ?></div></th>
<?php } ?>
<?php if ($Page->origin->Visible) { // origin ?>
        <th data-name="origin" class="<?= $Page->origin->headerCellClass() ?>"><div id="elh_invoice_details_origin" class="invoice_details_origin"><?= $Page->renderFieldHeader($Page->origin) ?></div></th>
<?php } ?>
<?php if ($Page->final_destination->Visible) { // final_destination ?>
        <th data-name="final_destination" class="<?= $Page->final_destination->headerCellClass() ?>"><div id="elh_invoice_details_final_destination" class="invoice_details_final_destination"><?= $Page->renderFieldHeader($Page->final_destination) ?></div></th>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
        <th data-name="payment_terms" class="<?= $Page->payment_terms->headerCellClass() ?>"><div id="elh_invoice_details_payment_terms" class="invoice_details_payment_terms"><?= $Page->renderFieldHeader($Page->payment_terms) ?></div></th>
<?php } ?>
<?php if ($Page->pre_carriage_receipt->Visible) { // pre_carriage_receipt ?>
        <th data-name="pre_carriage_receipt" class="<?= $Page->pre_carriage_receipt->headerCellClass() ?>"><div id="elh_invoice_details_pre_carriage_receipt" class="invoice_details_pre_carriage_receipt"><?= $Page->renderFieldHeader($Page->pre_carriage_receipt) ?></div></th>
<?php } ?>
<?php if ($Page->place_of_receipt->Visible) { // place_of_receipt ?>
        <th data-name="place_of_receipt" class="<?= $Page->place_of_receipt->headerCellClass() ?>"><div id="elh_invoice_details_place_of_receipt" class="invoice_details_place_of_receipt"><?= $Page->renderFieldHeader($Page->place_of_receipt) ?></div></th>
<?php } ?>
<?php if ($Page->loading_port->Visible) { // loading_port ?>
        <th data-name="loading_port" class="<?= $Page->loading_port->headerCellClass() ?>"><div id="elh_invoice_details_loading_port" class="invoice_details_loading_port"><?= $Page->renderFieldHeader($Page->loading_port) ?></div></th>
<?php } ?>
<?php if ($Page->port_discharge->Visible) { // port_discharge ?>
        <th data-name="port_discharge" class="<?= $Page->port_discharge->headerCellClass() ?>"><div id="elh_invoice_details_port_discharge" class="invoice_details_port_discharge"><?= $Page->renderFieldHeader($Page->port_discharge) ?></div></th>
<?php } ?>
<?php if ($Page->d_01->Visible) { // d_01 ?>
        <th data-name="d_01" class="<?= $Page->d_01->headerCellClass() ?>"><div id="elh_invoice_details_d_01" class="invoice_details_d_01"><?= $Page->renderFieldHeader($Page->d_01) ?></div></th>
<?php } ?>
<?php if ($Page->description_01->Visible) { // description_01 ?>
        <th data-name="description_01" class="<?= $Page->description_01->headerCellClass() ?>"><div id="elh_invoice_details_description_01" class="invoice_details_description_01"><?= $Page->renderFieldHeader($Page->description_01) ?></div></th>
<?php } ?>
<?php if ($Page->d_02->Visible) { // d_02 ?>
        <th data-name="d_02" class="<?= $Page->d_02->headerCellClass() ?>"><div id="elh_invoice_details_d_02" class="invoice_details_d_02"><?= $Page->renderFieldHeader($Page->d_02) ?></div></th>
<?php } ?>
<?php if ($Page->description_02->Visible) { // description_02 ?>
        <th data-name="description_02" class="<?= $Page->description_02->headerCellClass() ?>"><div id="elh_invoice_details_description_02" class="invoice_details_description_02"><?= $Page->renderFieldHeader($Page->description_02) ?></div></th>
<?php } ?>
<?php if ($Page->gross_weight->Visible) { // gross_weight ?>
        <th data-name="gross_weight" class="<?= $Page->gross_weight->headerCellClass() ?>"><div id="elh_invoice_details_gross_weight" class="invoice_details_gross_weight"><?= $Page->renderFieldHeader($Page->gross_weight) ?></div></th>
<?php } ?>
<?php if ($Page->nett_weight->Visible) { // nett_weight ?>
        <th data-name="nett_weight" class="<?= $Page->nett_weight->headerCellClass() ?>"><div id="elh_invoice_details_nett_weight" class="invoice_details_nett_weight"><?= $Page->renderFieldHeader($Page->nett_weight) ?></div></th>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
        <th data-name="cbm" class="<?= $Page->cbm->headerCellClass() ?>"><div id="elh_invoice_details_cbm" class="invoice_details_cbm"><?= $Page->renderFieldHeader($Page->cbm) ?></div></th>
<?php } ?>
<?php if ($Page->shipment_mode->Visible) { // shipment_mode ?>
        <th data-name="shipment_mode" class="<?= $Page->shipment_mode->headerCellClass() ?>"><div id="elh_invoice_details_shipment_mode" class="invoice_details_shipment_mode"><?= $Page->renderFieldHeader($Page->shipment_mode) ?></div></th>
<?php } ?>
<?php if ($Page->ex_factory_date->Visible) { // ex_factory_date ?>
        <th data-name="ex_factory_date" class="<?= $Page->ex_factory_date->headerCellClass() ?>"><div id="elh_invoice_details_ex_factory_date" class="invoice_details_ex_factory_date"><?= $Page->renderFieldHeader($Page->ex_factory_date) ?></div></th>
<?php } ?>
<?php if ($Page->sailing_date->Visible) { // sailing_date ?>
        <th data-name="sailing_date" class="<?= $Page->sailing_date->headerCellClass() ?>"><div id="elh_invoice_details_sailing_date" class="invoice_details_sailing_date"><?= $Page->renderFieldHeader($Page->sailing_date) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_invoice_details_operator" class="invoice_details_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_invoice_details_datetime" class="invoice_details_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->cart_lines->Visible) { // cart_lines ?>
        <th data-name="cart_lines" class="<?= $Page->cart_lines->headerCellClass() ?>"><div id="elh_invoice_details_cart_lines" class="invoice_details_cart_lines"><?= $Page->renderFieldHeader($Page->cart_lines) ?></div></th>
<?php } ?>
<?php if ($Page->pl_lines->Visible) { // pl_lines ?>
        <th data-name="pl_lines" class="<?= $Page->pl_lines->headerCellClass() ?>"><div id="elh_invoice_details_pl_lines" class="invoice_details_pl_lines"><?= $Page->renderFieldHeader($Page->pl_lines) ?></div></th>
<?php } ?>
<?php if ($Page->freezed->Visible) { // freezed ?>
        <th data-name="freezed" class="<?= $Page->freezed->headerCellClass() ?>"><div id="elh_invoice_details_freezed" class="invoice_details_freezed"><?= $Page->renderFieldHeader($Page->freezed) ?></div></th>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
        <th data-name="a_operator" class="<?= $Page->a_operator->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_invoice_details_a_operator" class="invoice_details_a_operator"><?= $Page->renderFieldHeader($Page->a_operator) ?></div></th>
<?php } ?>
<?php if ($Page->port_delivery->Visible) { // port_delivery ?>
        <th data-name="port_delivery" class="<?= $Page->port_delivery->headerCellClass() ?>"><div id="elh_invoice_details_port_delivery" class="invoice_details_port_delivery"><?= $Page->renderFieldHeader($Page->port_delivery) ?></div></th>
<?php } ?>
<?php if ($Page->dispatch_details->Visible) { // dispatch_details ?>
        <th data-name="dispatch_details" class="<?= $Page->dispatch_details->headerCellClass() ?>"><div id="elh_invoice_details_dispatch_details" class="invoice_details_dispatch_details"><?= $Page->renderFieldHeader($Page->dispatch_details) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_id" class="el_invoice_details_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->exporter->Visible) { // exporter ?>
        <td data-name="exporter"<?= $Page->exporter->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_exporter" class="el_invoice_details_exporter">
<span<?= $Page->exporter->viewAttributes() ?>>
<?= $Page->exporter->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->consignee->Visible) { // consignee ?>
        <td data-name="consignee"<?= $Page->consignee->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_consignee" class="el_invoice_details_consignee">
<span<?= $Page->consignee->viewAttributes() ?>>
<?= $Page->consignee->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->consignee_other->Visible) { // consignee_other ?>
        <td data-name="consignee_other"<?= $Page->consignee_other->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_consignee_other" class="el_invoice_details_consignee_other">
<span<?= $Page->consignee_other->viewAttributes() ?>>
<?= $Page->consignee_other->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_list_no->Visible) { // packing_list_no ?>
        <td data-name="packing_list_no"<?= $Page->packing_list_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_packing_list_no" class="el_invoice_details_packing_list_no">
<span<?= $Page->packing_list_no->viewAttributes() ?>>
<?= $Page->packing_list_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_11->Visible) { // d_11 ?>
        <td data-name="d_11"<?= $Page->d_11->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_d_11" class="el_invoice_details_d_11">
<span<?= $Page->d_11->viewAttributes() ?>>
<?= $Page->d_11->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->in_template->Visible) { // in_template ?>
        <td data-name="in_template"<?= $Page->in_template->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_in_template" class="el_invoice_details_in_template">
<span<?= $Page->in_template->viewAttributes() ?>>
<?= $Page->in_template->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pl_template->Visible) { // pl_template ?>
        <td data-name="pl_template"<?= $Page->pl_template->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_pl_template" class="el_invoice_details_pl_template">
<span<?= $Page->pl_template->viewAttributes() ?>>
<?= $Page->pl_template->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->invoice_no->Visible) { // invoice_no ?>
        <td data-name="invoice_no"<?= $Page->invoice_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_invoice_no" class="el_invoice_details_invoice_no">
<span<?= $Page->invoice_no->viewAttributes() ?>>
<?= $Page->invoice_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->invoice_date->Visible) { // invoice_date ?>
        <td data-name="invoice_date"<?= $Page->invoice_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_invoice_date" class="el_invoice_details_invoice_date">
<span<?= $Page->invoice_date->viewAttributes() ?>>
<?= $Page->invoice_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_no->Visible) { // po_no ?>
        <td data-name="po_no"<?= $Page->po_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_po_no" class="el_invoice_details_po_no">
<span<?= $Page->po_no->viewAttributes() ?>>
<?= $Page->po_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->other_reference->Visible) { // other_reference ?>
        <td data-name="other_reference"<?= $Page->other_reference->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_other_reference" class="el_invoice_details_other_reference">
<span<?= $Page->other_reference->viewAttributes() ?>>
<?= $Page->other_reference->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->origin->Visible) { // origin ?>
        <td data-name="origin"<?= $Page->origin->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_origin" class="el_invoice_details_origin">
<span<?= $Page->origin->viewAttributes() ?>>
<?= $Page->origin->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->final_destination->Visible) { // final_destination ?>
        <td data-name="final_destination"<?= $Page->final_destination->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_final_destination" class="el_invoice_details_final_destination">
<span<?= $Page->final_destination->viewAttributes() ?>>
<?= $Page->final_destination->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment_terms->Visible) { // payment_terms ?>
        <td data-name="payment_terms"<?= $Page->payment_terms->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_payment_terms" class="el_invoice_details_payment_terms">
<span<?= $Page->payment_terms->viewAttributes() ?>>
<?= $Page->payment_terms->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pre_carriage_receipt->Visible) { // pre_carriage_receipt ?>
        <td data-name="pre_carriage_receipt"<?= $Page->pre_carriage_receipt->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_pre_carriage_receipt" class="el_invoice_details_pre_carriage_receipt">
<span<?= $Page->pre_carriage_receipt->viewAttributes() ?>>
<?= $Page->pre_carriage_receipt->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->place_of_receipt->Visible) { // place_of_receipt ?>
        <td data-name="place_of_receipt"<?= $Page->place_of_receipt->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_place_of_receipt" class="el_invoice_details_place_of_receipt">
<span<?= $Page->place_of_receipt->viewAttributes() ?>>
<?= $Page->place_of_receipt->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->loading_port->Visible) { // loading_port ?>
        <td data-name="loading_port"<?= $Page->loading_port->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_loading_port" class="el_invoice_details_loading_port">
<span<?= $Page->loading_port->viewAttributes() ?>>
<?= $Page->loading_port->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->port_discharge->Visible) { // port_discharge ?>
        <td data-name="port_discharge"<?= $Page->port_discharge->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_port_discharge" class="el_invoice_details_port_discharge">
<span<?= $Page->port_discharge->viewAttributes() ?>>
<?= $Page->port_discharge->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_01->Visible) { // d_01 ?>
        <td data-name="d_01"<?= $Page->d_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_d_01" class="el_invoice_details_d_01">
<span<?= $Page->d_01->viewAttributes() ?>>
<?= $Page->d_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->description_01->Visible) { // description_01 ?>
        <td data-name="description_01"<?= $Page->description_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_description_01" class="el_invoice_details_description_01">
<span<?= $Page->description_01->viewAttributes() ?>>
<?= $Page->description_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_02->Visible) { // d_02 ?>
        <td data-name="d_02"<?= $Page->d_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_d_02" class="el_invoice_details_d_02">
<span<?= $Page->d_02->viewAttributes() ?>>
<?= $Page->d_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->description_02->Visible) { // description_02 ?>
        <td data-name="description_02"<?= $Page->description_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_description_02" class="el_invoice_details_description_02">
<span<?= $Page->description_02->viewAttributes() ?>>
<?= $Page->description_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gross_weight->Visible) { // gross_weight ?>
        <td data-name="gross_weight"<?= $Page->gross_weight->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_gross_weight" class="el_invoice_details_gross_weight">
<span<?= $Page->gross_weight->viewAttributes() ?>>
<?= $Page->gross_weight->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->nett_weight->Visible) { // nett_weight ?>
        <td data-name="nett_weight"<?= $Page->nett_weight->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_nett_weight" class="el_invoice_details_nett_weight">
<span<?= $Page->nett_weight->viewAttributes() ?>>
<?= $Page->nett_weight->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cbm->Visible) { // cbm ?>
        <td data-name="cbm"<?= $Page->cbm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_cbm" class="el_invoice_details_cbm">
<span<?= $Page->cbm->viewAttributes() ?>>
<?= $Page->cbm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shipment_mode->Visible) { // shipment_mode ?>
        <td data-name="shipment_mode"<?= $Page->shipment_mode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_shipment_mode" class="el_invoice_details_shipment_mode">
<span<?= $Page->shipment_mode->viewAttributes() ?>>
<?= $Page->shipment_mode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ex_factory_date->Visible) { // ex_factory_date ?>
        <td data-name="ex_factory_date"<?= $Page->ex_factory_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_ex_factory_date" class="el_invoice_details_ex_factory_date">
<span<?= $Page->ex_factory_date->viewAttributes() ?>>
<?= $Page->ex_factory_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sailing_date->Visible) { // sailing_date ?>
        <td data-name="sailing_date"<?= $Page->sailing_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_sailing_date" class="el_invoice_details_sailing_date">
<span<?= $Page->sailing_date->viewAttributes() ?>>
<?= $Page->sailing_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_operator" class="el_invoice_details_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_datetime" class="el_invoice_details_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cart_lines->Visible) { // cart_lines ?>
        <td data-name="cart_lines"<?= $Page->cart_lines->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_cart_lines" class="el_invoice_details_cart_lines">
<span<?= $Page->cart_lines->viewAttributes() ?>>
<?= $Page->cart_lines->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pl_lines->Visible) { // pl_lines ?>
        <td data-name="pl_lines"<?= $Page->pl_lines->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_pl_lines" class="el_invoice_details_pl_lines">
<span<?= $Page->pl_lines->viewAttributes() ?>>
<?= $Page->pl_lines->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->freezed->Visible) { // freezed ?>
        <td data-name="freezed"<?= $Page->freezed->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_freezed" class="el_invoice_details_freezed">
<span<?= $Page->freezed->viewAttributes() ?>>
<?= $Page->freezed->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->a_operator->Visible) { // a_operator ?>
        <td data-name="a_operator"<?= $Page->a_operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_a_operator" class="el_invoice_details_a_operator">
<span<?= $Page->a_operator->viewAttributes() ?>>
<?= $Page->a_operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->port_delivery->Visible) { // port_delivery ?>
        <td data-name="port_delivery"<?= $Page->port_delivery->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_port_delivery" class="el_invoice_details_port_delivery">
<span<?= $Page->port_delivery->viewAttributes() ?>>
<?= $Page->port_delivery->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dispatch_details->Visible) { // dispatch_details ?>
        <td data-name="dispatch_details"<?= $Page->dispatch_details->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_invoice_details_dispatch_details" class="el_invoice_details_dispatch_details">
<span<?= $Page->dispatch_details->viewAttributes() ?>>
<?= $Page->dispatch_details->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("invoice_details");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
