<?php

namespace PHPMaker2024\fibre;

// Page object
$InvoiceDetailsAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { invoice_details: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var finvoice_detailsadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("finvoice_detailsadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null], fields._barcode.isInvalid],
            ["exporter", [fields.exporter.visible && fields.exporter.required ? ew.Validators.required(fields.exporter.caption) : null], fields.exporter.isInvalid],
            ["consignee", [fields.consignee.visible && fields.consignee.required ? ew.Validators.required(fields.consignee.caption) : null], fields.consignee.isInvalid],
            ["consignee_other", [fields.consignee_other.visible && fields.consignee_other.required ? ew.Validators.required(fields.consignee_other.caption) : null], fields.consignee_other.isInvalid],
            ["packing_list_no", [fields.packing_list_no.visible && fields.packing_list_no.required ? ew.Validators.required(fields.packing_list_no.caption) : null], fields.packing_list_no.isInvalid],
            ["d_11", [fields.d_11.visible && fields.d_11.required ? ew.Validators.required(fields.d_11.caption) : null], fields.d_11.isInvalid],
            ["description_11", [fields.description_11.visible && fields.description_11.required ? ew.Validators.required(fields.description_11.caption) : null], fields.description_11.isInvalid],
            ["in_template", [fields.in_template.visible && fields.in_template.required ? ew.Validators.required(fields.in_template.caption) : null], fields.in_template.isInvalid],
            ["pl_template", [fields.pl_template.visible && fields.pl_template.required ? ew.Validators.required(fields.pl_template.caption) : null], fields.pl_template.isInvalid],
            ["invoice_no", [fields.invoice_no.visible && fields.invoice_no.required ? ew.Validators.required(fields.invoice_no.caption) : null], fields.invoice_no.isInvalid],
            ["invoice_date", [fields.invoice_date.visible && fields.invoice_date.required ? ew.Validators.required(fields.invoice_date.caption) : null, ew.Validators.datetime(fields.invoice_date.clientFormatPattern)], fields.invoice_date.isInvalid],
            ["po_no", [fields.po_no.visible && fields.po_no.required ? ew.Validators.required(fields.po_no.caption) : null], fields.po_no.isInvalid],
            ["other_reference", [fields.other_reference.visible && fields.other_reference.required ? ew.Validators.required(fields.other_reference.caption) : null], fields.other_reference.isInvalid],
            ["origin", [fields.origin.visible && fields.origin.required ? ew.Validators.required(fields.origin.caption) : null], fields.origin.isInvalid],
            ["final_destination", [fields.final_destination.visible && fields.final_destination.required ? ew.Validators.required(fields.final_destination.caption) : null], fields.final_destination.isInvalid],
            ["payment_terms", [fields.payment_terms.visible && fields.payment_terms.required ? ew.Validators.required(fields.payment_terms.caption) : null], fields.payment_terms.isInvalid],
            ["pre_carriage_receipt", [fields.pre_carriage_receipt.visible && fields.pre_carriage_receipt.required ? ew.Validators.required(fields.pre_carriage_receipt.caption) : null], fields.pre_carriage_receipt.isInvalid],
            ["place_of_receipt", [fields.place_of_receipt.visible && fields.place_of_receipt.required ? ew.Validators.required(fields.place_of_receipt.caption) : null], fields.place_of_receipt.isInvalid],
            ["loading_port", [fields.loading_port.visible && fields.loading_port.required ? ew.Validators.required(fields.loading_port.caption) : null], fields.loading_port.isInvalid],
            ["port_discharge", [fields.port_discharge.visible && fields.port_discharge.required ? ew.Validators.required(fields.port_discharge.caption) : null], fields.port_discharge.isInvalid],
            ["d_01", [fields.d_01.visible && fields.d_01.required ? ew.Validators.required(fields.d_01.caption) : null], fields.d_01.isInvalid],
            ["description_01", [fields.description_01.visible && fields.description_01.required ? ew.Validators.required(fields.description_01.caption) : null], fields.description_01.isInvalid],
            ["d_02", [fields.d_02.visible && fields.d_02.required ? ew.Validators.required(fields.d_02.caption) : null], fields.d_02.isInvalid],
            ["description_02", [fields.description_02.visible && fields.description_02.required ? ew.Validators.required(fields.description_02.caption) : null], fields.description_02.isInvalid],
            ["gross_weight", [fields.gross_weight.visible && fields.gross_weight.required ? ew.Validators.required(fields.gross_weight.caption) : null], fields.gross_weight.isInvalid],
            ["nett_weight", [fields.nett_weight.visible && fields.nett_weight.required ? ew.Validators.required(fields.nett_weight.caption) : null], fields.nett_weight.isInvalid],
            ["cbm", [fields.cbm.visible && fields.cbm.required ? ew.Validators.required(fields.cbm.caption) : null], fields.cbm.isInvalid],
            ["exporter_bank_details", [fields.exporter_bank_details.visible && fields.exporter_bank_details.required ? ew.Validators.required(fields.exporter_bank_details.caption) : null], fields.exporter_bank_details.isInvalid],
            ["intermediary_bank", [fields.intermediary_bank.visible && fields.intermediary_bank.required ? ew.Validators.required(fields.intermediary_bank.caption) : null], fields.intermediary_bank.isInvalid],
            ["shipment_mode", [fields.shipment_mode.visible && fields.shipment_mode.required ? ew.Validators.required(fields.shipment_mode.caption) : null], fields.shipment_mode.isInvalid],
            ["ex_factory_date", [fields.ex_factory_date.visible && fields.ex_factory_date.required ? ew.Validators.required(fields.ex_factory_date.caption) : null, ew.Validators.datetime(fields.ex_factory_date.clientFormatPattern)], fields.ex_factory_date.isInvalid],
            ["sailing_date", [fields.sailing_date.visible && fields.sailing_date.required ? ew.Validators.required(fields.sailing_date.caption) : null, ew.Validators.datetime(fields.sailing_date.clientFormatPattern)], fields.sailing_date.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["cart_lines", [fields.cart_lines.visible && fields.cart_lines.required ? ew.Validators.required(fields.cart_lines.caption) : null, ew.Validators.regex(/^([0-9,]){5,5}$/)], fields.cart_lines.isInvalid],
            ["pl_lines", [fields.pl_lines.visible && fields.pl_lines.required ? ew.Validators.required(fields.pl_lines.caption) : null, ew.Validators.regex(/^([0-9,]){5,5}$/)], fields.pl_lines.isInvalid],
            ["freezed", [fields.freezed.visible && fields.freezed.required ? ew.Validators.required(fields.freezed.caption) : null], fields.freezed.isInvalid],
            ["port_delivery", [fields.port_delivery.visible && fields.port_delivery.required ? ew.Validators.required(fields.port_delivery.caption) : null], fields.port_delivery.isInvalid],
            ["dispatch_details", [fields.dispatch_details.visible && fields.dispatch_details.required ? ew.Validators.required(fields.dispatch_details.caption) : null], fields.dispatch_details.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "exporter": <?= $Page->exporter->toClientList($Page) ?>,
            "consignee": <?= $Page->consignee->toClientList($Page) ?>,
            "consignee_other": <?= $Page->consignee_other->toClientList($Page) ?>,
            "packing_list_no": <?= $Page->packing_list_no->toClientList($Page) ?>,
            "in_template": <?= $Page->in_template->toClientList($Page) ?>,
            "pl_template": <?= $Page->pl_template->toClientList($Page) ?>,
            "shipment_mode": <?= $Page->shipment_mode->toClientList($Page) ?>,
            "freezed": <?= $Page->freezed->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="finvoice_detailsadd" id="finvoice_detailsadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="invoice_details">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode"<?= $Page->_barcode->rowAttributes() ?>>
        <label id="elh_invoice_details__barcode" for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_barcode->caption() ?><?= $Page->_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_barcode->cellAttributes() ?>>
<span id="el_invoice_details__barcode">
<textarea data-table="invoice_details" data-field="x__barcode" name="x__barcode" id="x__barcode" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>"<?= $Page->_barcode->editAttributes() ?> aria-describedby="x__barcode_help"><?= $Page->_barcode->EditValue ?></textarea>
<?= $Page->_barcode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->exporter->Visible) { // exporter ?>
    <div id="r_exporter"<?= $Page->exporter->rowAttributes() ?>>
        <label id="elh_invoice_details_exporter" for="x_exporter" class="<?= $Page->LeftColumnClass ?>"><?= $Page->exporter->caption() ?><?= $Page->exporter->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->exporter->cellAttributes() ?>>
<span id="el_invoice_details_exporter">
    <select
        id="x_exporter"
        name="x_exporter"
        class="form-select ew-select<?= $Page->exporter->isInvalidClass() ?>"
        <?php if (!$Page->exporter->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailsadd_x_exporter"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_exporter"
        data-value-separator="<?= $Page->exporter->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->exporter->getPlaceHolder()) ?>"
        <?= $Page->exporter->editAttributes() ?>>
        <?= $Page->exporter->selectOptionListHtml("x_exporter") ?>
    </select>
    <?= $Page->exporter->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->exporter->getErrorMessage() ?></div>
<?= $Page->exporter->Lookup->getParamTag($Page, "p_x_exporter") ?>
<?php if (!$Page->exporter->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailsadd", function() {
    var options = { name: "x_exporter", selectId: "finvoice_detailsadd_x_exporter" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailsadd.lists.exporter?.lookupOptions.length) {
        options.data = { id: "x_exporter", form: "finvoice_detailsadd" };
    } else {
        options.ajax = { id: "x_exporter", form: "finvoice_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.exporter.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->consignee->Visible) { // consignee ?>
    <div id="r_consignee"<?= $Page->consignee->rowAttributes() ?>>
        <label id="elh_invoice_details_consignee" for="x_consignee" class="<?= $Page->LeftColumnClass ?>"><?= $Page->consignee->caption() ?><?= $Page->consignee->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->consignee->cellAttributes() ?>>
<span id="el_invoice_details_consignee">
    <select
        id="x_consignee"
        name="x_consignee"
        class="form-select ew-select<?= $Page->consignee->isInvalidClass() ?>"
        <?php if (!$Page->consignee->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailsadd_x_consignee"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_consignee"
        data-value-separator="<?= $Page->consignee->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->consignee->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->consignee->editAttributes() ?>>
        <?= $Page->consignee->selectOptionListHtml("x_consignee") ?>
    </select>
    <?= $Page->consignee->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->consignee->getErrorMessage() ?></div>
<?= $Page->consignee->Lookup->getParamTag($Page, "p_x_consignee") ?>
<?php if (!$Page->consignee->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailsadd", function() {
    var options = { name: "x_consignee", selectId: "finvoice_detailsadd_x_consignee" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailsadd.lists.consignee?.lookupOptions.length) {
        options.data = { id: "x_consignee", form: "finvoice_detailsadd" };
    } else {
        options.ajax = { id: "x_consignee", form: "finvoice_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.consignee.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->consignee_other->Visible) { // consignee_other ?>
    <div id="r_consignee_other"<?= $Page->consignee_other->rowAttributes() ?>>
        <label id="elh_invoice_details_consignee_other" for="x_consignee_other" class="<?= $Page->LeftColumnClass ?>"><?= $Page->consignee_other->caption() ?><?= $Page->consignee_other->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->consignee_other->cellAttributes() ?>>
<span id="el_invoice_details_consignee_other">
    <select
        id="x_consignee_other"
        name="x_consignee_other"
        class="form-select ew-select<?= $Page->consignee_other->isInvalidClass() ?>"
        <?php if (!$Page->consignee_other->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailsadd_x_consignee_other"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_consignee_other"
        data-value-separator="<?= $Page->consignee_other->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->consignee_other->getPlaceHolder()) ?>"
        <?= $Page->consignee_other->editAttributes() ?>>
        <?= $Page->consignee_other->selectOptionListHtml("x_consignee_other") ?>
    </select>
    <?= $Page->consignee_other->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->consignee_other->getErrorMessage() ?></div>
<?= $Page->consignee_other->Lookup->getParamTag($Page, "p_x_consignee_other") ?>
<?php if (!$Page->consignee_other->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailsadd", function() {
    var options = { name: "x_consignee_other", selectId: "finvoice_detailsadd_x_consignee_other" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailsadd.lists.consignee_other?.lookupOptions.length) {
        options.data = { id: "x_consignee_other", form: "finvoice_detailsadd" };
    } else {
        options.ajax = { id: "x_consignee_other", form: "finvoice_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.consignee_other.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing_list_no->Visible) { // packing_list_no ?>
    <div id="r_packing_list_no"<?= $Page->packing_list_no->rowAttributes() ?>>
        <label id="elh_invoice_details_packing_list_no" for="x_packing_list_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing_list_no->caption() ?><?= $Page->packing_list_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing_list_no->cellAttributes() ?>>
<span id="el_invoice_details_packing_list_no">
    <select
        id="x_packing_list_no"
        name="x_packing_list_no"
        class="form-select ew-select<?= $Page->packing_list_no->isInvalidClass() ?>"
        <?php if (!$Page->packing_list_no->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailsadd_x_packing_list_no"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_packing_list_no"
        data-value-separator="<?= $Page->packing_list_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_list_no->getPlaceHolder()) ?>"
        <?= $Page->packing_list_no->editAttributes() ?>>
        <?= $Page->packing_list_no->selectOptionListHtml("x_packing_list_no") ?>
    </select>
    <?= $Page->packing_list_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->packing_list_no->getErrorMessage() ?></div>
<?= $Page->packing_list_no->Lookup->getParamTag($Page, "p_x_packing_list_no") ?>
<?php if (!$Page->packing_list_no->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailsadd", function() {
    var options = { name: "x_packing_list_no", selectId: "finvoice_detailsadd_x_packing_list_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailsadd.lists.packing_list_no?.lookupOptions.length) {
        options.data = { id: "x_packing_list_no", form: "finvoice_detailsadd" };
    } else {
        options.ajax = { id: "x_packing_list_no", form: "finvoice_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.packing_list_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->d_11->Visible) { // d_11 ?>
    <div id="r_d_11"<?= $Page->d_11->rowAttributes() ?>>
        <label id="elh_invoice_details_d_11" for="x_d_11" class="<?= $Page->LeftColumnClass ?>"><?= $Page->d_11->caption() ?><?= $Page->d_11->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->d_11->cellAttributes() ?>>
<span id="el_invoice_details_d_11">
<input type="<?= $Page->d_11->getInputTextType() ?>" name="x_d_11" id="x_d_11" data-table="invoice_details" data-field="x_d_11" value="<?= $Page->d_11->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_11->formatPattern()) ?>"<?= $Page->d_11->editAttributes() ?> aria-describedby="x_d_11_help">
<?= $Page->d_11->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->d_11->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_11->Visible) { // description_11 ?>
    <div id="r_description_11"<?= $Page->description_11->rowAttributes() ?>>
        <label id="elh_invoice_details_description_11" for="x_description_11" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_11->caption() ?><?= $Page->description_11->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_11->cellAttributes() ?>>
<span id="el_invoice_details_description_11">
<textarea data-table="invoice_details" data-field="x_description_11" name="x_description_11" id="x_description_11" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->description_11->getPlaceHolder()) ?>"<?= $Page->description_11->editAttributes() ?> aria-describedby="x_description_11_help"><?= $Page->description_11->EditValue ?></textarea>
<?= $Page->description_11->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_11->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->in_template->Visible) { // in_template ?>
    <div id="r_in_template"<?= $Page->in_template->rowAttributes() ?>>
        <label id="elh_invoice_details_in_template" for="x_in_template" class="<?= $Page->LeftColumnClass ?>"><?= $Page->in_template->caption() ?><?= $Page->in_template->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->in_template->cellAttributes() ?>>
<span id="el_invoice_details_in_template">
    <select
        id="x_in_template"
        name="x_in_template"
        class="form-select ew-select<?= $Page->in_template->isInvalidClass() ?>"
        <?php if (!$Page->in_template->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailsadd_x_in_template"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_in_template"
        data-value-separator="<?= $Page->in_template->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->in_template->getPlaceHolder()) ?>"
        <?= $Page->in_template->editAttributes() ?>>
        <?= $Page->in_template->selectOptionListHtml("x_in_template") ?>
    </select>
    <?= $Page->in_template->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->in_template->getErrorMessage() ?></div>
<?= $Page->in_template->Lookup->getParamTag($Page, "p_x_in_template") ?>
<?php if (!$Page->in_template->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailsadd", function() {
    var options = { name: "x_in_template", selectId: "finvoice_detailsadd_x_in_template" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailsadd.lists.in_template?.lookupOptions.length) {
        options.data = { id: "x_in_template", form: "finvoice_detailsadd" };
    } else {
        options.ajax = { id: "x_in_template", form: "finvoice_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.in_template.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pl_template->Visible) { // pl_template ?>
    <div id="r_pl_template"<?= $Page->pl_template->rowAttributes() ?>>
        <label id="elh_invoice_details_pl_template" for="x_pl_template" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pl_template->caption() ?><?= $Page->pl_template->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pl_template->cellAttributes() ?>>
<span id="el_invoice_details_pl_template">
    <select
        id="x_pl_template"
        name="x_pl_template"
        class="form-select ew-select<?= $Page->pl_template->isInvalidClass() ?>"
        <?php if (!$Page->pl_template->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailsadd_x_pl_template"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_pl_template"
        data-value-separator="<?= $Page->pl_template->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pl_template->getPlaceHolder()) ?>"
        <?= $Page->pl_template->editAttributes() ?>>
        <?= $Page->pl_template->selectOptionListHtml("x_pl_template") ?>
    </select>
    <?= $Page->pl_template->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->pl_template->getErrorMessage() ?></div>
<?= $Page->pl_template->Lookup->getParamTag($Page, "p_x_pl_template") ?>
<?php if (!$Page->pl_template->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailsadd", function() {
    var options = { name: "x_pl_template", selectId: "finvoice_detailsadd_x_pl_template" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailsadd.lists.pl_template?.lookupOptions.length) {
        options.data = { id: "x_pl_template", form: "finvoice_detailsadd" };
    } else {
        options.ajax = { id: "x_pl_template", form: "finvoice_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.pl_template.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->invoice_no->Visible) { // invoice_no ?>
    <div id="r_invoice_no"<?= $Page->invoice_no->rowAttributes() ?>>
        <label id="elh_invoice_details_invoice_no" for="x_invoice_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->invoice_no->caption() ?><?= $Page->invoice_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->invoice_no->cellAttributes() ?>>
<span id="el_invoice_details_invoice_no">
<input type="<?= $Page->invoice_no->getInputTextType() ?>" name="x_invoice_no" id="x_invoice_no" data-table="invoice_details" data-field="x_invoice_no" value="<?= $Page->invoice_no->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->invoice_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_no->formatPattern()) ?>"<?= $Page->invoice_no->editAttributes() ?> aria-describedby="x_invoice_no_help">
<?= $Page->invoice_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->invoice_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
    <div id="r_invoice_date"<?= $Page->invoice_date->rowAttributes() ?>>
        <label id="elh_invoice_details_invoice_date" for="x_invoice_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->invoice_date->caption() ?><?= $Page->invoice_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->invoice_date->cellAttributes() ?>>
<span id="el_invoice_details_invoice_date">
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="x_invoice_date" id="x_invoice_date" data-table="invoice_details" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?> aria-describedby="x_invoice_date_help">
<?= $Page->invoice_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage() ?></div>
<?php if (!$Page->invoice_date->ReadOnly && !$Page->invoice_date->Disabled && !isset($Page->invoice_date->EditAttrs["readonly"]) && !isset($Page->invoice_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvoice_detailsadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvoice_detailsadd", "x_invoice_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_no->Visible) { // po_no ?>
    <div id="r_po_no"<?= $Page->po_no->rowAttributes() ?>>
        <label id="elh_invoice_details_po_no" for="x_po_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_no->caption() ?><?= $Page->po_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_no->cellAttributes() ?>>
<span id="el_invoice_details_po_no">
<textarea data-table="invoice_details" data-field="x_po_no" name="x_po_no" id="x_po_no" cols="35" rows="3" placeholder="<?= HtmlEncode($Page->po_no->getPlaceHolder()) ?>"<?= $Page->po_no->editAttributes() ?> aria-describedby="x_po_no_help"><?= $Page->po_no->EditValue ?></textarea>
<?= $Page->po_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->po_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other_reference->Visible) { // other_reference ?>
    <div id="r_other_reference"<?= $Page->other_reference->rowAttributes() ?>>
        <label id="elh_invoice_details_other_reference" for="x_other_reference" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other_reference->caption() ?><?= $Page->other_reference->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other_reference->cellAttributes() ?>>
<span id="el_invoice_details_other_reference">
<input type="<?= $Page->other_reference->getInputTextType() ?>" name="x_other_reference" id="x_other_reference" data-table="invoice_details" data-field="x_other_reference" value="<?= $Page->other_reference->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->other_reference->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_reference->formatPattern()) ?>"<?= $Page->other_reference->editAttributes() ?> aria-describedby="x_other_reference_help">
<?= $Page->other_reference->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other_reference->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->origin->Visible) { // origin ?>
    <div id="r_origin"<?= $Page->origin->rowAttributes() ?>>
        <label id="elh_invoice_details_origin" for="x_origin" class="<?= $Page->LeftColumnClass ?>"><?= $Page->origin->caption() ?><?= $Page->origin->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->origin->cellAttributes() ?>>
<span id="el_invoice_details_origin">
<input type="<?= $Page->origin->getInputTextType() ?>" name="x_origin" id="x_origin" data-table="invoice_details" data-field="x_origin" value="<?= $Page->origin->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->origin->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->origin->formatPattern()) ?>"<?= $Page->origin->editAttributes() ?> aria-describedby="x_origin_help">
<?= $Page->origin->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->origin->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->final_destination->Visible) { // final_destination ?>
    <div id="r_final_destination"<?= $Page->final_destination->rowAttributes() ?>>
        <label id="elh_invoice_details_final_destination" for="x_final_destination" class="<?= $Page->LeftColumnClass ?>"><?= $Page->final_destination->caption() ?><?= $Page->final_destination->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->final_destination->cellAttributes() ?>>
<span id="el_invoice_details_final_destination">
<input type="<?= $Page->final_destination->getInputTextType() ?>" name="x_final_destination" id="x_final_destination" data-table="invoice_details" data-field="x_final_destination" value="<?= $Page->final_destination->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->final_destination->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->final_destination->formatPattern()) ?>"<?= $Page->final_destination->editAttributes() ?> aria-describedby="x_final_destination_help">
<?= $Page->final_destination->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->final_destination->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
    <div id="r_payment_terms"<?= $Page->payment_terms->rowAttributes() ?>>
        <label id="elh_invoice_details_payment_terms" for="x_payment_terms" class="<?= $Page->LeftColumnClass ?>"><?= $Page->payment_terms->caption() ?><?= $Page->payment_terms->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->payment_terms->cellAttributes() ?>>
<span id="el_invoice_details_payment_terms">
<textarea data-table="invoice_details" data-field="x_payment_terms" name="x_payment_terms" id="x_payment_terms" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->payment_terms->getPlaceHolder()) ?>"<?= $Page->payment_terms->editAttributes() ?> aria-describedby="x_payment_terms_help"><?= $Page->payment_terms->EditValue ?></textarea>
<?= $Page->payment_terms->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->payment_terms->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pre_carriage_receipt->Visible) { // pre_carriage_receipt ?>
    <div id="r_pre_carriage_receipt"<?= $Page->pre_carriage_receipt->rowAttributes() ?>>
        <label id="elh_invoice_details_pre_carriage_receipt" for="x_pre_carriage_receipt" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pre_carriage_receipt->caption() ?><?= $Page->pre_carriage_receipt->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pre_carriage_receipt->cellAttributes() ?>>
<span id="el_invoice_details_pre_carriage_receipt">
<input type="<?= $Page->pre_carriage_receipt->getInputTextType() ?>" name="x_pre_carriage_receipt" id="x_pre_carriage_receipt" data-table="invoice_details" data-field="x_pre_carriage_receipt" value="<?= $Page->pre_carriage_receipt->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->pre_carriage_receipt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pre_carriage_receipt->formatPattern()) ?>"<?= $Page->pre_carriage_receipt->editAttributes() ?> aria-describedby="x_pre_carriage_receipt_help">
<?= $Page->pre_carriage_receipt->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->pre_carriage_receipt->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->place_of_receipt->Visible) { // place_of_receipt ?>
    <div id="r_place_of_receipt"<?= $Page->place_of_receipt->rowAttributes() ?>>
        <label id="elh_invoice_details_place_of_receipt" for="x_place_of_receipt" class="<?= $Page->LeftColumnClass ?>"><?= $Page->place_of_receipt->caption() ?><?= $Page->place_of_receipt->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->place_of_receipt->cellAttributes() ?>>
<span id="el_invoice_details_place_of_receipt">
<input type="<?= $Page->place_of_receipt->getInputTextType() ?>" name="x_place_of_receipt" id="x_place_of_receipt" data-table="invoice_details" data-field="x_place_of_receipt" value="<?= $Page->place_of_receipt->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->place_of_receipt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->place_of_receipt->formatPattern()) ?>"<?= $Page->place_of_receipt->editAttributes() ?> aria-describedby="x_place_of_receipt_help">
<?= $Page->place_of_receipt->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->place_of_receipt->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->loading_port->Visible) { // loading_port ?>
    <div id="r_loading_port"<?= $Page->loading_port->rowAttributes() ?>>
        <label id="elh_invoice_details_loading_port" for="x_loading_port" class="<?= $Page->LeftColumnClass ?>"><?= $Page->loading_port->caption() ?><?= $Page->loading_port->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->loading_port->cellAttributes() ?>>
<span id="el_invoice_details_loading_port">
<input type="<?= $Page->loading_port->getInputTextType() ?>" name="x_loading_port" id="x_loading_port" data-table="invoice_details" data-field="x_loading_port" value="<?= $Page->loading_port->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->loading_port->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->loading_port->formatPattern()) ?>"<?= $Page->loading_port->editAttributes() ?> aria-describedby="x_loading_port_help">
<?= $Page->loading_port->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->loading_port->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->port_discharge->Visible) { // port_discharge ?>
    <div id="r_port_discharge"<?= $Page->port_discharge->rowAttributes() ?>>
        <label id="elh_invoice_details_port_discharge" for="x_port_discharge" class="<?= $Page->LeftColumnClass ?>"><?= $Page->port_discharge->caption() ?><?= $Page->port_discharge->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->port_discharge->cellAttributes() ?>>
<span id="el_invoice_details_port_discharge">
<input type="<?= $Page->port_discharge->getInputTextType() ?>" name="x_port_discharge" id="x_port_discharge" data-table="invoice_details" data-field="x_port_discharge" value="<?= $Page->port_discharge->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->port_discharge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_discharge->formatPattern()) ?>"<?= $Page->port_discharge->editAttributes() ?> aria-describedby="x_port_discharge_help">
<?= $Page->port_discharge->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->port_discharge->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->d_01->Visible) { // d_01 ?>
    <div id="r_d_01"<?= $Page->d_01->rowAttributes() ?>>
        <label id="elh_invoice_details_d_01" for="x_d_01" class="<?= $Page->LeftColumnClass ?>"><?= $Page->d_01->caption() ?><?= $Page->d_01->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->d_01->cellAttributes() ?>>
<span id="el_invoice_details_d_01">
<input type="<?= $Page->d_01->getInputTextType() ?>" name="x_d_01" id="x_d_01" data-table="invoice_details" data-field="x_d_01" value="<?= $Page->d_01->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_01->formatPattern()) ?>"<?= $Page->d_01->editAttributes() ?> aria-describedby="x_d_01_help">
<?= $Page->d_01->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->d_01->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_01->Visible) { // description_01 ?>
    <div id="r_description_01"<?= $Page->description_01->rowAttributes() ?>>
        <label id="elh_invoice_details_description_01" for="x_description_01" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_01->caption() ?><?= $Page->description_01->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_01->cellAttributes() ?>>
<span id="el_invoice_details_description_01">
<input type="<?= $Page->description_01->getInputTextType() ?>" name="x_description_01" id="x_description_01" data-table="invoice_details" data-field="x_description_01" value="<?= $Page->description_01->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_01->formatPattern()) ?>"<?= $Page->description_01->editAttributes() ?> aria-describedby="x_description_01_help">
<?= $Page->description_01->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_01->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->d_02->Visible) { // d_02 ?>
    <div id="r_d_02"<?= $Page->d_02->rowAttributes() ?>>
        <label id="elh_invoice_details_d_02" for="x_d_02" class="<?= $Page->LeftColumnClass ?>"><?= $Page->d_02->caption() ?><?= $Page->d_02->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->d_02->cellAttributes() ?>>
<span id="el_invoice_details_d_02">
<input type="<?= $Page->d_02->getInputTextType() ?>" name="x_d_02" id="x_d_02" data-table="invoice_details" data-field="x_d_02" value="<?= $Page->d_02->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->d_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_02->formatPattern()) ?>"<?= $Page->d_02->editAttributes() ?> aria-describedby="x_d_02_help">
<?= $Page->d_02->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->d_02->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_02->Visible) { // description_02 ?>
    <div id="r_description_02"<?= $Page->description_02->rowAttributes() ?>>
        <label id="elh_invoice_details_description_02" for="x_description_02" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_02->caption() ?><?= $Page->description_02->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_02->cellAttributes() ?>>
<span id="el_invoice_details_description_02">
<input type="<?= $Page->description_02->getInputTextType() ?>" name="x_description_02" id="x_description_02" data-table="invoice_details" data-field="x_description_02" value="<?= $Page->description_02->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description_02->formatPattern()) ?>"<?= $Page->description_02->editAttributes() ?> aria-describedby="x_description_02_help">
<?= $Page->description_02->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_02->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gross_weight->Visible) { // gross_weight ?>
    <div id="r_gross_weight"<?= $Page->gross_weight->rowAttributes() ?>>
        <label id="elh_invoice_details_gross_weight" for="x_gross_weight" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gross_weight->caption() ?><?= $Page->gross_weight->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gross_weight->cellAttributes() ?>>
<span id="el_invoice_details_gross_weight">
<input type="<?= $Page->gross_weight->getInputTextType() ?>" name="x_gross_weight" id="x_gross_weight" data-table="invoice_details" data-field="x_gross_weight" value="<?= $Page->gross_weight->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->gross_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gross_weight->formatPattern()) ?>"<?= $Page->gross_weight->editAttributes() ?> aria-describedby="x_gross_weight_help">
<?= $Page->gross_weight->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->gross_weight->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->nett_weight->Visible) { // nett_weight ?>
    <div id="r_nett_weight"<?= $Page->nett_weight->rowAttributes() ?>>
        <label id="elh_invoice_details_nett_weight" for="x_nett_weight" class="<?= $Page->LeftColumnClass ?>"><?= $Page->nett_weight->caption() ?><?= $Page->nett_weight->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->nett_weight->cellAttributes() ?>>
<span id="el_invoice_details_nett_weight">
<input type="<?= $Page->nett_weight->getInputTextType() ?>" name="x_nett_weight" id="x_nett_weight" data-table="invoice_details" data-field="x_nett_weight" value="<?= $Page->nett_weight->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->nett_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->nett_weight->formatPattern()) ?>"<?= $Page->nett_weight->editAttributes() ?> aria-describedby="x_nett_weight_help">
<?= $Page->nett_weight->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->nett_weight->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
    <div id="r_cbm"<?= $Page->cbm->rowAttributes() ?>>
        <label id="elh_invoice_details_cbm" for="x_cbm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cbm->caption() ?><?= $Page->cbm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cbm->cellAttributes() ?>>
<span id="el_invoice_details_cbm">
<input type="<?= $Page->cbm->getInputTextType() ?>" name="x_cbm" id="x_cbm" data-table="invoice_details" data-field="x_cbm" value="<?= $Page->cbm->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cbm->formatPattern()) ?>"<?= $Page->cbm->editAttributes() ?> aria-describedby="x_cbm_help">
<?= $Page->cbm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cbm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->exporter_bank_details->Visible) { // exporter_bank_details ?>
    <div id="r_exporter_bank_details"<?= $Page->exporter_bank_details->rowAttributes() ?>>
        <label id="elh_invoice_details_exporter_bank_details" for="x_exporter_bank_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->exporter_bank_details->caption() ?><?= $Page->exporter_bank_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->exporter_bank_details->cellAttributes() ?>>
<span id="el_invoice_details_exporter_bank_details">
<textarea data-table="invoice_details" data-field="x_exporter_bank_details" name="x_exporter_bank_details" id="x_exporter_bank_details" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->exporter_bank_details->getPlaceHolder()) ?>"<?= $Page->exporter_bank_details->editAttributes() ?> aria-describedby="x_exporter_bank_details_help"><?= $Page->exporter_bank_details->EditValue ?></textarea>
<?= $Page->exporter_bank_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->exporter_bank_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->intermediary_bank->Visible) { // intermediary_bank ?>
    <div id="r_intermediary_bank"<?= $Page->intermediary_bank->rowAttributes() ?>>
        <label id="elh_invoice_details_intermediary_bank" for="x_intermediary_bank" class="<?= $Page->LeftColumnClass ?>"><?= $Page->intermediary_bank->caption() ?><?= $Page->intermediary_bank->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->intermediary_bank->cellAttributes() ?>>
<span id="el_invoice_details_intermediary_bank">
<textarea data-table="invoice_details" data-field="x_intermediary_bank" name="x_intermediary_bank" id="x_intermediary_bank" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->intermediary_bank->getPlaceHolder()) ?>"<?= $Page->intermediary_bank->editAttributes() ?> aria-describedby="x_intermediary_bank_help"><?= $Page->intermediary_bank->EditValue ?></textarea>
<?= $Page->intermediary_bank->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->intermediary_bank->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shipment_mode->Visible) { // shipment_mode ?>
    <div id="r_shipment_mode"<?= $Page->shipment_mode->rowAttributes() ?>>
        <label id="elh_invoice_details_shipment_mode" for="x_shipment_mode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shipment_mode->caption() ?><?= $Page->shipment_mode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shipment_mode->cellAttributes() ?>>
<span id="el_invoice_details_shipment_mode">
    <select
        id="x_shipment_mode"
        name="x_shipment_mode"
        class="form-select ew-select<?= $Page->shipment_mode->isInvalidClass() ?>"
        <?php if (!$Page->shipment_mode->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailsadd_x_shipment_mode"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_shipment_mode"
        data-value-separator="<?= $Page->shipment_mode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shipment_mode->getPlaceHolder()) ?>"
        <?= $Page->shipment_mode->editAttributes() ?>>
        <?= $Page->shipment_mode->selectOptionListHtml("x_shipment_mode") ?>
    </select>
    <?= $Page->shipment_mode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->shipment_mode->getErrorMessage() ?></div>
<?php if (!$Page->shipment_mode->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailsadd", function() {
    var options = { name: "x_shipment_mode", selectId: "finvoice_detailsadd_x_shipment_mode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailsadd.lists.shipment_mode?.lookupOptions.length) {
        options.data = { id: "x_shipment_mode", form: "finvoice_detailsadd" };
    } else {
        options.ajax = { id: "x_shipment_mode", form: "finvoice_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.shipment_mode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ex_factory_date->Visible) { // ex_factory_date ?>
    <div id="r_ex_factory_date"<?= $Page->ex_factory_date->rowAttributes() ?>>
        <label id="elh_invoice_details_ex_factory_date" for="x_ex_factory_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ex_factory_date->caption() ?><?= $Page->ex_factory_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ex_factory_date->cellAttributes() ?>>
<span id="el_invoice_details_ex_factory_date">
<input type="<?= $Page->ex_factory_date->getInputTextType() ?>" name="x_ex_factory_date" id="x_ex_factory_date" data-table="invoice_details" data-field="x_ex_factory_date" value="<?= $Page->ex_factory_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->ex_factory_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ex_factory_date->formatPattern()) ?>"<?= $Page->ex_factory_date->editAttributes() ?> aria-describedby="x_ex_factory_date_help">
<?= $Page->ex_factory_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ex_factory_date->getErrorMessage() ?></div>
<?php if (!$Page->ex_factory_date->ReadOnly && !$Page->ex_factory_date->Disabled && !isset($Page->ex_factory_date->EditAttrs["readonly"]) && !isset($Page->ex_factory_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvoice_detailsadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvoice_detailsadd", "x_ex_factory_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sailing_date->Visible) { // sailing_date ?>
    <div id="r_sailing_date"<?= $Page->sailing_date->rowAttributes() ?>>
        <label id="elh_invoice_details_sailing_date" for="x_sailing_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sailing_date->caption() ?><?= $Page->sailing_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sailing_date->cellAttributes() ?>>
<span id="el_invoice_details_sailing_date">
<input type="<?= $Page->sailing_date->getInputTextType() ?>" name="x_sailing_date" id="x_sailing_date" data-table="invoice_details" data-field="x_sailing_date" value="<?= $Page->sailing_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->sailing_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sailing_date->formatPattern()) ?>"<?= $Page->sailing_date->editAttributes() ?> aria-describedby="x_sailing_date_help">
<?= $Page->sailing_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sailing_date->getErrorMessage() ?></div>
<?php if (!$Page->sailing_date->ReadOnly && !$Page->sailing_date->Disabled && !isset($Page->sailing_date->EditAttrs["readonly"]) && !isset($Page->sailing_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvoice_detailsadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvoice_detailsadd", "x_sailing_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cart_lines->Visible) { // cart_lines ?>
    <div id="r_cart_lines"<?= $Page->cart_lines->rowAttributes() ?>>
        <label id="elh_invoice_details_cart_lines" for="x_cart_lines" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cart_lines->caption() ?><?= $Page->cart_lines->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cart_lines->cellAttributes() ?>>
<span id="el_invoice_details_cart_lines">
<input type="<?= $Page->cart_lines->getInputTextType() ?>" name="x_cart_lines" id="x_cart_lines" data-table="invoice_details" data-field="x_cart_lines" value="<?= $Page->cart_lines->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->cart_lines->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cart_lines->formatPattern()) ?>"<?= $Page->cart_lines->editAttributes() ?> aria-describedby="x_cart_lines_help">
<?= $Page->cart_lines->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cart_lines->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pl_lines->Visible) { // pl_lines ?>
    <div id="r_pl_lines"<?= $Page->pl_lines->rowAttributes() ?>>
        <label id="elh_invoice_details_pl_lines" for="x_pl_lines" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pl_lines->caption() ?><?= $Page->pl_lines->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pl_lines->cellAttributes() ?>>
<span id="el_invoice_details_pl_lines">
<input type="<?= $Page->pl_lines->getInputTextType() ?>" name="x_pl_lines" id="x_pl_lines" data-table="invoice_details" data-field="x_pl_lines" value="<?= $Page->pl_lines->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->pl_lines->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_lines->formatPattern()) ?>"<?= $Page->pl_lines->editAttributes() ?> aria-describedby="x_pl_lines_help">
<?= $Page->pl_lines->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->pl_lines->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->freezed->Visible) { // freezed ?>
    <div id="r_freezed"<?= $Page->freezed->rowAttributes() ?>>
        <label id="elh_invoice_details_freezed" for="x_freezed" class="<?= $Page->LeftColumnClass ?>"><?= $Page->freezed->caption() ?><?= $Page->freezed->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->freezed->cellAttributes() ?>>
<span id="el_invoice_details_freezed">
    <select
        id="x_freezed"
        name="x_freezed"
        class="form-select ew-select<?= $Page->freezed->isInvalidClass() ?>"
        <?php if (!$Page->freezed->IsNativeSelect) { ?>
        data-select2-id="finvoice_detailsadd_x_freezed"
        <?php } ?>
        data-table="invoice_details"
        data-field="x_freezed"
        data-value-separator="<?= $Page->freezed->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->freezed->getPlaceHolder()) ?>"
        <?= $Page->freezed->editAttributes() ?>>
        <?= $Page->freezed->selectOptionListHtml("x_freezed") ?>
    </select>
    <?= $Page->freezed->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->freezed->getErrorMessage() ?></div>
<?php if (!$Page->freezed->IsNativeSelect) { ?>
<script>
loadjs.ready("finvoice_detailsadd", function() {
    var options = { name: "x_freezed", selectId: "finvoice_detailsadd_x_freezed" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvoice_detailsadd.lists.freezed?.lookupOptions.length) {
        options.data = { id: "x_freezed", form: "finvoice_detailsadd" };
    } else {
        options.ajax = { id: "x_freezed", form: "finvoice_detailsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.invoice_details.fields.freezed.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->port_delivery->Visible) { // port_delivery ?>
    <div id="r_port_delivery"<?= $Page->port_delivery->rowAttributes() ?>>
        <label id="elh_invoice_details_port_delivery" for="x_port_delivery" class="<?= $Page->LeftColumnClass ?>"><?= $Page->port_delivery->caption() ?><?= $Page->port_delivery->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->port_delivery->cellAttributes() ?>>
<span id="el_invoice_details_port_delivery">
<input type="<?= $Page->port_delivery->getInputTextType() ?>" name="x_port_delivery" id="x_port_delivery" data-table="invoice_details" data-field="x_port_delivery" value="<?= $Page->port_delivery->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->port_delivery->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_delivery->formatPattern()) ?>"<?= $Page->port_delivery->editAttributes() ?> aria-describedby="x_port_delivery_help">
<?= $Page->port_delivery->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->port_delivery->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dispatch_details->Visible) { // dispatch_details ?>
    <div id="r_dispatch_details"<?= $Page->dispatch_details->rowAttributes() ?>>
        <label id="elh_invoice_details_dispatch_details" for="x_dispatch_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dispatch_details->caption() ?><?= $Page->dispatch_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dispatch_details->cellAttributes() ?>>
<span id="el_invoice_details_dispatch_details">
<input type="<?= $Page->dispatch_details->getInputTextType() ?>" name="x_dispatch_details" id="x_dispatch_details" data-table="invoice_details" data-field="x_dispatch_details" value="<?= $Page->dispatch_details->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->dispatch_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dispatch_details->formatPattern()) ?>"<?= $Page->dispatch_details->editAttributes() ?> aria-describedby="x_dispatch_details_help">
<?= $Page->dispatch_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dispatch_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="finvoice_detailsadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="finvoice_detailsadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("invoice_details");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    $("#r_po_no").append('<div class="input-group-append" ><h6 style="color:blue" onclick="javascript:populatebuyerpo()"><i class="fa fa-check"></i> Populate Buyer PO</h6></div>');

    function populatebuyerpo()
    {
    	var pl = $("#x_packing_list_no").val();
    			$.getJSON(window.location.origin +'/apcajax?getbuyerpobyplno='+pl,function(data) {
    			$("#x_po_no").val(data);
    			});
    }
});
</script>
