<?php

namespace PHPMaker2024\fibre;

// Page object
$InvestorListView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="finvestor_listview" id="finvestor_listview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { investor_list: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var finvestor_listview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("finvestor_listview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="investor_list">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_investor_list_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_investor_list_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->share_no->Visible) { // share_no ?>
    <tr id="r_share_no"<?= $Page->share_no->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_investor_list_share_no"><?= $Page->share_no->caption() ?></span></td>
        <td data-name="share_no"<?= $Page->share_no->cellAttributes() ?>>
<span id="el_investor_list_share_no">
<span<?= $Page->share_no->viewAttributes() ?>>
<?= $Page->share_no->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->folio_no->Visible) { // folio_no ?>
    <tr id="r_folio_no"<?= $Page->folio_no->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_investor_list_folio_no"><?= $Page->folio_no->caption() ?></span></td>
        <td data-name="folio_no"<?= $Page->folio_no->cellAttributes() ?>>
<span id="el_investor_list_folio_no">
<span<?= $Page->folio_no->viewAttributes() ?>>
<?= $Page->folio_no->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <tr id="r_qty"<?= $Page->qty->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_investor_list_qty"><?= $Page->qty->caption() ?></span></td>
        <td data-name="qty"<?= $Page->qty->cellAttributes() ?>>
<span id="el_investor_list_qty">
<span<?= $Page->qty->viewAttributes() ?>>
<?= $Page->qty->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->transfer_id_old->Visible) { // transfer_id_old ?>
    <tr id="r_transfer_id_old"<?= $Page->transfer_id_old->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_investor_list_transfer_id_old"><?= $Page->transfer_id_old->caption() ?></span></td>
        <td data-name="transfer_id_old"<?= $Page->transfer_id_old->cellAttributes() ?>>
<span id="el_investor_list_transfer_id_old">
<span<?= $Page->transfer_id_old->viewAttributes() ?>>
<?= $Page->transfer_id_old->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->transfer_id_new->Visible) { // transfer_id_new ?>
    <tr id="r_transfer_id_new"<?= $Page->transfer_id_new->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_investor_list_transfer_id_new"><?= $Page->transfer_id_new->caption() ?></span></td>
        <td data-name="transfer_id_new"<?= $Page->transfer_id_new->cellAttributes() ?>>
<span id="el_investor_list_transfer_id_new">
<span<?= $Page->transfer_id_new->viewAttributes() ?>>
<?= $Page->transfer_id_new->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <tr id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_investor_list_operator"><?= $Page->operator->caption() ?></span></td>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el_investor_list_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <tr id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_investor_list_datetime"><?= $Page->datetime->caption() ?></span></td>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el_investor_list_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
