<?php

namespace PHPMaker2024\fibre;

// Page object
$InvestorListSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { investor_list: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var finvestor_listsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("finvestor_listsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["share_no", [ew.Validators.integer], fields.share_no.isInvalid],
            ["folio_no", [], fields.folio_no.isInvalid],
            ["qty", [ew.Validators.integer], fields.qty.isInvalid],
            ["transfer_id_old", [ew.Validators.integer], fields.transfer_id_old.isInvalid],
            ["transfer_id_new", [ew.Validators.integer], fields.transfer_id_new.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "folio_no": <?= $Page->folio_no->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="finvestor_listsearch" id="finvestor_listsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="investor_list">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_list_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_list_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="investor_list" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->share_no->Visible) { // share_no ?>
    <div id="r_share_no" class="row"<?= $Page->share_no->rowAttributes() ?>>
        <label for="x_share_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_list_share_no"><?= $Page->share_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_share_no" id="z_share_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->share_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_list_share_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->share_no->getInputTextType() ?>" name="x_share_no" id="x_share_no" data-table="investor_list" data-field="x_share_no" value="<?= $Page->share_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->share_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->share_no->formatPattern()) ?>"<?= $Page->share_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->share_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->folio_no->Visible) { // folio_no ?>
    <div id="r_folio_no" class="row"<?= $Page->folio_no->rowAttributes() ?>>
        <label for="x_folio_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_list_folio_no"><?= $Page->folio_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_folio_no" id="z_folio_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->folio_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_list_folio_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_folio_no"
        name="x_folio_no"
        class="form-select ew-select<?= $Page->folio_no->isInvalidClass() ?>"
        <?php if (!$Page->folio_no->IsNativeSelect) { ?>
        data-select2-id="finvestor_listsearch_x_folio_no"
        <?php } ?>
        data-table="investor_list"
        data-field="x_folio_no"
        data-value-separator="<?= $Page->folio_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->folio_no->getPlaceHolder()) ?>"
        <?= $Page->folio_no->editAttributes() ?>>
        <?= $Page->folio_no->selectOptionListHtml("x_folio_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->folio_no->getErrorMessage(false) ?></div>
<?= $Page->folio_no->Lookup->getParamTag($Page, "p_x_folio_no") ?>
<?php if (!$Page->folio_no->IsNativeSelect) { ?>
<script>
loadjs.ready("finvestor_listsearch", function() {
    var options = { name: "x_folio_no", selectId: "finvestor_listsearch_x_folio_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvestor_listsearch.lists.folio_no?.lookupOptions.length) {
        options.data = { id: "x_folio_no", form: "finvestor_listsearch" };
    } else {
        options.ajax = { id: "x_folio_no", form: "finvestor_listsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.investor_list.fields.folio_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty" class="row"<?= $Page->qty->rowAttributes() ?>>
        <label for="x_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_list_qty"><?= $Page->qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty" id="z_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_list_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty->getInputTextType() ?>" name="x_qty" id="x_qty" data-table="investor_list" data-field="x_qty" value="<?= $Page->qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty->formatPattern()) ?>"<?= $Page->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->transfer_id_old->Visible) { // transfer_id_old ?>
    <div id="r_transfer_id_old" class="row"<?= $Page->transfer_id_old->rowAttributes() ?>>
        <label for="x_transfer_id_old" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_list_transfer_id_old"><?= $Page->transfer_id_old->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_transfer_id_old" id="z_transfer_id_old" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->transfer_id_old->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_list_transfer_id_old" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->transfer_id_old->getInputTextType() ?>" name="x_transfer_id_old" id="x_transfer_id_old" data-table="investor_list" data-field="x_transfer_id_old" value="<?= $Page->transfer_id_old->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->transfer_id_old->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->transfer_id_old->formatPattern()) ?>"<?= $Page->transfer_id_old->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->transfer_id_old->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->transfer_id_new->Visible) { // transfer_id_new ?>
    <div id="r_transfer_id_new" class="row"<?= $Page->transfer_id_new->rowAttributes() ?>>
        <label for="x_transfer_id_new" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_list_transfer_id_new"><?= $Page->transfer_id_new->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_transfer_id_new" id="z_transfer_id_new" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->transfer_id_new->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_list_transfer_id_new" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->transfer_id_new->getInputTextType() ?>" name="x_transfer_id_new" id="x_transfer_id_new" data-table="investor_list" data-field="x_transfer_id_new" value="<?= $Page->transfer_id_new->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->transfer_id_new->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->transfer_id_new->formatPattern()) ?>"<?= $Page->transfer_id_new->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->transfer_id_new->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_list_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_list_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="investor_list" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_list_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_list_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="investor_list" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvestor_listsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvestor_listsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="finvestor_listsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="finvestor_listsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="finvestor_listsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("investor_list");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
