<?php

namespace PHPMaker2024\fibre;

// Page object
$InvestorListAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { investor_list: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var finvestor_listadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("finvestor_listadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["share_no", [fields.share_no.visible && fields.share_no.required ? ew.Validators.required(fields.share_no.caption) : null, ew.Validators.integer], fields.share_no.isInvalid],
            ["folio_no", [fields.folio_no.visible && fields.folio_no.required ? ew.Validators.required(fields.folio_no.caption) : null], fields.folio_no.isInvalid],
            ["qty", [fields.qty.visible && fields.qty.required ? ew.Validators.required(fields.qty.caption) : null, ew.Validators.integer], fields.qty.isInvalid],
            ["transfer_id_old", [fields.transfer_id_old.visible && fields.transfer_id_old.required ? ew.Validators.required(fields.transfer_id_old.caption) : null, ew.Validators.integer], fields.transfer_id_old.isInvalid],
            ["transfer_id_new", [fields.transfer_id_new.visible && fields.transfer_id_new.required ? ew.Validators.required(fields.transfer_id_new.caption) : null, ew.Validators.integer], fields.transfer_id_new.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "folio_no": <?= $Page->folio_no->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="finvestor_listadd" id="finvestor_listadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="investor_list">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->share_no->Visible) { // share_no ?>
    <div id="r_share_no"<?= $Page->share_no->rowAttributes() ?>>
        <label id="elh_investor_list_share_no" for="x_share_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->share_no->caption() ?><?= $Page->share_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->share_no->cellAttributes() ?>>
<span id="el_investor_list_share_no">
<input type="<?= $Page->share_no->getInputTextType() ?>" name="x_share_no" id="x_share_no" data-table="investor_list" data-field="x_share_no" value="<?= $Page->share_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->share_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->share_no->formatPattern()) ?>"<?= $Page->share_no->editAttributes() ?> aria-describedby="x_share_no_help">
<?= $Page->share_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->share_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->folio_no->Visible) { // folio_no ?>
    <div id="r_folio_no"<?= $Page->folio_no->rowAttributes() ?>>
        <label id="elh_investor_list_folio_no" for="x_folio_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->folio_no->caption() ?><?= $Page->folio_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->folio_no->cellAttributes() ?>>
<span id="el_investor_list_folio_no">
    <select
        id="x_folio_no"
        name="x_folio_no"
        class="form-select ew-select<?= $Page->folio_no->isInvalidClass() ?>"
        <?php if (!$Page->folio_no->IsNativeSelect) { ?>
        data-select2-id="finvestor_listadd_x_folio_no"
        <?php } ?>
        data-table="investor_list"
        data-field="x_folio_no"
        data-value-separator="<?= $Page->folio_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->folio_no->getPlaceHolder()) ?>"
        <?= $Page->folio_no->editAttributes() ?>>
        <?= $Page->folio_no->selectOptionListHtml("x_folio_no") ?>
    </select>
    <?= $Page->folio_no->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->folio_no->getErrorMessage() ?></div>
<?= $Page->folio_no->Lookup->getParamTag($Page, "p_x_folio_no") ?>
<?php if (!$Page->folio_no->IsNativeSelect) { ?>
<script>
loadjs.ready("finvestor_listadd", function() {
    var options = { name: "x_folio_no", selectId: "finvestor_listadd_x_folio_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvestor_listadd.lists.folio_no?.lookupOptions.length) {
        options.data = { id: "x_folio_no", form: "finvestor_listadd" };
    } else {
        options.ajax = { id: "x_folio_no", form: "finvestor_listadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.investor_list.fields.folio_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty"<?= $Page->qty->rowAttributes() ?>>
        <label id="elh_investor_list_qty" for="x_qty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->qty->caption() ?><?= $Page->qty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->qty->cellAttributes() ?>>
<span id="el_investor_list_qty">
<input type="<?= $Page->qty->getInputTextType() ?>" name="x_qty" id="x_qty" data-table="investor_list" data-field="x_qty" value="<?= $Page->qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty->formatPattern()) ?>"<?= $Page->qty->editAttributes() ?> aria-describedby="x_qty_help">
<?= $Page->qty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->qty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->transfer_id_old->Visible) { // transfer_id_old ?>
    <div id="r_transfer_id_old"<?= $Page->transfer_id_old->rowAttributes() ?>>
        <label id="elh_investor_list_transfer_id_old" for="x_transfer_id_old" class="<?= $Page->LeftColumnClass ?>"><?= $Page->transfer_id_old->caption() ?><?= $Page->transfer_id_old->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->transfer_id_old->cellAttributes() ?>>
<span id="el_investor_list_transfer_id_old">
<input type="<?= $Page->transfer_id_old->getInputTextType() ?>" name="x_transfer_id_old" id="x_transfer_id_old" data-table="investor_list" data-field="x_transfer_id_old" value="<?= $Page->transfer_id_old->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->transfer_id_old->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->transfer_id_old->formatPattern()) ?>"<?= $Page->transfer_id_old->editAttributes() ?> aria-describedby="x_transfer_id_old_help">
<?= $Page->transfer_id_old->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->transfer_id_old->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->transfer_id_new->Visible) { // transfer_id_new ?>
    <div id="r_transfer_id_new"<?= $Page->transfer_id_new->rowAttributes() ?>>
        <label id="elh_investor_list_transfer_id_new" for="x_transfer_id_new" class="<?= $Page->LeftColumnClass ?>"><?= $Page->transfer_id_new->caption() ?><?= $Page->transfer_id_new->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->transfer_id_new->cellAttributes() ?>>
<span id="el_investor_list_transfer_id_new">
<input type="<?= $Page->transfer_id_new->getInputTextType() ?>" name="x_transfer_id_new" id="x_transfer_id_new" data-table="investor_list" data-field="x_transfer_id_new" value="<?= $Page->transfer_id_new->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->transfer_id_new->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->transfer_id_new->formatPattern()) ?>"<?= $Page->transfer_id_new->editAttributes() ?> aria-describedby="x_transfer_id_new_help">
<?= $Page->transfer_id_new->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->transfer_id_new->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="finvestor_listadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="finvestor_listadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("investor_list");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
