<?php

namespace PHPMaker2024\fibre;

// Page object
$InvestorInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { investor_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var finvestor_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("finvestor_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["qty", [ew.Validators.integer], fields.qty.isInvalid],
            ["aadhaar_no", [ew.Validators.integer], fields.aadhaar_no.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["gender", [], fields.gender.isInvalid],
            ["dob", [], fields.dob.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["care_of", [], fields.care_of.isInvalid],
            ["father_name", [], fields.father_name.isInvalid],
            ["mother_name", [], fields.mother_name.isInvalid],
            ["nominee_name", [], fields.nominee_name.isInvalid],
            ["nominee_relation", [], fields.nominee_relation.isInvalid],
            ["pan_no", [], fields.pan_no.isInvalid],
            ["uploads", [], fields.uploads.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["adviser", [], fields.adviser.isInvalid],
            ["share_no", [], fields.share_no.isInvalid],
            ["inv_start_date", [ew.Validators.datetime(fields.inv_start_date.clientFormatPattern)], fields.inv_start_date.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["gurantee", [ew.Validators.float], fields.gurantee.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["otp", [ew.Validators.integer], fields.otp.isInvalid],
            ["pan_response", [ew.Validators.datetime(fields.pan_response.clientFormatPattern)], fields.pan_response.isInvalid],
            ["pan_verify_datetime", [ew.Validators.datetime(fields.pan_verify_datetime.clientFormatPattern)], fields.pan_verify_datetime.isInvalid],
            ["aadhaar_response", [], fields.aadhaar_response.isInvalid],
            ["aadhaar_verify_datetime", [ew.Validators.datetime(fields.aadhaar_verify_datetime.clientFormatPattern)], fields.aadhaar_verify_datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "nominee_relation": <?= $Page->nominee_relation->toClientList($Page) ?>,
            "adviser": <?= $Page->adviser->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="finvestor_infosearch" id="finvestor_infosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="investor_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="investor_info" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty" class="row"<?= $Page->qty->rowAttributes() ?>>
        <label for="x_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_qty"><?= $Page->qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty" id="z_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty->getInputTextType() ?>" name="x_qty" id="x_qty" data-table="investor_info" data-field="x_qty" value="<?= $Page->qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty->formatPattern()) ?>"<?= $Page->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
    <div id="r_aadhaar_no" class="row"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <label for="x_aadhaar_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_aadhaar_no"><?= $Page->aadhaar_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_aadhaar_no" id="z_aadhaar_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->aadhaar_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_aadhaar_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->aadhaar_no->getInputTextType() ?>" name="x_aadhaar_no" id="x_aadhaar_no" data-table="investor_info" data-field="x_aadhaar_no" value="<?= $Page->aadhaar_no->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->aadhaar_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_no->formatPattern()) ?>"<?= $Page->aadhaar_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->aadhaar_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="investor_info" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
    <div id="r_gender" class="row"<?= $Page->gender->rowAttributes() ?>>
        <label for="x_gender" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_gender"><?= $Page->gender->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_gender" id="z_gender" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gender->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_gender" class="ew-search-field ew-search-field-single">
    <select
        id="x_gender"
        name="x_gender"
        class="form-select ew-select<?= $Page->gender->isInvalidClass() ?>"
        <?php if (!$Page->gender->IsNativeSelect) { ?>
        data-select2-id="finvestor_infosearch_x_gender"
        <?php } ?>
        data-table="investor_info"
        data-field="x_gender"
        data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gender->getPlaceHolder()) ?>"
        <?= $Page->gender->editAttributes() ?>>
        <?= $Page->gender->selectOptionListHtml("x_gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->gender->getErrorMessage(false) ?></div>
<?php if (!$Page->gender->IsNativeSelect) { ?>
<script>
loadjs.ready("finvestor_infosearch", function() {
    var options = { name: "x_gender", selectId: "finvestor_infosearch_x_gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvestor_infosearch.lists.gender?.lookupOptions.length) {
        options.data = { id: "x_gender", form: "finvestor_infosearch" };
    } else {
        options.ajax = { id: "x_gender", form: "finvestor_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.investor_info.fields.gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <div id="r_dob" class="row"<?= $Page->dob->rowAttributes() ?>>
        <label for="x_dob" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_dob"><?= $Page->dob->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_dob" id="z_dob" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dob->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_dob" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="investor_info" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage(false) ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvestor_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvestor_infosearch", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="investor_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="22" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email" class="row"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info__email"><?= $Page->_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__email" id="z__email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="investor_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address" class="row"<?= $Page->address->rowAttributes() ?>>
        <label for="x_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_address"><?= $Page->address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_address" id="z_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="investor_info" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="30" maxlength="252" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->care_of->Visible) { // care_of ?>
    <div id="r_care_of" class="row"<?= $Page->care_of->rowAttributes() ?>>
        <label for="x_care_of" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_care_of"><?= $Page->care_of->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_care_of" id="z_care_of" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->care_of->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_care_of" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->care_of->getInputTextType() ?>" name="x_care_of" id="x_care_of" data-table="investor_info" data-field="x_care_of" value="<?= $Page->care_of->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->care_of->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->care_of->formatPattern()) ?>"<?= $Page->care_of->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->care_of->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
    <div id="r_father_name" class="row"<?= $Page->father_name->rowAttributes() ?>>
        <label for="x_father_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_father_name"><?= $Page->father_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_father_name" id="z_father_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->father_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_father_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->father_name->getInputTextType() ?>" name="x_father_name" id="x_father_name" data-table="investor_info" data-field="x_father_name" value="<?= $Page->father_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->father_name->formatPattern()) ?>"<?= $Page->father_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->father_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mother_name->Visible) { // mother_name ?>
    <div id="r_mother_name" class="row"<?= $Page->mother_name->rowAttributes() ?>>
        <label for="x_mother_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_mother_name"><?= $Page->mother_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mother_name" id="z_mother_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mother_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_mother_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mother_name->getInputTextType() ?>" name="x_mother_name" id="x_mother_name" data-table="investor_info" data-field="x_mother_name" value="<?= $Page->mother_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->mother_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mother_name->formatPattern()) ?>"<?= $Page->mother_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mother_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->nominee_name->Visible) { // nominee_name ?>
    <div id="r_nominee_name" class="row"<?= $Page->nominee_name->rowAttributes() ?>>
        <label for="x_nominee_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_nominee_name"><?= $Page->nominee_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_nominee_name" id="z_nominee_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->nominee_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_nominee_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->nominee_name->getInputTextType() ?>" name="x_nominee_name" id="x_nominee_name" data-table="investor_info" data-field="x_nominee_name" value="<?= $Page->nominee_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->nominee_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->nominee_name->formatPattern()) ?>"<?= $Page->nominee_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->nominee_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->nominee_relation->Visible) { // nominee_relation ?>
    <div id="r_nominee_relation" class="row"<?= $Page->nominee_relation->rowAttributes() ?>>
        <label for="x_nominee_relation" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_nominee_relation"><?= $Page->nominee_relation->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_nominee_relation" id="z_nominee_relation" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->nominee_relation->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_nominee_relation" class="ew-search-field ew-search-field-single">
    <select
        id="x_nominee_relation"
        name="x_nominee_relation"
        class="form-select ew-select<?= $Page->nominee_relation->isInvalidClass() ?>"
        <?php if (!$Page->nominee_relation->IsNativeSelect) { ?>
        data-select2-id="finvestor_infosearch_x_nominee_relation"
        <?php } ?>
        data-table="investor_info"
        data-field="x_nominee_relation"
        data-value-separator="<?= $Page->nominee_relation->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->nominee_relation->getPlaceHolder()) ?>"
        <?= $Page->nominee_relation->editAttributes() ?>>
        <?= $Page->nominee_relation->selectOptionListHtml("x_nominee_relation") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->nominee_relation->getErrorMessage(false) ?></div>
<?php if (!$Page->nominee_relation->IsNativeSelect) { ?>
<script>
loadjs.ready("finvestor_infosearch", function() {
    var options = { name: "x_nominee_relation", selectId: "finvestor_infosearch_x_nominee_relation" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvestor_infosearch.lists.nominee_relation?.lookupOptions.length) {
        options.data = { id: "x_nominee_relation", form: "finvestor_infosearch" };
    } else {
        options.ajax = { id: "x_nominee_relation", form: "finvestor_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.investor_info.fields.nominee_relation.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pan_no->Visible) { // pan_no ?>
    <div id="r_pan_no" class="row"<?= $Page->pan_no->rowAttributes() ?>>
        <label for="x_pan_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_pan_no"><?= $Page->pan_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pan_no" id="z_pan_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pan_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_pan_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pan_no->getInputTextType() ?>" name="x_pan_no" id="x_pan_no" data-table="investor_info" data-field="x_pan_no" value="<?= $Page->pan_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->pan_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_no->formatPattern()) ?>"<?= $Page->pan_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pan_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads" class="row"<?= $Page->uploads->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_uploads"><?= $Page->uploads->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_uploads" id="z_uploads" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->uploads->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_uploads" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->uploads->getInputTextType() ?>" name="x_uploads" id="x_uploads" data-table="investor_info" data-field="x_uploads" value="<?= $Page->uploads->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Page->uploads->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uploads->formatPattern()) ?>"<?= $Page->uploads->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uploads->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="investor_info" data-field="x_image" value="<?= $Page->image->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->adviser->Visible) { // adviser ?>
    <div id="r_adviser" class="row"<?= $Page->adviser->rowAttributes() ?>>
        <label for="x_adviser" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_adviser"><?= $Page->adviser->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_adviser" id="z_adviser" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->adviser->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_adviser" class="ew-search-field ew-search-field-single">
    <select
        id="x_adviser"
        name="x_adviser"
        class="form-select ew-select<?= $Page->adviser->isInvalidClass() ?>"
        <?php if (!$Page->adviser->IsNativeSelect) { ?>
        data-select2-id="finvestor_infosearch_x_adviser"
        <?php } ?>
        data-table="investor_info"
        data-field="x_adviser"
        data-value-separator="<?= $Page->adviser->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->adviser->getPlaceHolder()) ?>"
        <?= $Page->adviser->editAttributes() ?>>
        <?= $Page->adviser->selectOptionListHtml("x_adviser") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->adviser->getErrorMessage(false) ?></div>
<?= $Page->adviser->Lookup->getParamTag($Page, "p_x_adviser") ?>
<?php if (!$Page->adviser->IsNativeSelect) { ?>
<script>
loadjs.ready("finvestor_infosearch", function() {
    var options = { name: "x_adviser", selectId: "finvestor_infosearch_x_adviser" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvestor_infosearch.lists.adviser?.lookupOptions.length) {
        options.data = { id: "x_adviser", form: "finvestor_infosearch" };
    } else {
        options.ajax = { id: "x_adviser", form: "finvestor_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.investor_info.fields.adviser.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->share_no->Visible) { // share_no ?>
    <div id="r_share_no" class="row"<?= $Page->share_no->rowAttributes() ?>>
        <label for="x_share_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_share_no"><?= $Page->share_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_share_no" id="z_share_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->share_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_share_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->share_no->getInputTextType() ?>" name="x_share_no" id="x_share_no" data-table="investor_info" data-field="x_share_no" value="<?= $Page->share_no->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->share_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->share_no->formatPattern()) ?>"<?= $Page->share_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->share_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->inv_start_date->Visible) { // inv_start_date ?>
    <div id="r_inv_start_date" class="row"<?= $Page->inv_start_date->rowAttributes() ?>>
        <label for="x_inv_start_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_inv_start_date"><?= $Page->inv_start_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_inv_start_date" id="z_inv_start_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->inv_start_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_inv_start_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->inv_start_date->getInputTextType() ?>" name="x_inv_start_date" id="x_inv_start_date" data-table="investor_info" data-field="x_inv_start_date" value="<?= $Page->inv_start_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->inv_start_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->inv_start_date->formatPattern()) ?>"<?= $Page->inv_start_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->inv_start_date->getErrorMessage(false) ?></div>
<?php if (!$Page->inv_start_date->ReadOnly && !$Page->inv_start_date->Disabled && !isset($Page->inv_start_date->EditAttrs["readonly"]) && !isset($Page->inv_start_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvestor_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvestor_infosearch", "x_inv_start_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="investor_info" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gurantee->Visible) { // gurantee ?>
    <div id="r_gurantee" class="row"<?= $Page->gurantee->rowAttributes() ?>>
        <label for="x_gurantee" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_gurantee"><?= $Page->gurantee->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gurantee" id="z_gurantee" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gurantee->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_gurantee" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gurantee->getInputTextType() ?>" name="x_gurantee" id="x_gurantee" data-table="investor_info" data-field="x_gurantee" value="<?= $Page->gurantee->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->gurantee->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gurantee->formatPattern()) ?>"<?= $Page->gurantee->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gurantee->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="investor_info" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="investor_info" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="investor_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvestor_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvestor_infosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->otp->Visible) { // otp ?>
    <div id="r_otp" class="row"<?= $Page->otp->rowAttributes() ?>>
        <label for="x_otp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_otp"><?= $Page->otp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_otp" id="z_otp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->otp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_otp" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->otp->getInputTextType() ?>" name="x_otp" id="x_otp" data-table="investor_info" data-field="x_otp" value="<?= $Page->otp->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->otp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->otp->formatPattern()) ?>"<?= $Page->otp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->otp->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pan_response->Visible) { // pan_response ?>
    <div id="r_pan_response" class="row"<?= $Page->pan_response->rowAttributes() ?>>
        <label for="x_pan_response" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_pan_response"><?= $Page->pan_response->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pan_response" id="z_pan_response" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pan_response->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_pan_response" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pan_response->getInputTextType() ?>" name="x_pan_response" id="x_pan_response" data-table="investor_info" data-field="x_pan_response" value="<?= $Page->pan_response->EditValue ?>" maxlength="300" placeholder="<?= HtmlEncode($Page->pan_response->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_response->formatPattern()) ?>"<?= $Page->pan_response->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pan_response->getErrorMessage(false) ?></div>
<?php if (!$Page->pan_response->ReadOnly && !$Page->pan_response->Disabled && !isset($Page->pan_response->EditAttrs["readonly"]) && !isset($Page->pan_response->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvestor_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvestor_infosearch", "x_pan_response", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pan_verify_datetime->Visible) { // pan_verify_datetime ?>
    <div id="r_pan_verify_datetime" class="row"<?= $Page->pan_verify_datetime->rowAttributes() ?>>
        <label for="x_pan_verify_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_pan_verify_datetime"><?= $Page->pan_verify_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pan_verify_datetime" id="z_pan_verify_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pan_verify_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_pan_verify_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pan_verify_datetime->getInputTextType() ?>" name="x_pan_verify_datetime" id="x_pan_verify_datetime" data-table="investor_info" data-field="x_pan_verify_datetime" value="<?= $Page->pan_verify_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->pan_verify_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_verify_datetime->formatPattern()) ?>"<?= $Page->pan_verify_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pan_verify_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->pan_verify_datetime->ReadOnly && !$Page->pan_verify_datetime->Disabled && !isset($Page->pan_verify_datetime->EditAttrs["readonly"]) && !isset($Page->pan_verify_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvestor_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvestor_infosearch", "x_pan_verify_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_response->Visible) { // aadhaar_response ?>
    <div id="r_aadhaar_response" class="row"<?= $Page->aadhaar_response->rowAttributes() ?>>
        <label for="x_aadhaar_response" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_aadhaar_response"><?= $Page->aadhaar_response->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_aadhaar_response" id="z_aadhaar_response" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->aadhaar_response->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_aadhaar_response" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->aadhaar_response->getInputTextType() ?>" name="x_aadhaar_response" id="x_aadhaar_response" data-table="investor_info" data-field="x_aadhaar_response" value="<?= $Page->aadhaar_response->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->aadhaar_response->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_response->formatPattern()) ?>"<?= $Page->aadhaar_response->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->aadhaar_response->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_verify_datetime->Visible) { // aadhaar_verify_datetime ?>
    <div id="r_aadhaar_verify_datetime" class="row"<?= $Page->aadhaar_verify_datetime->rowAttributes() ?>>
        <label for="x_aadhaar_verify_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_investor_info_aadhaar_verify_datetime"><?= $Page->aadhaar_verify_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_aadhaar_verify_datetime" id="z_aadhaar_verify_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->aadhaar_verify_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_investor_info_aadhaar_verify_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->aadhaar_verify_datetime->getInputTextType() ?>" name="x_aadhaar_verify_datetime" id="x_aadhaar_verify_datetime" data-table="investor_info" data-field="x_aadhaar_verify_datetime" value="<?= $Page->aadhaar_verify_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->aadhaar_verify_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_verify_datetime->formatPattern()) ?>"<?= $Page->aadhaar_verify_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->aadhaar_verify_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->aadhaar_verify_datetime->ReadOnly && !$Page->aadhaar_verify_datetime->Disabled && !isset($Page->aadhaar_verify_datetime->EditAttrs["readonly"]) && !isset($Page->aadhaar_verify_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvestor_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvestor_infosearch", "x_aadhaar_verify_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="finvestor_infosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="finvestor_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="finvestor_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("investor_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
