<?php

namespace PHPMaker2024\fibre;

// Page object
$InvestorInfoList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { investor_info: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="finvestor_infosrch" id="finvestor_infosrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="finvestor_infosrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { investor_info: currentTable } });
var currentForm;
var finvestor_infosrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("finvestor_infosrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="finvestor_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="finvestor_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="finvestor_infosrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="finvestor_infosrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="finvestor_infosrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="finvestor_infosrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="finvestor_infosrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="investor_info">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_investor_info" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_investor_infolist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_investor_info_id" class="investor_info_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
        <th data-name="qty" class="<?= $Page->qty->headerCellClass() ?>"><div id="elh_investor_info_qty" class="investor_info_qty"><?= $Page->renderFieldHeader($Page->qty) ?></div></th>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
        <th data-name="aadhaar_no" class="<?= $Page->aadhaar_no->headerCellClass() ?>"><div id="elh_investor_info_aadhaar_no" class="investor_info_aadhaar_no"><?= $Page->renderFieldHeader($Page->aadhaar_no) ?></div></th>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
        <th data-name="name" class="<?= $Page->name->headerCellClass() ?>"><div id="elh_investor_info_name" class="investor_info_name"><?= $Page->renderFieldHeader($Page->name) ?></div></th>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
        <th data-name="gender" class="<?= $Page->gender->headerCellClass() ?>"><div id="elh_investor_info_gender" class="investor_info_gender"><?= $Page->renderFieldHeader($Page->gender) ?></div></th>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
        <th data-name="dob" class="<?= $Page->dob->headerCellClass() ?>"><div id="elh_investor_info_dob" class="investor_info_dob"><?= $Page->renderFieldHeader($Page->dob) ?></div></th>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
        <th data-name="mobile" class="<?= $Page->mobile->headerCellClass() ?>"><div id="elh_investor_info_mobile" class="investor_info_mobile"><?= $Page->renderFieldHeader($Page->mobile) ?></div></th>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
        <th data-name="_email" class="<?= $Page->_email->headerCellClass() ?>"><div id="elh_investor_info__email" class="investor_info__email"><?= $Page->renderFieldHeader($Page->_email) ?></div></th>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
        <th data-name="address" class="<?= $Page->address->headerCellClass() ?>"><div id="elh_investor_info_address" class="investor_info_address"><?= $Page->renderFieldHeader($Page->address) ?></div></th>
<?php } ?>
<?php if ($Page->care_of->Visible) { // care_of ?>
        <th data-name="care_of" class="<?= $Page->care_of->headerCellClass() ?>"><div id="elh_investor_info_care_of" class="investor_info_care_of"><?= $Page->renderFieldHeader($Page->care_of) ?></div></th>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
        <th data-name="father_name" class="<?= $Page->father_name->headerCellClass() ?>"><div id="elh_investor_info_father_name" class="investor_info_father_name"><?= $Page->renderFieldHeader($Page->father_name) ?></div></th>
<?php } ?>
<?php if ($Page->mother_name->Visible) { // mother_name ?>
        <th data-name="mother_name" class="<?= $Page->mother_name->headerCellClass() ?>"><div id="elh_investor_info_mother_name" class="investor_info_mother_name"><?= $Page->renderFieldHeader($Page->mother_name) ?></div></th>
<?php } ?>
<?php if ($Page->nominee_name->Visible) { // nominee_name ?>
        <th data-name="nominee_name" class="<?= $Page->nominee_name->headerCellClass() ?>"><div id="elh_investor_info_nominee_name" class="investor_info_nominee_name"><?= $Page->renderFieldHeader($Page->nominee_name) ?></div></th>
<?php } ?>
<?php if ($Page->nominee_relation->Visible) { // nominee_relation ?>
        <th data-name="nominee_relation" class="<?= $Page->nominee_relation->headerCellClass() ?>"><div id="elh_investor_info_nominee_relation" class="investor_info_nominee_relation"><?= $Page->renderFieldHeader($Page->nominee_relation) ?></div></th>
<?php } ?>
<?php if ($Page->pan_no->Visible) { // pan_no ?>
        <th data-name="pan_no" class="<?= $Page->pan_no->headerCellClass() ?>"><div id="elh_investor_info_pan_no" class="investor_info_pan_no"><?= $Page->renderFieldHeader($Page->pan_no) ?></div></th>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
        <th data-name="image" class="<?= $Page->image->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_investor_info_image" class="investor_info_image"><?= $Page->renderFieldHeader($Page->image) ?></div></th>
<?php } ?>
<?php if ($Page->adviser->Visible) { // adviser ?>
        <th data-name="adviser" class="<?= $Page->adviser->headerCellClass() ?>"><div id="elh_investor_info_adviser" class="investor_info_adviser"><?= $Page->renderFieldHeader($Page->adviser) ?></div></th>
<?php } ?>
<?php if ($Page->share_no->Visible) { // share_no ?>
        <th data-name="share_no" class="<?= $Page->share_no->headerCellClass() ?>"><div id="elh_investor_info_share_no" class="investor_info_share_no"><?= $Page->renderFieldHeader($Page->share_no) ?></div></th>
<?php } ?>
<?php if ($Page->inv_start_date->Visible) { // inv_start_date ?>
        <th data-name="inv_start_date" class="<?= $Page->inv_start_date->headerCellClass() ?>"><div id="elh_investor_info_inv_start_date" class="investor_info_inv_start_date"><?= $Page->renderFieldHeader($Page->inv_start_date) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>"><div id="elh_investor_info_amount" class="investor_info_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->gurantee->Visible) { // gurantee ?>
        <th data-name="gurantee" class="<?= $Page->gurantee->headerCellClass() ?>"><div id="elh_investor_info_gurantee" class="investor_info_gurantee"><?= $Page->renderFieldHeader($Page->gurantee) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_investor_info_remarks" class="investor_info_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_investor_info_operator" class="investor_info_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_investor_info_datetime" class="investor_info_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_id" class="el_investor_info_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty->Visible) { // qty ?>
        <td data-name="qty"<?= $Page->qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_qty" class="el_investor_info_qty">
<span<?= $Page->qty->viewAttributes() ?>>
<?php if (!EmptyString($Page->qty->getViewValue()) && $Page->qty->linkAttributes() != "") { ?>
<a<?= $Page->qty->linkAttributes() ?>><?= $Page->qty->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->qty->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
        <td data-name="aadhaar_no"<?= $Page->aadhaar_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_aadhaar_no" class="el_investor_info_aadhaar_no">
<span<?= $Page->aadhaar_no->viewAttributes() ?>>
<?= $Page->aadhaar_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->name->Visible) { // name ?>
        <td data-name="name"<?= $Page->name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_name" class="el_investor_info_name">
<span<?= $Page->name->viewAttributes() ?>>
<?= $Page->name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gender->Visible) { // gender ?>
        <td data-name="gender"<?= $Page->gender->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_gender" class="el_investor_info_gender">
<span<?= $Page->gender->viewAttributes() ?>>
<?= $Page->gender->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dob->Visible) { // dob ?>
        <td data-name="dob"<?= $Page->dob->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_dob" class="el_investor_info_dob">
<span<?= $Page->dob->viewAttributes() ?>>
<?= $Page->dob->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mobile->Visible) { // mobile ?>
        <td data-name="mobile"<?= $Page->mobile->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_mobile" class="el_investor_info_mobile">
<span<?= $Page->mobile->viewAttributes() ?>>
<?= $Page->mobile->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_email->Visible) { // email ?>
        <td data-name="_email"<?= $Page->_email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info__email" class="el_investor_info__email">
<span<?= $Page->_email->viewAttributes() ?>>
<?= $Page->_email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->address->Visible) { // address ?>
        <td data-name="address"<?= $Page->address->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_address" class="el_investor_info_address">
<span<?= $Page->address->viewAttributes() ?>>
<?= $Page->address->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->care_of->Visible) { // care_of ?>
        <td data-name="care_of"<?= $Page->care_of->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_care_of" class="el_investor_info_care_of">
<span<?= $Page->care_of->viewAttributes() ?>>
<?= $Page->care_of->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->father_name->Visible) { // father_name ?>
        <td data-name="father_name"<?= $Page->father_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_father_name" class="el_investor_info_father_name">
<span<?= $Page->father_name->viewAttributes() ?>>
<?= $Page->father_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mother_name->Visible) { // mother_name ?>
        <td data-name="mother_name"<?= $Page->mother_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_mother_name" class="el_investor_info_mother_name">
<span<?= $Page->mother_name->viewAttributes() ?>>
<?= $Page->mother_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->nominee_name->Visible) { // nominee_name ?>
        <td data-name="nominee_name"<?= $Page->nominee_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_nominee_name" class="el_investor_info_nominee_name">
<span<?= $Page->nominee_name->viewAttributes() ?>>
<?= $Page->nominee_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->nominee_relation->Visible) { // nominee_relation ?>
        <td data-name="nominee_relation"<?= $Page->nominee_relation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_nominee_relation" class="el_investor_info_nominee_relation">
<span<?= $Page->nominee_relation->viewAttributes() ?>>
<?= $Page->nominee_relation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pan_no->Visible) { // pan_no ?>
        <td data-name="pan_no"<?= $Page->pan_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_pan_no" class="el_investor_info_pan_no">
<span<?= $Page->pan_no->viewAttributes() ?>>
<?= $Page->pan_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->image->Visible) { // image ?>
        <td data-name="image"<?= $Page->image->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_image" class="el_investor_info_image">
<span>
<?= GetFileViewTag($Page->image, $Page->image->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->adviser->Visible) { // adviser ?>
        <td data-name="adviser"<?= $Page->adviser->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_adviser" class="el_investor_info_adviser">
<span<?= $Page->adviser->viewAttributes() ?>>
<?= $Page->adviser->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->share_no->Visible) { // share_no ?>
        <td data-name="share_no"<?= $Page->share_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_share_no" class="el_investor_info_share_no">
<span<?= $Page->share_no->viewAttributes() ?>>
<?= $Page->share_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->inv_start_date->Visible) { // inv_start_date ?>
        <td data-name="inv_start_date"<?= $Page->inv_start_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_inv_start_date" class="el_investor_info_inv_start_date">
<span<?= $Page->inv_start_date->viewAttributes() ?>>
<?= $Page->inv_start_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_amount" class="el_investor_info_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?= $Page->amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gurantee->Visible) { // gurantee ?>
        <td data-name="gurantee"<?= $Page->gurantee->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_gurantee" class="el_investor_info_gurantee">
<span<?= $Page->gurantee->viewAttributes() ?>>
<?= $Page->gurantee->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_remarks" class="el_investor_info_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_operator" class="el_investor_info_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_investor_info_datetime" class="el_investor_info_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_investor_info_id" class="investor_info_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->qty->Visible) { // qty ?>
        <td data-name="qty" class="<?= $Page->qty->footerCellClass() ?>"><span id="elf_investor_info_qty" class="investor_info_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?php if (!EmptyString($Page->qty->ViewValue) && $Page->qty->linkAttributes() != "") { ?>
        <a<?= $Page->qty->linkAttributes() ?>><?= $Page->qty->ViewValue ?></a>
        <?php } else { ?>
        <?= $Page->qty->ViewValue ?>
        <?php } ?>
        </span>
        </span></td>
    <?php } ?>
    <?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
        <td data-name="aadhaar_no" class="<?= $Page->aadhaar_no->footerCellClass() ?>"><span id="elf_investor_info_aadhaar_no" class="investor_info_aadhaar_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->name->Visible) { // name ?>
        <td data-name="name" class="<?= $Page->name->footerCellClass() ?>"><span id="elf_investor_info_name" class="investor_info_name">
        </span></td>
    <?php } ?>
    <?php if ($Page->gender->Visible) { // gender ?>
        <td data-name="gender" class="<?= $Page->gender->footerCellClass() ?>"><span id="elf_investor_info_gender" class="investor_info_gender">
        </span></td>
    <?php } ?>
    <?php if ($Page->dob->Visible) { // dob ?>
        <td data-name="dob" class="<?= $Page->dob->footerCellClass() ?>"><span id="elf_investor_info_dob" class="investor_info_dob">
        </span></td>
    <?php } ?>
    <?php if ($Page->mobile->Visible) { // mobile ?>
        <td data-name="mobile" class="<?= $Page->mobile->footerCellClass() ?>"><span id="elf_investor_info_mobile" class="investor_info_mobile">
        </span></td>
    <?php } ?>
    <?php if ($Page->_email->Visible) { // email ?>
        <td data-name="_email" class="<?= $Page->_email->footerCellClass() ?>"><span id="elf_investor_info__email" class="investor_info__email">
        </span></td>
    <?php } ?>
    <?php if ($Page->address->Visible) { // address ?>
        <td data-name="address" class="<?= $Page->address->footerCellClass() ?>"><span id="elf_investor_info_address" class="investor_info_address">
        </span></td>
    <?php } ?>
    <?php if ($Page->care_of->Visible) { // care_of ?>
        <td data-name="care_of" class="<?= $Page->care_of->footerCellClass() ?>"><span id="elf_investor_info_care_of" class="investor_info_care_of">
        </span></td>
    <?php } ?>
    <?php if ($Page->father_name->Visible) { // father_name ?>
        <td data-name="father_name" class="<?= $Page->father_name->footerCellClass() ?>"><span id="elf_investor_info_father_name" class="investor_info_father_name">
        </span></td>
    <?php } ?>
    <?php if ($Page->mother_name->Visible) { // mother_name ?>
        <td data-name="mother_name" class="<?= $Page->mother_name->footerCellClass() ?>"><span id="elf_investor_info_mother_name" class="investor_info_mother_name">
        </span></td>
    <?php } ?>
    <?php if ($Page->nominee_name->Visible) { // nominee_name ?>
        <td data-name="nominee_name" class="<?= $Page->nominee_name->footerCellClass() ?>"><span id="elf_investor_info_nominee_name" class="investor_info_nominee_name">
        </span></td>
    <?php } ?>
    <?php if ($Page->nominee_relation->Visible) { // nominee_relation ?>
        <td data-name="nominee_relation" class="<?= $Page->nominee_relation->footerCellClass() ?>"><span id="elf_investor_info_nominee_relation" class="investor_info_nominee_relation">
        </span></td>
    <?php } ?>
    <?php if ($Page->pan_no->Visible) { // pan_no ?>
        <td data-name="pan_no" class="<?= $Page->pan_no->footerCellClass() ?>"><span id="elf_investor_info_pan_no" class="investor_info_pan_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->image->Visible) { // image ?>
        <td data-name="image" class="<?= $Page->image->footerCellClass() ?>"><span id="elf_investor_info_image" class="investor_info_image">
        </span></td>
    <?php } ?>
    <?php if ($Page->adviser->Visible) { // adviser ?>
        <td data-name="adviser" class="<?= $Page->adviser->footerCellClass() ?>"><span id="elf_investor_info_adviser" class="investor_info_adviser">
        </span></td>
    <?php } ?>
    <?php if ($Page->share_no->Visible) { // share_no ?>
        <td data-name="share_no" class="<?= $Page->share_no->footerCellClass() ?>"><span id="elf_investor_info_share_no" class="investor_info_share_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->inv_start_date->Visible) { // inv_start_date ?>
        <td data-name="inv_start_date" class="<?= $Page->inv_start_date->footerCellClass() ?>"><span id="elf_investor_info_inv_start_date" class="investor_info_inv_start_date">
        </span></td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount" class="<?= $Page->amount->footerCellClass() ?>"><span id="elf_investor_info_amount" class="investor_info_amount">
        </span></td>
    <?php } ?>
    <?php if ($Page->gurantee->Visible) { // gurantee ?>
        <td data-name="gurantee" class="<?= $Page->gurantee->footerCellClass() ?>"><span id="elf_investor_info_gurantee" class="investor_info_gurantee">
        </span></td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks" class="<?= $Page->remarks->footerCellClass() ?>"><span id="elf_investor_info_remarks" class="investor_info_remarks">
        </span></td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator" class="<?= $Page->operator->footerCellClass() ?>"><span id="elf_investor_info_operator" class="investor_info_operator">
        </span></td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Page->datetime->footerCellClass() ?>"><span id="elf_investor_info_datetime" class="investor_info_datetime">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("investor_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
