<?php

namespace PHPMaker2024\fibre;

// Page object
$InvestorInfoAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { investor_info: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var finvestor_infoadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("finvestor_infoadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["aadhaar_no", [fields.aadhaar_no.visible && fields.aadhaar_no.required ? ew.Validators.required(fields.aadhaar_no.caption) : null, ew.Validators.integer], fields.aadhaar_no.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["gender", [fields.gender.visible && fields.gender.required ? ew.Validators.required(fields.gender.caption) : null], fields.gender.isInvalid],
            ["dob", [fields.dob.visible && fields.dob.required ? ew.Validators.required(fields.dob.caption) : null], fields.dob.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null], fields.mobile.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null], fields._email.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["care_of", [fields.care_of.visible && fields.care_of.required ? ew.Validators.required(fields.care_of.caption) : null], fields.care_of.isInvalid],
            ["father_name", [fields.father_name.visible && fields.father_name.required ? ew.Validators.required(fields.father_name.caption) : null], fields.father_name.isInvalid],
            ["mother_name", [fields.mother_name.visible && fields.mother_name.required ? ew.Validators.required(fields.mother_name.caption) : null], fields.mother_name.isInvalid],
            ["nominee_name", [fields.nominee_name.visible && fields.nominee_name.required ? ew.Validators.required(fields.nominee_name.caption) : null], fields.nominee_name.isInvalid],
            ["nominee_relation", [fields.nominee_relation.visible && fields.nominee_relation.required ? ew.Validators.required(fields.nominee_relation.caption) : null], fields.nominee_relation.isInvalid],
            ["pan_no", [fields.pan_no.visible && fields.pan_no.required ? ew.Validators.required(fields.pan_no.caption) : null], fields.pan_no.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["adviser", [fields.adviser.visible && fields.adviser.required ? ew.Validators.required(fields.adviser.caption) : null], fields.adviser.isInvalid],
            ["share_no", [fields.share_no.visible && fields.share_no.required ? ew.Validators.required(fields.share_no.caption) : null], fields.share_no.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "nominee_relation": <?= $Page->nominee_relation->toClientList($Page) ?>,
            "adviser": <?= $Page->adviser->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="finvestor_infoadd" id="finvestor_infoadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="investor_info">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
    <div id="r_aadhaar_no"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <label id="elh_investor_info_aadhaar_no" for="x_aadhaar_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->aadhaar_no->caption() ?><?= $Page->aadhaar_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->aadhaar_no->cellAttributes() ?>>
<span id="el_investor_info_aadhaar_no">
<input type="<?= $Page->aadhaar_no->getInputTextType() ?>" name="x_aadhaar_no" id="x_aadhaar_no" data-table="investor_info" data-field="x_aadhaar_no" value="<?= $Page->aadhaar_no->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->aadhaar_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_no->formatPattern()) ?>"<?= $Page->aadhaar_no->editAttributes() ?> aria-describedby="x_aadhaar_no_help">
<?= $Page->aadhaar_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->aadhaar_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label id="elh_investor_info_name" for="x_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->name->caption() ?><?= $Page->name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->name->cellAttributes() ?>>
<span id="el_investor_info_name">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="investor_info" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
<?= $Page->name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
    <div id="r_gender"<?= $Page->gender->rowAttributes() ?>>
        <label id="elh_investor_info_gender" for="x_gender" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gender->caption() ?><?= $Page->gender->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gender->cellAttributes() ?>>
<span id="el_investor_info_gender">
    <select
        id="x_gender"
        name="x_gender"
        class="form-select ew-select<?= $Page->gender->isInvalidClass() ?>"
        <?php if (!$Page->gender->IsNativeSelect) { ?>
        data-select2-id="finvestor_infoadd_x_gender"
        <?php } ?>
        data-table="investor_info"
        data-field="x_gender"
        data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gender->getPlaceHolder()) ?>"
        <?= $Page->gender->editAttributes() ?>>
        <?= $Page->gender->selectOptionListHtml("x_gender") ?>
    </select>
    <?= $Page->gender->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->gender->getErrorMessage() ?></div>
<?php if (!$Page->gender->IsNativeSelect) { ?>
<script>
loadjs.ready("finvestor_infoadd", function() {
    var options = { name: "x_gender", selectId: "finvestor_infoadd_x_gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvestor_infoadd.lists.gender?.lookupOptions.length) {
        options.data = { id: "x_gender", form: "finvestor_infoadd" };
    } else {
        options.ajax = { id: "x_gender", form: "finvestor_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.investor_info.fields.gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <div id="r_dob"<?= $Page->dob->rowAttributes() ?>>
        <label id="elh_investor_info_dob" for="x_dob" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dob->caption() ?><?= $Page->dob->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dob->cellAttributes() ?>>
<span id="el_investor_info_dob">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="investor_info" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?> aria-describedby="x_dob_help">
<?= $Page->dob->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage() ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["finvestor_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("finvestor_infoadd", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_investor_info_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_investor_info_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="investor_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="22" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label id="elh_investor_info__email" for="x__email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_email->caption() ?><?= $Page->_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_email->cellAttributes() ?>>
<span id="el_investor_info__email">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="investor_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
<?= $Page->_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label id="elh_investor_info_address" for="x_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->address->cellAttributes() ?>>
<span id="el_investor_info_address">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="investor_info" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="30" maxlength="252" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help">
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->care_of->Visible) { // care_of ?>
    <div id="r_care_of"<?= $Page->care_of->rowAttributes() ?>>
        <label id="elh_investor_info_care_of" for="x_care_of" class="<?= $Page->LeftColumnClass ?>"><?= $Page->care_of->caption() ?><?= $Page->care_of->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->care_of->cellAttributes() ?>>
<span id="el_investor_info_care_of">
<input type="<?= $Page->care_of->getInputTextType() ?>" name="x_care_of" id="x_care_of" data-table="investor_info" data-field="x_care_of" value="<?= $Page->care_of->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->care_of->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->care_of->formatPattern()) ?>"<?= $Page->care_of->editAttributes() ?> aria-describedby="x_care_of_help">
<?= $Page->care_of->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->care_of->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
    <div id="r_father_name"<?= $Page->father_name->rowAttributes() ?>>
        <label id="elh_investor_info_father_name" for="x_father_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->father_name->caption() ?><?= $Page->father_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->father_name->cellAttributes() ?>>
<span id="el_investor_info_father_name">
<input type="<?= $Page->father_name->getInputTextType() ?>" name="x_father_name" id="x_father_name" data-table="investor_info" data-field="x_father_name" value="<?= $Page->father_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->father_name->formatPattern()) ?>"<?= $Page->father_name->editAttributes() ?> aria-describedby="x_father_name_help">
<?= $Page->father_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->father_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mother_name->Visible) { // mother_name ?>
    <div id="r_mother_name"<?= $Page->mother_name->rowAttributes() ?>>
        <label id="elh_investor_info_mother_name" for="x_mother_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mother_name->caption() ?><?= $Page->mother_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mother_name->cellAttributes() ?>>
<span id="el_investor_info_mother_name">
<input type="<?= $Page->mother_name->getInputTextType() ?>" name="x_mother_name" id="x_mother_name" data-table="investor_info" data-field="x_mother_name" value="<?= $Page->mother_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->mother_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mother_name->formatPattern()) ?>"<?= $Page->mother_name->editAttributes() ?> aria-describedby="x_mother_name_help">
<?= $Page->mother_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mother_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->nominee_name->Visible) { // nominee_name ?>
    <div id="r_nominee_name"<?= $Page->nominee_name->rowAttributes() ?>>
        <label id="elh_investor_info_nominee_name" for="x_nominee_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->nominee_name->caption() ?><?= $Page->nominee_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->nominee_name->cellAttributes() ?>>
<span id="el_investor_info_nominee_name">
<input type="<?= $Page->nominee_name->getInputTextType() ?>" name="x_nominee_name" id="x_nominee_name" data-table="investor_info" data-field="x_nominee_name" value="<?= $Page->nominee_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->nominee_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->nominee_name->formatPattern()) ?>"<?= $Page->nominee_name->editAttributes() ?> aria-describedby="x_nominee_name_help">
<?= $Page->nominee_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->nominee_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->nominee_relation->Visible) { // nominee_relation ?>
    <div id="r_nominee_relation"<?= $Page->nominee_relation->rowAttributes() ?>>
        <label id="elh_investor_info_nominee_relation" for="x_nominee_relation" class="<?= $Page->LeftColumnClass ?>"><?= $Page->nominee_relation->caption() ?><?= $Page->nominee_relation->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->nominee_relation->cellAttributes() ?>>
<span id="el_investor_info_nominee_relation">
    <select
        id="x_nominee_relation"
        name="x_nominee_relation"
        class="form-select ew-select<?= $Page->nominee_relation->isInvalidClass() ?>"
        <?php if (!$Page->nominee_relation->IsNativeSelect) { ?>
        data-select2-id="finvestor_infoadd_x_nominee_relation"
        <?php } ?>
        data-table="investor_info"
        data-field="x_nominee_relation"
        data-value-separator="<?= $Page->nominee_relation->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->nominee_relation->getPlaceHolder()) ?>"
        <?= $Page->nominee_relation->editAttributes() ?>>
        <?= $Page->nominee_relation->selectOptionListHtml("x_nominee_relation") ?>
    </select>
    <?= $Page->nominee_relation->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->nominee_relation->getErrorMessage() ?></div>
<?php if (!$Page->nominee_relation->IsNativeSelect) { ?>
<script>
loadjs.ready("finvestor_infoadd", function() {
    var options = { name: "x_nominee_relation", selectId: "finvestor_infoadd_x_nominee_relation" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvestor_infoadd.lists.nominee_relation?.lookupOptions.length) {
        options.data = { id: "x_nominee_relation", form: "finvestor_infoadd" };
    } else {
        options.ajax = { id: "x_nominee_relation", form: "finvestor_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.investor_info.fields.nominee_relation.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pan_no->Visible) { // pan_no ?>
    <div id="r_pan_no"<?= $Page->pan_no->rowAttributes() ?>>
        <label id="elh_investor_info_pan_no" for="x_pan_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pan_no->caption() ?><?= $Page->pan_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pan_no->cellAttributes() ?>>
<span id="el_investor_info_pan_no">
<input type="<?= $Page->pan_no->getInputTextType() ?>" name="x_pan_no" id="x_pan_no" data-table="investor_info" data-field="x_pan_no" value="<?= $Page->pan_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->pan_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_no->formatPattern()) ?>"<?= $Page->pan_no->editAttributes() ?> aria-describedby="x_pan_no_help">
<?= $Page->pan_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->pan_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_investor_info_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_investor_info_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="investor_info"
        data-field="x_uploads"
        data-size="500"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->adviser->Visible) { // adviser ?>
    <div id="r_adviser"<?= $Page->adviser->rowAttributes() ?>>
        <label id="elh_investor_info_adviser" for="x_adviser" class="<?= $Page->LeftColumnClass ?>"><?= $Page->adviser->caption() ?><?= $Page->adviser->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->adviser->cellAttributes() ?>>
<span id="el_investor_info_adviser">
    <select
        id="x_adviser"
        name="x_adviser"
        class="form-select ew-select<?= $Page->adviser->isInvalidClass() ?>"
        <?php if (!$Page->adviser->IsNativeSelect) { ?>
        data-select2-id="finvestor_infoadd_x_adviser"
        <?php } ?>
        data-table="investor_info"
        data-field="x_adviser"
        data-value-separator="<?= $Page->adviser->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->adviser->getPlaceHolder()) ?>"
        <?= $Page->adviser->editAttributes() ?>>
        <?= $Page->adviser->selectOptionListHtml("x_adviser") ?>
    </select>
    <?= $Page->adviser->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->adviser->getErrorMessage() ?></div>
<?= $Page->adviser->Lookup->getParamTag($Page, "p_x_adviser") ?>
<?php if (!$Page->adviser->IsNativeSelect) { ?>
<script>
loadjs.ready("finvestor_infoadd", function() {
    var options = { name: "x_adviser", selectId: "finvestor_infoadd_x_adviser" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (finvestor_infoadd.lists.adviser?.lookupOptions.length) {
        options.data = { id: "x_adviser", form: "finvestor_infoadd" };
    } else {
        options.ajax = { id: "x_adviser", form: "finvestor_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.investor_info.fields.adviser.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->share_no->Visible) { // share_no ?>
    <div id="r_share_no"<?= $Page->share_no->rowAttributes() ?>>
        <label id="elh_investor_info_share_no" for="x_share_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->share_no->caption() ?><?= $Page->share_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->share_no->cellAttributes() ?>>
<span id="el_investor_info_share_no">
<textarea data-table="investor_info" data-field="x_share_no" name="x_share_no" id="x_share_no" cols="30" rows="2" placeholder="<?= HtmlEncode($Page->share_no->getPlaceHolder()) ?>"<?= $Page->share_no->editAttributes() ?> aria-describedby="x_share_no_help"><?= $Page->share_no->EditValue ?></textarea>
<?= $Page->share_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->share_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_investor_info_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_investor_info_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="investor_info" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="finvestor_infoadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="finvestor_infoadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("investor_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    $('#x_aadhaar_no').attr('type', 'number');
    $('#x_mobile').attr('type', 'number');
    $("#el_investor_info_aadhaar_no").append('<div class="input-group-append" ><h6 style="color:blue" onclick="javascript:checkaadhaar()"><i class="fa fa-check"></i> Verify Aadhaar</h6></div>');

    function checkaadhaar()
    {
    	var aadhaar = $("#x_aadhaar_no").val();
    	if (aadhaar.length != 12)
    	{
    		alert('Enter Correct Aadhaar No.')
    	}
    	else
    	{
    		$.getJSON(window.location.origin +'/apcajax2?maadhaar='+aadhaar,function(data)
    		{
    			if (data == 0)
    			{
    				$.getJSON(window.location.origin +'/apcajaxes?maadhaarotp='+aadhaar,function(data1)
    				{
    					const arrayotp = JSON.parse(data1);
    					var clientId = arrayotp.result.data.client_id ? arrayotp.result.data.client_id : '';
    					Obj='<div class="modal" id="myModal"><div class="modal-dialog modal-dialog-scrollable modal-lg"><div class="modal-content"><!-- Modal Header --><div class="modal-header"><h1 class="modal-title">Enter OTP</h1><button type="button" class="close" data-bs-dismiss="modal">×</button></div><!-- Modal body --><div class="modal-body"><label for="otp">Please enter the OTP (One-Time Password) <br>received for Aadhaar verification on your registered mobile number.</label><br><br><input type="text" id="otp" name="otp" required autofocus><input type="hidden" id="cid" name="cid" value="'+clientId+'"><input type="hidden" id="aadh" name="aadh" value="'+aadhaar+'"><br></div><div class="modal-footer"><input type="button" id="sbtn" class="btn btn-primary" value="SUBMIT" onclick="SUBMITModal()"><button id="cbtn" type="button" class="btn btn-danger" onclick="CLOSEModal()">Close</button></div></div></div>';
    					$("body").prepend(Obj);
    					$("#myModal").modal("show");
    				})
    			}
    			else
    			{
    			Obj='<div class="modal" id="myModal"><div class="modal-dialog modal-dialog-scrollable modal-lg"><div class="modal-content"><!-- Modal Header --><div class="modal-header"><h1 class="modal-title">New Request</h1><button type="button" class="close" data-bs-dismiss="modal">×</button></div><!-- Modal body --><div class="modal-body"><h5>An Aadhaar number already exists for the provided Aadhaar No. on ID# '+data+'</h5></div><div class="modal-footer"><a href="investorinfoedit?id='+data+'" target="_self" class="btn btn-primary">Access the previous ID</a><button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button></div></div></div>';
    			$("body").prepend(Obj);
    			$("#myModal").modal("show")
    			//new Audio('beep.mp3').play(); // define your audio	
    			}				
    		});
    	}
    }

    function SUBMITModal()
    {
    	var otp = $("#otp").val();
    	var cid = $("#cid").val();			
    	$.getJSON(window.location.origin +'/apcajaxes?getaadhaardatabyotp='+otp+'&cid='+cid);
    	$("#sbtn").hide();
    	setTimeout($("#cbtn").click(), 1000); 
    }

    function CLOSEModal()
    {
    	var aadhaar = $("#aadh").val();			
    	$.getJSON(window.location.origin +'/apcajax2?maadhaar='+aadhaar, function(data2)
    	{
    	$("#myModal").modal("hide");
    	setTimeout(location.href = "investor_infoedit?id="+data2, 1000);
    	})
    }
});
</script>
