<?php

namespace PHPMaker2024\fibre;

// Page object
$IntShopEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fint_shopedit" id="fint_shopedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { int_shop: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fint_shopedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fint_shopedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["short_description", [fields.short_description.visible && fields.short_description.required ? ew.Validators.required(fields.short_description.caption) : null], fields.short_description.isInvalid],
            ["includes", [fields.includes.visible && fields.includes.required ? ew.Validators.required(fields.includes.caption) : null], fields.includes.isInvalid],
            ["description", [fields.description.visible && fields.description.required ? ew.Validators.required(fields.description.caption) : null], fields.description.isInvalid],
            ["price", [fields.price.visible && fields.price.required ? ew.Validators.required(fields.price.caption) : null, ew.Validators.float], fields.price.isInvalid],
            ["discount_coupon", [fields.discount_coupon.visible && fields.discount_coupon.required ? ew.Validators.required(fields.discount_coupon.caption) : null], fields.discount_coupon.isInvalid],
            ["discount", [fields.discount.visible && fields.discount.required ? ew.Validators.required(fields.discount.caption) : null, ew.Validators.float], fields.discount.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["valid_till", [fields.valid_till.visible && fields.valid_till.required ? ew.Validators.required(fields.valid_till.caption) : null, ew.Validators.datetime(fields.valid_till.clientFormatPattern)], fields.valid_till.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null, ew.Validators.integer], fields.status.isInvalid],
            ["_response", [fields._response.visible && fields._response.required ? ew.Validators.required(fields._response.caption) : null, ew.Validators.integer], fields._response.isInvalid],
            ["code", [fields.code.visible && fields.code.required ? ew.Validators.required(fields.code.caption) : null], fields.code.isInvalid],
            ["show_to", [fields.show_to.visible && fields.show_to.required ? ew.Validators.required(fields.show_to.caption) : null], fields.show_to.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "category": <?= $Page->category->toClientList($Page) ?>,
            "includes": <?= $Page->includes->toClientList($Page) ?>,
            "show_to": <?= $Page->show_to->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="int_shop">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_int_shop_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_int_shop_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="int_shop" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_int_shop_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_int_shop_category">
<template id="tp_x_category">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="int_shop" data-field="x_category" name="x_category" id="x_category"<?= $Page->category->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_category" class="ew-item-list"></div>
<selection-list hidden
    id="x_category[]"
    name="x_category[]"
    value="<?= HtmlEncode($Page->category->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_category"
    data-target="dsl_x_category"
    data-repeatcolumn="5"
    class="form-control<?= $Page->category->isInvalidClass() ?>"
    data-table="int_shop"
    data-field="x_category"
    data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
    <?= $Page->category->editAttributes() ?>></selection-list>
<?= $Page->category->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->short_description->Visible) { // short_description ?>
    <div id="r_short_description"<?= $Page->short_description->rowAttributes() ?>>
        <label id="elh_int_shop_short_description" for="x_short_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->short_description->caption() ?><?= $Page->short_description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->short_description->cellAttributes() ?>>
<span id="el_int_shop_short_description">
<input type="<?= $Page->short_description->getInputTextType() ?>" name="x_short_description" id="x_short_description" data-table="int_shop" data-field="x_short_description" value="<?= $Page->short_description->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->short_description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->short_description->formatPattern()) ?>"<?= $Page->short_description->editAttributes() ?> aria-describedby="x_short_description_help">
<?= $Page->short_description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->short_description->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->includes->Visible) { // includes ?>
    <div id="r_includes"<?= $Page->includes->rowAttributes() ?>>
        <label id="elh_int_shop_includes" class="<?= $Page->LeftColumnClass ?>"><?= $Page->includes->caption() ?><?= $Page->includes->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->includes->cellAttributes() ?>>
<span id="el_int_shop_includes">
<template id="tp_x_includes">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="int_shop" data-field="x_includes" name="x_includes" id="x_includes"<?= $Page->includes->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_includes" class="ew-item-list"></div>
<selection-list hidden
    id="x_includes[]"
    name="x_includes[]"
    value="<?= HtmlEncode($Page->includes->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_includes"
    data-target="dsl_x_includes"
    data-repeatcolumn="5"
    class="form-control<?= $Page->includes->isInvalidClass() ?>"
    data-table="int_shop"
    data-field="x_includes"
    data-value-separator="<?= $Page->includes->displayValueSeparatorAttribute() ?>"
    <?= $Page->includes->editAttributes() ?>></selection-list>
<?= $Page->includes->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->includes->getErrorMessage() ?></div>
<?= $Page->includes->Lookup->getParamTag($Page, "p_x_includes") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description"<?= $Page->description->rowAttributes() ?>>
        <label id="elh_int_shop_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description->caption() ?><?= $Page->description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description->cellAttributes() ?>>
<span id="el_int_shop_description">
<?php $Page->description->EditAttrs->appendClass("editor"); ?>
<textarea data-table="int_shop" data-field="x_description" name="x_description" id="x_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>"<?= $Page->description->editAttributes() ?> aria-describedby="x_description_help"><?= $Page->description->EditValue ?></textarea>
<?= $Page->description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage() ?></div>
<script>
loadjs.ready(["fint_shopedit", "editor"], function() {
    ew.createEditor("fint_shopedit", "x_description", 35, 4, <?= $Page->description->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price"<?= $Page->price->rowAttributes() ?>>
        <label id="elh_int_shop_price" for="x_price" class="<?= $Page->LeftColumnClass ?>"><?= $Page->price->caption() ?><?= $Page->price->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->price->cellAttributes() ?>>
<span id="el_int_shop_price">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="int_shop" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?> aria-describedby="x_price_help">
<?= $Page->price->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->discount_coupon->Visible) { // discount_coupon ?>
    <div id="r_discount_coupon"<?= $Page->discount_coupon->rowAttributes() ?>>
        <label id="elh_int_shop_discount_coupon" for="x_discount_coupon" class="<?= $Page->LeftColumnClass ?>"><?= $Page->discount_coupon->caption() ?><?= $Page->discount_coupon->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->discount_coupon->cellAttributes() ?>>
<span id="el_int_shop_discount_coupon">
<input type="<?= $Page->discount_coupon->getInputTextType() ?>" name="x_discount_coupon" id="x_discount_coupon" data-table="int_shop" data-field="x_discount_coupon" value="<?= $Page->discount_coupon->EditValue ?>" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->discount_coupon->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->discount_coupon->formatPattern()) ?>"<?= $Page->discount_coupon->editAttributes() ?> aria-describedby="x_discount_coupon_help">
<?= $Page->discount_coupon->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->discount_coupon->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->discount->Visible) { // discount ?>
    <div id="r_discount"<?= $Page->discount->rowAttributes() ?>>
        <label id="elh_int_shop_discount" for="x_discount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->discount->caption() ?><?= $Page->discount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->discount->cellAttributes() ?>>
<span id="el_int_shop_discount">
<input type="<?= $Page->discount->getInputTextType() ?>" name="x_discount" id="x_discount" data-table="int_shop" data-field="x_discount" value="<?= $Page->discount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->discount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->discount->formatPattern()) ?>"<?= $Page->discount->editAttributes() ?> aria-describedby="x_discount_help">
<?= $Page->discount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->discount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_int_shop_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_int_shop_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="int_shop" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->valid_till->Visible) { // valid_till ?>
    <div id="r_valid_till"<?= $Page->valid_till->rowAttributes() ?>>
        <label id="elh_int_shop_valid_till" for="x_valid_till" class="<?= $Page->LeftColumnClass ?>"><?= $Page->valid_till->caption() ?><?= $Page->valid_till->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->valid_till->cellAttributes() ?>>
<span id="el_int_shop_valid_till">
<input type="<?= $Page->valid_till->getInputTextType() ?>" name="x_valid_till" id="x_valid_till" data-table="int_shop" data-field="x_valid_till" value="<?= $Page->valid_till->EditValue ?>" placeholder="<?= HtmlEncode($Page->valid_till->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->valid_till->formatPattern()) ?>"<?= $Page->valid_till->editAttributes() ?> aria-describedby="x_valid_till_help">
<?= $Page->valid_till->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->valid_till->getErrorMessage() ?></div>
<?php if (!$Page->valid_till->ReadOnly && !$Page->valid_till->Disabled && !isset($Page->valid_till->EditAttrs["readonly"]) && !isset($Page->valid_till->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fint_shopedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fint_shopedit", "x_valid_till", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_int_shop_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_int_shop_status">
<input type="<?= $Page->status->getInputTextType() ?>" name="x_status" id="x_status" data-table="int_shop" data-field="x_status" value="<?= $Page->status->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?> aria-describedby="x_status_help">
<?= $Page->status->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_response->Visible) { // response ?>
    <div id="r__response"<?= $Page->_response->rowAttributes() ?>>
        <label id="elh_int_shop__response" for="x__response" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_response->caption() ?><?= $Page->_response->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_response->cellAttributes() ?>>
<span id="el_int_shop__response">
<input type="<?= $Page->_response->getInputTextType() ?>" name="x__response" id="x__response" data-table="int_shop" data-field="x__response" value="<?= $Page->_response->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->_response->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_response->formatPattern()) ?>"<?= $Page->_response->editAttributes() ?> aria-describedby="x__response_help">
<?= $Page->_response->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_response->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code"<?= $Page->code->rowAttributes() ?>>
        <label id="elh_int_shop_code" for="x_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->code->caption() ?><?= $Page->code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->code->cellAttributes() ?>>
<span id="el_int_shop_code">
<textarea data-table="int_shop" data-field="x_code" name="x_code" id="x_code" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>"<?= $Page->code->editAttributes() ?> aria-describedby="x_code_help"><?= $Page->code->EditValue ?></textarea>
<?= $Page->code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->show_to->Visible) { // show_to ?>
    <div id="r_show_to"<?= $Page->show_to->rowAttributes() ?>>
        <label id="elh_int_shop_show_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->show_to->caption() ?><?= $Page->show_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->show_to->cellAttributes() ?>>
<span id="el_int_shop_show_to">
<template id="tp_x_show_to">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="int_shop" data-field="x_show_to" name="x_show_to" id="x_show_to"<?= $Page->show_to->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_show_to" class="ew-item-list"></div>
<selection-list hidden
    id="x_show_to[]"
    name="x_show_to[]"
    value="<?= HtmlEncode($Page->show_to->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_show_to"
    data-target="dsl_x_show_to"
    data-repeatcolumn="5"
    class="form-control<?= $Page->show_to->isInvalidClass() ?>"
    data-table="int_shop"
    data-field="x_show_to"
    data-value-separator="<?= $Page->show_to->displayValueSeparatorAttribute() ?>"
    <?= $Page->show_to->editAttributes() ?>></selection-list>
<?= $Page->show_to->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->show_to->getErrorMessage() ?></div>
<?= $Page->show_to->Lookup->getParamTag($Page, "p_x_show_to") ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fint_shopedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fint_shopedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("int_shop");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
