<?php

namespace PHPMaker2024\fibre;

// Page object
$IntPortalListAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { int_portal_list: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fint_portal_listadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fint_portal_listadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["url", [fields.url.visible && fields.url.required ? ew.Validators.required(fields.url.caption) : null], fields.url.isInvalid],
            ["_db", [fields._db.visible && fields._db.required ? ew.Validators.required(fields._db.caption) : null], fields._db.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null, ew.Validators.integer], fields.status.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "category": <?= $Page->category->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fint_portal_listadd" id="fint_portal_listadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="int_portal_list">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url"<?= $Page->url->rowAttributes() ?>>
        <label id="elh_int_portal_list_url" for="x_url" class="<?= $Page->LeftColumnClass ?>"><?= $Page->url->caption() ?><?= $Page->url->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->url->cellAttributes() ?>>
<span id="el_int_portal_list_url">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="int_portal_list" data-field="x_url" value="<?= $Page->url->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?> aria-describedby="x_url_help">
<?= $Page->url->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_db->Visible) { // db ?>
    <div id="r__db"<?= $Page->_db->rowAttributes() ?>>
        <label id="elh_int_portal_list__db" for="x__db" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_db->caption() ?><?= $Page->_db->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_db->cellAttributes() ?>>
<span id="el_int_portal_list__db">
<input type="<?= $Page->_db->getInputTextType() ?>" name="x__db" id="x__db" data-table="int_portal_list" data-field="x__db" value="<?= $Page->_db->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_db->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_db->formatPattern()) ?>"<?= $Page->_db->editAttributes() ?> aria-describedby="x__db_help">
<?= $Page->_db->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_db->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_int_portal_list_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_int_portal_list_category">
<?php
if (IsRTL()) {
    $Page->category->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_category" class="ew-auto-suggest">
    <input type="<?= $Page->category->getInputTextType() ?>" class="form-control" name="sv_x_category" id="sv_x_category" value="<?= RemoveHtml($Page->category->EditValue) ?>" autocomplete="off" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->category->formatPattern()) ?>"<?= $Page->category->editAttributes() ?> aria-describedby="x_category_help">
</span>
<selection-list hidden class="form-control" data-table="int_portal_list" data-field="x_category" data-input="sv_x_category" data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>" name="x_category" id="x_category" value="<?= HtmlEncode($Page->category->CurrentValue) ?>"></selection-list>
<?= $Page->category->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<script>
loadjs.ready("fint_portal_listadd", function() {
    fint_portal_listadd.createAutoSuggest(Object.assign({"id":"x_category","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->category->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.int_portal_list.fields.category.autoSuggestOptions));
});
</script>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_int_portal_list_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_int_portal_list_status">
<input type="<?= $Page->status->getInputTextType() ?>" name="x_status" id="x_status" data-table="int_portal_list" data-field="x_status" value="<?= $Page->status->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?> aria-describedby="x_status_help">
<?= $Page->status->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fint_portal_listadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fint_portal_listadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("int_portal_list");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
