<?php

namespace PHPMaker2024\fibre;

// Page object
$IntFibreHelpSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { int_fibre_help: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fint_fibre_helpsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fint_fibre_helpsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["level", [], fields.level.isInvalid],
            ["table_name", [], fields.table_name.isInvalid],
            ["y_table_name", [ew.Validators.between], false],
            ["table_caption", [], fields.table_caption.isInvalid],
            ["y_table_caption", [ew.Validators.between], false],
            ["admin_notes", [], fields.admin_notes.isInvalid],
            ["y_admin_notes", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "level": <?= $Page->level->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fint_fibre_helpsearch" id="fint_fibre_helpsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="int_fibre_help">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_int_fibre_help_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_int_fibre_help_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="int_fibre_help" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->level->Visible) { // level ?>
    <div id="r_level" class="row"<?= $Page->level->rowAttributes() ?>>
        <label for="x_level" class="<?= $Page->LeftColumnClass ?>"><span id="elh_int_fibre_help_level"><?= $Page->level->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_level" id="z_level" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->level->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_int_fibre_help_level" class="ew-search-field ew-search-field-single">
    <select
        id="x_level"
        name="x_level"
        class="form-select ew-select<?= $Page->level->isInvalidClass() ?>"
        <?php if (!$Page->level->IsNativeSelect) { ?>
        data-select2-id="fint_fibre_helpsearch_x_level"
        <?php } ?>
        data-table="int_fibre_help"
        data-field="x_level"
        data-value-separator="<?= $Page->level->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->level->getPlaceHolder()) ?>"
        <?= $Page->level->editAttributes() ?>>
        <?= $Page->level->selectOptionListHtml("x_level") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->level->getErrorMessage(false) ?></div>
<?php if (!$Page->level->IsNativeSelect) { ?>
<script>
loadjs.ready("fint_fibre_helpsearch", function() {
    var options = { name: "x_level", selectId: "fint_fibre_helpsearch_x_level" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fint_fibre_helpsearch.lists.level?.lookupOptions.length) {
        options.data = { id: "x_level", form: "fint_fibre_helpsearch" };
    } else {
        options.ajax = { id: "x_level", form: "fint_fibre_helpsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.int_fibre_help.fields.level.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->table_name->Visible) { // table_name ?>
    <div id="r_table_name" class="row"<?= $Page->table_name->rowAttributes() ?>>
        <label for="x_table_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_int_fibre_help_table_name"><?= $Page->table_name->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->table_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_table_name" id="z_table_name" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->table_name->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->table_name->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_int_fibre_help_table_name" class="ew-search-field">
<input type="<?= $Page->table_name->getInputTextType() ?>" name="x_table_name" id="x_table_name" data-table="int_fibre_help" data-field="x_table_name" value="<?= $Page->table_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_name->formatPattern()) ?>"<?= $Page->table_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_name->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_int_fibre_help_table_name" class="ew-search-field2 d-none">
<input type="<?= $Page->table_name->getInputTextType() ?>" name="y_table_name" id="y_table_name" data-table="int_fibre_help" data-field="x_table_name" value="<?= $Page->table_name->EditValue2 ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_name->formatPattern()) ?>"<?= $Page->table_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->table_caption->Visible) { // table_caption ?>
    <div id="r_table_caption" class="row"<?= $Page->table_caption->rowAttributes() ?>>
        <label for="x_table_caption" class="<?= $Page->LeftColumnClass ?>"><span id="elh_int_fibre_help_table_caption"><?= $Page->table_caption->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->table_caption->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_table_caption" id="z_table_caption" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->table_caption->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->table_caption->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_int_fibre_help_table_caption" class="ew-search-field">
<input type="<?= $Page->table_caption->getInputTextType() ?>" name="x_table_caption" id="x_table_caption" data-table="int_fibre_help" data-field="x_table_caption" value="<?= $Page->table_caption->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_caption->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_caption->formatPattern()) ?>"<?= $Page->table_caption->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_caption->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_int_fibre_help_table_caption" class="ew-search-field2 d-none">
<input type="<?= $Page->table_caption->getInputTextType() ?>" name="y_table_caption" id="y_table_caption" data-table="int_fibre_help" data-field="x_table_caption" value="<?= $Page->table_caption->EditValue2 ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_caption->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_caption->formatPattern()) ?>"<?= $Page->table_caption->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_caption->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->admin_notes->Visible) { // admin_notes ?>
    <div id="r_admin_notes" class="row"<?= $Page->admin_notes->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_int_fibre_help_admin_notes"><?= $Page->admin_notes->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->admin_notes->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_admin_notes" id="z_admin_notes" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->admin_notes->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->admin_notes->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_int_fibre_help_admin_notes" class="ew-search-field">
<input type="<?= $Page->admin_notes->getInputTextType() ?>" name="x_admin_notes" id="x_admin_notes" data-table="int_fibre_help" data-field="x_admin_notes" value="<?= $Page->admin_notes->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->admin_notes->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->admin_notes->formatPattern()) ?>"<?= $Page->admin_notes->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->admin_notes->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_int_fibre_help_admin_notes" class="ew-search-field2 d-none">
<input type="<?= $Page->admin_notes->getInputTextType() ?>" name="y_admin_notes" id="y_admin_notes" data-table="int_fibre_help" data-field="x_admin_notes" value="<?= $Page->admin_notes->EditValue2 ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->admin_notes->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->admin_notes->formatPattern()) ?>"<?= $Page->admin_notes->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->admin_notes->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fint_fibre_helpsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fint_fibre_helpsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fint_fibre_helpsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("int_fibre_help");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
