<?php

namespace PHPMaker2024\fibre;

// Page object
$ImportBcodeAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { import_bcode: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fimport_bcodeadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fimport_bcodeadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null], fields._barcode.isInvalid],
            ["material_requirement", [fields.material_requirement.visible && fields.material_requirement.required ? ew.Validators.required(fields.material_requirement.caption) : null], fields.material_requirement.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "material_requirement": <?= $Page->material_requirement->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fimport_bcodeadd" id="fimport_bcodeadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="import_bcode">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode"<?= $Page->_barcode->rowAttributes() ?>>
        <label id="elh_import_bcode__barcode" for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_barcode->caption() ?><?= $Page->_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_barcode->cellAttributes() ?>>
<span id="el_import_bcode__barcode">
<textarea data-table="import_bcode" data-field="x__barcode" name="x__barcode" id="x__barcode" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>"<?= $Page->_barcode->editAttributes() ?> aria-describedby="x__barcode_help"><?= $Page->_barcode->EditValue ?></textarea>
<?= $Page->_barcode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->material_requirement->Visible) { // material_requirement ?>
    <div id="r_material_requirement"<?= $Page->material_requirement->rowAttributes() ?>>
        <label id="elh_import_bcode_material_requirement" for="x_material_requirement" class="<?= $Page->LeftColumnClass ?>"><?= $Page->material_requirement->caption() ?><?= $Page->material_requirement->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->material_requirement->cellAttributes() ?>>
<span id="el_import_bcode_material_requirement">
    <select
        id="x_material_requirement"
        name="x_material_requirement"
        class="form-select ew-select<?= $Page->material_requirement->isInvalidClass() ?>"
        <?php if (!$Page->material_requirement->IsNativeSelect) { ?>
        data-select2-id="fimport_bcodeadd_x_material_requirement"
        <?php } ?>
        data-table="import_bcode"
        data-field="x_material_requirement"
        data-value-separator="<?= $Page->material_requirement->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->material_requirement->getPlaceHolder()) ?>"
        <?= $Page->material_requirement->editAttributes() ?>>
        <?= $Page->material_requirement->selectOptionListHtml("x_material_requirement") ?>
    </select>
    <?= $Page->material_requirement->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->material_requirement->getErrorMessage() ?></div>
<?php if (!$Page->material_requirement->IsNativeSelect) { ?>
<script>
loadjs.ready("fimport_bcodeadd", function() {
    var options = { name: "x_material_requirement", selectId: "fimport_bcodeadd_x_material_requirement" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fimport_bcodeadd.lists.material_requirement?.lookupOptions.length) {
        options.data = { id: "x_material_requirement", form: "fimport_bcodeadd" };
    } else {
        options.ajax = { id: "x_material_requirement", form: "fimport_bcodeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.import_bcode.fields.material_requirement.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fimport_bcodeadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fimport_bcodeadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("import_bcode");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
