<?php

namespace PHPMaker2024\fibre;

// Page object
$HelpUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { help: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fhelpupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fhelpupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["field_description", [fields.field_description.visible && fields.field_description.required ? ew.Validators.required(fields.field_description.caption) : null], fields.field_description.isInvalid],
            ["_visible", [fields._visible.visible && fields._visible.required ? ew.Validators.required(fields._visible.caption) : null], fields._visible.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "_visible": <?= $Page->_visible->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fhelpupdate" id="fhelpupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="help">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_helpupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"<?= $Page->Disabled ?>><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->field_description->Visible && (!$Page->isConfirm() || $Page->field_description->multiUpdateSelected())) { // field_description ?>
    <div id="r_field_description"<?= $Page->field_description->rowAttributes() ?>>
        <label for="x_field_description" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_field_description" id="u_field_description" class="form-check-input ew-multi-select" value="1"<?= $Page->field_description->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_field_description"><?= $Page->field_description->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_field_description" id="u_field_description" value="<?= $Page->field_description->MultiUpdate ?>">
            <?= $Page->field_description->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->field_description->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_help_field_description">
                <textarea data-table="help" data-field="x_field_description" name="x_field_description" id="x_field_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->field_description->getPlaceHolder()) ?>"<?= $Page->field_description->editAttributes() ?> aria-describedby="x_field_description_help"><?= $Page->field_description->EditValue ?></textarea>
                <?= $Page->field_description->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->field_description->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_help_field_description">
                <span<?= $Page->field_description->viewAttributes() ?>>
                <?= $Page->field_description->ViewValue ?></span>
                <input type="hidden" data-table="help" data-field="x_field_description" data-hidden="1" name="x_field_description" id="x_field_description" value="<?= HtmlEncode($Page->field_description->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_visible->Visible && (!$Page->isConfirm() || $Page->_visible->multiUpdateSelected())) { // visible ?>
    <div id="r__visible"<?= $Page->_visible->rowAttributes() ?>>
        <label for="x__visible" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u__visible" id="u__visible" class="form-check-input ew-multi-select" value="1"<?= $Page->_visible->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u__visible"><?= $Page->_visible->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u__visible" id="u__visible" value="<?= $Page->_visible->MultiUpdate ?>">
            <?= $Page->_visible->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_visible->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_help__visible">
                    <select
                        id="x__visible"
                        name="x__visible"
                        class="form-select ew-select<?= $Page->_visible->isInvalidClass() ?>"
                        <?php if (!$Page->_visible->IsNativeSelect) { ?>
                        data-select2-id="fhelpupdate_x__visible"
                        <?php } ?>
                        data-table="help"
                        data-field="x__visible"
                        data-value-separator="<?= $Page->_visible->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->_visible->getPlaceHolder()) ?>"
                        <?= $Page->_visible->editAttributes() ?>>
                        <?= $Page->_visible->selectOptionListHtml("x__visible") ?>
                    </select>
                    <?= $Page->_visible->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->_visible->getErrorMessage() ?></div>
                <?php if (!$Page->_visible->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fhelpupdate", function() {
                    var options = { name: "x__visible", selectId: "fhelpupdate_x__visible" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fhelpupdate.lists._visible?.lookupOptions.length) {
                        options.data = { id: "x__visible", form: "fhelpupdate" };
                    } else {
                        options.ajax = { id: "x__visible", form: "fhelpupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.help.fields._visible.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_help__visible">
                <span<?= $Page->_visible->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->_visible->getDisplayValue($Page->_visible->ViewValue) ?></span></span>
                <input type="hidden" data-table="help" data-field="x__visible" data-hidden="1" name="x__visible" id="x__visible" value="<?= HtmlEncode($Page->_visible->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fhelpupdate" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fhelpupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fhelpupdate"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="fhelpupdate" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("help");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
