<?php

namespace PHPMaker2024\fibre;

// Page object
$HelpSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { help: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fhelpsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fhelpsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["level", [], fields.level.isInvalid],
            ["menu_group", [], fields.menu_group.isInvalid],
            ["y_menu_group", [ew.Validators.between], false],
            ["menu_description", [], fields.menu_description.isInvalid],
            ["y_menu_description", [ew.Validators.between], false],
            ["table_name", [], fields.table_name.isInvalid],
            ["y_table_name", [ew.Validators.between], false],
            ["table_caption", [], fields.table_caption.isInvalid],
            ["y_table_caption", [ew.Validators.between], false],
            ["field_name", [], fields.field_name.isInvalid],
            ["y_field_name", [ew.Validators.between], false],
            ["field_caption", [], fields.field_caption.isInvalid],
            ["y_field_caption", [ew.Validators.between], false],
            ["field_description", [], fields.field_description.isInvalid],
            ["y_field_description", [ew.Validators.between], false],
            ["table_description", [], fields.table_description.isInvalid],
            ["portal_notes", [], fields.portal_notes.isInvalid],
            ["y_portal_notes", [ew.Validators.between], false],
            ["_visible", [], fields._visible.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "level": <?= $Page->level->toClientList($Page) ?>,
            "_visible": <?= $Page->_visible->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fhelpsearch" id="fhelpsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="help">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_help_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="help" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->level->Visible) { // level ?>
    <div id="r_level" class="row"<?= $Page->level->rowAttributes() ?>>
        <label for="x_level" class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_level"><?= $Page->level->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_level" id="z_level" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->level->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_help_level" class="ew-search-field ew-search-field-single">
    <select
        id="x_level"
        name="x_level"
        class="form-select ew-select<?= $Page->level->isInvalidClass() ?>"
        <?php if (!$Page->level->IsNativeSelect) { ?>
        data-select2-id="fhelpsearch_x_level"
        <?php } ?>
        data-table="help"
        data-field="x_level"
        data-value-separator="<?= $Page->level->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->level->getPlaceHolder()) ?>"
        <?= $Page->level->editAttributes() ?>>
        <?= $Page->level->selectOptionListHtml("x_level") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->level->getErrorMessage(false) ?></div>
<?php if (!$Page->level->IsNativeSelect) { ?>
<script>
loadjs.ready("fhelpsearch", function() {
    var options = { name: "x_level", selectId: "fhelpsearch_x_level" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fhelpsearch.lists.level?.lookupOptions.length) {
        options.data = { id: "x_level", form: "fhelpsearch" };
    } else {
        options.ajax = { id: "x_level", form: "fhelpsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.help.fields.level.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->menu_group->Visible) { // menu_group ?>
    <div id="r_menu_group" class="row"<?= $Page->menu_group->rowAttributes() ?>>
        <label for="x_menu_group" class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_menu_group"><?= $Page->menu_group->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->menu_group->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_menu_group" id="z_menu_group" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->menu_group->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->menu_group->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_help_menu_group" class="ew-search-field">
<input type="<?= $Page->menu_group->getInputTextType() ?>" name="x_menu_group" id="x_menu_group" data-table="help" data-field="x_menu_group" value="<?= $Page->menu_group->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->menu_group->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->menu_group->formatPattern()) ?>"<?= $Page->menu_group->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->menu_group->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_help_menu_group" class="ew-search-field2 d-none">
<input type="<?= $Page->menu_group->getInputTextType() ?>" name="y_menu_group" id="y_menu_group" data-table="help" data-field="x_menu_group" value="<?= $Page->menu_group->EditValue2 ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->menu_group->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->menu_group->formatPattern()) ?>"<?= $Page->menu_group->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->menu_group->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->menu_description->Visible) { // menu_description ?>
    <div id="r_menu_description" class="row"<?= $Page->menu_description->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_menu_description"><?= $Page->menu_description->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->menu_description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_menu_description" id="z_menu_description" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->menu_description->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->menu_description->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_help_menu_description" class="ew-search-field">
<input type="<?= $Page->menu_description->getInputTextType() ?>" name="x_menu_description" id="x_menu_description" data-table="help" data-field="x_menu_description" value="<?= $Page->menu_description->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->menu_description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->menu_description->formatPattern()) ?>"<?= $Page->menu_description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->menu_description->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_help_menu_description" class="ew-search-field2 d-none">
<input type="<?= $Page->menu_description->getInputTextType() ?>" name="y_menu_description" id="y_menu_description" data-table="help" data-field="x_menu_description" value="<?= $Page->menu_description->EditValue2 ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->menu_description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->menu_description->formatPattern()) ?>"<?= $Page->menu_description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->menu_description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->table_name->Visible) { // table_name ?>
    <div id="r_table_name" class="row"<?= $Page->table_name->rowAttributes() ?>>
        <label for="x_table_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_table_name"><?= $Page->table_name->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->table_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_table_name" id="z_table_name" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->table_name->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->table_name->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_help_table_name" class="ew-search-field">
<input type="<?= $Page->table_name->getInputTextType() ?>" name="x_table_name" id="x_table_name" data-table="help" data-field="x_table_name" value="<?= $Page->table_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_name->formatPattern()) ?>"<?= $Page->table_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_name->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_help_table_name" class="ew-search-field2 d-none">
<input type="<?= $Page->table_name->getInputTextType() ?>" name="y_table_name" id="y_table_name" data-table="help" data-field="x_table_name" value="<?= $Page->table_name->EditValue2 ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_name->formatPattern()) ?>"<?= $Page->table_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->table_caption->Visible) { // table_caption ?>
    <div id="r_table_caption" class="row"<?= $Page->table_caption->rowAttributes() ?>>
        <label for="x_table_caption" class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_table_caption"><?= $Page->table_caption->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->table_caption->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_table_caption" id="z_table_caption" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->table_caption->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->table_caption->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_help_table_caption" class="ew-search-field">
<input type="<?= $Page->table_caption->getInputTextType() ?>" name="x_table_caption" id="x_table_caption" data-table="help" data-field="x_table_caption" value="<?= $Page->table_caption->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_caption->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_caption->formatPattern()) ?>"<?= $Page->table_caption->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_caption->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_help_table_caption" class="ew-search-field2 d-none">
<input type="<?= $Page->table_caption->getInputTextType() ?>" name="y_table_caption" id="y_table_caption" data-table="help" data-field="x_table_caption" value="<?= $Page->table_caption->EditValue2 ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_caption->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_caption->formatPattern()) ?>"<?= $Page->table_caption->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_caption->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->field_name->Visible) { // field_name ?>
    <div id="r_field_name" class="row"<?= $Page->field_name->rowAttributes() ?>>
        <label for="x_field_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_field_name"><?= $Page->field_name->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->field_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_field_name" id="z_field_name" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->field_name->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->field_name->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_help_field_name" class="ew-search-field">
<input type="<?= $Page->field_name->getInputTextType() ?>" name="x_field_name" id="x_field_name" data-table="help" data-field="x_field_name" value="<?= $Page->field_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->field_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field_name->formatPattern()) ?>"<?= $Page->field_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field_name->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_help_field_name" class="ew-search-field2 d-none">
<input type="<?= $Page->field_name->getInputTextType() ?>" name="y_field_name" id="y_field_name" data-table="help" data-field="x_field_name" value="<?= $Page->field_name->EditValue2 ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->field_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field_name->formatPattern()) ?>"<?= $Page->field_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->field_caption->Visible) { // field_caption ?>
    <div id="r_field_caption" class="row"<?= $Page->field_caption->rowAttributes() ?>>
        <label for="x_field_caption" class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_field_caption"><?= $Page->field_caption->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->field_caption->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_field_caption" id="z_field_caption" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->field_caption->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->field_caption->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_help_field_caption" class="ew-search-field">
<input type="<?= $Page->field_caption->getInputTextType() ?>" name="x_field_caption" id="x_field_caption" data-table="help" data-field="x_field_caption" value="<?= $Page->field_caption->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->field_caption->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field_caption->formatPattern()) ?>"<?= $Page->field_caption->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field_caption->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_help_field_caption" class="ew-search-field2 d-none">
<input type="<?= $Page->field_caption->getInputTextType() ?>" name="y_field_caption" id="y_field_caption" data-table="help" data-field="x_field_caption" value="<?= $Page->field_caption->EditValue2 ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->field_caption->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field_caption->formatPattern()) ?>"<?= $Page->field_caption->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field_caption->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->field_description->Visible) { // field_description ?>
    <div id="r_field_description" class="row"<?= $Page->field_description->rowAttributes() ?>>
        <label for="x_field_description" class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_field_description"><?= $Page->field_description->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->field_description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_field_description" id="z_field_description" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->field_description->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->field_description->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_help_field_description" class="ew-search-field">
<input type="<?= $Page->field_description->getInputTextType() ?>" name="x_field_description" id="x_field_description" data-table="help" data-field="x_field_description" value="<?= $Page->field_description->EditValue ?>" size="35" maxlength="1000" placeholder="<?= HtmlEncode($Page->field_description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field_description->formatPattern()) ?>"<?= $Page->field_description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field_description->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_help_field_description" class="ew-search-field2 d-none">
<input type="<?= $Page->field_description->getInputTextType() ?>" name="y_field_description" id="y_field_description" data-table="help" data-field="x_field_description" value="<?= $Page->field_description->EditValue2 ?>" size="35" maxlength="1000" placeholder="<?= HtmlEncode($Page->field_description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field_description->formatPattern()) ?>"<?= $Page->field_description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field_description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->table_description->Visible) { // table_description ?>
    <div id="r_table_description" class="row"<?= $Page->table_description->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_table_description"><?= $Page->table_description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_table_description" id="z_table_description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->table_description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_help_table_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->table_description->getInputTextType() ?>" name="x_table_description" id="x_table_description" data-table="help" data-field="x_table_description" value="<?= $Page->table_description->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->table_description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_description->formatPattern()) ?>"<?= $Page->table_description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->portal_notes->Visible) { // portal_notes ?>
    <div id="r_portal_notes" class="row"<?= $Page->portal_notes->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_portal_notes"><?= $Page->portal_notes->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->portal_notes->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_portal_notes" id="z_portal_notes" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->portal_notes->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->portal_notes->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_help_portal_notes" class="ew-search-field">
<input type="<?= $Page->portal_notes->getInputTextType() ?>" name="x_portal_notes" id="x_portal_notes" data-table="help" data-field="x_portal_notes" value="<?= $Page->portal_notes->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->portal_notes->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->portal_notes->formatPattern()) ?>"<?= $Page->portal_notes->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->portal_notes->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_help_portal_notes" class="ew-search-field2 d-none">
<input type="<?= $Page->portal_notes->getInputTextType() ?>" name="y_portal_notes" id="y_portal_notes" data-table="help" data-field="x_portal_notes" value="<?= $Page->portal_notes->EditValue2 ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->portal_notes->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->portal_notes->formatPattern()) ?>"<?= $Page->portal_notes->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->portal_notes->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_visible->Visible) { // visible ?>
    <div id="r__visible" class="row"<?= $Page->_visible->rowAttributes() ?>>
        <label for="x__visible" class="<?= $Page->LeftColumnClass ?>"><span id="elh_help__visible"><?= $Page->_visible->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__visible" id="z__visible" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_visible->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_help__visible" class="ew-search-field ew-search-field-single">
    <select
        id="x__visible"
        name="x__visible"
        class="form-select ew-select<?= $Page->_visible->isInvalidClass() ?>"
        <?php if (!$Page->_visible->IsNativeSelect) { ?>
        data-select2-id="fhelpsearch_x__visible"
        <?php } ?>
        data-table="help"
        data-field="x__visible"
        data-value-separator="<?= $Page->_visible->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_visible->getPlaceHolder()) ?>"
        <?= $Page->_visible->editAttributes() ?>>
        <?= $Page->_visible->selectOptionListHtml("x__visible") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_visible->getErrorMessage(false) ?></div>
<?php if (!$Page->_visible->IsNativeSelect) { ?>
<script>
loadjs.ready("fhelpsearch", function() {
    var options = { name: "x__visible", selectId: "fhelpsearch_x__visible" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fhelpsearch.lists._visible?.lookupOptions.length) {
        options.data = { id: "x__visible", form: "fhelpsearch" };
    } else {
        options.ajax = { id: "x__visible", form: "fhelpsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.help.fields._visible.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_help_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fhelpsearch_x_operator"
        <?php } ?>
        data-table="help"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fhelpsearch", function() {
    var options = { name: "x_operator", selectId: "fhelpsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fhelpsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fhelpsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fhelpsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.help.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_help_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_help_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="help" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fhelpsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fhelpsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fhelpsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fhelpsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fhelpsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("help");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
