<?php

namespace PHPMaker2024\fibre;

// Page object
$HelpList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { help: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["level", [fields.level.visible && fields.level.required ? ew.Validators.required(fields.level.caption) : null], fields.level.isInvalid],
            ["menu_group", [fields.menu_group.visible && fields.menu_group.required ? ew.Validators.required(fields.menu_group.caption) : null], fields.menu_group.isInvalid],
            ["menu_description", [fields.menu_description.visible && fields.menu_description.required ? ew.Validators.required(fields.menu_description.caption) : null], fields.menu_description.isInvalid],
            ["table_name", [fields.table_name.visible && fields.table_name.required ? ew.Validators.required(fields.table_name.caption) : null], fields.table_name.isInvalid],
            ["table_caption", [fields.table_caption.visible && fields.table_caption.required ? ew.Validators.required(fields.table_caption.caption) : null], fields.table_caption.isInvalid],
            ["field_name", [fields.field_name.visible && fields.field_name.required ? ew.Validators.required(fields.field_name.caption) : null], fields.field_name.isInvalid],
            ["field_caption", [fields.field_caption.visible && fields.field_caption.required ? ew.Validators.required(fields.field_caption.caption) : null], fields.field_caption.isInvalid],
            ["field_description", [fields.field_description.visible && fields.field_description.required ? ew.Validators.required(fields.field_description.caption) : null], fields.field_description.isInvalid],
            ["table_description", [fields.table_description.visible && fields.table_description.required ? ew.Validators.required(fields.table_description.caption) : null], fields.table_description.isInvalid],
            ["_visible", [fields._visible.visible && fields._visible.required ? ew.Validators.required(fields._visible.caption) : null], fields._visible.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "level": <?= $Page->level->toClientList($Page) ?>,
            "_visible": <?= $Page->_visible->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fhelpsrch" id="fhelpsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fhelpsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { help: currentTable } });
var currentForm;
var fhelpsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fhelpsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["level", [], fields.level.isInvalid],
            ["table_name", [], fields.table_name.isInvalid],
            ["y_table_name", [ew.Validators.between], false],
            ["table_caption", [], fields.table_caption.isInvalid],
            ["y_table_caption", [ew.Validators.between], false],
            ["field_name", [], fields.field_name.isInvalid],
            ["y_field_name", [ew.Validators.between], false],
            ["field_description", [], fields.field_description.isInvalid],
            ["y_field_description", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "level": <?= $Page->level->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->level->Visible) { // level ?>
<?php
if (!$Page->level->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_level" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->level->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_level" class="ew-search-caption ew-label"><?= $Page->level->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_level" id="z_level" value="=">
</div>
        </div>
        <div id="el_help_level" class="ew-search-field">
    <select
        id="x_level"
        name="x_level"
        class="form-select ew-select<?= $Page->level->isInvalidClass() ?>"
        <?php if (!$Page->level->IsNativeSelect) { ?>
        data-select2-id="fhelpsrch_x_level"
        <?php } ?>
        data-table="help"
        data-field="x_level"
        data-value-separator="<?= $Page->level->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->level->getPlaceHolder()) ?>"
        <?= $Page->level->editAttributes() ?>>
        <?= $Page->level->selectOptionListHtml("x_level") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->level->getErrorMessage(false) ?></div>
<?php if (!$Page->level->IsNativeSelect) { ?>
<script>
loadjs.ready("fhelpsrch", function() {
    var options = { name: "x_level", selectId: "fhelpsrch_x_level" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fhelpsrch.lists.level?.lookupOptions.length) {
        options.data = { id: "x_level", form: "fhelpsrch" };
    } else {
        options.ajax = { id: "x_level", form: "fhelpsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.help.fields.level.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->table_name->Visible) { // table_name ?>
<?php
if (!$Page->table_name->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_table_name" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->table_name->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_table_name" class="ew-search-caption ew-label"><?= $Page->table_name->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_table_name" id="z_table_name" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->table_name->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->table_name->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_help_table_name" class="ew-search-field">
<input type="<?= $Page->table_name->getInputTextType() ?>" name="x_table_name" id="x_table_name" data-table="help" data-field="x_table_name" value="<?= $Page->table_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_name->formatPattern()) ?>"<?= $Page->table_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_name->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_help_table_name" class="ew-search-field2 d-none">
<input type="<?= $Page->table_name->getInputTextType() ?>" name="y_table_name" id="y_table_name" data-table="help" data-field="x_table_name" value="<?= $Page->table_name->EditValue2 ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_name->formatPattern()) ?>"<?= $Page->table_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_name->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->table_caption->Visible) { // table_caption ?>
<?php
if (!$Page->table_caption->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_table_caption" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->table_caption->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_table_caption" class="ew-search-caption ew-label"><?= $Page->table_caption->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_table_caption" id="z_table_caption" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->table_caption->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->table_caption->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_help_table_caption" class="ew-search-field">
<input type="<?= $Page->table_caption->getInputTextType() ?>" name="x_table_caption" id="x_table_caption" data-table="help" data-field="x_table_caption" value="<?= $Page->table_caption->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_caption->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_caption->formatPattern()) ?>"<?= $Page->table_caption->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_caption->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_help_table_caption" class="ew-search-field2 d-none">
<input type="<?= $Page->table_caption->getInputTextType() ?>" name="y_table_caption" id="y_table_caption" data-table="help" data-field="x_table_caption" value="<?= $Page->table_caption->EditValue2 ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_caption->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_caption->formatPattern()) ?>"<?= $Page->table_caption->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_caption->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->field_name->Visible) { // field_name ?>
<?php
if (!$Page->field_name->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_field_name" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->field_name->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_field_name" class="ew-search-caption ew-label"><?= $Page->field_name->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_field_name" id="z_field_name" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->field_name->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->field_name->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_help_field_name" class="ew-search-field">
<input type="<?= $Page->field_name->getInputTextType() ?>" name="x_field_name" id="x_field_name" data-table="help" data-field="x_field_name" value="<?= $Page->field_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->field_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field_name->formatPattern()) ?>"<?= $Page->field_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field_name->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_help_field_name" class="ew-search-field2 d-none">
<input type="<?= $Page->field_name->getInputTextType() ?>" name="y_field_name" id="y_field_name" data-table="help" data-field="x_field_name" value="<?= $Page->field_name->EditValue2 ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->field_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field_name->formatPattern()) ?>"<?= $Page->field_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field_name->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->field_description->Visible) { // field_description ?>
<?php
if (!$Page->field_description->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_field_description" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->field_description->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_field_description" class="ew-search-caption ew-label"><?= $Page->field_description->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_field_description" id="z_field_description" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->field_description->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->field_description->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_help_field_description" class="ew-search-field">
<input type="<?= $Page->field_description->getInputTextType() ?>" name="x_field_description" id="x_field_description" data-table="help" data-field="x_field_description" value="<?= $Page->field_description->EditValue ?>" size="35" maxlength="1000" placeholder="<?= HtmlEncode($Page->field_description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field_description->formatPattern()) ?>"<?= $Page->field_description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field_description->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_help_field_description" class="ew-search-field2 d-none">
<input type="<?= $Page->field_description->getInputTextType() ?>" name="y_field_description" id="y_field_description" data-table="help" data-field="x_field_description" value="<?= $Page->field_description->EditValue2 ?>" size="35" maxlength="1000" placeholder="<?= HtmlEncode($Page->field_description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field_description->formatPattern()) ?>"<?= $Page->field_description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field_description->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fhelpsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fhelpsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fhelpsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fhelpsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fhelpsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fhelpsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fhelpsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="help">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_help" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_helplist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_help_id" class="help_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->level->Visible) { // level ?>
        <th data-name="level" class="<?= $Page->level->headerCellClass() ?>"><div id="elh_help_level" class="help_level"><?= $Page->renderFieldHeader($Page->level) ?></div></th>
<?php } ?>
<?php if ($Page->menu_group->Visible) { // menu_group ?>
        <th data-name="menu_group" class="<?= $Page->menu_group->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_menu_group" class="help_menu_group"><?= $Page->renderFieldHeader($Page->menu_group) ?></div></th>
<?php } ?>
<?php if ($Page->menu_description->Visible) { // menu_description ?>
        <th data-name="menu_description" class="<?= $Page->menu_description->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_menu_description" class="help_menu_description"><?= $Page->renderFieldHeader($Page->menu_description) ?></div></th>
<?php } ?>
<?php if ($Page->table_name->Visible) { // table_name ?>
        <th data-name="table_name" class="<?= $Page->table_name->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_table_name" class="help_table_name"><?= $Page->renderFieldHeader($Page->table_name) ?></div></th>
<?php } ?>
<?php if ($Page->table_caption->Visible) { // table_caption ?>
        <th data-name="table_caption" class="<?= $Page->table_caption->headerCellClass() ?>"><div id="elh_help_table_caption" class="help_table_caption"><?= $Page->renderFieldHeader($Page->table_caption) ?></div></th>
<?php } ?>
<?php if ($Page->field_name->Visible) { // field_name ?>
        <th data-name="field_name" class="<?= $Page->field_name->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_field_name" class="help_field_name"><?= $Page->renderFieldHeader($Page->field_name) ?></div></th>
<?php } ?>
<?php if ($Page->field_caption->Visible) { // field_caption ?>
        <th data-name="field_caption" class="<?= $Page->field_caption->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_field_caption" class="help_field_caption"><?= $Page->renderFieldHeader($Page->field_caption) ?></div></th>
<?php } ?>
<?php if ($Page->field_description->Visible) { // field_description ?>
        <th data-name="field_description" class="<?= $Page->field_description->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_field_description" class="help_field_description"><?= $Page->renderFieldHeader($Page->field_description) ?></div></th>
<?php } ?>
<?php if ($Page->table_description->Visible) { // table_description ?>
        <th data-name="table_description" class="<?= $Page->table_description->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_help_table_description" class="help_table_description"><?= $Page->renderFieldHeader($Page->table_description) ?></div></th>
<?php } ?>
<?php if ($Page->_visible->Visible) { // visible ?>
        <th data-name="_visible" class="<?= $Page->_visible->headerCellClass() ?>"><div id="elh_help__visible" class="help__visible"><?= $Page->renderFieldHeader($Page->_visible) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_help_operator" class="help_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_help_datetime" class="help_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_id" class="el_help_id"></span>
<input type="hidden" data-table="help" data-field="x_id" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_id" id="o<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_id" class="el_help_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="help" data-field="x_id" data-hidden="1" name="x<?= $Page->RowIndex ?>_id" id="x<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_id" class="el_help_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="help" data-field="x_id" data-hidden="1" name="x<?= $Page->RowIndex ?>_id" id="x<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->level->Visible) { // level ?>
        <td data-name="level"<?= $Page->level->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_level" class="el_help_level">
    <select
        id="x<?= $Page->RowIndex ?>_level"
        name="x<?= $Page->RowIndex ?>_level"
        class="form-select ew-select<?= $Page->level->isInvalidClass() ?>"
        <?php if (!$Page->level->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_level"
        <?php } ?>
        data-table="help"
        data-field="x_level"
        data-value-separator="<?= $Page->level->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->level->getPlaceHolder()) ?>"
        <?= $Page->level->editAttributes() ?>>
        <?= $Page->level->selectOptionListHtml("x{$Page->RowIndex}_level") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->level->getErrorMessage() ?></div>
<?php if (!$Page->level->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_level", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_level" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.level?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_level", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_level", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.help.fields.level.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="help" data-field="x_level" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_level" id="o<?= $Page->RowIndex ?>_level" value="<?= HtmlEncode($Page->level->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_level" class="el_help_level">
<span<?= $Page->level->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->level->getDisplayValue($Page->level->EditValue) ?></span></span>
<input type="hidden" data-table="help" data-field="x_level" data-hidden="1" name="x<?= $Page->RowIndex ?>_level" id="x<?= $Page->RowIndex ?>_level" value="<?= HtmlEncode($Page->level->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_level" class="el_help_level">
<span<?= $Page->level->viewAttributes() ?>>
<?= $Page->level->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->menu_group->Visible) { // menu_group ?>
        <td data-name="menu_group"<?= $Page->menu_group->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_menu_group" class="el_help_menu_group">
<input type="<?= $Page->menu_group->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_menu_group" id="x<?= $Page->RowIndex ?>_menu_group" data-table="help" data-field="x_menu_group" value="<?= $Page->menu_group->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->menu_group->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->menu_group->formatPattern()) ?>"<?= $Page->menu_group->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->menu_group->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="help" data-field="x_menu_group" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_menu_group" id="o<?= $Page->RowIndex ?>_menu_group" value="<?= HtmlEncode($Page->menu_group->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_menu_group" class="el_help_menu_group">
<input type="<?= $Page->menu_group->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_menu_group" id="x<?= $Page->RowIndex ?>_menu_group" data-table="help" data-field="x_menu_group" value="<?= $Page->menu_group->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->menu_group->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->menu_group->formatPattern()) ?>"<?= $Page->menu_group->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->menu_group->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_menu_group" class="el_help_menu_group">
<span<?= $Page->menu_group->viewAttributes() ?>>
<?= $Page->menu_group->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->menu_description->Visible) { // menu_description ?>
        <td data-name="menu_description"<?= $Page->menu_description->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_menu_description" class="el_help_menu_description">
<?php $Page->menu_description->EditAttrs->appendClass("editor"); ?>
<textarea data-table="help" data-field="x_menu_description" name="x<?= $Page->RowIndex ?>_menu_description" id="x<?= $Page->RowIndex ?>_menu_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->menu_description->getPlaceHolder()) ?>"<?= $Page->menu_description->editAttributes() ?>><?= $Page->menu_description->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->menu_description->getErrorMessage() ?></div>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "editor"], function() {
    ew.createEditor("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_menu_description", 0, 0, <?= $Page->menu_description->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
<input type="hidden" data-table="help" data-field="x_menu_description" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_menu_description" id="o<?= $Page->RowIndex ?>_menu_description" value="<?= HtmlEncode($Page->menu_description->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_menu_description" class="el_help_menu_description">
<?php $Page->menu_description->EditAttrs->appendClass("editor"); ?>
<textarea data-table="help" data-field="x_menu_description" name="x<?= $Page->RowIndex ?>_menu_description" id="x<?= $Page->RowIndex ?>_menu_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->menu_description->getPlaceHolder()) ?>"<?= $Page->menu_description->editAttributes() ?>><?= $Page->menu_description->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->menu_description->getErrorMessage() ?></div>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "editor"], function() {
    ew.createEditor("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_menu_description", 0, 0, <?= $Page->menu_description->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_menu_description" class="el_help_menu_description">
<span<?= $Page->menu_description->viewAttributes() ?>>
<?= $Page->menu_description->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->table_name->Visible) { // table_name ?>
        <td data-name="table_name"<?= $Page->table_name->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_table_name" class="el_help_table_name">
<input type="<?= $Page->table_name->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_table_name" id="x<?= $Page->RowIndex ?>_table_name" data-table="help" data-field="x_table_name" value="<?= $Page->table_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_name->formatPattern()) ?>"<?= $Page->table_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="help" data-field="x_table_name" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_table_name" id="o<?= $Page->RowIndex ?>_table_name" value="<?= HtmlEncode($Page->table_name->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_table_name" class="el_help_table_name">
<span<?= $Page->table_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->table_name->getDisplayValue($Page->table_name->EditValue))) ?>"></span>
<input type="hidden" data-table="help" data-field="x_table_name" data-hidden="1" name="x<?= $Page->RowIndex ?>_table_name" id="x<?= $Page->RowIndex ?>_table_name" value="<?= HtmlEncode($Page->table_name->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_table_name" class="el_help_table_name">
<span<?= $Page->table_name->viewAttributes() ?>>
<?= $Page->table_name->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->table_caption->Visible) { // table_caption ?>
        <td data-name="table_caption"<?= $Page->table_caption->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_table_caption" class="el_help_table_caption">
<input type="<?= $Page->table_caption->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_table_caption" id="x<?= $Page->RowIndex ?>_table_caption" data-table="help" data-field="x_table_caption" value="<?= $Page->table_caption->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->table_caption->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->table_caption->formatPattern()) ?>"<?= $Page->table_caption->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->table_caption->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="help" data-field="x_table_caption" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_table_caption" id="o<?= $Page->RowIndex ?>_table_caption" value="<?= HtmlEncode($Page->table_caption->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_table_caption" class="el_help_table_caption">
<span<?= $Page->table_caption->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->table_caption->getDisplayValue($Page->table_caption->EditValue))) ?>"></span>
<input type="hidden" data-table="help" data-field="x_table_caption" data-hidden="1" name="x<?= $Page->RowIndex ?>_table_caption" id="x<?= $Page->RowIndex ?>_table_caption" value="<?= HtmlEncode($Page->table_caption->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_table_caption" class="el_help_table_caption">
<span<?= $Page->table_caption->viewAttributes() ?>>
<?= $Page->table_caption->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->field_name->Visible) { // field_name ?>
        <td data-name="field_name"<?= $Page->field_name->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_field_name" class="el_help_field_name">
<input type="<?= $Page->field_name->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_field_name" id="x<?= $Page->RowIndex ?>_field_name" data-table="help" data-field="x_field_name" value="<?= $Page->field_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->field_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field_name->formatPattern()) ?>"<?= $Page->field_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field_name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="help" data-field="x_field_name" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_field_name" id="o<?= $Page->RowIndex ?>_field_name" value="<?= HtmlEncode($Page->field_name->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_field_name" class="el_help_field_name">
<span<?= $Page->field_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->field_name->getDisplayValue($Page->field_name->EditValue))) ?>"></span>
<input type="hidden" data-table="help" data-field="x_field_name" data-hidden="1" name="x<?= $Page->RowIndex ?>_field_name" id="x<?= $Page->RowIndex ?>_field_name" value="<?= HtmlEncode($Page->field_name->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_field_name" class="el_help_field_name">
<span<?= $Page->field_name->viewAttributes() ?>>
<?= $Page->field_name->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->field_caption->Visible) { // field_caption ?>
        <td data-name="field_caption"<?= $Page->field_caption->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_field_caption" class="el_help_field_caption">
<input type="<?= $Page->field_caption->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_field_caption" id="x<?= $Page->RowIndex ?>_field_caption" data-table="help" data-field="x_field_caption" value="<?= $Page->field_caption->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->field_caption->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->field_caption->formatPattern()) ?>"<?= $Page->field_caption->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->field_caption->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="help" data-field="x_field_caption" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_field_caption" id="o<?= $Page->RowIndex ?>_field_caption" value="<?= HtmlEncode($Page->field_caption->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_field_caption" class="el_help_field_caption">
<span<?= $Page->field_caption->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->field_caption->getDisplayValue($Page->field_caption->EditValue))) ?>"></span>
<input type="hidden" data-table="help" data-field="x_field_caption" data-hidden="1" name="x<?= $Page->RowIndex ?>_field_caption" id="x<?= $Page->RowIndex ?>_field_caption" value="<?= HtmlEncode($Page->field_caption->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_field_caption" class="el_help_field_caption">
<span<?= $Page->field_caption->viewAttributes() ?>>
<?= $Page->field_caption->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->field_description->Visible) { // field_description ?>
        <td data-name="field_description"<?= $Page->field_description->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_field_description" class="el_help_field_description">
<textarea data-table="help" data-field="x_field_description" name="x<?= $Page->RowIndex ?>_field_description" id="x<?= $Page->RowIndex ?>_field_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->field_description->getPlaceHolder()) ?>"<?= $Page->field_description->editAttributes() ?>><?= $Page->field_description->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->field_description->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="help" data-field="x_field_description" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_field_description" id="o<?= $Page->RowIndex ?>_field_description" value="<?= HtmlEncode($Page->field_description->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_field_description" class="el_help_field_description">
<textarea data-table="help" data-field="x_field_description" name="x<?= $Page->RowIndex ?>_field_description" id="x<?= $Page->RowIndex ?>_field_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->field_description->getPlaceHolder()) ?>"<?= $Page->field_description->editAttributes() ?>><?= $Page->field_description->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->field_description->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_field_description" class="el_help_field_description">
<span<?= $Page->field_description->viewAttributes() ?>>
<?= $Page->field_description->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->table_description->Visible) { // table_description ?>
        <td data-name="table_description"<?= $Page->table_description->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_table_description" class="el_help_table_description">
<?php $Page->table_description->EditAttrs->appendClass("editor"); ?>
<textarea data-table="help" data-field="x_table_description" name="x<?= $Page->RowIndex ?>_table_description" id="x<?= $Page->RowIndex ?>_table_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->table_description->getPlaceHolder()) ?>"<?= $Page->table_description->editAttributes() ?>><?= $Page->table_description->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->table_description->getErrorMessage() ?></div>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "editor"], function() {
    ew.createEditor("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_table_description", 35, 4, <?= $Page->table_description->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
<input type="hidden" data-table="help" data-field="x_table_description" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_table_description" id="o<?= $Page->RowIndex ?>_table_description" value="<?= HtmlEncode($Page->table_description->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_table_description" class="el_help_table_description">
<?php $Page->table_description->EditAttrs->appendClass("editor"); ?>
<textarea data-table="help" data-field="x_table_description" name="x<?= $Page->RowIndex ?>_table_description" id="x<?= $Page->RowIndex ?>_table_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->table_description->getPlaceHolder()) ?>"<?= $Page->table_description->editAttributes() ?>><?= $Page->table_description->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->table_description->getErrorMessage() ?></div>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "editor"], function() {
    ew.createEditor("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_table_description", 35, 4, <?= $Page->table_description->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_table_description" class="el_help_table_description">
<span<?= $Page->table_description->viewAttributes() ?>>
<?= $Page->table_description->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->_visible->Visible) { // visible ?>
        <td data-name="_visible"<?= $Page->_visible->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help__visible" class="el_help__visible">
    <select
        id="x<?= $Page->RowIndex ?>__visible"
        name="x<?= $Page->RowIndex ?>__visible"
        class="form-select ew-select<?= $Page->_visible->isInvalidClass() ?>"
        <?php if (!$Page->_visible->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>__visible"
        <?php } ?>
        data-table="help"
        data-field="x__visible"
        data-value-separator="<?= $Page->_visible->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_visible->getPlaceHolder()) ?>"
        <?= $Page->_visible->editAttributes() ?>>
        <?= $Page->_visible->selectOptionListHtml("x{$Page->RowIndex}__visible") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_visible->getErrorMessage() ?></div>
<?php if (!$Page->_visible->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>__visible", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>__visible" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists._visible?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>__visible", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>__visible", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.help.fields._visible.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="help" data-field="x__visible" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>__visible" id="o<?= $Page->RowIndex ?>__visible" value="<?= HtmlEncode($Page->_visible->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help__visible" class="el_help__visible">
    <select
        id="x<?= $Page->RowIndex ?>__visible"
        name="x<?= $Page->RowIndex ?>__visible"
        class="form-select ew-select<?= $Page->_visible->isInvalidClass() ?>"
        <?php if (!$Page->_visible->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>__visible"
        <?php } ?>
        data-table="help"
        data-field="x__visible"
        data-value-separator="<?= $Page->_visible->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_visible->getPlaceHolder()) ?>"
        <?= $Page->_visible->editAttributes() ?>>
        <?= $Page->_visible->selectOptionListHtml("x{$Page->RowIndex}__visible") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_visible->getErrorMessage() ?></div>
<?php if (!$Page->_visible->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>__visible", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>__visible" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists._visible?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>__visible", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>__visible", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.help.fields._visible.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help__visible" class="el_help__visible">
<span<?= $Page->_visible->viewAttributes() ?>>
<?= $Page->_visible->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="help" data-field="x_operator" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_operator" id="o<?= $Page->RowIndex ?>_operator" value="<?= HtmlEncode($Page->operator->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_operator" class="el_help_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="help" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_datetime" id="o<?= $Page->RowIndex ?>_datetime" value="<?= HtmlEncode($Page->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_help_datetime" class="el_help_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("help");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
